package HashData::DBI;

use strict;
use warnings;

use Role::Tiny::With;
with 'HashDataRole::Source::DBI';

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-01-15'; # DATE
our $DIST = 'HashDataRoles-Standard'; # DIST
our $VERSION = '0.003'; # VERSION

1;
# ABSTRACT: Get hash data from DBI

__END__

=pod

=encoding UTF-8

=head1 NAME

HashData::DBI - Get hash data from DBI

=head1 VERSION

This document describes version 0.003 of HashData::DBI (from Perl distribution HashDataRoles-Standard), released on 2024-01-15.

=head1 SYNOPSIS

 use HashData::DBI;

 my $ary = HashData::DBI->new(
     iterate_sth    => $dbh->prepare("SELECT mykey,myval FROM mytable"),
     get_by_key_sth => $dbh->prepare("SELECT myval FROM mytable WHERE mykey=?"),
     row_count_sth  => $dbh->prepare("SELECT COUNT(*) FROM mytable"),
 );

 # or
 my $ary = HashData::DBI->new(
     dsn           => "DBI:mysql:database=mydb",
     user          => "...",
     password      => "...",
     table         => "mytable",
     key_column    => "mykey",
     val_column    => "myval",
 );

=head1 DESCRIPTION

This is an C<HashData::> module to get array elements from a L<DBI> query.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/HashDataRoles-Standard>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-HashDataRoles-Standard>.

=head1 SEE ALSO

L<DBI>

L<ArrayData>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2021 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=HashDataRoles-Standard>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
