package Bencher::Scenario::RegexpCommon::Startup;

our $DATE = '2016-01-24'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our @modules = ("Regexp::Common","Regexp::Common::ANSIescape","Regexp::Common::CC","Regexp::Common::Chess","Regexp::Common::Emacs","Regexp::Common::Email::Address","Regexp::Common::IRC","Regexp::Common::SEN","Regexp::Common::URI","Regexp::Common::URI::RFC1035","Regexp::Common::URI::RFC1738","Regexp::Common::URI::RFC1808","Regexp::Common::URI::RFC2384","Regexp::Common::URI::RFC2396","Regexp::Common::URI::RFC2806","Regexp::Common::URI::fax","Regexp::Common::URI::file","Regexp::Common::URI::ftp","Regexp::Common::URI::gopher","Regexp::Common::URI::http","Regexp::Common::URI::news","Regexp::Common::URI::pop","Regexp::Common::URI::prospero","Regexp::Common::URI::tel","Regexp::Common::URI::telnet","Regexp::Common::URI::tv","Regexp::Common::URI::wais","Regexp::Common::VATIN","Regexp::Common::balanced","Regexp::Common::comment","Regexp::Common::debian","Regexp::Common::delimited","Regexp::Common::lingua","Regexp::Common::list","Regexp::Common::microsyntax","Regexp::Common::net","Regexp::Common::net::CIDR","Regexp::Common::number","Regexp::Common::profanity","Regexp::Common::profanity_us","Regexp::Common::time","Regexp::Common::whitespace","Regexp::Common::zip"); # PRECOMPUTED FROM: grep {!/\ARegexp::Common::(Entry|Other|WithActions.*|_.*)\z/} do { require App::lcpan::Call; @{ App::lcpan::Call::call_lcpan_script(argv=>["modules", "--namespace", "Regexp::Common"]) } }

our $scenario = {
    summary => 'Benchmark module startup overhead of Regexp::Common modules',

    module_startup => 1,

    participants => [
        map { +{module=>$_} } @modules,
    ],
};

1;
# ABSTRACT: Benchmark module startup overhead of Regexp::Common modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::RegexpCommon::Startup - Benchmark module startup overhead of Regexp::Common modules

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::RegexpCommon::Startup (from Perl distribution Bencher-Scenarios-RegexpCommon), released on 2016-01-24.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m RegexpCommon::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Regexp::Common> 2016010801

L<Regexp::Common::ANSIescape> 14

L<Regexp::Common::CC> 2016010801

L<Regexp::Common::Chess> 0.1

L<Regexp::Common::Emacs> 14

L<Regexp::Common::Email::Address> 1.01

L<Regexp::Common::IRC> 0.04

L<Regexp::Common::SEN> 2016010801

L<Regexp::Common::URI> 2016010801

L<Regexp::Common::URI::RFC1035> 2016010801

L<Regexp::Common::URI::RFC1738> 2016010801

L<Regexp::Common::URI::RFC1808> 2016010801

L<Regexp::Common::URI::RFC2384> 2016010801

L<Regexp::Common::URI::RFC2396> 2016010801

L<Regexp::Common::URI::RFC2806> 2016010801

L<Regexp::Common::URI::fax> 2016010801

L<Regexp::Common::URI::file> 2016010801

L<Regexp::Common::URI::ftp> 2016010801

L<Regexp::Common::URI::gopher> 2016010801

L<Regexp::Common::URI::http> 2016010801

L<Regexp::Common::URI::news> 2016010801

L<Regexp::Common::URI::pop> 2016010801

L<Regexp::Common::URI::prospero> 2016010801

L<Regexp::Common::URI::tel> 2016010801

L<Regexp::Common::URI::telnet> 2016010801

L<Regexp::Common::URI::tv> 2016010801

L<Regexp::Common::URI::wais> 2016010801

L<Regexp::Common::VATIN> v1.0

L<Regexp::Common::balanced> 2016010801

L<Regexp::Common::comment> 2016010801

L<Regexp::Common::debian> v0.2.14

L<Regexp::Common::delimited> 2016010801

L<Regexp::Common::lingua> 2016010801

L<Regexp::Common::list> 2016010801

L<Regexp::Common::microsyntax> 0.02

L<Regexp::Common::net> 2016010801

L<Regexp::Common::net::CIDR> 0.03

L<Regexp::Common::number> 2016010801

L<Regexp::Common::profanity> 2016010801

L<Regexp::Common::profanity_us> 4.112150

L<Regexp::Common::time> 0.07

L<Regexp::Common::whitespace> 2016010801

L<Regexp::Common::zip> 2016010801

=head1 BENCHMARK PARTICIPANTS

=over

=item * Regexp::Common (perl_code)

L<Regexp::Common>



=item * Regexp::Common::ANSIescape (perl_code)

L<Regexp::Common::ANSIescape>



=item * Regexp::Common::CC (perl_code)

L<Regexp::Common::CC>



=item * Regexp::Common::Chess (perl_code)

L<Regexp::Common::Chess>



=item * Regexp::Common::Emacs (perl_code)

L<Regexp::Common::Emacs>



=item * Regexp::Common::Email::Address (perl_code)

L<Regexp::Common::Email::Address>



=item * Regexp::Common::IRC (perl_code)

L<Regexp::Common::IRC>



=item * Regexp::Common::SEN (perl_code)

L<Regexp::Common::SEN>



=item * Regexp::Common::URI (perl_code)

L<Regexp::Common::URI>



=item * Regexp::Common::URI::RFC1035 (perl_code)

L<Regexp::Common::URI::RFC1035>



=item * Regexp::Common::URI::RFC1738 (perl_code)

L<Regexp::Common::URI::RFC1738>



=item * Regexp::Common::URI::RFC1808 (perl_code)

L<Regexp::Common::URI::RFC1808>



=item * Regexp::Common::URI::RFC2384 (perl_code)

L<Regexp::Common::URI::RFC2384>



=item * Regexp::Common::URI::RFC2396 (perl_code)

L<Regexp::Common::URI::RFC2396>



=item * Regexp::Common::URI::RFC2806 (perl_code)

L<Regexp::Common::URI::RFC2806>



=item * Regexp::Common::URI::fax (perl_code)

L<Regexp::Common::URI::fax>



=item * Regexp::Common::URI::file (perl_code)

L<Regexp::Common::URI::file>



=item * Regexp::Common::URI::ftp (perl_code)

L<Regexp::Common::URI::ftp>



=item * Regexp::Common::URI::gopher (perl_code)

L<Regexp::Common::URI::gopher>



=item * Regexp::Common::URI::http (perl_code)

L<Regexp::Common::URI::http>



=item * Regexp::Common::URI::news (perl_code)

L<Regexp::Common::URI::news>



=item * Regexp::Common::URI::pop (perl_code)

L<Regexp::Common::URI::pop>



=item * Regexp::Common::URI::prospero (perl_code)

L<Regexp::Common::URI::prospero>



=item * Regexp::Common::URI::tel (perl_code)

L<Regexp::Common::URI::tel>



=item * Regexp::Common::URI::telnet (perl_code)

L<Regexp::Common::URI::telnet>



=item * Regexp::Common::URI::tv (perl_code)

L<Regexp::Common::URI::tv>



=item * Regexp::Common::URI::wais (perl_code)

L<Regexp::Common::URI::wais>



=item * Regexp::Common::VATIN (perl_code)

L<Regexp::Common::VATIN>



=item * Regexp::Common::balanced (perl_code)

L<Regexp::Common::balanced>



=item * Regexp::Common::comment (perl_code)

L<Regexp::Common::comment>



=item * Regexp::Common::debian (perl_code)

L<Regexp::Common::debian>



=item * Regexp::Common::delimited (perl_code)

L<Regexp::Common::delimited>



=item * Regexp::Common::lingua (perl_code)

L<Regexp::Common::lingua>



=item * Regexp::Common::list (perl_code)

L<Regexp::Common::list>



=item * Regexp::Common::microsyntax (perl_code)

L<Regexp::Common::microsyntax>



=item * Regexp::Common::net (perl_code)

L<Regexp::Common::net>



=item * Regexp::Common::net::CIDR (perl_code)

L<Regexp::Common::net::CIDR>



=item * Regexp::Common::number (perl_code)

L<Regexp::Common::number>



=item * Regexp::Common::profanity (perl_code)

L<Regexp::Common::profanity>



=item * Regexp::Common::profanity_us (perl_code)

L<Regexp::Common::profanity_us>



=item * Regexp::Common::time (perl_code)

L<Regexp::Common::time>



=item * Regexp::Common::whitespace (perl_code)

L<Regexp::Common::whitespace>



=item * Regexp::Common::zip (perl_code)

L<Regexp::Common::zip>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m RegexpCommon::Startup >>):

 +--------------------------------+-----------+------------------------+---------+---------+
 | participant                    | time (ms) | mod_overhead_time (ms) | errors  | samples |
 +--------------------------------+-----------+------------------------+---------+---------+
 | Regexp::Common::microsyntax    | 49        | 46.5                   | 9.8e-05 | 20      |
 | Regexp::Common::Email::Address | 31        | 28.5                   | 0.00011 | 20      |
 | Regexp::Common::time           | 30        | 27.5                   | 0.00011 | 20      |
 | Regexp::Common                 | 22        | 19.5                   | 5.7e-05 | 20      |
 | Regexp::Common::URI::http      | 14        | 11.5                   | 0.0001  | 21      |
 | Regexp::Common::URI::file      | 14        | 11.5                   | 5.3e-05 | 20      |
 | Regexp::Common::URI::wais      | 14        | 11.5                   | 8.3e-05 | 20      |
 | Regexp::Common::URI::news      | 14        | 11.5                   | 6.2e-05 | 20      |
 | Regexp::Common::URI::gopher    | 14        | 11.5                   | 6.9e-05 | 21      |
 | Regexp::Common::URI::fax       | 14        | 11.5                   | 5.3e-05 | 20      |
 | Regexp::Common::URI::tv        | 14        | 11.5                   | 3.5e-05 | 20      |
 | Regexp::Common::URI::ftp       | 14        | 11.5                   | 6.7e-05 | 21      |
 | Regexp::Common::URI::telnet    | 14        | 11.5                   | 4.9e-05 | 20      |
 | Regexp::Common::URI::pop       | 14        | 11.5                   | 2.5e-05 | 21      |
 | Regexp::Common::URI::prospero  | 14        | 11.5                   | 6.6e-05 | 20      |
 | Regexp::Common::URI            | 14        | 11.5                   | 5.3e-05 | 21      |
 | Regexp::Common::URI::tel       | 14        | 11.5                   | 3.9e-05 | 20      |
 | Regexp::Common::profanity_us   | 13        | 10.5                   | 4.4e-05 | 20      |
 | Regexp::Common::ANSIescape     | 9.8       | 7.3                    | 2.7e-05 | 22      |
 | Regexp::Common::Emacs          | 9.6       | 7.1                    | 2.8e-05 | 20      |
 | Regexp::Common::comment        | 9.2       | 6.7                    | 3.5e-05 | 20      |
 | Regexp::Common::URI::RFC2806   | 9.1       | 6.6                    | 3.8e-05 | 20      |
 | Regexp::Common::number         | 8.7       | 6.2                    | 3.9e-05 | 20      |
 | Regexp::Common::URI::RFC2384   | 8.3       | 5.8                    | 3.6e-05 | 20      |
 | Regexp::Common::URI::RFC1738   | 8         | 5.5                    | 2.2e-05 | 20      |
 | Regexp::Common::CC             | 7.9       | 5.4                    | 3.1e-05 | 20      |
 | Regexp::Common::URI::RFC1035   | 7.8       | 5.3                    | 3.8e-05 | 21      |
 | Regexp::Common::lingua         | 7.7       | 5.2                    | 1.1e-05 | 20      |
 | Regexp::Common::debian         | 7.6       | 5.1                    | 2.6e-05 | 20      |
 | Regexp::Common::URI::RFC2396   | 7.3       | 4.8                    | 3.3e-05 | 23      |
 | Regexp::Common::IRC            | 7.1       | 4.6                    | 4.3e-05 | 21      |
 | Regexp::Common::VATIN          | 7         | 4.5                    | 2.8e-05 | 20      |
 | Regexp::Common::net            | 6.9       | 4.4                    | 2.4e-05 | 22      |
 | Regexp::Common::zip            | 6.9       | 4.4                    | 3.3e-05 | 20      |
 | Regexp::Common::balanced       | 6.7       | 4.2                    | 1.9e-05 | 20      |
 | Regexp::Common::list           | 6.7       | 4.2                    | 2.8e-05 | 21      |
 | Regexp::Common::profanity      | 6.6       | 4.1                    | 3.6e-05 | 21      |
 | Regexp::Common::net::CIDR      | 6.6       | 4.1                    | 3.4e-05 | 21      |
 | Regexp::Common::SEN            | 6.5       | 4                      | 1.4e-05 | 21      |
 | Regexp::Common::delimited      | 6.5       | 4                      | 1.5e-05 | 20      |
 | Regexp::Common::Chess          | 6.5       | 4                      | 1.2e-05 | 20      |
 | Regexp::Common::whitespace     | 6.5       | 4                      | 2e-05   | 20      |
 | Regexp::Common::URI::RFC1808   | 6.2       | 3.7                    | 3.6e-05 | 20      |
 | perl -e1 (baseline)            | 2.5       | 0                      | 1.1e-05 | 20      |
 +--------------------------------+-----------+------------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-RegexpCommon>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-RegexpCommon>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-RegexpCommon>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
