package Bencher::Scenario::DataSah::Validate;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.03'; # VERSION

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark validation',
    participants => [
        {
            name => 'gen_validator',
            code_template => 'state $v = Data::Sah::gen_validator(<schema>, {return_type => <return_type>}); $v->(<data>)',
        },
    ],
    datasets => [
        {
            name => 'int',
            args => {
                schema => 'int',
                'data@' => [1, "a"],
                'return_type@' => $return_types,
            },
        },
        {
            name => 'str+2clause',
            args => {
                schema => ['str', min_len=>1, max_len=>5],
                'data@' => ["abc", ""],
                'return_type@' => $return_types,
            },
        },
    ],
};

1;
# ABSTRACT: Benchmark validation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::Validate

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::DataSah::Validate (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::Validate

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_validator (perl_code)

Code template:

 state $v = Data::Sah::gen_validator(<schema>, {return_type => <return_type>}); $v->(<data>)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+---------------------------------------------------------------------------------------+-----------+----------+---------+---------+
 | seq | name                                                                                  | rate      | time     | errors  | samples |
 +-----+---------------------------------------------------------------------------------------+-----------+----------+---------+---------+
 | 5   | {data=>"a",dataset=>"int",participant=>"gen_validator",return_type=>"full"}           | 6.57e+05  | 1.52μs   | 3.3e-09 | 20      |
 | 11  | {data=>"",dataset=>"str+2clause",participant=>"gen_validator",return_type=>"full"}    | 7.19e+05  | 1.39μs   | 1.7e-09 | 20      |
 | 3   | {data=>"a",dataset=>"int",participant=>"gen_validator",return_type=>"str"}            | 1.115e+06 | 0.897μs  | 4.5e-11 | 20      |
 | 9   | {data=>"",dataset=>"str+2clause",participant=>"gen_validator",return_type=>"str"}     | 1.23e+06  | 0.815μs  | 2.1e-09 | 20      |
 | 10  | {data=>"abc",dataset=>"str+2clause",participant=>"gen_validator",return_type=>"full"} | 1.33e+06  | 0.752μs  | 3.8e-10 | 25      |
 | 8   | {data=>"abc",dataset=>"str+2clause",participant=>"gen_validator",return_type=>"str"}  | 1.36e+06  | 0.738μs  | 3.5e-10 | 29      |
 | 4   | {data=>1,dataset=>"int",participant=>"gen_validator",return_type=>"full"}             | 1.427e+06 | 0.7007μs | 4.6e-11 | 20      |
 | 2   | {data=>1,dataset=>"int",participant=>"gen_validator",return_type=>"str"}              | 1.464e+06 | 0.6831μs | 2.1e-10 | 20      |
 | 6   | {data=>"abc",dataset=>"str+2clause",participant=>"gen_validator",return_type=>"bool"} | 2.16e+06  | 0.463μs  | 8.3e-10 | 20      |
 | 0   | {data=>1,dataset=>"int",participant=>"gen_validator",return_type=>"bool"}             | 2.4e+06   | 0.42μs   | 2.7e-09 | 20      |
 | 7   | {data=>"",dataset=>"str+2clause",participant=>"gen_validator",return_type=>"bool"}    | 2.39e+06  | 0.418μs  | 2.1e-10 | 20      |
 | 1   | {data=>"a",dataset=>"int",participant=>"gen_validator",return_type=>"bool"}           | 2.46e+06  | 0.406μs  | 9.7e-10 | 23      |
 +-----+---------------------------------------------------------------------------------------+-----------+----------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
