package Bencher::Scenario::DataCSel::Parsing;

our $DATE = '2016-04-01'; # DATE
our $VERSION = '0.02'; # VERSION

our $scenario = {
    summary => 'Benchmark parsing speed',
    modules => {
        'Data::CSel' => {version => '0.04'},
    },
    participants => [
        { fcall_template => 'Data::CSel::parse_csel(<expr>)' },
    ],
    datasets => [
        {args=>{expr=>'*'}},
        {args=>{expr=>'T'}},
        {args=>{expr=>'T T2 T3 T4 T5'}},
        {args=>{expr=>'T ~ T ~ T ~ T ~ T'}},
        {args=>{expr=>':has(T[length > 1])'}},
    ],
};

1;
# ABSTRACT: Benchmark parsing speed

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataCSel::Parsing - Benchmark parsing speed

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::DataCSel::Parsing (from Perl distribution Bencher-Scenarios-DataCSel), released on 2016-04-01.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataCSel::Parsing

To run module startup overhead benchmark:

 % bencher --module-startup -m DataCSel::Parsing

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::CSel> 0.04

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::CSel::parse_csel (perl_code)

Function call template:

 Data::CSel::parse_csel(<expr>)



=back

=head1 BENCHMARK DATASETS

=over

=item * *

=item * T

=item * T T2 T3 T4 T5

=item * T ~ T ~ T ~ T ~ T

=item * :has(T[length > 1])

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2557M CPU @ 1.70GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17 >>, OS kernel: I<< Linux version 3.13.0-32-generic >>.

Benchmark with default options (C<< bencher -m DataCSel::Parsing >>):

 +---------------------+-----------+-----------+------------+---------+---------+
 | dataset             | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +---------------------+-----------+-----------+------------+---------+---------+
 | :has(T[length > 1]) | 1.63e+04  | 61.3      | 1          | 2.3e-08 | 27      |
 | T ~ T ~ T ~ T ~ T   | 2.2e+04   | 45        | 1.4        | 1.1e-07 | 20      |
 | T T2 T3 T4 T5       | 2.3e+04   | 44        | 1.4        | 5.3e-08 | 20      |
 | T                   | 9.02e+04  | 11.1      | 5.53       | 3.3e-09 | 20      |
 | *                   | 92502.9   | 10.8105   | 5.67498    | 0       | 20      |
 +---------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataCSel::Parsing --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Data::CSel          | 3e+01     | 20                     | 1          | 0.0012  | 20      |
 | perl -e1 (baseline) | 1e+01     | 0                      | 2          | 0.00025 | 20      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataCSel>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DataCSel>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataCSel>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
