package Bencher::Scenario::ArraySet::diff;

our $DATE = '2016-09-15'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark diff operation',
    participants => [
        {
            fcall_template => 'Array::Set::set_diff(<set1>, <set2>)',
        },
        {
            module => 'Set::Object',
            function => 'difference',
            code_template => 'my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->difference($set2);', # $res->as_string
        },
    ],
    datasets => [
        { name => '1_1'  , args => { set1=>[1], set2=>[1] } },

        { name => '10_1' , args => { set1=>[1..10], set2=>[1] } },
        { name => '10_5' , args => { set1=>[1..10], set2=>[1..5] } },
        { name => '10_10', args => { set1=>[1..10], set2=>[1..10] } },

        { name => '100_1'  , args => { set1=>[1..100], set2=>[1] } },
        { name => '100_10' , args => { set1=>[1..100], set2=>[1..10] } },
        { name => '100_100', args => { set1=>[1..100], set2=>[1..100] } },

        { name => '1000_1'   , args => { set1=>[1..1000], set2=>[1] } },
        { name => '1000_10'  , args => { set1=>[1..1000], set2=>[1..10] } },
        { name => '1000_100' , args => { set1=>[1..1000], set2=>[1..100] } },
        { name => '1000_1000', args => { set1=>[1..1000], set2=>[1..1000] } },
    ],
};

1;
# ABSTRACT: Benchmark diff operation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ArraySet::diff - Benchmark diff operation

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::ArraySet::diff (from Perl distribution Bencher-Scenarios-ArraySet), released on 2016-09-15.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ArraySet::diff

To run module startup overhead benchmark:

 % bencher --module-startup -m ArraySet::diff

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Array::Set> 0.03

L<Set::Object> 1.35

=head1 BENCHMARK PARTICIPANTS

=over

=item * Array::Set::set_diff (perl_code)

Function call template:

 Array::Set::set_diff(<set1>, <set2>)



=item * Set::Object::difference (perl_code)

Code template:

 my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->difference($set2);



=back

=head1 BENCHMARK DATASETS

=over

=item * 1_1

=item * 10_1

=item * 10_5

=item * 10_10

=item * 100_1

=item * 100_10

=item * 100_100

=item * 1000_1

=item * 1000_10

=item * 1000_100

=item * 1000_1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with C<< bencher -m ArraySet::diff --include-path archive/Array-Set-0.02/lib --include-path archive/Array-Set-0.03/lib --multimodver Array::Set >>:

 #table1#
 {dataset=>"1000_1"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |       290 |      3.4  |        1   | 4.3e-06 |      20 |
 | Set::Object::difference |        |      1300 |      0.77 |        4.4 | 1.1e-06 |      20 |
 | Array::Set::set_diff    | 0.03   |      2800 |      0.35 |        9.7 | 1.5e-06 |      20 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"1000_10"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |       200 |     5     |        1   | 1.9e-05 |      21 |
 | Set::Object::difference |        |      1280 |     0.778 |        6.4 | 6.4e-07 |      20 |
 | Array::Set::set_diff    | 0.03   |      2900 |     0.35  |       14   | 4.3e-07 |      20 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"1000_100"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |      52.6 |     19    |          1 | 9.9e-06 |      20 |
 | Set::Object::difference |        |    1300   |      0.8  |         24 | 1.1e-06 |      20 |
 | Array::Set::set_diff    | 0.03   |    2700   |      0.37 |         51 | 6.8e-07 |      21 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"1000_1000"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |      12.2 |     81.8  |          1 | 4.3e-05 |      20 |
 | Set::Object::difference |        |    1100   |      0.93 |         88 | 2.5e-06 |      20 |
 | Array::Set::set_diff    | 0.03   |    1600   |      0.63 |        130 | 3.8e-06 |      20 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table5#
 {dataset=>"100_1"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |      2800 |       350 |        1   | 4.1e-07 |      22 |
 | Set::Object::difference |        |     12000 |        80 |        4.4 | 9.7e-08 |      24 |
 | Array::Set::set_diff    | 0.03   |     28000 |        36 |        9.9 | 4.7e-08 |      26 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table6#
 {dataset=>"100_10"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |      2040 |       489 |        1   | 2.1e-07 |      20 |
 | Set::Object::difference |        |     12000 |        83 |        5.9 | 9.9e-08 |      23 |
 | Array::Set::set_diff    | 0.03   |     26000 |        38 |       13   | 9.3e-08 |      20 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table7#
 {dataset=>"100_100"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |       833 |      1200 |          1 | 6.9e-07 |      20 |
 | Set::Object::difference |        |     11000 |        93 |         13 | 1.1e-07 |      20 |
 | Array::Set::set_diff    | 0.03   |     18000 |        56 |         22 | 7.6e-08 |      22 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table8#
 {dataset=>"10_1"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |     22000 |     45    |       1    | 6.7e-08 |      20 |
 | Set::Object::difference |        |     74000 |     13    |       3.3  | 2.7e-08 |      20 |
 | Array::Set::set_diff    | 0.03   |    155000 |      6.45 |       6.97 | 3.3e-09 |      20 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table9#
 {dataset=>"10_10"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |     15600 |    63.9   |     1      | 2.5e-08 |      22 |
 | Set::Object::difference |        |     71090 |    14.07  |     4.546  | 2.4e-10 |      20 |
 | Array::Set::set_diff    | 0.03   |    131080 |     7.629 |     8.3823 | 1.1e-11 |      23 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table10#
 {dataset=>"10_5"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |     18000 |     55    |       1    | 1.1e-07 |      20 |
 | Set::Object::difference |        |     73000 |     14    |       4    | 5.3e-08 |      20 |
 | Array::Set::set_diff    | 0.03   |    140000 |      7.12 |       7.76 |   3e-09 |      24 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+

 #table11#
 {dataset=>"1_1"}
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant             | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_diff    | 0.02   |     77100 |      13   |        1   | 5.6e-09 |      28 |
 | Set::Object::difference |        |    160000 |       6.3 |        2.1 |   1e-08 |      20 |
 | Array::Set::set_diff    | 0.03   |    330000 |       3.1 |        4.2 |   1e-08 |      20 |
 +-------------------------+--------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ArraySet::diff --module-startup >>):

 #table12#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Set::Object         |      18   |                   12.6 |        1   | 2.3e-05 |      20 |
 | Array::Set          |      14   |                    8.6 |        1.3 | 2.1e-05 |      20 |
 | perl -e1 (baseline) |       5.4 |                    0   |        3.4 | 3.6e-05 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-ArraySet>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-ArraySet>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-ArraySet>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
