package Bencher::Scenario::ZodiacModules;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark various zodiac modules',
    participants => [
        {
            fcall_template => "Zodiac::Tiny::zodiac_of('2015-11-29')",
        },
        {
            fcall_template => "DateTime::Event::Zodiac::zodiac_date_name(DateTime->new(year=>2015, month=>11, day=>29))",
        },
        {
            fcall_template => "Zodiac::Chinese::Table::chinese_zodiac('2015-11-28')",
        },
        {
            fcall_template => "Zodiac::Chinese::chinese_zodiac(2015,11)",
        },
    ],
};

1;
# ABSTRACT: Benchmark various zodiac modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ZodiacModules

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::ZodiacModules (from Perl distribution Bencher-Scenario-ZodiacModules), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ZodiacModules

To run module startup overhead benchmark:

 % bencher --module-startup -m ZodiacModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<Zodiac::Tiny> 0.01

L<DateTime::Event::Zodiac> 1.03

L<Zodiac::Chinese::Table> 0.01

L<Zodiac::Chinese> 1

=head1 BENCHMARK PARTICIPANTS

=over

=item * Zodiac::Tiny::zodiac_of (perl_code)

Function call template:

 Zodiac::Tiny::zodiac_of('2015-11-29')



=item * DateTime::Event::Zodiac::zodiac_date_name (perl_code)

Function call template:

 DateTime::Event::Zodiac::zodiac_date_name(DateTime->new(year=>2015, month=>11, day=>29))



=item * Zodiac::Chinese::Table::chinese_zodiac (perl_code)

Function call template:

 Zodiac::Chinese::Table::chinese_zodiac('2015-11-28')



=item * Zodiac::Chinese::chinese_zodiac (perl_code)

Function call template:

 Zodiac::Chinese::chinese_zodiac(2015,11)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+---------------------------------------------------------------------------+----------+------------+---------+---------+
 | seq | name                                                                      | rate     | time       | errors  | samples |
 +-----+---------------------------------------------------------------------------+----------+------------+---------+---------+
 | 1   | {dataset=>undef,participant=>"DateTime::Event::Zodiac::zodiac_date_name"} | 751      | 1.33e+03μs | 1.6e-06 | 21      |
 | 0   | {dataset=>undef,participant=>"Zodiac::Tiny::zodiac_of"}                   | 5.77e+05 | 1.73μs     | 3.3e-09 | 20      |
 | 2   | {dataset=>undef,participant=>"Zodiac::Chinese::Table::chinese_zodiac"}    | 5.91e+05 | 1.69μs     | 8.3e-10 | 20      |
 | 3   | {dataset=>undef,participant=>"Zodiac::Chinese::chinese_zodiac"}           | 1.36e+06 | 0.733μs    | 4.2e-10 | 20      |
 +-----+---------------------------------------------------------------------------+----------+------------+---------+---------+


Benchmark module startup overhead:

 +-----+-------------------------+--------+-------------------+---------+---------+
 | seq | name                    | time   | mod_overhead_time | errors  | samples |
 +-----+-------------------------+--------+-------------------+---------+---------+
 | 2   | DateTime::Event::Zodiac | 57.4ms | 51.7ms            | 0.00014 | 20      |
 | 3   | Zodiac::Chinese::Table  | 10ms   | 4.5ms             | 4.1e-05 | 20      |
 | 4   | Zodiac::Chinese         | 9.2ms  | 3.5ms             | 3e-05   | 20      |
 | 1   | Zodiac::Tiny            | 5.8ms  | 0.15ms            | 3.8e-05 | 20      |
 | 0   | perl -e1 (baseline)     | 5.6ms  | 0ms               | 0.00016 | 20      |
 +-----+-------------------------+--------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ZodiacModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ZodiacModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ZodiacModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
