package Bencher::Scenario::ScalarUtilNumeric;

our $DATE = '2016-02-14'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Scalar::Util::Numeric vs Scalar::Util::Numeric::PP',
    participants => [
        map {
            my $which = $_;
            my $mod = $which eq 'pp' ?
                "Scalar::Util::Numeric::PP" : "Scalar::Util::Numeric";
            (
                {
                    module => $mod,
                    name => "isint-int-$which",
                    fcall_template => "$mod\::isint(1)",
                    tags => [$which, "func:isint"],
                },
                {
                    module => $mod,
                    name => "isint-str-$which",
                    fcall_template => "$mod\::isint('a')",
                    tags => [$which, "func:isint"],
                },
                {
                    module => $mod,
                    name => "isint-float-$which",
                    fcall_template => "$mod\::isint(1.23)",
                    tags => [$which, "func:isint"],
                },

                {
                    module => $mod,
                    name => "isfloat-int-$which",
                    fcall_template => "$mod\::isfloat(1)",
                    tags => [$which, "func:isfloat"],
                },
                {
                    module => $mod,
                    name => "isfloat-str-$which",
                    fcall_template => "$mod\::isfloat('a')",
                    tags => [$which, "func:isfloat"],
                },
                {
                    module => $mod,
                    name => "isfloat-float-$which",
                    fcall_template => "$mod\::isfloat(1.23)",
                    tags => [$which, "func:isfloat"],
                },

                {
                    module => $mod,
                    name => "isnum-int-$which",
                    fcall_template => "$mod\::isnum(1)",
                    tags => [$which, "func:isnum"],
                },
                {
                    module => $mod,
                    name => "isnum-str-$which",
                    fcall_template => "$mod\::isnum('a')",
                    tags => [$which, "func:isnum"],
                },
                {
                    module => $mod,
                    name => "isnum-float-$which",
                    fcall_template => "$mod\::isnum(1.23)",
                    tags => [$which, "func:isnum"],
                },
            );
        } ("pp", "xs"),
    ],
    datasets => [
    ],
};

1;
# ABSTRACT: Benchmark Scalar::Util::Numeric vs Scalar::Util::Numeric::PP

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ScalarUtilNumeric - Benchmark Scalar::Util::Numeric vs Scalar::Util::Numeric::PP

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::ScalarUtilNumeric (from Perl distribution Bencher-Scenario-ScalarUtilNumeric), released on 2016-02-14.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ScalarUtilNumeric

To run module startup overhead benchmark:

 % bencher --module-startup -m ScalarUtilNumeric

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Scalar::Util::Numeric::PP> 0.04

L<Scalar::Util::Numeric> 0.40

=head1 BENCHMARK PARTICIPANTS

=over

=item * isint-int-pp (perl_code) [pp, func:isint]

Function call template:

 Scalar::Util::Numeric::PP::isint(1)



=item * isint-str-pp (perl_code) [pp, func:isint]

Function call template:

 Scalar::Util::Numeric::PP::isint('a')



=item * isint-float-pp (perl_code) [pp, func:isint]

Function call template:

 Scalar::Util::Numeric::PP::isint(1.23)



=item * isfloat-int-pp (perl_code) [pp, func:isfloat]

Function call template:

 Scalar::Util::Numeric::PP::isfloat(1)



=item * isfloat-str-pp (perl_code) [pp, func:isfloat]

Function call template:

 Scalar::Util::Numeric::PP::isfloat('a')



=item * isfloat-float-pp (perl_code) [pp, func:isfloat]

Function call template:

 Scalar::Util::Numeric::PP::isfloat(1.23)



=item * isnum-int-pp (perl_code) [pp, func:isnum]

Function call template:

 Scalar::Util::Numeric::PP::isnum(1)



=item * isnum-str-pp (perl_code) [pp, func:isnum]

Function call template:

 Scalar::Util::Numeric::PP::isnum('a')



=item * isnum-float-pp (perl_code) [pp, func:isnum]

Function call template:

 Scalar::Util::Numeric::PP::isnum(1.23)



=item * isint-int-xs (perl_code) [xs, func:isint]

Function call template:

 Scalar::Util::Numeric::isint(1)



=item * isint-str-xs (perl_code) [xs, func:isint]

Function call template:

 Scalar::Util::Numeric::isint('a')



=item * isint-float-xs (perl_code) [xs, func:isint]

Function call template:

 Scalar::Util::Numeric::isint(1.23)



=item * isfloat-int-xs (perl_code) [xs, func:isfloat]

Function call template:

 Scalar::Util::Numeric::isfloat(1)



=item * isfloat-str-xs (perl_code) [xs, func:isfloat]

Function call template:

 Scalar::Util::Numeric::isfloat('a')



=item * isfloat-float-xs (perl_code) [xs, func:isfloat]

Function call template:

 Scalar::Util::Numeric::isfloat(1.23)



=item * isnum-int-xs (perl_code) [xs, func:isnum]

Function call template:

 Scalar::Util::Numeric::isnum(1)



=item * isnum-str-xs (perl_code) [xs, func:isnum]

Function call template:

 Scalar::Util::Numeric::isnum('a')



=item * isnum-float-xs (perl_code) [xs, func:isnum]

Function call template:

 Scalar::Util::Numeric::isnum(1.23)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m ScalarUtilNumeric >>):

 +------------------+-------------+-----------+---------+---------+
 | participant      | rate (/s)   | time (μs) | errors  | samples |
 +------------------+-------------+-----------+---------+---------+
 | isnum-float-pp   | 5.675e+05   | 1.762     | 4.6e-11 | 20      |
 | isnum-str-pp     | 6.6083e+05  | 1.5133    | 1.1e-11 | 20      |
 | isfloat-int-pp   | 9.34e+05    | 1.07      | 3.8e-10 | 24      |
 | isfloat-float-pp | 1.14e+06    | 0.877     | 4e-10   | 22      |
 | isfloat-str-pp   | 1.17e+06    | 0.852     | 4.2e-10 | 20      |
 | isint-float-pp   | 1.47e+06    | 0.679     | 2.1e-10 | 20      |
 | isnum-int-pp     | 1.70557e+06 | 0.586314  | 0       | 20      |
 | isint-int-pp     | 2.43341e+06 | 0.410946  | 0       | 20      |
 | isfloat-float-xs | 3.10057e+06 | 0.322521  | 0       | 21      |
 | isint-str-pp     | 3.13e+06    | 0.32      | 1e-10   | 20      |
 | isint-float-xs   | 3.194e+06   | 0.313087  | 0       | 20      |
 | isnum-float-xs   | 3.19535e+06 | 0.312954  | 0       | 21      |
 | isnum-int-xs     | 1.52e+07    | 0.0659    | 1e-11   | 20      |
 | isfloat-str-xs   | 1.53993e+07 | 0.0649378 | 0       | 20      |
 | isfloat-int-xs   | 1.58696e+07 | 0.0630136 | 0       | 20      |
 | isint-int-xs     | 1.6e+07     | 0.063     | 1.4e-10 | 25      |
 | isint-str-xs     | 1.61192e+07 | 0.0620377 | 0       | 20      |
 | isnum-str-xs     | 1.64e+07    | 0.061     | 1.1e-11 | 20      |
 +------------------+-------------+-----------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ScalarUtilNumeric --module-startup >>):

 +---------------------------+-----------+------------------------+---------+---------+
 | participant               | time (ms) | mod_overhead_time (ms) | errors  | samples |
 +---------------------------+-----------+------------------------+---------+---------+
 | Scalar::Util::Numeric     | 6.1       | 3.7                    | 2.1e-05 | 21      |
 | Scalar::Util::Numeric::PP | 4.7       | 2.3                    | 2.3e-05 | 20      |
 | perl -e1 (baseline)       | 2.4       | 0                      | 3.8e-06 | 20      |
 +---------------------------+-----------+------------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ScalarUtilNumeric>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ScalarUtilNumeric>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ScalarUtilNumeric>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
