package App::lcpan::Cmd::update_index;

our $DATE = '2015-04-15'; # DATE
our $VERSION = '0.18'; # VERSION

use 5.010;
use strict;
use warnings;

require App::lcpan;

our %SPEC;

$SPEC{':package'} = {
    v => 1.1,
    summary => "'update-index' command",
};

$SPEC{handle_cmd} = $App::lcpan::SPEC{update_index};
*handle_cmd = \&App::lcpan::update_index;

1;
# ABSTRACT: 'update-index' command

__END__

=pod

=encoding UTF-8

=head1 NAME

App::lcpan::Cmd::update_index - 'update-index' command

=head1 VERSION

This document describes version 0.18 of App::lcpan::Cmd::update_index (from Perl distribution App-lcpan), released on 2015-04-15.

=head1 FUNCTIONS


=head2 handle_cmd(%args) -> [status, msg, result, meta]

Create/update index.db in local CPAN mirror.

This subcommand is called by the C<update> subcommand after C<update-files> but
can be performed separately via C<update-index>. Its task is to create/update
C<index.db> SQLite database containing list of authors, modules, dists, and
dependencies.

It gets list of authors from parsing C<authors/01mailrc.txt.gz> file.

It gets list of packages from parsing C<modules/02packages.details.txt.gz>.
Afterwards, it tries to extract dist metadata C<META.yml> or C<META.json> from
each release file to get distribution name, abstract, and dependencies
information.

Arguments ('*' denotes required arguments):

=over 4

=item * B<cpan> => I<str>

Location of your local CPAN mirror, e.g. /path/to/cpan.

Defaults to C<~/cpan>.

=item * B<index_name> => I<str> (default: "index.db")

Filename of index.

=item * B<num_backups> => I<int> (default: 7)

Keep a number of backups.

Will create C<index.db.1>, C<index.db.2> and so on containing the older indexes.

=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-lcpan>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-lcpan>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-lcpan>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
