package Acme::CPANLists::Test;

our $DATE = '2015-10-23'; # DATE
our $VERSION = '0.02'; # VERSION

our @Module_Lists = (
    {
        id => 'cba525a5-436c-364f-b5d0-6d8bda85b386',
        summary => 'Test list',
        entries => [
            {module=>'Foo::Bar', summary=>'bar', related_modules=>['Foo::Qux']},
            {module=>'Foo::Baz', summary=>'baz', alternate_modules=>['Foo::Quux', 'Foo::Corge']},
        ],
    },
);

our @Author_Lists = (
    {
        id => '43151a18-dcf5-873b-ad35-1486c8925cb6',
        summary => 'Test list',
        entries => [
            {author=>'BARBIE'},
            {author=>'NEILB'},
            {author=>'RJBS'},
            {author=>'PERLANCAR', related_authors=>['SHARYANTO']},
        ],
    },
);

1;
# ABSTRACT: A test CPAN lists

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANLists::Test - A test CPAN lists

=head1 VERSION

This document describes version 0.02 of Acme::CPANLists::Test (from Perl distribution Acme-CPANLists-Test), released on 2015-10-23.

=head1 DESCRIPTION

=head1 SEE ALSO

L<Acme::CPANLists>

Other C<Acme::CPANLists::*> modules.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANLists-Test>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANLists-Test>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANLists-Test>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 AUTHOR LISTS

=head2 Test list

=over

=item * L<BARBIE|https://metacpan.org/author/BARBIE>

=item * L<NEILB|https://metacpan.org/author/NEILB>

=item * L<RJBS|https://metacpan.org/author/RJBS>

=item * L<PERLANCAR|https://metacpan.org/author/PERLANCAR>

=back

=head1 MODULE LISTS

=head2 Test list

=over

=item * L<Foo::Bar> - bar

=item * L<Foo::Baz> - baz

=back

=cut
