# NAME

Common::Routine - Common::Routine - Provide and synthesize very commonly used routines that are not provided in perl's build-in routines.

# VERSION

version 0.0.1

# SYNOPSIS

    use Common::Routine ":all";

    # routines used for math caculation
    my @array = 1..10;
    my $max = max @array          # return 10
    my $min = min @array          # return 1
    my $mean = mean @array        # return 5.5
    my $median = median @array    # return 5.5
    my $sum = sum @array          # return 55
    my $var = var @array          # return 9.166667
    my $sd = sd @array            # return 3.02765

    # routines for processing of string
    my $str = "  abc  ";
    my $t = trim $str;            # return "abc"
    my $l = ltrim $str;           # return "abc  "
    my $r = rtrim $str;           # return "  abc"

    # format number
    my $num = 1234.3567;
    my $re = round $num;          # return 1234
    my $re = round $num, 2;       # return 1234.36
    my $re = ceil $num;           # return 1235
    my $re = floor $num;          # return 1234
    my $re = format_number $num   # return 1,234.36
    my $re = format_number $num,1 # return 1,234.4

# DESCRIPTION

The aim of this module is to provide the very common used functions that are not existed in perl's build-in functions

In my daily work, I will used some very common function that are very simple and useful, but I have to write it by
myself or find and utilize them from different module. It's really boring to do this, and the purpose of this module is
to combat this problem.

# METHODS

## round($number, $precison)

Rounds the number to the specified precision. if `$precision` is omitted, it will be setted `0` (default:0).

## max(@elements)

Return the entry in the list with the highest numerical value. If the list is empty then `undef` is returned.
Arguments can be a Array or ArrayRef

## min(@elements)

Similar to ["max"](#max) but returns the entry in the list with the lowest numberical value. If the list is empty
then `undef` is returned.
Arguments can be a Array or ArrayRef

## sum(@elements)

Returns the numerical sum of all the elements in `@elements`. If `@elements` is empty then
`undef` is returned.
Arguments can be a Array or ArrayRef

## mean(@elements)

Returns the numerical mean of all the elements in `@elements`. If `@elements` is empty
then `undef` is returned.
Arguments can be a Array or ArrayRef

## median(@elements)

Returns the numerical mean of all the elements in `@elements`. If `@elements` is empty
then `undef` is returned.
Arguments can be a Array or ArrayRef

## var(@elements)

Returns the variance of list `@elements`
If `@elements` is empty then `undef` is returned.
Arguments can be a Array or ArrayRef

## sd(@elements)

Returns the standard deviation of list `@elements`
If `@elements` is empty then `undef` is returned.
Arguments can be a Array or ArrayRef

## trim($string)

Remove the whitespaces at the beginning or end of `$string`
if $string is `undef`, then `undef` is returned

## ltrim($string)

Remove the whitespaces at the beginning of `$string`
if $string is `undef`, then `undef` is returned

## rtrim($string)

Remove the whitespaces at the end of `$string`
if $string is `undef`, then `undef` is returned

# AUTHOR

Yan Xueqing <yanxueqing621@163.com>

# COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Yan Xueqing.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
