#!/usr/bin/perl -w

$ENV{PATH} = '';
unshift @INC, 't/lib';

use strict;
use Test::More tests => 2567;
use File::Spec;
use Data::Dumper;

use constant TRUE  => "__TRUE__";
use constant FALSE => "__FALSE__";

# if wait() is non-zero, we cannot reliably predict its value
use constant NOT_ZERO => "__NOT_ZERO__";

use TAPx::Parser;

my $SAMPLE_TESTS
  = File::Spec->catdir( File::Spec->curdir, 't', 'sample-tests' );

my %deprecated = map { $_ => 1 } qw(
  TAPx::Parser::good_plan
  TAPx::Parser::Results::Plan::passed
  TAPx::Parser::Results::Test::passed
  TAPx::Parser::Results::Test::actual_passed
  TAPx::Parser::Results::passed
);
$SIG{__WARN__} = sub {
    if ( $_[0] =~ /is deprecated/ ) {
        my @caller = caller(1);
        my $sub    = $caller[3];
        ok exists $deprecated{$sub},
          "... we should get a deprecated warning for $sub";
    }
    else {
        CORE::warn @_;
    }
};

# the %samples keys are the names of test scripts in t/sample-tests
my %samples = (
    descriptive => {
        results => [
            {   is_plan       => TRUE,
                raw           => '1..5',
                tests_planned => 5,
                passed        => TRUE,
                is_ok         => TRUE,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                description   => "Interlock activated",
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => "Megathrusters are go",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => "Head formed",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => "Blazing sword formed",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => "Robeast destroyed",
            }
        ],
        plan          => '1..5',
        passed        => [ 1 .. 5 ],
        actual_passed => [ 1 .. 5 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 5,
        tests_run     => 5,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    simple => {
        results => [
            {   is_plan       => TRUE,
                raw           => '1..5',
                tests_planned => 5,
                passed        => TRUE,
                is_ok         => TRUE,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => "",
            },
        ],
        plan          => '1..5',
        passed        => [ 1 .. 5 ],
        actual_passed => [ 1 .. 5 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 5,
        tests_run     => 5,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    simple_fail => {
        results => [
            {   is_plan       => TRUE,
                raw           => '1..5',
                tests_planned => 5,
                passed        => TRUE,
                is_ok         => TRUE,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => "",
            },
            {   actual_passed => FALSE,
                is_actual_ok  => FALSE,
                passed        => FALSE,
                is_ok         => FALSE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => "",
            },
            {   actual_passed => FALSE,
                is_actual_ok  => FALSE,
                passed        => FALSE,
                is_ok         => FALSE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => "",
            },
        ],
        plan          => '1..5',
        passed        => [ 1, 3, 4 ],
        actual_passed => [ 1, 3, 4 ],
        failed        => [ 2, 5 ],
        actual_failed => [ 2, 5 ],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 5,
        tests_run     => 5,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    skip => {
        results => [
            {   is_plan       => TRUE,
                raw           => '1..5',
                tests_planned => 5,
                passed        => TRUE,
                is_ok         => TRUE,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => TRUE,
                has_todo      => FALSE,
                number        => 2,
                description   => "",
                explanation   => 'rain delay',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => "",
            },
        ],
        plan          => '1..5',
        passed        => [ 1 .. 5 ],
        actual_passed => [ 1 .. 5 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [2],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 5,
        tests_run     => 5,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    skip_nomsg => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..1',
                tests_planned => 1,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => TRUE,
                has_todo      => FALSE,
                number        => 1,
                description   => "",
                explanation   => '',
            },
        ],
        plan          => '1..1',
        passed        => [1],
        actual_passed => [1],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [1],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 1,
        tests_run     => TRUE,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    todo_inline => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..3',
                tests_planned => 3,
            },
            {   actual_passed => FALSE,
                is_actual_ok  => FALSE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => TRUE,
                number        => 1,
                description   => "- Foo",
                explanation   => 'Just testing the todo interface.',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => TRUE,
                number        => 2,
                description   => "- Unexpected success",
                explanation   => 'Just testing the todo interface.',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => "- This is not todo",
                explanation   => '',
            },
        ],
        plan   => '1..3',
        passed => [ 1, 2, 3 ],
        actual_passed => [ 2, 3 ],
        failed        => [],
        actual_failed => [1],
        todo          => [ 1, 2 ],
        todo_failed   => [2],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 3,
        tests_run     => 3,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    duplicates => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..10',
                tests_planned => 10,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 6,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 7,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 8,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 9,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 10,
                description   => '',
                explanation   => '',
            },
        ],
        plan          => '1..10',
        passed        => [ 1 .. 4, 4 .. 10 ],
        actual_passed => [ 1 .. 4, 4 .. 10 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => FALSE,
        tests_planned => 10,
        tests_run     => 11,
        parse_errors  => [
            'Tests out of sequence.  Found (4) but expected (5)',
            'Tests out of sequence.  Found (5) but expected (6)',
            'Tests out of sequence.  Found (6) but expected (7)',
            'Tests out of sequence.  Found (7) but expected (8)',
            'Tests out of sequence.  Found (8) but expected (9)',
            'Tests out of sequence.  Found (9) but expected (10)',
            'Tests out of sequence.  Found (10) but expected (11)',
            'Bad plan.  You planned 10 tests but ran 11.',
        ],
        'exit' => 0,
        wait   => 0,
    },
    no_nums => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..5',
                tests_planned => 5,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                description   => "",
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => "",
            },
            {   actual_passed => FALSE,
                is_actual_ok  => FALSE,
                passed        => FALSE,
                is_ok         => FALSE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => "",
            }
        ],
        plan          => '1..5',
        passed        => [ 1, 2, 4, 5 ],
        actual_passed => [ 1, 2, 4, 5 ],
        failed        => [3],
        actual_failed => [3],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 5,
        tests_run     => 5,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    bailout => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..5',
                tests_planned => 5,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                description   => "",
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => "",
            },
            {   is_bailout  => TRUE,
                explanation => "GERONIMMMOOOOOO!!!",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => "",
            }
        ],
        plan          => '1..5',
        passed        => [ 1 .. 5 ],
        actual_passed => [ 1 .. 5 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 5,
        tests_run     => 5,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    no_output => {
        results       => [],
        plan          => '',
        passed        => [],
        actual_passed => [],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => FALSE,
        tests_planned => undef,
        tests_run     => 0,
        parse_errors  => [
            'No plan found in TAP output',
        ],
        'exit' => 0,
        wait   => 0,
    },
    too_many => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..3',
                tests_planned => 3,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                description   => "",
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 6,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 7,
                description   => "",
            },
        ],
        plan          => '1..3',
        passed        => [ 1 .. 7 ],
        actual_passed => [ 1 .. 7 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => FALSE,
        tests_planned => 3,
        tests_run     => 7,
        parse_errors  => ['Bad plan.  You planned 3 tests but ran 7.'],
        'exit'        => 4,
        wait          => NOT_ZERO,
    },
    taint => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..1',
                tests_planned => TRUE,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                description   => "- -T honored",
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
            },
        ],
        plan          => '1..1',
        passed        => [ 1 .. 1 ],
        actual_passed => [ 1 .. 1 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => TRUE,
        tests_run     => TRUE,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    'die' => {
        results       => [],
        plan          => '',
        passed        => [],
        actual_passed => [],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => FALSE,
        tests_planned => undef,
        tests_run     => 0,
        parse_errors  => [
            'No plan found in TAP output',
        ],
        'exit' => 1,
        wait   => NOT_ZERO,
    },
    die_head_end => {
        results => [
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => '',
                explanation   => '',
            },
        ],
        plan          => '',
        passed        => [ 1 .. 4 ],
        actual_passed => [ 1 .. 4 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => FALSE,
        tests_planned => undef,
        tests_run     => 4,
        parse_errors  => [
            'No plan found in TAP output',
        ],
        'exit' => 1,
        wait   => NOT_ZERO,
    },
    die_last_minute => {
        results => [
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => '',
                explanation   => '',
            },
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..4',
                tests_planned => 4,
            },
        ],
        plan          => '1..4',
        passed        => [ 1 .. 4 ],
        actual_passed => [ 1 .. 4 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 4,
        tests_run     => 4,
        parse_errors  => [],
        'exit'        => 1,
        wait          => NOT_ZERO,
    },
    bignum => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..2',
                tests_planned => 2,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 136211425,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 136211426,
                description   => '',
                explanation   => '',
            },
        ],
        plan          => '1..2',
        passed        => [ 1, 2, 136211425, 136211426 ],
        actual_passed => [ 1, 2, 136211425, 136211426 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => FALSE,
        tests_planned => 2,
        tests_run     => 4,
        parse_errors  => [
            'Tests out of sequence.  Found (136211425) but expected (3)',
            'Tests out of sequence.  Found (136211426) but expected (4)',
            'Bad plan.  You planned 2 tests but ran 4.'
        ],
        'exit' => 0,
        wait   => 0,
    },
    bignum_many => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..2',
                tests_planned => 2,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 99997,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 99998,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 99999,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 100000,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 100001,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 100002,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 100003,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 100004,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 100005,
                description   => '',
                explanation   => '',
            },
        ],
        plan          => '1..2',
        passed        => [ 1, 2, 99997 .. 100005 ],
        actual_passed => [ 1, 2, 99997 .. 100005 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => FALSE,
        tests_planned => 2,
        tests_run     => 11,
        parse_errors  => [
            'Tests out of sequence.  Found (99997) but expected (3)',
            'Tests out of sequence.  Found (99998) but expected (4)',
            'Tests out of sequence.  Found (99999) but expected (5)',
            'Tests out of sequence.  Found (100000) but expected (6)',
            'Tests out of sequence.  Found (100001) but expected (7)',
            'Tests out of sequence.  Found (100002) but expected (8)',
            'Tests out of sequence.  Found (100003) but expected (9)',
            'Tests out of sequence.  Found (100004) but expected (10)',
            'Tests out of sequence.  Found (100005) but expected (11)',
            'Bad plan.  You planned 2 tests but ran 11.'
        ],
        'exit' => 0,
        wait   => 0,
    },
    combined => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..10',
                tests_planned => 10,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => 'basset hounds got long ears',
                explanation   => '',
            },
            {   actual_passed => FALSE,
                is_actual_ok  => FALSE,
                passed        => FALSE,
                is_ok         => FALSE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => 'all hell broke loose',
                explanation   => '',
            },
            {   actual_passed => FALSE,
                is_actual_ok  => FALSE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => TRUE,
                number        => 4,
                description   => '',
                explanation   => 'if I heard a voice from heaven ...',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => 'say "live without loving",',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 6,
                description   => "I'd beg off.",
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => '1',
                has_todo      => FALSE,
                number        => 7,
                description   => '',
                explanation   => 'contract negotiations',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 8,
                description   => 'Girls are such exquisite hell',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => TRUE,
                number        => 9,
                description   => 'Elegy 9B',
                explanation   => '',
            },
            {   actual_passed => FALSE,
                is_actual_ok  => FALSE,
                passed        => FALSE,
                is_ok         => FALSE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 10,
                description   => '',
                explanation   => '',
            },
        ],
        plan          => '1..10',
        passed        => [ 1 .. 2, 4 .. 9 ],
        actual_passed => [ 1 .. 2, 5 .. 9 ],
        failed        => [ 3, 10 ],
        actual_failed => [ 3, 4, 10 ],
        todo          => [ 4, 9 ],
        todo_failed   => [9],
        skipped       => [7],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 10,
        tests_run     => 10,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    head_end => {
        results => [
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'comments',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => '',
                explanation   => '',
            },
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'comment',
            },
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..4',
                tests_planned => 4,
            },
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'more ignored stuff',
            },
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'and yet more',
            },
        ],
        plan          => '1..4',
        passed        => [ 1 .. 4 ],
        actual_passed => [ 1 .. 4 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 4,
        tests_run     => 4,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    head_fail => {
        results => [
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'comments',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => FALSE,
                is_actual_ok  => FALSE,
                passed        => FALSE,
                is_ok         => FALSE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => '',
                explanation   => '',
            },
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'comment',
            },
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..4',
                tests_planned => 4,
            },
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'more ignored stuff',
            },
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'and yet more',
            },
        ],
        plan          => '1..4',
        passed        => [ 1, 3, 4 ],
        actual_passed => [ 1, 3, 4 ],
        failed        => [2],
        actual_failed => [2],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 4,
        tests_run     => 4,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    out_of_order => {
        results => [
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => '- Test that argument passing works',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   =>
                  '- Test that passing arguments as references work',
                explanation => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => '- Test a normal sub',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 6,
                description   => '- Detach test',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 8,
                description   => '- Nested thread test',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 9,
                description   => '- Nested thread test',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 10,
                description   => '- Wanted 7, got 7',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 11,
                description   => '- Wanted 7, got 7',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 12,
                description   => '- Wanted 8, got 8',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 13,
                description   => '- Wanted 8, got 8',
                explanation   => '',
            },
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..15',
                tests_planned => 15,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => '- Check that Config::threads is true',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 7,
                description   => '- Detach test',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 14,
                description   =>
                  '- Check so that tid for threads work for main thread',
                explanation => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 15,
                description   =>
                  '- Check so that tid for threads work for main thread',
                explanation => '',
            },
        ],
        plan          => '1..15',
        passed        => [ 2 .. 4, 6, 8 .. 13, 1, 5, 7, 14, 15 ],
        actual_passed => [ 2 .. 4, 6, 8 .. 13, 1, 5, 7, 14, 15 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        is_good_plan  => FALSE,
        tests_planned => 15,
        tests_run     => 15,

        # Note that tests 14 and 15 *are* in the correct sequence.
        parse_errors => [
            'Tests out of sequence.  Found (2) but expected (1)',
            'Tests out of sequence.  Found (3) but expected (2)',
            'Tests out of sequence.  Found (4) but expected (3)',
            'Tests out of sequence.  Found (6) but expected (4)',
            'Tests out of sequence.  Found (8) but expected (5)',
            'Tests out of sequence.  Found (9) but expected (6)',
            'Tests out of sequence.  Found (10) but expected (7)',
            'Tests out of sequence.  Found (11) but expected (8)',
            'Tests out of sequence.  Found (12) but expected (9)',
            'Tests out of sequence.  Found (13) but expected (10)',
            'Plan (1..15) must be at the beginning or end of the TAP output',
            'Tests out of sequence.  Found (1) but expected (11)',
            'Tests out of sequence.  Found (5) but expected (12)',
            'Tests out of sequence.  Found (7) but expected (13)',
        ],
        'exit' => 0,
        wait   => 0,
    },
    skipall => {
        results => [
            {   is_plan       => TRUE,
                raw           => '1..0 # skip: rope',
                tests_planned => 0,
                passed        => TRUE,
                is_ok         => TRUE,
                directive     => 'SKIP',
                explanation   => ': rope'
            },
        ],
        plan          => '1..0',
        passed        => [],
        actual_passed => [],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 0,
        tests_run     => 0,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    skipall_nomsg => {
        results => [
            {   is_plan       => TRUE,
                raw           => '1..0',
                tests_planned => 0,
                passed        => TRUE,
                is_ok         => TRUE,
                directive     => 'SKIP',
                explanation   => ''
            },
        ],
        plan          => '1..0',
        passed        => [],
        actual_passed => [],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 0,
        tests_run     => 0,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    todo_misparse => {
        results => [
            {   is_plan       => TRUE,
                raw           => '1..1',
                tests_planned => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
            },
            {   actual_passed => FALSE,
                is_actual_ok  => FALSE,
                passed        => FALSE,
                is_ok         => FALSE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => 'Hamlette # TODOORNOTTODO',
                explanation   => '',
            },
        ],
        plan          => '1..1',
        passed        => [],
        actual_passed => [],
        failed        => [1],
        actual_failed => [1],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => TRUE,
        tests_run     => 1,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    shbang_misparse => {
        results => [
            {   is_plan       => TRUE,
                raw           => '1..2',
                tests_planned => 2,
                passed        => TRUE,
                is_ok         => TRUE,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                description   => "",
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => "",
            },
        ],
        plan          => '1..2',
        passed        => [ 1 .. 2 ],
        actual_passed => [ 1 .. 2 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 2,
        tests_run     => 2,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    switches => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..1',
                tests_planned => 1,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => "",
                explanation   => '',
            },
        ],
        __ARGS__      => { switches => '-Mstrict', },
        plan          => '1..1',
        passed        => [1],
        actual_passed => [1],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 1,
        tests_run     => TRUE,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    inc_taint => {
        results => [
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..1',
                tests_planned => 1,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => "",
                explanation   => '',
            },
        ],
        __ARGS__      => { switches => '-Iwe_added_this_lib', },
        plan          => '1..1',
        passed        => [1],
        actual_passed => [1],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 1,
        tests_run     => TRUE,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    sequence_misparse => {
        results => [
            {   is_plan       => TRUE,
                raw           => '1..5',
                tests_planned => 5,
                passed        => TRUE,
                is_ok         => TRUE,
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => "",
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => "\# skipped on foobar system",
            },
            {   is_comment => TRUE,
                comment    => '1234567890123456789012345678901234567890',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => "",
            },
            {   is_comment => TRUE,
                comment    => '1234567890123456789012345678901234567890',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 5,
                description   => "",
            },
        ],
        plan          => '1..5',
        passed        => [ 1 .. 5 ],
        actual_passed => [ 1 .. 5 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 5,
        tests_run     => 5,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    stdout_stderr => {

        # this switch is only necesassary when running tests because it allows
        # the tests executed with 'open("$command |")' to pick up the current
        # lib path.
        results => [
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'comments',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 1,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 2,
                description   => '',
                explanation   => '',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 3,
                description   => '',
                explanation   => '',
            },
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'comment',
            },
            {   actual_passed => TRUE,
                is_actual_ok  => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                is_test       => TRUE,
                has_skip      => FALSE,
                has_todo      => FALSE,
                number        => 4,
                description   => '',
                explanation   => '',
            },
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'more ignored stuff',
            },
            {   is_comment => TRUE,
                passed     => TRUE,
                is_ok      => TRUE,
                comment    => 'and yet more',
            },
            {   is_plan       => TRUE,
                passed        => TRUE,
                is_ok         => TRUE,
                raw           => '1..4',
                tests_planned => 4,
            },
        ],
        plan          => '1..4',
        passed        => [ 1 .. 4 ],
        actual_passed => [ 1 .. 4 ],
        failed        => [],
        actual_failed => [],
        todo          => [],
        todo_failed   => [],
        skipped       => [],
        good_plan     => TRUE,
        is_good_plan  => TRUE,
        tests_planned => 4,
        tests_run     => 4,
        parse_errors  => [],
        'exit'        => 0,
        wait          => 0,
    },
    #schwern => {

    #    # this switch is only necesassary when running tests because it allows
    #    # the tests executed with 'open("$command |")' to pick up the current
    #    # lib path.
    #    results => [
    #        {   is_plan       => TRUE,
    #            passed        => TRUE,
    #            is_ok         => TRUE,
    #            raw           => '1..1',
    #            tests_planned => 1,
    #        },
    #        {   is_comment => TRUE,
    #            passed     => TRUE,
    #            is_ok      => TRUE,
    #            comment    => 
    #            "You named your test '42'.  You shouldn't use numbers for your test names."
    #        },
    #        {   is_comment => TRUE,
    #            passed     => TRUE,
    #            is_ok      => TRUE,
    #            comment    => 'Very confusing.',
    #        },
    #        {   actual_passed => TRUE,
    #            is_actual_ok  => TRUE,
    #            passed        => TRUE,
    #            is_ok         => TRUE,
    #            is_test       => TRUE,
    #            has_skip      => FALSE,
    #            has_todo      => FALSE,
    #            number        => 1,
    #            description   => '- 42',
    #            explanation   => '',
    #        },
    #    ],
    #    plan          => '1..1',
    #    passed        => [ 1 .. 1 ],
    #    actual_passed => [ 1 .. 1 ],
    #    failed        => [],
    #    actual_failed => [],
    #    todo          => [],
    #    todo_failed   => [],
    #    skipped       => [],
    #    good_plan     => TRUE,
    #    is_good_plan  => TRUE,
    #    tests_planned => 1,
    #    tests_run     => 1,
    #    parse_errors  => [],
    #    'exit'        => 0,
    #    wait          => 0,
    #},
);

my %HANDLER_FOR = (
    NOT_ZERO, sub { local $^W; 0 != shift },
    TRUE,     sub { local $^W; !!shift },
    FALSE,    sub { local $^W; !shift },
);

foreach my $test ( sort keys %samples ) {

    #next unless 'out_of_order' eq $test;
    my $details = $samples{$test};
    my $results = delete $details->{results};
    my $args    = delete $details->{__ARGS__} || { switches => '' };

    # the following acrobatics are necessary to make it easy for the
    # Test::Builder::failure_output() method to be overridden when
    # TAPx::Parser is not installed.  Otherwise, these tests will fail. 
    my @switches = 'ARRAY' eq $args->{switches} 
         ? @{ $args->{switches} }
         : $args->{switches};
    $args->{switches} = [ '-Ilib',  @switches ];

    $args->{source} = File::Spec->catfile( $SAMPLE_TESTS, $test );

    my $parser = eval { analyze_test( $test, $results, $args ) };
    my $error = $@;
    ok !$error, "'$test' should parse successfully" or diag $error;

    if ($error) {
        my $tests = 0;
        while ( my ( $method, $answer ) = each %$details ) {
            $tests += ref $answer ? 2 : 1;
        }
        SKIP: {
            skip "$test did not parse successfully", $tests;
        }
    }
    else {
        while ( my ( $method, $answer ) = each %$details ) {
            if ( my $handler = $HANDLER_FOR{ $answer || '' } ) {    # yuck
                ok $handler->( $parser->$method ),
                  "... and $method should return a reasonable value";
            }
            elsif ( !ref $answer ) {
                local $^W;    # uninit warnings
                is $parser->$method, $answer,
                  "... and $method should equal $answer";
            }
            else {
                is scalar $parser->$method, scalar @$answer,
                  "... and $method should be the correct amount";
                is_deeply [ $parser->$method ], $answer,
                  "...... and the correct values"
                  or diag +Data::Dumper->Dump(
                    [ [ $parser->$method ], $answer ],
                    [ '*got', '*expected' ]
                  );
            }
        }
    }
}

sub analyze_test {
    my ( $test, $results, $args ) = @_;

    my $parser = TAPx::Parser->new($args);
    my $count  = 1;
    while ( defined( my $result = $parser->next ) ) {
        my $expected = shift @$results;
        my $raw      = $result->raw;
        ok defined $expected, "$test $count We should have a result for $raw";
        $count++;
        while ( my ( $method, $answer ) = each %$expected ) {
            if ( my $handler = $HANDLER_FOR{ $answer || '' } ) {    # yuck
                ok $handler->( $result->$method ),
                  "... and $method should return a reasonable value";
            }
            else {
                is $result->$method, $answer,
                  "... and $method should return the correct answer";
            }
        }
    }
    ok !@$results, '... and we should have the correct number of results';
    return $parser;
}

# vms_nit
