package App::SimpleBackuper;

=pod

=head1 What's this

B<Simple-backuper> is a simple tool for backuping files and restoring it from backups.

=head1 Benefits

=over

=item * Simplicity and transparency. Few lib files and one short script. Most programmers can understand it.

=item * Efficient use of disk space (incremental backup):

=over

=item * Automatic deduplication of parts of files (most modified files differ only partially).

=item * All files will be compressed with archivator (compression level may be configured).

=item * Incremental backup format doesn't require initial data snapshot.

=back

=item * Security:

=over

=item * All files will be encrypted with AES256 + RSA4096.

=item * Encryption doing before data send to storage host.

=item * For backuping you don't need to keep private RSA key accessible to this program. It needs only for restoring.

=item * Thus, even with the backup data, no one can get the source files from them. And also no one can fake a backup.

=back

=item * You can specify different priorities for any files.

=item * For recover your backup you need only: access to storage host, your crypting keys and some backup options.

=item * You can backup to local directory or to remote sftp server.

=item * Requires on backuper host: perl and some perl libs.

=item * Requires on SFTP storage host: disk space only.

=back

=head1 Installing

You can install simple-backuper from CPAN (perl packages repository) or directly from github.

=head2 From CPAN

C<cpan install App::SimpleBackuper>

=head2 From GitHub

=over

=item * C<git clone https://github.com/dmitry-novozhilov/simple-backuper.git>

=item * C<cd simple-backuper>

=item * C<make>

=item * C<perl Makefile.pl>

=item * C<sudo make install>

=back

=head1 Configuring

You need a configuration file. By default simple-backuper trying to read ~/.simple-backuper/config, but you can use other path.
In this case you need specify --cfg option on all simple-backuper run.

This file is json with comments allowed. It can be like this:

    {

        "db":                   "~/.simple-backuper/db",        // This database file changes every new backup. ~/.simple-backuper/db - is a default value.

        "compression_level":    9,                              // LZMA algorythm supports levels 1 to 9

        "public_key":           "~/.simple-backuper/key.pub",   // This key using with "backup" command.
                                                                // For restore-db command you need to use private key of this public key.
                                                                
                                                                // Creating new pair of keys:
                                                                // Private (for restoring): openssl genrsa -out ~/.simple-backuper/key 4096
                                                                // Public (for backuping): openssl rsa -in ~/.simple-backuper/key -pubout > ~/.simple-backuper/key.pub
                                                                // Keep the private key as your most valuable asset. Copy it to a safe place.
                                                                // It is desirable not in the backup storage, otherwise it will make it possible to use the backup data for someone other than you.

        "storage":              "/mnt/backups",                 // Use "host:path" or "user@host:path" for remote SFTP storage.
                                                                // All transfered data already encrypted.
                                                                // If you choose SFTP, make sure that this SFTP server works without a password.
                                                                // This can be configured with ~/.ssh/ config and ssh key-based authorization.

        "space_limit":          "100G",                         // Maximum of disc space on storage.
                                                                // While this limit has been reached, simple-backuper deletes the oldest and lowest priority file.
                                                                // K means kilobytes, M - megabytes, G - gygabytes, T - terabytes.

        "files": {                                              // Files globs with it's priorityes.
            "~":                            5,
            "~/.gnupg":                     50,                 // The higher the priority, the less likely it is to delete these files.
            "~/.bash_history":              0,                  // Zero priority prohibits backup. Use it for exceptions.
            "~/.cache":                     0,
            "~/.local/share/Trash":         0,
            "~/.mozilla/firefox/*/Cache":   0,
            "~/.thumbnails":                0,
        }
    }

=head1 First (initial) backup

After configuring you need to try backuping to check for it works:
C<simple-backuper backup --backup-name initial --verbose>

The initial backup will take a long time. It takes me more than a day.

The next backups will take much less time. Because usually only a small fraction of the files are changed.

=head1 Scheduled backups

You can add to crontab next command:
C<
0 0 * * * simple-backuper backup --backup-name `date -Idate`
>
It creates backup named as date every day.

=head1 Logging

Simple backuper is so simple that it does not log itself. You can write logs from STDOUT & STDERR:
C<< 
0 0 * * * simple-backuper backup --backup-name `date -Idate` 2E<gt>&1 E<gt>E<gt> simple-backuper.log
 >>

=head1 Recovering

=over

=item 1. The first thing you need is a database file. If you have it, move to next step. Otherwise you can restore it from your backup storage:

C<simple-backuper restore-db --storage YOUR_STORAGE --priv-key KEY>

=over

=item

YOUR_STORAGE - is your C<storage> option from config. For example C<my_ssh_backup_host:/path/to/backup/>.

=item

KEY - is path to your private key!

=back

=item 2. Chose backup and files by exploring you storage by commands like C<simple-backuper info>, C<simple-backuper info /home>,..

=item 3. Try to dry run of restoring files: C<simple-backuper restore --path CHOSED_PATH --backup-name CHOSED_BACKUP --storage YOUR_STORAGE --destination TARGET_DIR>

=over

=item

CHOSED_PATH - is path in backup to restoring files.

=item

CHOSED_BACKUP - is what version of your files must be restored.

=item

YOUR_STORAGE - is your C<storage> option from config. For example C<my_ssh_backup_host:/path/to/backup/>.

=item

TARGET_DIR - is dir for restored files.

=back

=item 4. If all ok, run restoring files with same command and C<--write> argument!

=back
=cut

use strict;
use warnings;
our $VERSION = '0.1';

1;
