/*
 * Unicode-Precis-Preparation
 *
 * Copyright (C) 2015 by Hatuka*nezumi - IKEDA Soji
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the same terms as Perl. For more details, see the full text of
 * the licenses at <http://dev.perl.org/licenses/>.
 *
 * This program is distributed in the hope that it will be
 * useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 */

#include <assert.h>
#include "precis_preparation.h"

/* Lines below are automatically generated.  Don't edit them manually. */
#define PROP_BLKWIDTH (6)
#define AGE_BLKWIDTH (5)
#define XPROP_BLKWIDTH (7)

#define JT_T (0x80)
#define JT_R (0x40)
#define JT_L (0x20)
#define JT_D (JT_R | JT_L)
#define JT_MASK (JT_T | JT_R | JT_L)

typedef enum {
    CCC_VIRAMA = 1,
    CH_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits,
    CH_GERESH,
    CH_GERSHAYIM,
    CH_KERAIA,
    CH_NAKAGURO,
    CH_MIDDLEDOT,
    CH_SMALLL,
    CH_ZWJ,
    CH_ZWNJ,
    SC_Greek,
    SC_Han,
    SC_Hebrew,
    SC_Hiragana,
    SC_Katakana
} xprop_t;


/* Lines below are automatically generated. Don't edit them manually. */
static U16 precis_prop_index[] = {
    0, 33, 96, 160, 216, 279, 343, 403, 343, 343, 359, 465, 343, 527, 590,
    638, 343, 343, 700, 343, 724, 773, 830, 892, 956, 1020, 343, 1077,
    1141, 1194, 1208, 1272, 1336, 1400, 1432, 1477, 343, 1541, 1605, 1665,
    1728, 1790, 1853, 1913, 1976, 2036, 2098, 2160, 2223, 2284, 2348, 2408,
    2470, 2531, 2595, 2659, 2722, 2786, 2849, 2913, 2977, 3039, 3102, 3164,
    343, 3228, 3262, 3320, 3384, 3384, 3384, 3384, 343, 3448, 3503, 3565,
    3612, 3649, 3713, 3745, 32, 343, 343, 343, 343, 343, 343, 343, 343,
    3247, 3809, 3841, 3905, 3969, 4033, 4087, 4151, 4183, 4247, 4295, 4359,
    4423, 4487, 4541, 4605, 4638, 4701, 4747, 343, 4811, 343, 4875, 4939,
    5003, 4747, 5065, 5129, 5189, 5246, 5310, 343, 343, 5370, 343, 5412,
    5470, 5534, 5596, 5660, 5707, 5759, 5818, 5882, 5918, 5979, 5995, 5995,
    5995, 5995, 5995, 5995, 5995, 5995, 6007, 6020, 6084, 5995, 5995, 5995,
    5995, 5995, 5995, 5995, 5995, 5995, 5995, 5994, 5995, 5995, 5995, 5995,
    5995, 5995, 5995, 5995, 5995, 5995, 5995, 5995, 5995, 5995, 5995, 5995,
    6135, 4747, 4747, 6199, 6215, 343, 6277, 6341, 6389, 6452, 6484, 6548,
    4747, 6612, 6007, 5995, 5995, 5995, 6654, 6718, 6782, 6823, 6856, 6920,
    6969, 7018, 7082, 7146, 5995, 5995, 5996, 5995, 5995, 5995, 5995, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 4295, 5995, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 7210, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 7274, 7331, 343, 343, 343, 343, 7380, 7444, 7507, 7538, 7602, 294,
    7657, 7700, 7758, 7822, 343, 7886, 3246, 7950, 343, 8014, 8078, 8142,
    343, 8206, 8269, 4747, 4747, 8333, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 8397,
    8454, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384, 3384,
    3384, 5995, 5995, 5995, 5995, 8518, 8560, 5995, 8608, 8672, 8736, 5995,
    8798, 5995, 5995, 5995, 5995, 5995, 8801, 8849, 8905, 8969, 9017, 5995,
    9071, 5994, 5995, 9135, 9198, 9262, 9325, 343, 9389, 9453, 5995, 9508,
    9556, 4747, 4747, 9620, 9667, 9731, 9794, 9858, 9918, 343, 343, 9982,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 10046, 10109, 4747, 4747, 10173, 4747, 10237, 4747, 10299, 10363,
    4747, 4747, 10427, 10491, 4747, 4747, 343, 7691, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 10555, 4747, 4747, 4747, 4747, 4747, 4747, 343,
    10619, 10683, 10745, 10809, 4743, 343, 10868, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4183, 7690, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 10932, 4747, 4747, 5995, 10996, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 10932, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 343, 343, 343, 343, 343, 343, 343, 343, 11060, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 343, 11112, 11175, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 11205, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 5995, 5995,
    5995, 6005, 8567, 11269, 11330, 11376, 5995, 11440, 4747, 4747, 5995,
    11504, 4747, 4747, 5995, 11568, 11603, 11664, 11722, 11786, 5995, 5995,
    5995, 5995, 8568, 5995, 5995, 5995, 5995, 11838, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 11898, 11960, 12024, 12084, 4747, 4747, 4747, 4747, 12148, 5995,
    12196, 12259, 12323, 12148, 12371, 11231, 12435, 12485, 4747, 4747,
    12549, 5998, 12604, 12663, 5996, 12727, 5995, 12735, 5997, 12792, 4747,
    11210, 5995, 12856, 5995, 4741, 5995, 6007, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 12872, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 9661, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 343, 3745, 343, 343,
    343, 9654, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 5995, 5995, 5995, 5995, 5995, 5995, 5995,
    5995, 11376, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 12872, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747, 4747,
    4747, 4747, 4747, 4747, 4747, 4747, 12872
};

/* Lines below are automatically generated. Don't edit them manually. */
static U8 precis_prop_array[] = {
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_CONTEXTO, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_CONTEXTO,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_CONTEXTO,
    PRECIS_CONTEXTO, PRECIS_CONTEXTO, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_CONTEXTJ, PRECIS_CONTEXTJ, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_UNASSIGNED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_CONTEXTO, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_DISALLOWED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED, PRECIS_DISALLOWED, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_PVALID,
    PRECIS_PVALID, PRECIS_PVALID, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS, PRECIS_ID_DIS,
    PRECIS_ID_DIS, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_UNASSIGNED,
    PRECIS_UNASSIGNED, PRECIS_UNASSIGNED, PRECIS_DISALLOWED,
    PRECIS_DISALLOWED
};

static U8 precis_prop_lookup(U32 cp)
{
    if ((cp & 0x00FFFE) == 0x00FFFE
	|| cp == 0x0E0001 || (0x0E0020 <= cp && cp <= 0x0E007F)
	|| (0x0E0100 <= cp && cp <= 0x0E01EF)
	|| (0x0F0000 <= cp && cp <= 0x0FFFFD)
	|| (0x100000 <= cp && cp <= 0x10FFFD))
	return PRECIS_DISALLOWED;
    else if (0x040000 <= cp)
	return PRECIS_UNASSIGNED;

    return precis_prop_array[precis_prop_index[cp >> PROP_BLKWIDTH] +
			     (cp & ((1 << PROP_BLKWIDTH) - 1))
	];
}

/* Lines below are automatically generated. Don't edit them manually. */
static U16 precis_age_index[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 36, 68, 98, 0, 0, 121,
    1, 143, 0, 0, 175, 207, 0, 0, 237, 267, 299, 0, 315, 0, 345, 0, 372,
    392, 424, 452, 0, 0, 474, 504, 532, 0, 564, 596, 628, 660, 0, 676, 708,
    726, 758, 777, 798, 816, 848, 863, 895, 900, 932, 950, 982, 0, 0, 1014,
    0, 1042, 1074, 1080, 1108, 1132, 0, 1164, 1194, 1209, 1240, 0, 1255,
    1251, 1275, 0, 0, 1306, 0, 1172, 1334, 1364, 0, 1388, 1411, 1437, 0,
    1464, 1342, 1494, 0, 1526, 0, 1556, 0, 1579, 1609, 1639, 1671, 1697,
    1729, 1761, 0, 0, 0, 0, 0, 0, 1782, 0, 1814, 1814, 1838, 1860, 1880,
    1905, 1935, 0, 848, 1967, 1999, 2025, 2031, 0, 2063, 2077, 0, 0, 2109,
    0, 0, 2132, 0, 2140, 2172, 848, 2197, 848, 2229, 2189, 2260, 2284,
    2301, 848, 2325, 2356, 2388, 848, 848, 2420, 2452, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    2461, 2493, 848, 848, 2505, 2537, 2569, 2572, 2604, 848, 848, 2636,
    2668, 2700, 848, 848, 2498, 848, 2732, 932, 2748, 2780, 2797, 2829,
    2847, 2879, 2901, 2923, 2955, 2987, 932, 933, 935, 3019, 3051, 0, 0,
    895, 895, 3083, 898, 2025, 3115, 3147, 3159, 2025, 3191, 3205, 2025, 0,
    0, 3237, 3253, 2955, 2955, 2955, 2975, 2879, 2879, 3285, 3310, 0, 0, 0,
    0, 3342, 0, 0, 3374, 0, 0, 0, 0, 0, 0, 0, 0, 0, 708, 3406, 3437, 3455,
    3484, 0, 3514, 0, 3531, 3560, 0, 3589, 0, 0, 3610, 0, 0, 0, 0, 0, 0, 0,
    3642, 3674, 0, 0, 3679, 3708, 3735, 3752, 3780, 0, 3807, 0, 0, 0, 0, 0,
    3828, 0, 0, 0, 0, 3817, 0, 0, 3860, 3892, 0, 0, 3918, 3950, 3982, 4007,
    4037, 4069, 4093, 4113, 4144, 4166, 4190, 4222, 4242, 848, 848, 848,
    848, 848, 848, 848, 848, 3735, 3735, 3735, 3735, 3735, 3735, 3735,
    3735, 3735, 3735, 3735, 3735, 3735, 3735, 3735, 3735, 4274, 4297, 4316,
    0, 0, 0, 0, 0, 2879, 4348, 4364, 4396, 2879, 2879, 2879, 4428, 2879,
    4454, 2879, 4480, 4512, 4544, 4544, 2025, 4576, 4606, 0, 0, 4638, 848,
    848, 2502, 848, 848, 848, 848, 848, 848, 2500, 4670, 0, 4698, 0, 0,
    4729, 4760, 0, 4761, 0, 1325, 0, 0, 0, 4793, 814, 4825, 4857, 0, 4888,
    4920, 0, 3822, 4951, 0, 0, 0, 0, 4967, 0, 0, 4994, 5026, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 2500, 2955, 2955, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5058,
    5086, 0, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 848,
    848, 848, 848, 848, 848, 848, 848, 848, 848, 848, 1681, 5118, 5149,
    932, 2025, 2025, 2025, 2025, 2025, 2025, 2025, 2025, 2025, 3305, 2025,
    5181, 5209, 932, 932, 5241, 5273, 5298, 2025, 2025, 5317, 5349, 0,
    5360, 2879, 5392, 895, 5424, 2025, 2025, 5456, 5488, 2025, 2025, 5520,
    5552, 932, 932, 5584, 0, 2025, 5616, 5648, 5488, 932, 932, 5680, 5712,
    5743, 5775, 0, 0, 0, 0, 932, 5807, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 5839, 5864, 5488, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1814,
    1814, 1814, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5896,
    3735, 5917, 2879, 2879, 2388, 0, 5949, 0, 0, 0, 0, 5979, 6009, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6025, 6041, 6073, 6101, 6128, 6141,
    0, 0, 0, 0, 0, 0, 4761, 4760, 0, 0, 0, 6161, 6193, 6198, 6229, 0, 2955,
    2955, 2955, 6261, 6293, 6305, 2879, 2879, 6337, 0, 6365, 6381, 0, 0, 0,
    0, 6382, 2025, 3300, 0, 6414, 6441, 6462, 0, 6494, 2879, 6526, 0, 6558,
    6584, 6602, 2955, 6616, 6636, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6668, 6678, 6710, 0, 0, 0, 0, 0,
    6742, 6774, 0, 0, 6806, 6814, 0, 0, 6846, 6871, 6902, 932, 0, 0, 0, 0,
    932, 5559, 942, 6934, 0, 0, 0, 0, 932, 932, 6958, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 933, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    3147, 3147, 6990, 7008, 932, 932, 7040, 7063, 6806, 7095, 7123, 0,
    6806, 6806, 7063, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6806, 7155,
    7117, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 895, 895, 895, 895, 895, 895, 895, 895, 895, 895, 895, 895,
    895, 895, 895, 895, 895, 895, 895, 895, 895, 895, 895, 895, 895, 895,
    895, 7187, 0, 0, 0, 0, 895, 895, 895, 7219, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 7251, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3147, 3147, 3147, 3147, 3147, 3147, 3147, 3147, 3147, 3147,
    3147, 3147, 3147, 3147, 3147, 3147, 3147, 3154, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 6806, 6806, 7283, 6807, 1031, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 6009, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6423, 6558, 7315, 6558, 6558, 6558, 6558,
    6415, 0, 2879, 2879, 5943, 0, 0, 0, 0, 0, 2955, 2955, 6623, 7347, 0, 0,
    0, 0, 6558, 6558, 7379, 6558, 7401, 7433, 7464, 6558, 7490, 7470, 7520,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 7548, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 7570, 6558, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7602, 7634, 7664, 7694, 7726, 7757, 0, 7785, 0, 0, 0, 0, 0, 0, 0,
    0, 2025, 7817, 2025, 2025, 3297, 7849, 7880, 0, 7912, 7929, 7961, 7993,
    8025, 0, 0, 8052, 8084, 8100, 8132, 0, 0, 0, 0, 0, 3147, 8149, 3147,
    3150, 8172, 3147, 8204, 8236, 3147, 3148, 8268, 3147, 3147, 3147, 3147,
    8276, 3147, 3149, 8308, 6003, 0, 0, 0, 8340, 8372, 8404, 8435, 0, 3147,
    3147, 6005, 0, 3147, 3147, 3147, 8172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 8451, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6422, 0, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932,
    932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 932, 5875,
    3147, 3147, 3147, 3147, 3147, 3147, 3149, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6558,
    6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558, 6558,
    6558, 6558, 6558, 6415, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8451, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8451
};

/* Lines below are automatically generated. Don't edit them manually. */
static U8 precis_age_array[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x32, 0x40, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0,
    0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x40, 0x40, 0x40, 0, 0, 0x30, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x51, 0x51, 0x51, 0x51, 0, 0,
    0x51, 0x51, 0, 0, 0, 0x50, 0x50, 0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x51, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x32, 0x32, 0, 0x30, 0,
    0x30, 0, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x31, 0x31, 0x32, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41,
    0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x30, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x30, 0x30, 0x32, 0x32, 0x30, 0x30,
    0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32,
    0, 0, 0x32, 0x32, 0, 0, 0x32, 0x32, 0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0, 0,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x50, 0x50,
    0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x52, 0x52, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0, 0, 0, 0, 0x61, 0, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x41, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50, 0, 0, 0, 0,
    0, 0x20, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x61, 0, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x41, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0x63, 0, 0x41, 0, 0x60, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32,
    0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x30, 0x30, 0, 0, 0, 0, 0, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40,
    0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x40,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x40, 0x40, 0x40, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0, 0, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0, 0, 0x60, 0, 0x61, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0, 0x52, 0, 0, 0, 0x40, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60,
    0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x60, 0, 0, 0, 0,
    0, 0x52, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x51, 0x51, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0x52, 0x52, 0x50, 0x50,
    0x41, 0x50, 0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0, 0, 0, 0, 0x40, 0, 0x40, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x61, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x40, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0, 0, 0x51, 0x51, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0, 0, 0x50, 0x50, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50, 0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60,
    0, 0, 0x51, 0, 0, 0, 0, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0x30, 0x30, 0, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0x30, 0, 0,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0x30, 0, 0, 0, 0,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0x30, 0, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x61, 0x61, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x51, 0x51, 0, 0, 0, 0, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30,
    0x20, 0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x30, 0x30, 0x30, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x30, 0x20, 0x30, 0x30, 0x30, 0, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0x51, 0x30,
    0x41, 0x41, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x60, 0x60, 0, 0,
    0, 0, 0, 0x30, 0x30, 0x51, 0x30, 0x30, 0x30, 0x30, 0x30, 0x51, 0x30,
    0x30, 0x51, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x51, 0x51, 0x51,
    0x30, 0x30, 0x30, 0x30, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0x52,
    0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0x61, 0, 0, 0, 0, 0, 0x61, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32,
    0x41, 0x41, 0, 0x41, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52,
    0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x41, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x41, 0x30, 0, 0x30, 0x30, 0x30, 0x30, 0, 0,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0x30, 0, 0x30, 0x30, 0x30,
    0x30, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x41, 0x30, 0,
    0x30, 0x30, 0x30, 0x30, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0x30, 0x30,
    0x30, 0x30, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x41, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x41, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x41, 0x30, 0, 0x30, 0x30, 0x30, 0x30, 0, 0, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x41, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0, 0, 0x60, 0x60, 0x41, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0, 0x32,
    0x32, 0x32, 0, 0x32, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x40, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0,
    0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x51,
    0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0,
    0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0, 0, 0, 0, 0x40, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0, 0x40,
    0x40, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x52, 0x52, 0, 0, 0, 0, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x52, 0, 0, 0, 0x41, 0x41, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0x41, 0x41, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0,
    0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0, 0, 0, 0, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x61, 0x61, 0x61, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0,
    0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0,
    0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x61, 0x61,
    0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x60, 0x52, 0x50, 0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20, 0x51, 0x51, 0x51, 0x51,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0x32,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32, 0x32, 0x32, 0x32, 0x32, 0x40,
    0x40, 0x41, 0x41, 0x32, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x32,
    0x32, 0x32, 0x32, 0x51, 0, 0x63, 0x63, 0x63, 0x63, 0, 0, 0, 0, 0, 0, 0,
    0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x20, 0x21, 0x30, 0x30, 0x30, 0x32, 0x32, 0x41,
    0x41, 0x41, 0x41, 0x52, 0x52, 0x52, 0x60, 0x62, 0, 0, 0, 0, 0, 0x30,
    0x30, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x41, 0x50, 0x50, 0x50,
    0x50, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x30, 0x30, 0x40, 0x41, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x41, 0x50, 0x50, 0x51, 0x52,
    0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x50, 0x51,
    0x51, 0x51, 0x51, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0,
    0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x32, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x52, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x40, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x32, 0x32, 0x41, 0x30,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x41, 0x41,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x51, 0x52, 0x52, 0x40, 0x40, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x60,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x60, 0x52, 0x60, 0x60, 0x60, 0x60, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0,
    0, 0, 0, 0x60, 0, 0, 0, 0, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0, 0x60, 0, 0, 0, 0, 0x60, 0x60,
    0x60, 0, 0x52, 0, 0, 0, 0, 0, 0, 0, 0x60, 0, 0, 0, 0, 0, 0, 0, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x50, 0x50, 0x50, 0x50, 0x61, 0x51, 0x61, 0x60, 0x60,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x51, 0x51, 0x51, 0x51, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x51,
    0x51, 0x51, 0x52, 0x51, 0x51, 0x51, 0x50, 0x50, 0x50, 0x50, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x61, 0x61, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0,
    0x61, 0, 0, 0, 0, 0, 0x61, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x61, 0x61,
    0, 0, 0, 0, 0, 0, 0, 0x41, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x60, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x51, 0x51, 0x51, 0x51, 0x41, 0x41, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x52,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x32, 0x32, 0x32, 0x30, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x32, 0,
    0, 0, 0, 0, 0, 0, 0, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x60, 0x60, 0x60,
    0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0, 0, 0, 0,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x40, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x41, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40, 0, 0, 0, 0, 0, 0, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x51, 0x51, 0x51,
    0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x61, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x32, 0x32,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x32, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x32, 0x30, 0x30, 0x30, 0x32, 0x30, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x60, 0x60, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0,
    0, 0, 0, 0, 0, 0x61, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x50, 0x50, 0x50, 0x50, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x60, 0x60, 0, 0x60, 0x60, 0x61, 0x61, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x61, 0x61, 0x60, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0, 0, 0, 0, 0, 0, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51,
    0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0,
    0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0, 0, 0, 0, 0x52, 0x52, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0, 0, 0x51, 0x51, 0x51, 0x51, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0x20, 0x20, 0x20,
    0x20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0,
    0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x61, 0x61, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x52,
    0x52, 0x52, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32,
    0x40, 0, 0, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32,
    0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x32,
    0x32, 0x40, 0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x30, 0x30, 0x30, 0x21, 0, 0, 0, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0x40, 0x40, 0, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0, 0, 0, 0, 0x40, 0x40, 0x40, 0,
    0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0, 0, 0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0, 0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0x40, 0x41, 0x41, 0x41, 0x41, 0,
    0, 0, 0, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x40, 0x40, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0, 0x40, 0, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0, 0x40, 0x40, 0, 0, 0, 0x40,
    0, 0, 0x40, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x52, 0x52, 0, 0, 0, 0x50, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0, 0, 0, 0, 0, 0x51, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0x61, 0x61,
    0x41, 0x41, 0x41, 0x41, 0, 0x41, 0x41, 0, 0, 0, 0, 0, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0, 0x41, 0x41, 0x41, 0, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
    0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0x41, 0x41, 0x41, 0, 0, 0, 0,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0, 0, 0,
    0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0, 0, 0, 0, 0, 0,
    0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0, 0, 0, 0, 0, 0, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50, 0x50, 0x50, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x50, 0x50, 0x50, 0x50, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0, 0, 0x51, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0x50,
    0x50, 0x50, 0x50, 0x50, 0x50, 0x50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0, 0x31, 0x31, 0, 0, 0x31, 0, 0, 0x31, 0x31, 0,
    0, 0x31, 0x31, 0x31, 0x31, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0, 0x31, 0, 0x31, 0x31, 0x31, 0x40, 0x31,
    0x31, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0, 0x31, 0x31, 0x31, 0x31, 0, 0, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0, 0x31, 0, 0, 0,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x41, 0x41,
    0, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x50, 0x50, 0, 0, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31,
    0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x61, 0x61,
    0x61, 0x61, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0x61, 0x61, 0, 0x61, 0, 0, 0x61,
    0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0x61,
    0x61, 0x61, 0x61, 0, 0x61, 0, 0x61, 0, 0, 0, 0, 0x61, 0, 0, 0, 0, 0x61,
    0, 0x61, 0, 0x61, 0, 0x61, 0x61, 0x61, 0, 0x61, 0x61, 0, 0x61, 0, 0,
    0x61, 0, 0x61, 0, 0x61, 0, 0x61, 0, 0x61, 0x61, 0, 0x61, 0, 0, 0x61,
    0x61, 0x61, 0x61, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0x61,
    0x61, 0x61, 0x61, 0, 0x61, 0x61, 0x61, 0x61, 0, 0x61, 0, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0, 0, 0, 0, 0x61, 0x61, 0x61, 0, 0x61, 0x61, 0x61, 0x61,
    0x61, 0, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
    0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0, 0, 0, 0, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
    0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0, 0x60, 0x52, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x52, 0x60, 0x52, 0x60, 0x60, 0x52, 0x60, 0x60,
    0x60, 0x52, 0x60, 0x60, 0x60, 0x52, 0x52, 0x52, 0x52, 0x52, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x52, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x52, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x61, 0x61, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x52, 0x60, 0x52, 0x52, 0x60, 0x60, 0x52, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x52, 0x52, 0x52, 0x52, 0x60,
    0x60, 0x52, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x52, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0x52, 0x52, 0x52,
    0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0x60, 0x60,
    0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x60, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0x60,
    0x60, 0x60, 0x60, 0, 0, 0, 0x61, 0x61, 0x61, 0x61, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x61, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x61, 0x60, 0x60, 0x60, 0x61,
    0x60, 0x61, 0x60, 0x61, 0x60, 0x61, 0x60, 0x60, 0x60, 0x61, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x61, 0x61, 0x60, 0x60, 0x60, 0x60, 0x61, 0x60,
    0x61, 0x61, 0x60, 0x60, 0x60, 0x60, 0x61, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20, 0x20
};

static U8 precis_age_lookup(U32 cp)
{
    if ((0x01FFFE <= cp && (cp & 0x00FFFE) == 0x00FFFE)
	|| (0x0F0000 <= cp && cp <= 0x0FFFFD)
	|| (0x100000 <= cp && cp <= 0x10FFFD))
	return 0x20;
    else if (cp == 0x0E0001 || (0x0E0020 <= cp && cp <= 0x0E007F))
	return 0x31;
    else if (0x0E0100 <= cp && cp <= 0x0E01EF)
	return 0x40;
    else if (0x040000 <= cp)
	return 0;

    return precis_age_array[precis_age_index[cp >> AGE_BLKWIDTH] +
			    (cp & ((1 << AGE_BLKWIDTH) - 1))
	];
}

/* Lines below are automatically generated. Don't edit them manually. */
static U16 precis_xprop_index[] = {
    0, 109, 165, 165, 165, 165, 293, 419, 165, 547, 165, 658, 786, 906,
    1034, 1162, 1278, 1374, 1498, 1625, 1722, 1849, 1976, 2102, 2180, 2280,
    2380, 2480, 2567, 2646, 2750, 2878, 2961, 3087, 165, 165, 165, 165,
    3122, 165, 165, 165, 165, 165, 165, 165, 3232, 3348, 3469, 3590, 3686,
    165, 3791, 165, 3918, 4032, 4148, 4204, 4321, 4428, 165, 165, 4556,
    4684, 4811, 4923, 5036, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 5075,
    5189, 197, 165, 5317, 5445, 5487, 5610, 5715, 165, 5843, 165, 5875,
    6003, 165, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 6131, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 6259, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    6336, 6462, 165, 165, 6588, 6703, 6817, 6945, 7032, 7112, 165, 7231,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    5445, 5445, 7359, 5483, 7487, 165, 165, 165, 165, 165, 7615, 166, 7654,
    7767, 165, 165, 7891, 8008, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 8135, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 8262, 8390, 8518, 8646, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 8731, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 8844, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 8972, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 8997, 9122, 9250, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 9378, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5486, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445, 5445,
    5445, 5445, 5445, 5445, 9506, 5445, 6306, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 5445, 5445, 5445, 5445,
    6306, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
    165, 165, 165, 165, 165, 165
};

/* Lines below are automatically generated. Don't edit them manually. */
static U8 precis_xprop_array[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, CH_SMALLL, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    CH_MIDDLEDOT, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, CH_KERAIA, SC_Greek,
    SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, 0, 0,
    SC_Greek, 0, SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, 0, SC_Greek, 0,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    JT_T | SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, SC_Hebrew,
    JT_T | SC_Hebrew, SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew,
    SC_Hebrew, JT_T | SC_Hebrew, JT_T | SC_Hebrew, SC_Hebrew,
    JT_T | SC_Hebrew, 0, 0, 0, 0, 0, 0, 0, 0, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, 0, 0, 0, 0, 0, SC_Hebrew, SC_Hebrew, SC_Hebrew, CH_GERESH,
    CH_GERSHAYIM, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, 0, 0, 0, JT_D, 0, JT_R,
    JT_R, JT_R, JT_R, JT_D, JT_R, JT_D, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_R, JT_R, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, 0, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_R, JT_D, JT_D, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, CH_Arabic_Indic_digits, CH_Arabic_Indic_digits,
    CH_Arabic_Indic_digits, CH_Arabic_Indic_digits, CH_Arabic_Indic_digits,
    CH_Arabic_Indic_digits, CH_Arabic_Indic_digits, CH_Arabic_Indic_digits,
    CH_Arabic_Indic_digits, CH_Arabic_Indic_digits, 0, 0, 0, 0, JT_D, JT_D,
    JT_T, JT_R, JT_R, JT_R, 0, JT_R, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R,
    JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_R, JT_D, JT_D, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R, JT_R,
    JT_D, JT_R, JT_D, JT_R, JT_D, JT_D, JT_R, JT_R, 0, JT_R, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_R, JT_R,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits,
    CH_extended_Arabic_Indic_digits, CH_extended_Arabic_Indic_digits, JT_D,
    JT_D, JT_D, 0, 0, JT_D, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_R, JT_T, JT_D, JT_D, JT_D, JT_R, JT_R, JT_R, JT_R, JT_R, JT_D,
    JT_D, JT_D, JT_D, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_R, JT_D, JT_R, JT_D, JT_R, JT_D, JT_D, JT_R, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    0, 0, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_R, JT_R, JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_D, JT_D, JT_D,
    JT_D, JT_R, JT_D, JT_R, JT_R, JT_D, JT_D, JT_D, JT_R, JT_R, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_R, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, JT_D, JT_R, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_R, JT_D, JT_D, JT_D, JT_D, JT_R, JT_D, 0, 0, 0,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, 0, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_R, JT_R, JT_R, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, 0, 0,
    0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0,
    0, 0, JT_T, JT_T, 0, 0, 0, 0, JT_T, JT_T, 0, 0, JT_T, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0,
    0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, 0,
    0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, 0, 0, JT_T, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0,
    0, JT_T, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T | CCC_VIRAMA,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, 0, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T | CCC_VIRAMA, 0,
    JT_T, JT_T, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, JT_T | CCC_VIRAMA, JT_T | CCC_VIRAMA, 0, 0, JT_T, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, JT_T, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T | CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_T, JT_D, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, JT_T, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0,
    JT_T | CCC_VIRAMA, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, JT_T, 0, 0, 0, 0, 0, JT_T, 0, CCC_VIRAMA, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0,
    JT_T, JT_T, CCC_VIRAMA, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, 0, JT_T, JT_T, 0, 0, 0, JT_T, 0, JT_T, JT_T, JT_T, CCC_VIRAMA,
    CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, 0, SC_Greek, 0, SC_Greek, 0, SC_Greek, 0,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, 0, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, 0, 0, SC_Greek, SC_Greek, SC_Greek, 0,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, CH_ZWNJ,
    CH_ZWJ, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, JT_T | CCC_VIRAMA, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han,
    0, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, 0, 0, JT_T, JT_T, 0, 0, SC_Hiragana,
    SC_Hiragana, SC_Hiragana, 0, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, CH_NAKAGURO, 0, SC_Katakana, SC_Katakana,
    SC_Katakana, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, 0, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D, JT_D,
    JT_L, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, 0, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T, 0,
    0, JT_T, 0, 0, 0, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0, JT_T,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, JT_T, 0, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, 0, 0, 0, 0,
    0, JT_T, JT_T, 0, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, JT_T, 0, 0, JT_T, 0, 0, 0, 0, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    SC_Hebrew, JT_T | SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, 0, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, 0, SC_Hebrew, 0, SC_Hebrew, SC_Hebrew, 0,
    SC_Hebrew, SC_Hebrew, 0, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew,
    SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, SC_Hebrew, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, 0, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana,
    SC_Katakana, SC_Katakana, SC_Katakana, SC_Katakana, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, 0, JT_T,
    JT_T, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, 0, 0, 0, 0, JT_T | CCC_VIRAMA,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T | CCC_VIRAMA, JT_T, 0, 0, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T, 0,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T | CCC_VIRAMA,
    JT_T | CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, CCC_VIRAMA, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, JT_T, 0, JT_T, 0, 0, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, CCC_VIRAMA, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, SC_Katakana, SC_Hiragana, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T,
    JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, JT_T, 0, 0, JT_T, JT_T, JT_T,
    JT_T, JT_T, JT_T, JT_T, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, JT_T, JT_T, JT_T, JT_T, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek, SC_Greek,
    JT_T | SC_Greek, JT_T | SC_Greek, JT_T | SC_Greek, SC_Greek, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, SC_Hiragana, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han, SC_Han,
    SC_Han, SC_Han, SC_Han, SC_Han
};

static U32 precis_xprop_lookup(U32 cp)
{
    if (cp == 0x0E0001 || (0x0E0020 <= cp && cp <= 0x0E007F)
	|| (0x0E0100 <= cp && cp <= 0x0E01EF))
	return JT_T;
    else if (0x040000 <= cp)
	return 0;

    return precis_xprop_array[precis_xprop_index[cp >> XPROP_BLKWIDTH] +
			      (cp & ((1 << XPROP_BLKWIDTH) - 1))
	];
}

static const U8 utf8_sequence_len[0x100] = {
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x00-0x0F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x10-0x1F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x20-0x2F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x30-0x3F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x40-0x4F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x50-0x5F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x60-0x6F */
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,	/* 0x70-0x7F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0x80-0x8F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0x90-0x9F */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0xA0-0xAF */
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0xB0-0xBF */
    0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,	/* 0xC0-0xCF */
    2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,	/* 0xD0-0xDF */
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,	/* 0xE0-0xEF */
    4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* 0xF0-0xFF */
};

STRLEN precis_prepare(U8 * buf, const STRLEN buflen, int stringclass,
		      U8 unicode_version, U8 ** pptr, STRLEN * lenptr,
		      STRLEN * idxptr, U32 * cpptr)
{
    U8 *p = buf;
    const U8 *end = buf + buflen;
    const U8 *end4 = end - 4;

    STRLEN len = 0, idx = 0;
    U32 cp = 0;
    U8 prop = PRECIS_PVALID;
    U8 has_hankana = 0, has_aid = 0, has_eaid = 0;
    typedef struct {
	U8 *p;
	STRLEN len;
	STRLEN idx;
	U32 cp;
    } ctx_t;
    ctx_t ctx = { NULL, 0, 0, 0 };
    ctx_t nakaguro = { NULL, 0, 0, 0 };

    U32 vec;
    U32 xprop, jtype, xprop_before = 0, jtype_before = 0;

    while (p < end4) {
      check:
	/* Check if string consists of valid UTF-8 sequences. */

	len = utf8_sequence_len[*p];

	switch (len) {
	case 0:
	    goto illseq;

	case 1:
	    /* 0xxxxxxx */
	    cp = (U32) p[0];
	    break;

	case 2:
	    /* 110xxxxx 10xxxxxx */
	    if ((p[1] & 0xC0) != 0x80)
		goto illseq;
	    cp = ((U32) (p[0] & 0x1F) << 6) | ((U32) (p[1] & 0x3F));
	    break;

	case 3:
	    vec = ((U32) p[0] << 16) | ((U32) p[1] << 8) | ((U32) p[2]);
	    /* 1110xxxx 10xxxxxx 10xxxxxx *//* Shortest form */
	    if ((vec & 0x00F0C0C0) != 0x00E08080 || vec < 0x00E0A080)
		goto illseq;
	    cp = ((U32) (p[0] & 0x0F) << 12)
		| ((U32) (p[1] & 0x3F) << 6) | ((U32) (p[2] & 0x3F));
	    /* Surrogates U+D800..U+DFFF */
	    if ((cp & 0x00F800) == 0x00D800)
		goto disallowed;
	    /* Non-characters U+FDD0..U+FDEF, U+FFFE..U+FFFF */
	    if (0x00FDD0 <= cp && cp <= 0x00FDEF)
		goto disallowed;
	    if ((cp & 0x00FFFE) == 0x00FFFE)
		goto disallowed;
	    break;

	case 4:
	    vec = ((U32) p[0] << 24)
		| ((U32) p[1] << 16) | ((U32) p[2] << 8) | ((U32) p[3]);
	    /* 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx *//* Shortest form */
	    if ((vec & 0xF8C0C0C0) != 0xF0808080 || vec < 0xF0908080)
		goto illseq;
	    cp = ((U32) (p[0] & 0x07) << 18)
		| ((U32) (p[1] & 0x3F) << 12)
		| ((U32) (p[2] & 0x3F) << 6) | ((U32) (p[3] & 0x3F));
	    /* Greater than U+10FFFF */
	    if (0x10FFFF < cp)
		goto disallowed;
	    /* Non-characters U+nFFFE..U+nFFFF */
	    if ((cp & 0x00FFFE) == 0x00FFFE)
		goto disallowed;
	    break;

	  illseq:
	    len = 0;
	    cp = 0;
	    /* goto disallowed; */
	  disallowed:
	    prop = PRECIS_DISALLOWED;
	    goto done;
	}			/* switch (len) */

	/* Check if character is assigned by specified version of Unicode. */

	if (unicode_version != 0
	    && unicode_version < precis_age_lookup(cp)) {
	    prop = PRECIS_UNASSIGNED;
	    goto done;
	}

	switch (stringclass) {
	case PRECIS_FREE_FORM_CLASS:
	case PRECIS_IDENTIFIER_CLASS:

	    /* Resolve property. */

	    prop = precis_prop_lookup(cp);

	    switch (prop) {
	    case PRECIS_PVALID:
	    case PRECIS_CONTEXTJ:
	    case PRECIS_CONTEXTO:
		break;

	    case PRECIS_ID_DIS:
		if (stringclass == PRECIS_IDENTIFIER_CLASS) {
		    prop = PRECIS_DISALLOWED;
		    goto done;
		} else
		    prop = PRECIS_PVALID;
		break;

	    default:
		goto done;
	    }

	    /* Resolve contextual rules. */

	    xprop = precis_xprop_lookup(cp);
	    jtype = xprop & JT_MASK;
	    xprop &= ~JT_MASK;

	    if (xprop == CH_NAKAGURO) {
		/* Rule 7: Record use of NAKAGURO. */
		if (nakaguro.p == NULL) {
		    nakaguro.p = p;
		    nakaguro.len = len;
		    nakaguro.idx = idx;
		    nakaguro.cp = cp;
		}
		prop = PRECIS_PVALID;
		xprop = 0;
	    }
	    if ((jtype_before & JT_L) && (jtype & JT_T))
		/* Rule 1.2: Allowing Re((JT:{L,D})(JT:T)*) */
		jtype = jtype_before;

	    switch (xprop_before) {
	    case CH_ZWNJ:
		goto after_ZWNJ;
	    case CH_MIDDLEDOT:
		goto after_MIDDLEDOT;
	    case CH_KERAIA:
		goto after_KERAIA;
	    }
	    switch (prop) {
	    case PRECIS_CONTEXTJ:
	    case PRECIS_CONTEXTO:
		ctx.p = p;
		ctx.len = len;
		ctx.idx = idx;
		ctx.cp = cp;
	    }

	    switch (xprop) {
		/* Rule 1: ZERO WIDTH NON-JOINER */
	    case CH_ZWNJ:	/* ZWNJ, CONTEXTJ */
		if (xprop_before == CCC_VIRAMA) {
		    /* Rule 1.1: CCC(Before(cp)) .eq. Virama */
		    prop = PRECIS_PVALID;
		    xprop = 0;
		} else if (jtype_before & JT_L)
		    /* Rule 1.2 top half: Re((JT:{L,D})(JT:T)*\u200C) */
		    ;
		else
		    goto done;
		break;

	      after_ZWNJ:
		/* Rule 1.2 bottom half: Re(\u200C(JT:T)*(JT:{R,D})) */
		if (jtype & JT_T) {
		    prop = PRECIS_CONTEXTJ;
		    xprop = xprop_before;	/* CP_ZWNJ */
		    jtype = jtype_before;	/* 0 */
		} else if (jtype & JT_R);
		else {
		    prop = PRECIS_CONTEXTJ;
		    goto done;
		}
		break;

		/* Rule 2: ZERO WIDTH JOINER */
	    case CH_ZWJ:	/* ZWJ, CONTEXTJ */
		if (xprop_before == CCC_VIRAMA)
		    prop = PRECIS_PVALID;
		else
		    goto done;
		break;

	    case CCC_VIRAMA:
		break;

		/* Rule 3: MIDDLE DOT */
	    case CH_MIDDLEDOT:	/* MIDDLE DOT, CONTEXTO */
		if (xprop_before == CH_SMALLL);
		else
		    goto done;
		break;

	      after_MIDDLEDOT:
		if (xprop == CH_SMALLL);
		else {
		    prop = PRECIS_CONTEXTO;
		    goto done;
		}
		break;

	    case CH_SMALLL:
		break;

		/* Rule 4: GREEK LOWER NUMERAL SIGN */
	    case CH_KERAIA:	/* KERAIA, CONTEXTO */
		break;

	      after_KERAIA:
		switch (xprop) {
		case CH_KERAIA:	/* CONTEXTO */
		    break;
		case SC_Greek:
		    break;
		default:
		    prop = PRECIS_CONTEXTO;
		    goto done;
		}
		break;

	    case SC_Greek:
		break;

		/* Rule 5: HEBREW PUNCTUATION GERESH */
	    case CH_GERESH:	/* GERESH, CONTEXTO */
		switch (xprop_before) {
		case CH_GERESH:
		case CH_GERSHAYIM:
		case SC_Hebrew:
		    prop = PRECIS_PVALID;
		    break;
		default:
		    goto done;
		}
		break;

		/* Rule 6: HEBREW PUNCTUATION GERSHAYIM */
	    case CH_GERSHAYIM:	/* GERSHAYIM, CONTEXTO */
		switch (xprop_before) {
		case CH_GERESH:
		case CH_GERSHAYIM:
		case SC_Hebrew:
		    prop = PRECIS_PVALID;
		    break;
		default:
		    goto done;
		}
		break;

	    case SC_Hebrew:
		break;

		/* Rule 7: KATAKANA MIDDLE DOT */
	    case CH_NAKAGURO:	/* NAKAGURO, CONTEXTO */
		 /*NOTREACHED*/	/* See above. */
		    break;

	    case SC_Han:
	    case SC_Hiragana:
	    case SC_Katakana:
		has_hankana = 1;
		break;

		/* Rule 8: ARABIC-INDIC DIGITS */
	    case CH_Arabic_Indic_digits:
		/* Arabic-Indic digits, CONTEXTO */
		if (has_eaid)
		    goto done;
		else {
		    prop = PRECIS_PVALID;
		    has_aid = 1;
		}
		break;

		/* Rule 9: EXTENDED ARABIC-INDIC DIGITS */
	    case CH_extended_Arabic_Indic_digits:
		/* Extended Arabic-Indic digits, CONTEXTO */
		if (has_aid)
		    goto done;
		else {
		    prop = PRECIS_PVALID;
		    has_eaid = 1;
		}
		break;

	    default:
		assert(prop == PRECIS_PVALID);
		assert(xprop == 0);
	    }			/* switch (xprop) */

	    xprop_before = xprop;
	    jtype_before = jtype;
	    break;

	default:
	    break;
	}			/* switch (stringclass) */

	p += len;
	idx++;
    }				/* while (p < end4) */
    if (p < end) {
	if (p + utf8_sequence_len[*p] <= end)
	    goto check;
	else
	    goto illseq;
    }

  done:
    if (nakaguro.p != NULL && !has_hankana) {
	if (pptr != NULL)
	    *pptr = nakaguro.p;
	if (lenptr != NULL)
	    *lenptr = nakaguro.len;
	if (idxptr != NULL)
	    *idxptr = nakaguro.idx;
	if (cpptr != NULL)
	    *cpptr = nakaguro.cp;
	prop = PRECIS_CONTEXTO;
    } else
	switch (prop) {
	case PRECIS_CONTEXTJ:
	case PRECIS_CONTEXTO:
	    assert(ctx.p != NULL);

	    if (pptr != NULL)
		*pptr = ctx.p;
	    if (lenptr != NULL)
		*lenptr = ctx.len;
	    if (idxptr != NULL)
		*idxptr = ctx.idx;
	    if (cpptr != NULL)
		*cpptr = ctx.cp;
	    break;

	case PRECIS_DISALLOWED:
	case PRECIS_UNASSIGNED:
	    if (pptr != NULL)
		*pptr = p;
	    if (lenptr != NULL)
		*lenptr = len;
	    if (idxptr != NULL)
		*idxptr = idx;
	    if (cpptr != NULL)
		*cpptr = cp;
	    break;

	default:
	    if (pptr != NULL)
		*pptr = p;
	    if (lenptr != NULL)
		*lenptr = 0;
	    if (idxptr != NULL)
		*idxptr = idx;
	    break;
	}

    return prop;
}
