#-*- perl -*-

package Unicode::LineBreak;

=encoding utf8

This file is automatically generated.  DON'T EDIT THIS FILE MANUALLY.

=cut

use constant { UNICODE_VERSION => '5.1.0' };

# Note: Entries related to BK, CR, CM, LF, NL, SP aren't used by break().
our $RULES_MAP = [
  #BkCrLfNlSpOpClQuGlNsExSyIsPrPoNuAlIdInHyBaBbB2CbZwCmWjH2H3JlJvJt
  [M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M], #BK
  [M,M,P,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M], #CR
  [M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M], #LF
  [M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M,M], #NL
  [P,P,P,P,P,D,P,D,P,D,P,P,P,D,D,D,D,D,D,D,D,D,D,D,P,D,P,D,D,D,D,D], #SP
  [P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P,P], #OP
  [P,P,P,P,P,D,P,I,P,P,P,P,P,I,I,D,D,D,D,I,I,D,D,D,P,D,P,D,D,D,D,D], #CL
  [P,P,P,P,P,P,P,I,P,I,P,P,P,I,I,I,I,I,I,I,I,I,I,I,P,I,P,I,I,I,I,I], #QU
  [P,P,P,P,P,I,P,I,P,I,P,P,P,I,I,I,I,I,I,I,I,I,I,I,P,I,P,I,I,I,I,I], #GL
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,D,D,D,D,D,I,I,D,D,D,P,D,P,D,D,D,D,D], #NS
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,D,D,D,D,D,I,I,D,D,D,P,D,P,D,D,D,D,D], #EX
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,D,I,D,D,D,I,I,D,D,D,P,D,P,D,D,D,D,D], #SY
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,D,I,I,D,D,I,I,D,D,D,P,D,P,D,D,D,D,D], #IS
  [P,P,P,P,P,I,P,I,P,I,P,P,P,D,D,I,I,I,D,I,I,D,D,D,P,D,P,I,I,I,I,I], #PR
  [P,P,P,P,P,I,P,I,P,I,P,P,P,D,D,I,I,D,D,I,I,D,D,D,P,D,P,D,D,D,D,D], #PO
  [P,P,P,P,P,D,P,I,P,I,P,P,P,I,I,I,I,D,I,I,I,D,D,D,P,D,P,D,D,D,D,D], #NU
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,D,I,I,D,I,I,I,D,D,D,P,D,P,D,D,D,D,D], #AL
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,I,D,D,D,I,I,I,D,D,D,P,D,P,D,D,D,D,D], #ID
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,D,D,D,D,I,I,I,D,D,D,P,D,P,D,D,D,D,D], #IN
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,D,I,D,D,D,I,I,D,D,D,P,D,P,D,D,D,D,D], #HY
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,D,D,D,D,D,I,I,D,D,D,P,D,P,D,D,D,D,D], #BA
  [P,P,P,P,P,I,P,I,P,I,P,P,P,I,I,I,I,I,I,I,I,I,I,D,P,I,P,I,I,I,I,I], #BB
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,D,D,D,D,D,I,I,D,P,D,P,D,P,D,D,D,D,D], #B2
  [P,P,P,P,P,D,P,I,P,D,P,P,P,D,D,D,D,D,D,D,D,D,D,D,P,D,P,D,D,D,D,D], #CB
  [P,P,P,P,P,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,P,D,D,D,D,D,D,D], #ZW
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,D,D,D,D,D,I,I,D,D,D,P,D,P,D,D,D,D,D], #CM
  [P,P,P,P,P,I,P,I,P,I,P,P,P,I,I,I,I,I,I,I,I,I,I,I,P,I,P,I,I,I,I,I], #WJ
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,I,D,D,D,I,I,I,D,D,D,P,D,P,D,D,D,I,I], #H2
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,I,D,D,D,I,I,I,D,D,D,P,D,P,D,D,D,D,I], #H3
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,I,D,D,D,I,I,I,D,D,D,P,D,P,I,I,I,I,D], #JL
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,I,D,D,D,I,I,I,D,D,D,P,D,P,D,D,D,I,I], #JV
  [P,P,P,P,P,D,P,I,P,I,P,P,P,D,I,D,D,D,I,I,I,D,D,D,P,D,P,D,D,D,D,I], #JT
];

our $lb_MAP = [
    [0x0000, 0x0008, LB_CM],
    [0x0009, 0x0009, LB_BA],
    [0x000A, 0x000A, LB_LF],
    [0x000B, 0x000C, LB_BK],
    [0x000D, 0x000D, LB_CR],
    [0x000E, 0x001F, LB_CM],
    [0x0020, 0x0020, LB_SP],
    [0x0021, 0x0021, LB_EX],
    [0x0022, 0x0022, LB_QU],
    [0x0024, 0x0024, LB_PR],
    [0x0025, 0x0025, LB_PO],
    [0x0027, 0x0027, LB_QU],
    [0x0028, 0x0028, LB_OP],
    [0x0029, 0x0029, LB_CL],
    [0x002B, 0x002B, LB_PR],
    [0x002C, 0x002C, LB_IS],
    [0x002D, 0x002D, LB_HY],
    [0x002E, 0x002E, LB_IS],
    [0x002F, 0x002F, LB_SY],
    [0x0030, 0x0039, LB_NU],
    [0x003A, 0x003B, LB_IS],
    [0x003F, 0x003F, LB_EX],
    [0x005B, 0x005B, LB_OP],
    [0x005C, 0x005C, LB_PR],
    [0x005D, 0x005D, LB_CL],
    [0x007B, 0x007B, LB_OP],
    [0x007C, 0x007C, LB_BA],
    [0x007D, 0x007D, LB_CL],
    [0x007F, 0x0084, LB_CM],
    [0x0085, 0x0085, LB_NL],
    [0x0086, 0x009F, LB_CM],
    [0x00A0, 0x00A0, LB_GL],
    [0x00A1, 0x00A1, LB_OP],
    [0x00A2, 0x00A2, LB_PO],
    [0x00A3, 0x00A5, LB_PR],
    [0x00A7, 0x00A8, LB_AI],
    [0x00AA, 0x00AA, LB_AI],
    [0x00AB, 0x00AB, LB_QU],
    [0x00AD, 0x00AD, LB_BA],
    [0x00B0, 0x00B0, LB_PO],
    [0x00B1, 0x00B1, LB_PR],
    [0x00B2, 0x00B3, LB_AI],
    [0x00B4, 0x00B4, LB_BB],
    [0x00B6, 0x00BA, LB_AI],
    [0x00BB, 0x00BB, LB_QU],
    [0x00BC, 0x00BE, LB_AI],
    [0x00BF, 0x00BF, LB_OP],
    [0x00D7, 0x00D7, LB_AI],
    [0x00F7, 0x00F7, LB_AI],
    [0x02C7, 0x02C7, LB_AI],
    [0x02C8, 0x02C8, LB_BB],
    [0x02C9, 0x02CB, LB_AI],
    [0x02CC, 0x02CC, LB_BB],
    [0x02CD, 0x02CD, LB_AI],
    [0x02D0, 0x02D0, LB_AI],
    [0x02D8, 0x02DB, LB_AI],
    [0x02DD, 0x02DD, LB_AI],
    [0x02DF, 0x02DF, LB_BB],
    [0x0300, 0x034E, LB_CM],
    [0x034F, 0x034F, LB_GL],
    [0x0350, 0x035B, LB_CM],
    [0x035C, 0x0362, LB_GL],
    [0x0363, 0x036F, LB_CM],
    [0x037E, 0x037E, LB_IS],
    [0x0483, 0x0489, LB_CM],
    [0x0589, 0x0589, LB_IS],
    [0x058A, 0x058A, LB_BA],
    [0x0591, 0x05BD, LB_CM],
    [0x05BE, 0x05BE, LB_BA],
    [0x05BF, 0x05BF, LB_CM],
    [0x05C1, 0x05C2, LB_CM],
    [0x05C4, 0x05C5, LB_CM],
    [0x05C6, 0x05C6, LB_EX],
    [0x05C7, 0x05C7, LB_CM],
    [0x0609, 0x060B, LB_PO],
    [0x060C, 0x060D, LB_IS],
    [0x0610, 0x061A, LB_CM],
    [0x061B, 0x061B, LB_EX],
    [0x061E, 0x061F, LB_EX],
    [0x064B, 0x065E, LB_CM],
    [0x0660, 0x0669, LB_NU],
    [0x066A, 0x066A, LB_PO],
    [0x066B, 0x066C, LB_NU],
    [0x0670, 0x0670, LB_CM],
    [0x06D4, 0x06D4, LB_EX],
    [0x06D6, 0x06DC, LB_CM],
    [0x06DE, 0x06E4, LB_CM],
    [0x06E7, 0x06E8, LB_CM],
    [0x06EA, 0x06ED, LB_CM],
    [0x06F0, 0x06F9, LB_NU],
    [0x0711, 0x0711, LB_CM],
    [0x0730, 0x074A, LB_CM],
    [0x07A6, 0x07B0, LB_CM],
    [0x07C0, 0x07C9, LB_NU],
    [0x07EB, 0x07F3, LB_CM],
    [0x07F8, 0x07F8, LB_IS],
    [0x07F9, 0x07F9, LB_EX],
    [0x0901, 0x0903, LB_CM],
    [0x093C, 0x093C, LB_CM],
    [0x093E, 0x094D, LB_CM],
    [0x0951, 0x0954, LB_CM],
    [0x0962, 0x0963, LB_CM],
    [0x0964, 0x0965, LB_BA],
    [0x0966, 0x096F, LB_NU],
    [0x0981, 0x0983, LB_CM],
    [0x09BC, 0x09BC, LB_CM],
    [0x09BE, 0x09C4, LB_CM],
    [0x09C7, 0x09C8, LB_CM],
    [0x09CB, 0x09CD, LB_CM],
    [0x09D7, 0x09D7, LB_CM],
    [0x09E2, 0x09E3, LB_CM],
    [0x09E6, 0x09EF, LB_NU],
    [0x09F2, 0x09F3, LB_PR],
    [0x0A01, 0x0A03, LB_CM],
    [0x0A3C, 0x0A3C, LB_CM],
    [0x0A3E, 0x0A42, LB_CM],
    [0x0A47, 0x0A48, LB_CM],
    [0x0A4B, 0x0A4D, LB_CM],
    [0x0A51, 0x0A51, LB_CM],
    [0x0A66, 0x0A6F, LB_NU],
    [0x0A70, 0x0A71, LB_CM],
    [0x0A75, 0x0A75, LB_CM],
    [0x0A81, 0x0A83, LB_CM],
    [0x0ABC, 0x0ABC, LB_CM],
    [0x0ABE, 0x0AC5, LB_CM],
    [0x0AC7, 0x0AC9, LB_CM],
    [0x0ACB, 0x0ACD, LB_CM],
    [0x0AE2, 0x0AE3, LB_CM],
    [0x0AE6, 0x0AEF, LB_NU],
    [0x0AF1, 0x0AF1, LB_PR],
    [0x0B01, 0x0B03, LB_CM],
    [0x0B3C, 0x0B3C, LB_CM],
    [0x0B3E, 0x0B44, LB_CM],
    [0x0B47, 0x0B48, LB_CM],
    [0x0B4B, 0x0B4D, LB_CM],
    [0x0B56, 0x0B57, LB_CM],
    [0x0B62, 0x0B63, LB_CM],
    [0x0B66, 0x0B6F, LB_NU],
    [0x0B82, 0x0B82, LB_CM],
    [0x0BBE, 0x0BC2, LB_CM],
    [0x0BC6, 0x0BC8, LB_CM],
    [0x0BCA, 0x0BCD, LB_CM],
    [0x0BD7, 0x0BD7, LB_CM],
    [0x0BE6, 0x0BEF, LB_NU],
    [0x0BF9, 0x0BF9, LB_PR],
    [0x0C01, 0x0C03, LB_CM],
    [0x0C3E, 0x0C44, LB_CM],
    [0x0C46, 0x0C48, LB_CM],
    [0x0C4A, 0x0C4D, LB_CM],
    [0x0C55, 0x0C56, LB_CM],
    [0x0C62, 0x0C63, LB_CM],
    [0x0C66, 0x0C6F, LB_NU],
    [0x0C82, 0x0C83, LB_CM],
    [0x0CBC, 0x0CBC, LB_CM],
    [0x0CBE, 0x0CC4, LB_CM],
    [0x0CC6, 0x0CC8, LB_CM],
    [0x0CCA, 0x0CCD, LB_CM],
    [0x0CD5, 0x0CD6, LB_CM],
    [0x0CE2, 0x0CE3, LB_CM],
    [0x0CE6, 0x0CEF, LB_NU],
    [0x0D02, 0x0D03, LB_CM],
    [0x0D3E, 0x0D44, LB_CM],
    [0x0D46, 0x0D48, LB_CM],
    [0x0D4A, 0x0D4D, LB_CM],
    [0x0D57, 0x0D57, LB_CM],
    [0x0D62, 0x0D63, LB_CM],
    [0x0D66, 0x0D6F, LB_NU],
    [0x0D79, 0x0D79, LB_PO],
    [0x0D82, 0x0D83, LB_CM],
    [0x0DCA, 0x0DCA, LB_CM],
    [0x0DCF, 0x0DD4, LB_CM],
    [0x0DD6, 0x0DD6, LB_CM],
    [0x0DD8, 0x0DDF, LB_CM],
    [0x0DF2, 0x0DF3, LB_CM],
    [0x0E01, 0x0E2F, LB_SAbase],
    [0x0E30, 0x0E3A, LB_SAextend],
    [0x0E3F, 0x0E3F, LB_PR],
    [0x0E40, 0x0E44, LB_SAprepend],
    [0x0E45, 0x0E45, LB_SAextend],
    [0x0E46, 0x0E46, LB_SAbase],
    [0x0E47, 0x0E4E, LB_SAextend],
    [0x0E50, 0x0E59, LB_NU],
    [0x0E5A, 0x0E5B, LB_BA],
    [0x0E81, 0x0E82, LB_SAbase],
    [0x0E84, 0x0E84, LB_SAbase],
    [0x0E87, 0x0E88, LB_SAbase],
    [0x0E8A, 0x0E8A, LB_SAbase],
    [0x0E8D, 0x0E8D, LB_SAbase],
    [0x0E94, 0x0E97, LB_SAbase],
    [0x0E99, 0x0E9F, LB_SAbase],
    [0x0EA1, 0x0EA3, LB_SAbase],
    [0x0EA5, 0x0EA5, LB_SAbase],
    [0x0EA7, 0x0EA7, LB_SAbase],
    [0x0EAA, 0x0EAB, LB_SAbase],
    [0x0EAD, 0x0EAF, LB_SAbase],
    [0x0EB0, 0x0EB9, LB_SAextend],
    [0x0EBB, 0x0EBC, LB_SAextend],
    [0x0EBD, 0x0EBD, LB_SAbase],
    [0x0EC0, 0x0EC4, LB_SAprepend],
    [0x0EC6, 0x0EC6, LB_SAbase],
    [0x0EC8, 0x0ECD, LB_SAextend],
    [0x0ED0, 0x0ED9, LB_NU],
    [0x0EDC, 0x0EDD, LB_SAbase],
    [0x0F01, 0x0F04, LB_BB],
    [0x0F06, 0x0F07, LB_BB],
    [0x0F08, 0x0F08, LB_GL],
    [0x0F09, 0x0F0A, LB_BB],
    [0x0F0B, 0x0F0B, LB_BA],
    [0x0F0C, 0x0F0C, LB_GL],
    [0x0F0D, 0x0F11, LB_EX],
    [0x0F12, 0x0F12, LB_GL],
    [0x0F14, 0x0F14, LB_EX],
    [0x0F18, 0x0F19, LB_CM],
    [0x0F20, 0x0F29, LB_NU],
    [0x0F34, 0x0F34, LB_BA],
    [0x0F35, 0x0F35, LB_CM],
    [0x0F37, 0x0F37, LB_CM],
    [0x0F39, 0x0F39, LB_CM],
    [0x0F3A, 0x0F3A, LB_OP],
    [0x0F3B, 0x0F3B, LB_CL],
    [0x0F3C, 0x0F3C, LB_OP],
    [0x0F3D, 0x0F3D, LB_CL],
    [0x0F3E, 0x0F3F, LB_CM],
    [0x0F71, 0x0F7E, LB_CM],
    [0x0F7F, 0x0F7F, LB_BA],
    [0x0F80, 0x0F84, LB_CM],
    [0x0F85, 0x0F85, LB_BA],
    [0x0F86, 0x0F87, LB_CM],
    [0x0F90, 0x0F97, LB_CM],
    [0x0F99, 0x0FBC, LB_CM],
    [0x0FBE, 0x0FBF, LB_BA],
    [0x0FC6, 0x0FC6, LB_CM],
    [0x0FD0, 0x0FD1, LB_BB],
    [0x0FD2, 0x0FD2, LB_BA],
    [0x0FD3, 0x0FD3, LB_BB],
    [0x1000, 0x102A, LB_SAbase],
    [0x102B, 0x103E, LB_SAextend],
    [0x103F, 0x103F, LB_SAbase],
    [0x1040, 0x1049, LB_NU],
    [0x104A, 0x104B, LB_BA],
    [0x1050, 0x1055, LB_SAbase],
    [0x1056, 0x1059, LB_SAextend],
    [0x105A, 0x105D, LB_SAbase],
    [0x105E, 0x1060, LB_SAextend],
    [0x1061, 0x1061, LB_SAbase],
    [0x1062, 0x1064, LB_SAextend],
    [0x1065, 0x1066, LB_SAbase],
    [0x1067, 0x106D, LB_SAextend],
    [0x106E, 0x1070, LB_SAbase],
    [0x1071, 0x1074, LB_SAextend],
    [0x1075, 0x1081, LB_SAbase],
    [0x1082, 0x108D, LB_SAextend],
    [0x108E, 0x108E, LB_SAbase],
    [0x108F, 0x108F, LB_SAextend],
    [0x1090, 0x1099, LB_NU],
    [0x109E, 0x109F, LB_SAbase],
    [0x1100, 0x1159, LB_JL],
    [0x115F, 0x115F, LB_JL],
    [0x1160, 0x11A2, LB_JV],
    [0x11A8, 0x11F9, LB_JT],
    [0x135F, 0x135F, LB_CM],
    [0x1361, 0x1361, LB_BA],
    [0x1680, 0x1680, LB_BA],
    [0x169B, 0x169B, LB_OP],
    [0x169C, 0x169C, LB_CL],
    [0x16EB, 0x16ED, LB_BA],
    [0x1712, 0x1714, LB_CM],
    [0x1732, 0x1734, LB_CM],
    [0x1735, 0x1736, LB_BA],
    [0x1752, 0x1753, LB_CM],
    [0x1772, 0x1773, LB_CM],
    [0x1780, 0x17B5, LB_SAbase],
    [0x17B6, 0x17D3, LB_SAextend],
    [0x17D4, 0x17D5, LB_BA],
    [0x17D6, 0x17D6, LB_NS],
    [0x17D7, 0x17D7, LB_SAbase],
    [0x17D8, 0x17D8, LB_BA],
    [0x17DA, 0x17DA, LB_BA],
    [0x17DB, 0x17DB, LB_PR],
    [0x17DC, 0x17DC, LB_SAbase],
    [0x17DD, 0x17DD, LB_SAextend],
    [0x17E0, 0x17E9, LB_NU],
    [0x1802, 0x1803, LB_EX],
    [0x1804, 0x1805, LB_BA],
    [0x1806, 0x1806, LB_BB],
    [0x1808, 0x1809, LB_EX],
    [0x180B, 0x180D, LB_CM],
    [0x180E, 0x180E, LB_GL],
    [0x1810, 0x1819, LB_NU],
    [0x18A9, 0x18A9, LB_CM],
    [0x1920, 0x192B, LB_CM],
    [0x1930, 0x193B, LB_CM],
    [0x1944, 0x1945, LB_EX],
    [0x1946, 0x194F, LB_NU],
    [0x1950, 0x196D, LB_SAbase],
    [0x1970, 0x1974, LB_SAbase],
    [0x1980, 0x19A9, LB_SAbase],
    [0x19B0, 0x19C0, LB_SAextend],
    [0x19C1, 0x19C7, LB_SAbase],
    [0x19C8, 0x19C9, LB_SAextend],
    [0x19D0, 0x19D9, LB_NU],
    [0x19DE, 0x19DF, LB_SAbase],
    [0x1A17, 0x1A1B, LB_CM],
    [0x1B00, 0x1B04, LB_CM],
    [0x1B34, 0x1B44, LB_CM],
    [0x1B50, 0x1B59, LB_NU],
    [0x1B5A, 0x1B60, LB_BA],
    [0x1B6B, 0x1B73, LB_CM],
    [0x1B80, 0x1B82, LB_CM],
    [0x1BA1, 0x1BAA, LB_CM],
    [0x1BB0, 0x1BB9, LB_NU],
    [0x1C24, 0x1C37, LB_CM],
    [0x1C3B, 0x1C3F, LB_BA],
    [0x1C40, 0x1C49, LB_NU],
    [0x1C50, 0x1C59, LB_NU],
    [0x1C7E, 0x1C7F, LB_BA],
    [0x1DC0, 0x1DE6, LB_CM],
    [0x1DFE, 0x1DFF, LB_CM],
    [0x1FFD, 0x1FFD, LB_BB],
    [0x2000, 0x2006, LB_BA],
    [0x2007, 0x2007, LB_GL],
    [0x2008, 0x200A, LB_BA],
    [0x200B, 0x200B, LB_ZW],
    [0x200C, 0x200F, LB_CM],
    [0x2010, 0x2010, LB_BA],
    [0x2011, 0x2011, LB_GL],
    [0x2012, 0x2013, LB_BA],
    [0x2014, 0x2014, LB_B2],
    [0x2015, 0x2016, LB_AI],
    [0x2018, 0x2019, LB_QU],
    [0x201A, 0x201A, LB_OP],
    [0x201B, 0x201D, LB_QU],
    [0x201E, 0x201E, LB_OP],
    [0x201F, 0x201F, LB_QU],
    [0x2020, 0x2021, LB_AI],
    [0x2024, 0x2026, LB_IN],
    [0x2027, 0x2027, LB_BA],
    [0x2028, 0x2029, LB_BK],
    [0x202A, 0x202E, LB_CM],
    [0x202F, 0x202F, LB_GL],
    [0x2030, 0x2037, LB_PO],
    [0x2039, 0x203A, LB_QU],
    [0x203B, 0x203B, LB_AI],
    [0x203C, 0x203D, LB_NS],
    [0x2044, 0x2044, LB_IS],
    [0x2045, 0x2045, LB_OP],
    [0x2046, 0x2046, LB_CL],
    [0x2047, 0x2049, LB_NS],
    [0x2056, 0x2056, LB_BA],
    [0x2058, 0x205B, LB_BA],
    [0x205D, 0x205F, LB_BA],
    [0x2060, 0x2060, LB_WJ],
    [0x206A, 0x206F, LB_CM],
    [0x2074, 0x2074, LB_AI],
    [0x207D, 0x207D, LB_OP],
    [0x207E, 0x207E, LB_CL],
    [0x207F, 0x207F, LB_AI],
    [0x2081, 0x2084, LB_AI],
    [0x208D, 0x208D, LB_OP],
    [0x208E, 0x208E, LB_CL],
    [0x20A0, 0x20A6, LB_PR],
    [0x20A7, 0x20A7, LB_PO],
    [0x20A8, 0x20B5, LB_PR],
    [0x20D0, 0x20F0, LB_CM],
    [0x2103, 0x2103, LB_PO],
    [0x2105, 0x2105, LB_AI],
    [0x2109, 0x2109, LB_PO],
    [0x2113, 0x2113, LB_AI],
    [0x2116, 0x2116, LB_PR],
    [0x2121, 0x2122, LB_AI],
    [0x212B, 0x212B, LB_AI],
    [0x2154, 0x2155, LB_AI],
    [0x215B, 0x215B, LB_AI],
    [0x215E, 0x215E, LB_AI],
    [0x2160, 0x216B, LB_AI],
    [0x2170, 0x2179, LB_AI],
    [0x2190, 0x2199, LB_AI],
    [0x21D2, 0x21D2, LB_AI],
    [0x21D4, 0x21D4, LB_AI],
    [0x2200, 0x2200, LB_AI],
    [0x2202, 0x2203, LB_AI],
    [0x2207, 0x2208, LB_AI],
    [0x220B, 0x220B, LB_AI],
    [0x220F, 0x220F, LB_AI],
    [0x2211, 0x2211, LB_AI],
    [0x2212, 0x2213, LB_PR],
    [0x2215, 0x2215, LB_AI],
    [0x221A, 0x221A, LB_AI],
    [0x221D, 0x2220, LB_AI],
    [0x2223, 0x2223, LB_AI],
    [0x2225, 0x2225, LB_AI],
    [0x2227, 0x222C, LB_AI],
    [0x222E, 0x222E, LB_AI],
    [0x2234, 0x2237, LB_AI],
    [0x223C, 0x223D, LB_AI],
    [0x2248, 0x2248, LB_AI],
    [0x224C, 0x224C, LB_AI],
    [0x2252, 0x2252, LB_AI],
    [0x2260, 0x2261, LB_AI],
    [0x2264, 0x2267, LB_AI],
    [0x226A, 0x226B, LB_AI],
    [0x226E, 0x226F, LB_AI],
    [0x2282, 0x2283, LB_AI],
    [0x2286, 0x2287, LB_AI],
    [0x2295, 0x2295, LB_AI],
    [0x2299, 0x2299, LB_AI],
    [0x22A5, 0x22A5, LB_AI],
    [0x22BF, 0x22BF, LB_AI],
    [0x2312, 0x2312, LB_AI],
    [0x2329, 0x2329, LB_OP],
    [0x232A, 0x232A, LB_CL],
    [0x2460, 0x24FE, LB_AI],
    [0x2500, 0x254B, LB_AI],
    [0x2550, 0x2574, LB_AI],
    [0x2580, 0x258F, LB_AI],
    [0x2592, 0x2595, LB_AI],
    [0x25A0, 0x25A1, LB_AI],
    [0x25A3, 0x25A9, LB_AI],
    [0x25B2, 0x25B3, LB_AI],
    [0x25B6, 0x25B7, LB_AI],
    [0x25BC, 0x25BD, LB_AI],
    [0x25C0, 0x25C1, LB_AI],
    [0x25C6, 0x25C8, LB_AI],
    [0x25CB, 0x25CB, LB_AI],
    [0x25CE, 0x25D1, LB_AI],
    [0x25E2, 0x25E5, LB_AI],
    [0x25EF, 0x25EF, LB_AI],
    [0x2605, 0x2606, LB_AI],
    [0x2609, 0x2609, LB_AI],
    [0x260E, 0x260F, LB_AI],
    [0x2614, 0x2617, LB_AI],
    [0x261C, 0x261C, LB_AI],
    [0x261E, 0x261E, LB_AI],
    [0x2640, 0x2640, LB_AI],
    [0x2642, 0x2642, LB_AI],
    [0x2660, 0x2661, LB_AI],
    [0x2663, 0x2665, LB_AI],
    [0x2667, 0x266A, LB_AI],
    [0x266C, 0x266D, LB_AI],
    [0x266F, 0x266F, LB_AI],
    [0x275B, 0x275E, LB_QU],
    [0x2762, 0x2763, LB_EX],
    [0x2768, 0x2768, LB_OP],
    [0x2769, 0x2769, LB_CL],
    [0x276A, 0x276A, LB_OP],
    [0x276B, 0x276B, LB_CL],
    [0x276C, 0x276C, LB_OP],
    [0x276D, 0x276D, LB_CL],
    [0x276E, 0x276E, LB_OP],
    [0x276F, 0x276F, LB_CL],
    [0x2770, 0x2770, LB_OP],
    [0x2771, 0x2771, LB_CL],
    [0x2772, 0x2772, LB_OP],
    [0x2773, 0x2773, LB_CL],
    [0x2774, 0x2774, LB_OP],
    [0x2775, 0x2775, LB_CL],
    [0x2776, 0x2793, LB_AI],
    [0x27C5, 0x27C5, LB_OP],
    [0x27C6, 0x27C6, LB_CL],
    [0x27E6, 0x27E6, LB_OP],
    [0x27E7, 0x27E7, LB_CL],
    [0x27E8, 0x27E8, LB_OP],
    [0x27E9, 0x27E9, LB_CL],
    [0x27EA, 0x27EA, LB_OP],
    [0x27EB, 0x27EB, LB_CL],
    [0x27EC, 0x27EC, LB_OP],
    [0x27ED, 0x27ED, LB_CL],
    [0x27EE, 0x27EE, LB_OP],
    [0x27EF, 0x27EF, LB_CL],
    [0x2983, 0x2983, LB_OP],
    [0x2984, 0x2984, LB_CL],
    [0x2985, 0x2985, LB_OP],
    [0x2986, 0x2986, LB_CL],
    [0x2987, 0x2987, LB_OP],
    [0x2988, 0x2988, LB_CL],
    [0x2989, 0x2989, LB_OP],
    [0x298A, 0x298A, LB_CL],
    [0x298B, 0x298B, LB_OP],
    [0x298C, 0x298C, LB_CL],
    [0x298D, 0x298D, LB_OP],
    [0x298E, 0x298E, LB_CL],
    [0x298F, 0x298F, LB_OP],
    [0x2990, 0x2990, LB_CL],
    [0x2991, 0x2991, LB_OP],
    [0x2992, 0x2992, LB_CL],
    [0x2993, 0x2993, LB_OP],
    [0x2994, 0x2994, LB_CL],
    [0x2995, 0x2995, LB_OP],
    [0x2996, 0x2996, LB_CL],
    [0x2997, 0x2997, LB_OP],
    [0x2998, 0x2998, LB_CL],
    [0x29D8, 0x29D8, LB_OP],
    [0x29D9, 0x29D9, LB_CL],
    [0x29DA, 0x29DA, LB_OP],
    [0x29DB, 0x29DB, LB_CL],
    [0x29FC, 0x29FC, LB_OP],
    [0x29FD, 0x29FD, LB_CL],
    [0x2CF9, 0x2CF9, LB_EX],
    [0x2CFA, 0x2CFC, LB_BA],
    [0x2CFE, 0x2CFE, LB_EX],
    [0x2CFF, 0x2CFF, LB_BA],
    [0x2DE0, 0x2DFF, LB_CM],
    [0x2E00, 0x2E0D, LB_QU],
    [0x2E0E, 0x2E15, LB_BA],
    [0x2E17, 0x2E17, LB_BA],
    [0x2E18, 0x2E18, LB_OP],
    [0x2E19, 0x2E19, LB_BA],
    [0x2E1C, 0x2E1D, LB_QU],
    [0x2E20, 0x2E21, LB_QU],
    [0x2E22, 0x2E22, LB_OP],
    [0x2E23, 0x2E23, LB_CL],
    [0x2E24, 0x2E24, LB_OP],
    [0x2E25, 0x2E25, LB_CL],
    [0x2E26, 0x2E26, LB_OP],
    [0x2E27, 0x2E27, LB_CL],
    [0x2E28, 0x2E28, LB_OP],
    [0x2E29, 0x2E29, LB_CL],
    [0x2E2A, 0x2E2D, LB_BA],
    [0x2E2E, 0x2E2E, LB_EX],
    [0x2E30, 0x2E30, LB_BA],
    [0x2E80, 0x2E99, LB_ID],
    [0x2E9B, 0x2EF3, LB_ID],
    [0x2F00, 0x2FD5, LB_ID],
    [0x2FF0, 0x2FFB, LB_ID],
    [0x3000, 0x3000, LB_ID],
    [0x3001, 0x3002, LB_CL],
    [0x3003, 0x3004, LB_ID],
    [0x3005, 0x3005, LB_NS],
    [0x3006, 0x3007, LB_ID],
    [0x3008, 0x3008, LB_OP],
    [0x3009, 0x3009, LB_CL],
    [0x300A, 0x300A, LB_OP],
    [0x300B, 0x300B, LB_CL],
    [0x300C, 0x300C, LB_OP],
    [0x300D, 0x300D, LB_CL],
    [0x300E, 0x300E, LB_OP],
    [0x300F, 0x300F, LB_CL],
    [0x3010, 0x3010, LB_OP],
    [0x3011, 0x3011, LB_CL],
    [0x3012, 0x3013, LB_ID],
    [0x3014, 0x3014, LB_OP],
    [0x3015, 0x3015, LB_CL],
    [0x3016, 0x3016, LB_OP],
    [0x3017, 0x3017, LB_CL],
    [0x3018, 0x3018, LB_OP],
    [0x3019, 0x3019, LB_CL],
    [0x301A, 0x301A, LB_OP],
    [0x301B, 0x301B, LB_CL],
    [0x301C, 0x301C, LB_NS],
    [0x301D, 0x301D, LB_OP],
    [0x301E, 0x301F, LB_CL],
    [0x3020, 0x3029, LB_ID],
    [0x302A, 0x302F, LB_CM],
    [0x3030, 0x303A, LB_ID],
    [0x303B, 0x303C, LB_NS],
    [0x303D, 0x303F, LB_ID],
    [0x3041, 0x3041, LB_NS],
    [0x3042, 0x3042, LB_ID],
    [0x3043, 0x3043, LB_NS],
    [0x3044, 0x3044, LB_ID],
    [0x3045, 0x3045, LB_NS],
    [0x3046, 0x3046, LB_ID],
    [0x3047, 0x3047, LB_NS],
    [0x3048, 0x3048, LB_ID],
    [0x3049, 0x3049, LB_NS],
    [0x304A, 0x3062, LB_ID],
    [0x3063, 0x3063, LB_NS],
    [0x3064, 0x3082, LB_ID],
    [0x3083, 0x3083, LB_NS],
    [0x3084, 0x3084, LB_ID],
    [0x3085, 0x3085, LB_NS],
    [0x3086, 0x3086, LB_ID],
    [0x3087, 0x3087, LB_NS],
    [0x3088, 0x308D, LB_ID],
    [0x308E, 0x308E, LB_NS],
    [0x308F, 0x3094, LB_ID],
    [0x3095, 0x3096, LB_NS],
    [0x3099, 0x309A, LB_CM],
    [0x309B, 0x309E, LB_NS],
    [0x309F, 0x309F, LB_ID],
    [0x30A0, 0x30A1, LB_NS],
    [0x30A2, 0x30A2, LB_ID],
    [0x30A3, 0x30A3, LB_NS],
    [0x30A4, 0x30A4, LB_ID],
    [0x30A5, 0x30A5, LB_NS],
    [0x30A6, 0x30A6, LB_ID],
    [0x30A7, 0x30A7, LB_NS],
    [0x30A8, 0x30A8, LB_ID],
    [0x30A9, 0x30A9, LB_NS],
    [0x30AA, 0x30C2, LB_ID],
    [0x30C3, 0x30C3, LB_NS],
    [0x30C4, 0x30E2, LB_ID],
    [0x30E3, 0x30E3, LB_NS],
    [0x30E4, 0x30E4, LB_ID],
    [0x30E5, 0x30E5, LB_NS],
    [0x30E6, 0x30E6, LB_ID],
    [0x30E7, 0x30E7, LB_NS],
    [0x30E8, 0x30ED, LB_ID],
    [0x30EE, 0x30EE, LB_NS],
    [0x30EF, 0x30F4, LB_ID],
    [0x30F5, 0x30F6, LB_NS],
    [0x30F7, 0x30FA, LB_ID],
    [0x30FB, 0x30FE, LB_NS],
    [0x30FF, 0x30FF, LB_ID],
    [0x3105, 0x312D, LB_ID],
    [0x3131, 0x318E, LB_ID],
    [0x3190, 0x31B7, LB_ID],
    [0x31C0, 0x31E3, LB_ID],
    [0x31F0, 0x31FF, LB_NS],
    [0x3200, 0x321E, LB_ID],
    [0x3220, 0x3243, LB_ID],
    [0x3250, 0x32FE, LB_ID],
    [0x3300, 0x33FF, LB_ID],
    [0xA015, 0xA015, LB_NS],
    [0xA490, 0xA4C6, LB_ID],
    [0xA60D, 0xA60D, LB_BA],
    [0xA60E, 0xA60E, LB_EX],
    [0xA60F, 0xA60F, LB_BA],
    [0xA620, 0xA629, LB_NU],
    [0xA66F, 0xA672, LB_CM],
    [0xA67C, 0xA67D, LB_CM],
    [0xA802, 0xA802, LB_CM],
    [0xA806, 0xA806, LB_CM],
    [0xA80B, 0xA80B, LB_CM],
    [0xA823, 0xA827, LB_CM],
    [0xA874, 0xA875, LB_BB],
    [0xA876, 0xA877, LB_EX],
    [0xA880, 0xA881, LB_CM],
    [0xA8B4, 0xA8C4, LB_CM],
    [0xA8CE, 0xA8CF, LB_BA],
    [0xA8D0, 0xA8D9, LB_NU],
    [0xA900, 0xA909, LB_NU],
    [0xA926, 0xA92D, LB_CM],
    [0xA92E, 0xA92F, LB_BA],
    [0xA947, 0xA953, LB_CM],
    [0xAA29, 0xAA36, LB_CM],
    [0xAA43, 0xAA43, LB_CM],
    [0xAA4C, 0xAA4D, LB_CM],
    [0xAA50, 0xAA59, LB_NU],
    [0xAA5D, 0xAA5F, LB_BA],
    [0xFB1E, 0xFB1E, LB_CM],
    [0xFD3E, 0xFD3E, LB_OP],
    [0xFD3F, 0xFD3F, LB_CL],
    [0xFDFC, 0xFDFC, LB_PO],
    [0xFE00, 0xFE0F, LB_CM],
    [0xFE10, 0xFE10, LB_IS],
    [0xFE11, 0xFE12, LB_CL],
    [0xFE13, 0xFE14, LB_IS],
    [0xFE15, 0xFE16, LB_EX],
    [0xFE17, 0xFE17, LB_OP],
    [0xFE18, 0xFE18, LB_CL],
    [0xFE19, 0xFE19, LB_IN],
    [0xFE20, 0xFE26, LB_CM],
    [0xFE30, 0xFE34, LB_ID],
    [0xFE35, 0xFE35, LB_OP],
    [0xFE36, 0xFE36, LB_CL],
    [0xFE37, 0xFE37, LB_OP],
    [0xFE38, 0xFE38, LB_CL],
    [0xFE39, 0xFE39, LB_OP],
    [0xFE3A, 0xFE3A, LB_CL],
    [0xFE3B, 0xFE3B, LB_OP],
    [0xFE3C, 0xFE3C, LB_CL],
    [0xFE3D, 0xFE3D, LB_OP],
    [0xFE3E, 0xFE3E, LB_CL],
    [0xFE3F, 0xFE3F, LB_OP],
    [0xFE40, 0xFE40, LB_CL],
    [0xFE41, 0xFE41, LB_OP],
    [0xFE42, 0xFE42, LB_CL],
    [0xFE43, 0xFE43, LB_OP],
    [0xFE44, 0xFE44, LB_CL],
    [0xFE45, 0xFE46, LB_ID],
    [0xFE47, 0xFE47, LB_OP],
    [0xFE48, 0xFE48, LB_CL],
    [0xFE49, 0xFE4F, LB_ID],
    [0xFE50, 0xFE50, LB_CL],
    [0xFE51, 0xFE51, LB_ID],
    [0xFE52, 0xFE52, LB_CL],
    [0xFE54, 0xFE55, LB_NS],
    [0xFE56, 0xFE57, LB_EX],
    [0xFE58, 0xFE58, LB_ID],
    [0xFE59, 0xFE59, LB_OP],
    [0xFE5A, 0xFE5A, LB_CL],
    [0xFE5B, 0xFE5B, LB_OP],
    [0xFE5C, 0xFE5C, LB_CL],
    [0xFE5D, 0xFE5D, LB_OP],
    [0xFE5E, 0xFE5E, LB_CL],
    [0xFE5F, 0xFE66, LB_ID],
    [0xFE68, 0xFE68, LB_ID],
    [0xFE69, 0xFE69, LB_PR],
    [0xFE6A, 0xFE6A, LB_PO],
    [0xFE6B, 0xFE6B, LB_ID],
    [0xFEFF, 0xFEFF, LB_WJ],
    [0xFF01, 0xFF01, LB_EX],
    [0xFF02, 0xFF03, LB_ID],
    [0xFF04, 0xFF04, LB_PR],
    [0xFF05, 0xFF05, LB_PO],
    [0xFF06, 0xFF07, LB_ID],
    [0xFF08, 0xFF08, LB_OP],
    [0xFF09, 0xFF09, LB_CL],
    [0xFF0A, 0xFF0B, LB_ID],
    [0xFF0C, 0xFF0C, LB_CL],
    [0xFF0D, 0xFF0D, LB_ID],
    [0xFF0E, 0xFF0E, LB_CL],
    [0xFF0F, 0xFF19, LB_ID],
    [0xFF1A, 0xFF1B, LB_NS],
    [0xFF1C, 0xFF1E, LB_ID],
    [0xFF1F, 0xFF1F, LB_EX],
    [0xFF20, 0xFF3A, LB_ID],
    [0xFF3B, 0xFF3B, LB_OP],
    [0xFF3C, 0xFF3C, LB_ID],
    [0xFF3D, 0xFF3D, LB_CL],
    [0xFF3E, 0xFF5A, LB_ID],
    [0xFF5B, 0xFF5B, LB_OP],
    [0xFF5C, 0xFF5C, LB_ID],
    [0xFF5D, 0xFF5D, LB_CL],
    [0xFF5E, 0xFF5E, LB_ID],
    [0xFF5F, 0xFF5F, LB_OP],
    [0xFF60, 0xFF61, LB_CL],
    [0xFF62, 0xFF62, LB_OP],
    [0xFF63, 0xFF64, LB_CL],
    [0xFF65, 0xFF65, LB_NS],
    [0xFF67, 0xFF70, LB_NS],
    [0xFF9E, 0xFF9F, LB_NS],
    [0xFFE0, 0xFFE0, LB_PO],
    [0xFFE1, 0xFFE1, LB_PR],
    [0xFFE2, 0xFFE4, LB_ID],
    [0xFFE5, 0xFFE6, LB_PR],
    [0xFFF9, 0xFFFB, LB_CM],
    [0xFFFC, 0xFFFC, LB_CB],
    [0xFFFD, 0xFFFD, LB_AI],
    [0x10100, 0x10102, LB_BA],
    [0x101FD, 0x101FD, LB_CM],
    [0x1039F, 0x1039F, LB_BA],
    [0x103D0, 0x103D0, LB_BA],
    [0x104A0, 0x104A9, LB_NU],
    [0x1091F, 0x1091F, LB_BA],
    [0x10A01, 0x10A03, LB_CM],
    [0x10A05, 0x10A06, LB_CM],
    [0x10A0C, 0x10A0F, LB_CM],
    [0x10A38, 0x10A3A, LB_CM],
    [0x10A3F, 0x10A3F, LB_CM],
    [0x10A50, 0x10A57, LB_BA],
    [0x12470, 0x12473, LB_BA],
    [0x1D165, 0x1D169, LB_CM],
    [0x1D16D, 0x1D182, LB_CM],
    [0x1D185, 0x1D18B, LB_CM],
    [0x1D1AA, 0x1D1AD, LB_CM],
    [0x1D242, 0x1D244, LB_CM],
    [0x1D7CE, 0x1D7FF, LB_NU]
];

our $ea_MAP = [
    [0x0000, 0x001F, EA_Z],
    [0x0020, 0x007E, EA_Na],
    [0x007F, 0x009F, EA_Z],
    [0x00A1, 0x00A1, EA_A],
    [0x00A2, 0x00A3, EA_Na],
    [0x00A4, 0x00A4, EA_A],
    [0x00A5, 0x00A6, EA_Na],
    [0x00A7, 0x00A8, EA_A],
    [0x00AA, 0x00AA, EA_A],
    [0x00AC, 0x00AC, EA_Na],
    [0x00AD, 0x00AD, EA_Z],
    [0x00AE, 0x00AE, EA_A],
    [0x00AF, 0x00AF, EA_Na],
    [0x00B0, 0x00B4, EA_A],
    [0x00B6, 0x00BA, EA_A],
    [0x00BC, 0x00BF, EA_A],
    [0x00C6, 0x00C6, EA_A],
    [0x00D0, 0x00D0, EA_A],
    [0x00D7, 0x00D8, EA_A],
    [0x00DE, 0x00E1, EA_A],
    [0x00E6, 0x00E6, EA_A],
    [0x00E8, 0x00EA, EA_A],
    [0x00EC, 0x00ED, EA_A],
    [0x00F0, 0x00F0, EA_A],
    [0x00F2, 0x00F3, EA_A],
    [0x00F7, 0x00FA, EA_A],
    [0x00FC, 0x00FC, EA_A],
    [0x00FE, 0x00FE, EA_A],
    [0x0101, 0x0101, EA_A],
    [0x0111, 0x0111, EA_A],
    [0x0113, 0x0113, EA_A],
    [0x011B, 0x011B, EA_A],
    [0x0126, 0x0127, EA_A],
    [0x012B, 0x012B, EA_A],
    [0x0131, 0x0133, EA_A],
    [0x0138, 0x0138, EA_A],
    [0x013F, 0x0142, EA_A],
    [0x0144, 0x0144, EA_A],
    [0x0148, 0x014B, EA_A],
    [0x014D, 0x014D, EA_A],
    [0x0152, 0x0153, EA_A],
    [0x0166, 0x0167, EA_A],
    [0x016B, 0x016B, EA_A],
    [0x01CE, 0x01CE, EA_A],
    [0x01D0, 0x01D0, EA_A],
    [0x01D2, 0x01D2, EA_A],
    [0x01D4, 0x01D4, EA_A],
    [0x01D6, 0x01D6, EA_A],
    [0x01D8, 0x01D8, EA_A],
    [0x01DA, 0x01DA, EA_A],
    [0x01DC, 0x01DC, EA_A],
    [0x0251, 0x0251, EA_A],
    [0x0261, 0x0261, EA_A],
    [0x02C4, 0x02C4, EA_A],
    [0x02C7, 0x02C7, EA_A],
    [0x02C9, 0x02CB, EA_A],
    [0x02CD, 0x02CD, EA_A],
    [0x02D0, 0x02D0, EA_A],
    [0x02D8, 0x02DB, EA_A],
    [0x02DD, 0x02DD, EA_A],
    [0x02DF, 0x02DF, EA_A],
    [0x0300, 0x036F, EA_Z],
    [0x0391, 0x03A1, EA_A],
    [0x03A3, 0x03A9, EA_A],
    [0x03B1, 0x03C1, EA_A],
    [0x03C3, 0x03C9, EA_A],
    [0x0401, 0x0401, EA_A],
    [0x0410, 0x044F, EA_A],
    [0x0451, 0x0451, EA_A],
    [0x0483, 0x0489, EA_Z],
    [0x0591, 0x05BD, EA_Z],
    [0x05BF, 0x05BF, EA_Z],
    [0x05C1, 0x05C2, EA_Z],
    [0x05C4, 0x05C5, EA_Z],
    [0x05C7, 0x05C7, EA_Z],
    [0x0600, 0x0603, EA_Z],
    [0x0610, 0x061A, EA_Z],
    [0x064B, 0x065E, EA_Z],
    [0x0670, 0x0670, EA_Z],
    [0x06D6, 0x06E4, EA_Z],
    [0x06E7, 0x06E8, EA_Z],
    [0x06EA, 0x06ED, EA_Z],
    [0x070F, 0x070F, EA_Z],
    [0x0711, 0x0711, EA_Z],
    [0x0730, 0x074A, EA_Z],
    [0x07A6, 0x07B0, EA_Z],
    [0x07EB, 0x07F3, EA_Z],
    [0x0901, 0x0902, EA_Z],
    [0x093C, 0x093C, EA_Z],
    [0x0941, 0x0948, EA_Z],
    [0x094D, 0x094D, EA_Z],
    [0x0951, 0x0954, EA_Z],
    [0x0962, 0x0963, EA_Z],
    [0x0981, 0x0981, EA_Z],
    [0x09BC, 0x09BC, EA_Z],
    [0x09C1, 0x09C4, EA_Z],
    [0x09CD, 0x09CD, EA_Z],
    [0x09E2, 0x09E3, EA_Z],
    [0x0A01, 0x0A02, EA_Z],
    [0x0A3C, 0x0A3C, EA_Z],
    [0x0A41, 0x0A42, EA_Z],
    [0x0A47, 0x0A48, EA_Z],
    [0x0A4B, 0x0A4D, EA_Z],
    [0x0A51, 0x0A51, EA_Z],
    [0x0A70, 0x0A71, EA_Z],
    [0x0A75, 0x0A75, EA_Z],
    [0x0A81, 0x0A82, EA_Z],
    [0x0ABC, 0x0ABC, EA_Z],
    [0x0AC1, 0x0AC5, EA_Z],
    [0x0AC7, 0x0AC8, EA_Z],
    [0x0ACD, 0x0ACD, EA_Z],
    [0x0AE2, 0x0AE3, EA_Z],
    [0x0B01, 0x0B01, EA_Z],
    [0x0B3C, 0x0B3C, EA_Z],
    [0x0B3F, 0x0B3F, EA_Z],
    [0x0B41, 0x0B44, EA_Z],
    [0x0B4D, 0x0B4D, EA_Z],
    [0x0B56, 0x0B56, EA_Z],
    [0x0B62, 0x0B63, EA_Z],
    [0x0B82, 0x0B82, EA_Z],
    [0x0BC0, 0x0BC0, EA_Z],
    [0x0BCD, 0x0BCD, EA_Z],
    [0x0C3E, 0x0C40, EA_Z],
    [0x0C46, 0x0C48, EA_Z],
    [0x0C4A, 0x0C4D, EA_Z],
    [0x0C55, 0x0C56, EA_Z],
    [0x0C62, 0x0C63, EA_Z],
    [0x0CBC, 0x0CBC, EA_Z],
    [0x0CBF, 0x0CBF, EA_Z],
    [0x0CC6, 0x0CC6, EA_Z],
    [0x0CCC, 0x0CCD, EA_Z],
    [0x0CE2, 0x0CE3, EA_Z],
    [0x0D41, 0x0D44, EA_Z],
    [0x0D4D, 0x0D4D, EA_Z],
    [0x0D62, 0x0D63, EA_Z],
    [0x0DCA, 0x0DCA, EA_Z],
    [0x0DD2, 0x0DD4, EA_Z],
    [0x0DD6, 0x0DD6, EA_Z],
    [0x0E31, 0x0E31, EA_Z],
    [0x0E34, 0x0E3A, EA_Z],
    [0x0E47, 0x0E4E, EA_Z],
    [0x0EB1, 0x0EB1, EA_Z],
    [0x0EB4, 0x0EB9, EA_Z],
    [0x0EBB, 0x0EBC, EA_Z],
    [0x0EC8, 0x0ECD, EA_Z],
    [0x0F18, 0x0F19, EA_Z],
    [0x0F35, 0x0F35, EA_Z],
    [0x0F37, 0x0F37, EA_Z],
    [0x0F39, 0x0F39, EA_Z],
    [0x0F71, 0x0F7E, EA_Z],
    [0x0F80, 0x0F84, EA_Z],
    [0x0F86, 0x0F87, EA_Z],
    [0x0F90, 0x0F97, EA_Z],
    [0x0F99, 0x0FBC, EA_Z],
    [0x0FC6, 0x0FC6, EA_Z],
    [0x102D, 0x1030, EA_Z],
    [0x1032, 0x1037, EA_Z],
    [0x1039, 0x103A, EA_Z],
    [0x103D, 0x103E, EA_Z],
    [0x1058, 0x1059, EA_Z],
    [0x105E, 0x1060, EA_Z],
    [0x1071, 0x1074, EA_Z],
    [0x1082, 0x1082, EA_Z],
    [0x1085, 0x1086, EA_Z],
    [0x108D, 0x108D, EA_Z],
    [0x1100, 0x1159, EA_W],
    [0x115F, 0x115F, EA_W],
    [0x135F, 0x135F, EA_Z],
    [0x1712, 0x1714, EA_Z],
    [0x1732, 0x1734, EA_Z],
    [0x1752, 0x1753, EA_Z],
    [0x1772, 0x1773, EA_Z],
    [0x17B4, 0x17B5, EA_Z],
    [0x17B7, 0x17BD, EA_Z],
    [0x17C6, 0x17C6, EA_Z],
    [0x17C9, 0x17D3, EA_Z],
    [0x17DD, 0x17DD, EA_Z],
    [0x180B, 0x180D, EA_Z],
    [0x18A9, 0x18A9, EA_Z],
    [0x1920, 0x1922, EA_Z],
    [0x1927, 0x1928, EA_Z],
    [0x1932, 0x1932, EA_Z],
    [0x1939, 0x193B, EA_Z],
    [0x1A17, 0x1A18, EA_Z],
    [0x1B00, 0x1B03, EA_Z],
    [0x1B34, 0x1B34, EA_Z],
    [0x1B36, 0x1B3A, EA_Z],
    [0x1B3C, 0x1B3C, EA_Z],
    [0x1B42, 0x1B42, EA_Z],
    [0x1B6B, 0x1B73, EA_Z],
    [0x1B80, 0x1B81, EA_Z],
    [0x1BA2, 0x1BA5, EA_Z],
    [0x1BA8, 0x1BA9, EA_Z],
    [0x1C2C, 0x1C33, EA_Z],
    [0x1C36, 0x1C37, EA_Z],
    [0x1DC0, 0x1DE6, EA_Z],
    [0x1DFE, 0x1DFF, EA_Z],
    [0x200B, 0x200F, EA_Z],
    [0x2010, 0x2010, EA_A],
    [0x2013, 0x2016, EA_A],
    [0x2018, 0x2019, EA_A],
    [0x201C, 0x201D, EA_A],
    [0x2020, 0x2022, EA_A],
    [0x2024, 0x2027, EA_A],
    [0x2028, 0x202E, EA_Z],
    [0x2030, 0x2030, EA_A],
    [0x2032, 0x2033, EA_A],
    [0x2035, 0x2035, EA_A],
    [0x203B, 0x203B, EA_A],
    [0x203E, 0x203E, EA_A],
    [0x2074, 0x2074, EA_A],
    [0x207F, 0x207F, EA_A],
    [0x2081, 0x2084, EA_A],
    [0x20A9, 0x20A9, EA_H],
    [0x20AC, 0x20AC, EA_A],
    [0x20D0, 0x20F0, EA_Z],
    [0x2103, 0x2103, EA_A],
    [0x2105, 0x2105, EA_A],
    [0x2109, 0x2109, EA_A],
    [0x2113, 0x2113, EA_A],
    [0x2116, 0x2116, EA_A],
    [0x2121, 0x2122, EA_A],
    [0x2126, 0x2126, EA_A],
    [0x212B, 0x212B, EA_A],
    [0x2153, 0x2154, EA_A],
    [0x215B, 0x215E, EA_A],
    [0x2160, 0x216B, EA_A],
    [0x2170, 0x2179, EA_A],
    [0x2190, 0x2199, EA_A],
    [0x21B8, 0x21B9, EA_A],
    [0x21D2, 0x21D2, EA_A],
    [0x21D4, 0x21D4, EA_A],
    [0x21E7, 0x21E7, EA_A],
    [0x2200, 0x2200, EA_A],
    [0x2202, 0x2203, EA_A],
    [0x2207, 0x2208, EA_A],
    [0x220B, 0x220B, EA_A],
    [0x220F, 0x220F, EA_A],
    [0x2211, 0x2211, EA_A],
    [0x2215, 0x2215, EA_A],
    [0x221A, 0x221A, EA_A],
    [0x221D, 0x2220, EA_A],
    [0x2223, 0x2223, EA_A],
    [0x2225, 0x2225, EA_A],
    [0x2227, 0x222C, EA_A],
    [0x222E, 0x222E, EA_A],
    [0x2234, 0x2237, EA_A],
    [0x223C, 0x223D, EA_A],
    [0x2248, 0x2248, EA_A],
    [0x224C, 0x224C, EA_A],
    [0x2252, 0x2252, EA_A],
    [0x2260, 0x2261, EA_A],
    [0x2264, 0x2267, EA_A],
    [0x226A, 0x226B, EA_A],
    [0x226E, 0x226F, EA_A],
    [0x2282, 0x2283, EA_A],
    [0x2286, 0x2287, EA_A],
    [0x2295, 0x2295, EA_A],
    [0x2299, 0x2299, EA_A],
    [0x22A5, 0x22A5, EA_A],
    [0x22BF, 0x22BF, EA_A],
    [0x2312, 0x2312, EA_A],
    [0x2329, 0x232A, EA_W],
    [0x2460, 0x24E9, EA_A],
    [0x24EB, 0x254B, EA_A],
    [0x2550, 0x2573, EA_A],
    [0x2580, 0x258F, EA_A],
    [0x2592, 0x2595, EA_A],
    [0x25A0, 0x25A1, EA_A],
    [0x25A3, 0x25A9, EA_A],
    [0x25B2, 0x25B3, EA_A],
    [0x25B6, 0x25B7, EA_A],
    [0x25BC, 0x25BD, EA_A],
    [0x25C0, 0x25C1, EA_A],
    [0x25C6, 0x25C8, EA_A],
    [0x25CB, 0x25CB, EA_A],
    [0x25CE, 0x25D1, EA_A],
    [0x25E2, 0x25E5, EA_A],
    [0x25EF, 0x25EF, EA_A],
    [0x2605, 0x2606, EA_A],
    [0x2609, 0x2609, EA_A],
    [0x260E, 0x260F, EA_A],
    [0x2614, 0x2615, EA_A],
    [0x261C, 0x261C, EA_A],
    [0x261E, 0x261E, EA_A],
    [0x2640, 0x2640, EA_A],
    [0x2642, 0x2642, EA_A],
    [0x2660, 0x2661, EA_A],
    [0x2663, 0x2665, EA_A],
    [0x2667, 0x266A, EA_A],
    [0x266C, 0x266D, EA_A],
    [0x266F, 0x266F, EA_A],
    [0x273D, 0x273D, EA_A],
    [0x2776, 0x277F, EA_A],
    [0x27E6, 0x27ED, EA_Na],
    [0x2985, 0x2986, EA_Na],
    [0x2DE0, 0x2DFF, EA_Z],
    [0x2E80, 0x2E99, EA_W],
    [0x2E9B, 0x2EF3, EA_W],
    [0x2F00, 0x2FD5, EA_W],
    [0x2FF0, 0x2FFB, EA_W],
    [0x3000, 0x3000, EA_F],
    [0x3001, 0x3029, EA_W],
    [0x302A, 0x302F, EA_Z],
    [0x3030, 0x303E, EA_W],
    [0x3041, 0x3096, EA_W],
    [0x3099, 0x309A, EA_Z],
    [0x309B, 0x30FF, EA_W],
    [0x3105, 0x312D, EA_W],
    [0x3131, 0x318E, EA_W],
    [0x3190, 0x31B7, EA_W],
    [0x31C0, 0x31E3, EA_W],
    [0x31F0, 0x321E, EA_W],
    [0x3220, 0x3243, EA_W],
    [0x3250, 0x32FE, EA_W],
    [0x3300, 0x33FF, EA_W],
    [0xA015, 0xA015, EA_W],
    [0xA490, 0xA4C6, EA_W],
    [0xA66F, 0xA672, EA_Z],
    [0xA67C, 0xA67D, EA_Z],
    [0xA802, 0xA802, EA_Z],
    [0xA806, 0xA806, EA_Z],
    [0xA80B, 0xA80B, EA_Z],
    [0xA825, 0xA826, EA_Z],
    [0xA8C4, 0xA8C4, EA_Z],
    [0xA926, 0xA92D, EA_Z],
    [0xA947, 0xA951, EA_Z],
    [0xAA29, 0xAA2E, EA_Z],
    [0xAA31, 0xAA32, EA_Z],
    [0xAA35, 0xAA36, EA_Z],
    [0xAA43, 0xAA43, EA_Z],
    [0xAA4C, 0xAA4C, EA_Z],
    [0xFB1E, 0xFB1E, EA_Z],
    [0xFE00, 0xFE0F, EA_Z],
    [0xFE10, 0xFE19, EA_W],
    [0xFE20, 0xFE26, EA_Z],
    [0xFE30, 0xFE52, EA_W],
    [0xFE54, 0xFE66, EA_W],
    [0xFE68, 0xFE6B, EA_W],
    [0xFEFF, 0xFEFF, EA_Z],
    [0xFF01, 0xFF60, EA_F],
    [0xFF61, 0xFFBE, EA_H],
    [0xFFC2, 0xFFC7, EA_H],
    [0xFFCA, 0xFFCF, EA_H],
    [0xFFD2, 0xFFD7, EA_H],
    [0xFFDA, 0xFFDC, EA_H],
    [0xFFE0, 0xFFE6, EA_F],
    [0xFFE8, 0xFFEE, EA_H],
    [0xFFFD, 0xFFFD, EA_A],
    [0x101FD, 0x101FD, EA_Z],
    [0x10A01, 0x10A03, EA_Z],
    [0x10A05, 0x10A06, EA_Z],
    [0x10A0C, 0x10A0F, EA_Z],
    [0x10A38, 0x10A3A, EA_Z],
    [0x10A3F, 0x10A3F, EA_Z],
    [0x1D167, 0x1D169, EA_Z],
    [0x1D173, 0x1D182, EA_Z],
    [0x1D185, 0x1D18B, EA_Z],
    [0x1D1AA, 0x1D1AD, EA_Z],
    [0x1D242, 0x1D244, EA_Z]
];

our $script_MAP = [
    [0x0E01, 0x0E3A, SCRIPT_Thai],
    [0x0E40, 0x0E4E, SCRIPT_Thai],
    [0x0E81, 0x0E82, SCRIPT_Lao],
    [0x0E84, 0x0E84, SCRIPT_Lao],
    [0x0E87, 0x0E88, SCRIPT_Lao],
    [0x0E8A, 0x0E8A, SCRIPT_Lao],
    [0x0E8D, 0x0E8D, SCRIPT_Lao],
    [0x0E94, 0x0E97, SCRIPT_Lao],
    [0x0E99, 0x0E9F, SCRIPT_Lao],
    [0x0EA1, 0x0EA3, SCRIPT_Lao],
    [0x0EA5, 0x0EA5, SCRIPT_Lao],
    [0x0EA7, 0x0EA7, SCRIPT_Lao],
    [0x0EAA, 0x0EAB, SCRIPT_Lao],
    [0x0EAD, 0x0EB9, SCRIPT_Lao],
    [0x0EBB, 0x0EBD, SCRIPT_Lao],
    [0x0EC0, 0x0EC4, SCRIPT_Lao],
    [0x0EC6, 0x0EC6, SCRIPT_Lao],
    [0x0EC8, 0x0ECD, SCRIPT_Lao],
    [0x0EDC, 0x0EDD, SCRIPT_Lao],
    [0x1000, 0x103F, SCRIPT_Myanmar],
    [0x1050, 0x108F, SCRIPT_Myanmar],
    [0x109E, 0x109F, SCRIPT_Myanmar],
    [0x1780, 0x17D3, SCRIPT_Khmer],
    [0x17D7, 0x17D7, SCRIPT_Khmer],
    [0x17DC, 0x17DD, SCRIPT_Khmer],
    [0x1950, 0x196D, SCRIPT_Tai_Le],
    [0x1970, 0x1974, SCRIPT_Tai_Le],
    [0x1980, 0x19A9, SCRIPT_New_Tai_Lue],
    [0x19B0, 0x19C9, SCRIPT_New_Tai_Lue],
    [0x19DE, 0x19DF, SCRIPT_New_Tai_Lue]
];

1;
