#-*- perl -*-

package Unicode::LineBreak;

sub lb_AI {
    return <<'END';
00A7	00A8	
00AA		
00B2	00B3	
00B6	00BA	
00BC	00BE	
00D7		
00F7		
02C7		
02C9	02CB	
02CD		
02D0		
02D8	02DB	
02DD		
2015	2016	
2020	2021	
203B		
2074		
207F		
2081	2084	
2105		
2113		
2121	2122	
212B		
2154	2155	
215B		
215E		
2160	216B	
2170	2179	
2190	2199	
21D2		
21D4		
2200		
2202	2203	
2207	2208	
220B		
220F		
2211		
2215		
221A		
221D	2220	
2223		
2225		
2227	222C	
222E		
2234	2237	
223C	223D	
2248		
224C		
2252		
2260	2261	
2264	2267	
226A	226B	
226E	226F	
2282	2283	
2286	2287	
2295		
2299		
22A5		
22BF		
2312		
2460	24FE	
2500	254B	
2550	2574	
2580	258F	
2592	2595	
25A0	25A1	
25A3	25A9	
25B2	25B3	
25B6	25B7	
25BC	25BD	
25C0	25C1	
25C6	25C8	
25CB		
25CE	25D1	
25E2	25E5	
25EF		
2605	2606	
2609		
260E	260F	
2614	2617	
261C		
261E		
2640		
2642		
2660	2661	
2663	2665	
2667	266A	
266C	266D	
266F		
2776	2793	
FFFD		
END
}

sub lb_AL {
    return <<'END';
0023		
0026		
002A		
003C	003E	
0040	005A	
005E	007A	
007E		
00A6		
00A9		
00AC		
00AE	00AF	
00B5		
00C0	00D6	
00D8	00F6	
00F8	02C6	
02CE	02CF	
02D1	02D7	
02DC		
02DE		
02E0	02FF	
0370	0377	
037A	037D	
0384	038A	
038C		
038E	03A1	
03A3	0482	
048A	0523	
0531	0556	
0559	055F	
0561	0587	
05C0		
05C3		
05D0	05EA	
05F0	05F4	
0600	0603	
0606	0608	
060E	060F	
0621	064A	
066D	066F	
0671	06D3	
06D5		
06DD		
06E5	06E6	
06E9		
06EE	06EF	
06FA	070D	
070F	0710	
0712	072F	
074D	07A5	
07B1		
07CA	07EA	
07F4	07F7	
07FA		
0904	0939	
093D		
0950		
0958	0961	
0970	0972	
097B	097F	
0985	098C	
098F	0990	
0993	09A8	
09AA	09B0	
09B2		
09B6	09B9	
09BD		
09CE		
09DC	09DD	
09DF	09E1	
09F0	09F1	
09F4	09FA	
0A05	0A0A	
0A0F	0A10	
0A13	0A28	
0A2A	0A30	
0A32	0A33	
0A35	0A36	
0A38	0A39	
0A59	0A5C	
0A5E		
0A72	0A74	
0A85	0A8D	
0A8F	0A91	
0A93	0AA8	
0AAA	0AB0	
0AB2	0AB3	
0AB5	0AB9	
0ABD		
0AD0		
0AE0	0AE1	
0B05	0B0C	
0B0F	0B10	
0B13	0B28	
0B2A	0B30	
0B32	0B33	
0B35	0B39	
0B3D		
0B5C	0B5D	
0B5F	0B61	
0B70	0B71	
0B83		
0B85	0B8A	
0B8E	0B90	
0B92	0B95	
0B99	0B9A	
0B9C		
0B9E	0B9F	
0BA3	0BA4	
0BA8	0BAA	
0BAE	0BB9	
0BD0		
0BF0	0BF8	
0BFA		
0C05	0C0C	
0C0E	0C10	
0C12	0C28	
0C2A	0C33	
0C35	0C39	
0C3D		
0C58	0C59	
0C60	0C61	
0C78	0C7F	
0C85	0C8C	
0C8E	0C90	
0C92	0CA8	
0CAA	0CB3	
0CB5	0CB9	
0CBD		
0CDE		
0CE0	0CE1	
0CF1	0CF2	
0D05	0D0C	
0D0E	0D10	
0D12	0D28	
0D2A	0D39	
0D3D		
0D60	0D61	
0D70	0D75	
0D7A	0D7F	
0D85	0D96	
0D9A	0DB1	
0DB3	0DBB	
0DBD		
0DC0	0DC6	
0DF4		
0E4F		
0F00		
0F05		
0F13		
0F15	0F17	
0F1A	0F1F	
0F2A	0F33	
0F36		
0F38		
0F40	0F47	
0F49	0F6C	
0F88	0F8B	
0FC0	0FC5	
0FC7	0FCC	
0FCE	0FCF	
0FD4		
104C	104F	
10A0	10C5	
10D0	10FC	
1200	1248	
124A	124D	
1250	1256	
1258		
125A	125D	
1260	1288	
128A	128D	
1290	12B0	
12B2	12B5	
12B8	12BE	
12C0		
12C2	12C5	
12C8	12D6	
12D8	1310	
1312	1315	
1318	135A	
1360		
1362	137C	
1380	1399	
13A0	13F4	
1401	1676	
1681	169A	
16A0	16EA	
16EE	16F0	
1700	170C	
170E	1711	
1720	1731	
1740	1751	
1760	176C	
176E	1770	
17D9		
17F0	17F9	
1800	1801	
1807		
180A		
1820	1877	
1880	18A8	
18AA		
1900	191C	
1940		
19E0	1A16	
1A1E	1A1F	
1B05	1B33	
1B45	1B4B	
1B61	1B6A	
1B74	1B7C	
1B83	1BA0	
1BAE	1BAF	
1C00	1C23	
1C4D	1C4F	
1C5A	1C7D	
1D00	1DBF	
1E00	1F15	
1F18	1F1D	
1F20	1F45	
1F48	1F4D	
1F50	1F57	
1F59		
1F5B		
1F5D		
1F5F	1F7D	
1F80	1FB4	
1FB6	1FC4	
1FC6	1FD3	
1FD6	1FDB	
1FDD	1FEF	
1FF2	1FF4	
1FF6	1FFC	
1FFE		
2017		
2022	2023	
2038		
203E	2043	
204A	2055	
2057		
205C		
2061	2064	
2070	2071	
2075	207C	
2080		
2085	208C	
2090	2094	
2100	2102	
2104		
2106	2108	
210A	2112	
2114	2115	
2117	2120	
2123	212A	
212C	214F	
2153		
2156	215A	
215C	215D	
215F		
216C	216F	
217A	2188	
219A	21D1	
21D3		
21D5	21FF	
2201		
2204	2206	
2209	220A	
220C	220E	
2210		
2214		
2216	2219	
221B	221C	
2221	2222	
2224		
2226		
222D		
222F	2233	
2238	223B	
223E	2247	
2249	224B	
224D	2251	
2253	225F	
2262	2263	
2268	2269	
226C	226D	
2270	2281	
2284	2285	
2288	2294	
2296	2298	
229A	22A4	
22A6	22BE	
22C0	2311	
2313	2328	
232B	23E7	
2400	2426	
2440	244A	
24FF		
254C	254F	
2575	257F	
2590	2591	
2596	259F	
25A2		
25AA	25B1	
25B4	25B5	
25B8	25BB	
25BE	25BF	
25C2	25C5	
25C9	25CA	
25CC	25CD	
25D2	25E1	
25E6	25EE	
25F0	2604	
2607	2608	
260A	260D	
2610	2613	
2618	261B	
261D		
261F	263F	
2641		
2643	265F	
2662		
2666		
266B		
266E		
2670	269D	
26A0	26BC	
26C0	26C3	
2701	2704	
2706	2709	
270C	2727	
2729	274B	
274D		
274F	2752	
2756		
2758	275A	
2761		
2764	2767	
2794		
2798	27AF	
27B1	27BE	
27C0	27C4	
27C7	27CA	
27CC		
27D0	27E5	
27F0	2982	
2999	29D7	
29DC	29FB	
29FE	2B4C	
2B50	2B54	
2C00	2C2E	
2C30	2C5E	
2C60	2C6F	
2C71	2C7D	
2C80	2CEA	
2CFD		
2D00	2D25	
2D30	2D65	
2D6F		
2D80	2D96	
2DA0	2DA6	
2DA8	2DAE	
2DB0	2DB6	
2DB8	2DBE	
2DC0	2DC6	
2DC8	2DCE	
2DD0	2DD6	
2DD8	2DDE	
2E16		
2E1A	2E1B	
2E1E	2E1F	
2E2F		
4DC0	4DFF	
A500	A60C	
A610	A61F	
A62A	A62B	
A640	A65F	
A662	A66E	
A673		
A67E	A697	
A700	A78C	
A7FB	A801	
A803	A805	
A807	A80A	
A80C	A822	
A828	A82B	
A840	A873	
A882	A8B3	
A90A	A925	
A930	A946	
A95F		
AA00	AA28	
AA40	AA42	
AA44	AA4B	
AA5C		
FB00	FB06	
FB13	FB17	
FB1D		
FB1F	FB36	
FB38	FB3C	
FB3E		
FB40	FB41	
FB43	FB44	
FB46	FBB1	
FBD3	FD3D	
FD50	FD8F	
FD92	FDC7	
FDF0	FDFB	
FDFD		
FE70	FE74	
FE76	FEFC	
FF66		
FF71	FF9D	
FFA0	FFBE	
FFC2	FFC7	
FFCA	FFCF	
FFD2	FFD7	
FFDA	FFDC	
FFE8	FFEE	
10000	1000B	
1000D	10026	
10028	1003A	
1003C	1003D	
1003F	1004D	
10050	1005D	
10080	100FA	
10107	10133	
10137	1018A	
10190	1019B	
101D0	101FC	
10280	1029C	
102A0	102D0	
10300	1031E	
10320	10323	
10330	1034A	
10380	1039D	
103A0	103C3	
103C8	103CF	
103D1	103D5	
10400	1049D	
10800	10805	
10808		
1080A	10835	
10837	10838	
1083C		
1083F		
10900	10919	
10920	10939	
1093F		
10A00		
10A10	10A13	
10A15	10A17	
10A19	10A33	
10A40	10A47	
10A58		
12000	1236E	
12400	12462	
1D000	1D0F5	
1D100	1D126	
1D129	1D164	
1D16A	1D16C	
1D183	1D184	
1D18C	1D1A9	
1D1AE	1D1DD	
1D200	1D241	
1D245		
1D300	1D356	
1D360	1D371	
1D400	1D454	
1D456	1D49C	
1D49E	1D49F	
1D4A2		
1D4A5	1D4A6	
1D4A9	1D4AC	
1D4AE	1D4B9	
1D4BB		
1D4BD	1D4C3	
1D4C5	1D505	
1D507	1D50A	
1D50D	1D514	
1D516	1D51C	
1D51E	1D539	
1D53B	1D53E	
1D540	1D544	
1D546		
1D54A	1D550	
1D552	1D6A5	
1D6A8	1D7CB	
1F000	1F02B	
1F030	1F093	
END
}

sub lb_B2 {
    return <<'END';
2014		
END
}

sub lb_BA {
    return <<'END';
0009		
007C		
00AD		
058A		
05BE		
0964	0965	
0E5A	0E5B	
0F0B		
0F34		
0F7F		
0F85		
0FBE	0FBF	
0FD2		
104A	104B	
1361		
1680		
16EB	16ED	
1735	1736	
17D4	17D5	
17D8		
17DA		
1804	1805	
1B5A	1B60	
1C3B	1C3F	
1C7E	1C7F	
2000	2006	
2008	200A	
2010		
2012	2013	
2027		
2056		
2058	205B	
205D	205F	
2CFA	2CFC	
2CFF		
2E0E	2E15	
2E17		
2E19		
2E2A	2E2D	
2E30		
A60D		
A60F		
A8CE	A8CF	
A92E	A92F	
AA5D	AA5F	
10100	10102	
1039F		
103D0		
1091F		
10A50	10A57	
12470	12473	
END
}

sub lb_BB {
    return <<'END';
00B4		
02C8		
02CC		
02DF		
0F01	0F04	
0F06	0F07	
0F09	0F0A	
0FD0	0FD1	
0FD3		
1806		
1FFD		
A874	A875	
END
}

sub lb_BK {
    return <<'END';
000B	000C	
2028	2029	
END
}

sub lb_CB {
    return <<'END';
FFFC		
END
}

sub lb_CL {
    return <<'END';
0029		
005D		
007D		
0F3B		
0F3D		
169C		
2046		
207E		
208E		
232A		
2769		
276B		
276D		
276F		
2771		
2773		
2775		
27C6		
27E7		
27E9		
27EB		
27ED		
27EF		
2984		
2986		
2988		
298A		
298C		
298E		
2990		
2992		
2994		
2996		
2998		
29D9		
29DB		
29FD		
2E23		
2E25		
2E27		
2E29		
3001	3002	
3009		
300B		
300D		
300F		
3011		
3015		
3017		
3019		
301B		
301E	301F	
FD3F		
FE11	FE12	
FE18		
FE36		
FE38		
FE3A		
FE3C		
FE3E		
FE40		
FE42		
FE44		
FE48		
FE50		
FE52		
FE5A		
FE5C		
FE5E		
FF09		
FF0C		
FF0E		
FF3D		
FF5D		
FF60	FF61	
FF63	FF64	
END
}

sub lb_CM {
    return <<'END';
0000	0008	
000E	001F	
007F	0084	
0086	009F	
0300	034E	
0350	035B	
0363	036F	
0483	0489	
0591	05BD	
05BF		
05C1	05C2	
05C4	05C5	
05C7		
0610	061A	
064B	065E	
0670		
06D6	06DC	
06DE	06E4	
06E7	06E8	
06EA	06ED	
0711		
0730	074A	
07A6	07B0	
07EB	07F3	
0901	0903	
093C		
093E	094D	
0951	0954	
0962	0963	
0981	0983	
09BC		
09BE	09C4	
09C7	09C8	
09CB	09CD	
09D7		
09E2	09E3	
0A01	0A03	
0A3C		
0A3E	0A42	
0A47	0A48	
0A4B	0A4D	
0A51		
0A70	0A71	
0A75		
0A81	0A83	
0ABC		
0ABE	0AC5	
0AC7	0AC9	
0ACB	0ACD	
0AE2	0AE3	
0B01	0B03	
0B3C		
0B3E	0B44	
0B47	0B48	
0B4B	0B4D	
0B56	0B57	
0B62	0B63	
0B82		
0BBE	0BC2	
0BC6	0BC8	
0BCA	0BCD	
0BD7		
0C01	0C03	
0C3E	0C44	
0C46	0C48	
0C4A	0C4D	
0C55	0C56	
0C62	0C63	
0C82	0C83	
0CBC		
0CBE	0CC4	
0CC6	0CC8	
0CCA	0CCD	
0CD5	0CD6	
0CE2	0CE3	
0D02	0D03	
0D3E	0D44	
0D46	0D48	
0D4A	0D4D	
0D57		
0D62	0D63	
0D82	0D83	
0DCA		
0DCF	0DD4	
0DD6		
0DD8	0DDF	
0DF2	0DF3	
0F18	0F19	
0F35		
0F37		
0F39		
0F3E	0F3F	
0F71	0F7E	
0F80	0F84	
0F86	0F87	
0F90	0F97	
0F99	0FBC	
0FC6		
135F		
1712	1714	
1732	1734	
1752	1753	
1772	1773	
180B	180D	
18A9		
1920	192B	
1930	193B	
1A17	1A1B	
1B00	1B04	
1B34	1B44	
1B6B	1B73	
1B80	1B82	
1BA1	1BAA	
1C24	1C37	
1DC0	1DE6	
1DFE	1DFF	
200C	200F	
202A	202E	
206A	206F	
20D0	20F0	
2DE0	2DFF	
302A	302F	
3099	309A	
A66F	A672	
A67C	A67D	
A802		
A806		
A80B		
A823	A827	
A880	A881	
A8B4	A8C4	
A926	A92D	
A947	A953	
AA29	AA36	
AA43		
AA4C	AA4D	
FB1E		
FE00	FE0F	
FE20	FE26	
FFF9	FFFB	
101FD		
10A01	10A03	
10A05	10A06	
10A0C	10A0F	
10A38	10A3A	
10A3F		
1D165	1D169	
1D16D	1D182	
1D185	1D18B	
1D1AA	1D1AD	
1D242	1D244	
E0001		
E0020	E007F	
E0100	E01EF	
END
}

sub lb_CR {
    return <<'END';
000D		
END
}

sub lb_EX {
    return <<'END';
0021		
003F		
05C6		
061B		
061E	061F	
06D4		
07F9		
0F0D	0F11	
0F14		
1802	1803	
1808	1809	
1944	1945	
2762	2763	
2CF9		
2CFE		
2E2E		
A60E		
A876	A877	
FE15	FE16	
FE56	FE57	
FF01		
FF1F		
END
}

sub lb_GL {
    return <<'END';
00A0		
034F		
035C	0362	
0F08		
0F0C		
0F12		
180E		
2007		
2011		
202F		
END
}

sub lb_H2 {
    return <<'END';
AC00		
AC1C		
AC38		
AC54		
AC70		
AC8C		
ACA8		
ACC4		
ACE0		
ACFC		
AD18		
AD34		
AD50		
AD6C		
AD88		
ADA4		
ADC0		
ADDC		
ADF8		
AE14		
AE30		
AE4C		
AE68		
AE84		
AEA0		
AEBC		
AED8		
AEF4		
AF10		
AF2C		
AF48		
AF64		
AF80		
AF9C		
AFB8		
AFD4		
AFF0		
B00C		
B028		
B044		
B060		
B07C		
B098		
B0B4		
B0D0		
B0EC		
B108		
B124		
B140		
B15C		
B178		
B194		
B1B0		
B1CC		
B1E8		
B204		
B220		
B23C		
B258		
B274		
B290		
B2AC		
B2C8		
B2E4		
B300		
B31C		
B338		
B354		
B370		
B38C		
B3A8		
B3C4		
B3E0		
B3FC		
B418		
B434		
B450		
B46C		
B488		
B4A4		
B4C0		
B4DC		
B4F8		
B514		
B530		
B54C		
B568		
B584		
B5A0		
B5BC		
B5D8		
B5F4		
B610		
B62C		
B648		
B664		
B680		
B69C		
B6B8		
B6D4		
B6F0		
B70C		
B728		
B744		
B760		
B77C		
B798		
B7B4		
B7D0		
B7EC		
B808		
B824		
B840		
B85C		
B878		
B894		
B8B0		
B8CC		
B8E8		
B904		
B920		
B93C		
B958		
B974		
B990		
B9AC		
B9C8		
B9E4		
BA00		
BA1C		
BA38		
BA54		
BA70		
BA8C		
BAA8		
BAC4		
BAE0		
BAFC		
BB18		
BB34		
BB50		
BB6C		
BB88		
BBA4		
BBC0		
BBDC		
BBF8		
BC14		
BC30		
BC4C		
BC68		
BC84		
BCA0		
BCBC		
BCD8		
BCF4		
BD10		
BD2C		
BD48		
BD64		
BD80		
BD9C		
BDB8		
BDD4		
BDF0		
BE0C		
BE28		
BE44		
BE60		
BE7C		
BE98		
BEB4		
BED0		
BEEC		
BF08		
BF24		
BF40		
BF5C		
BF78		
BF94		
BFB0		
BFCC		
BFE8		
C004		
C020		
C03C		
C058		
C074		
C090		
C0AC		
C0C8		
C0E4		
C100		
C11C		
C138		
C154		
C170		
C18C		
C1A8		
C1C4		
C1E0		
C1FC		
C218		
C234		
C250		
C26C		
C288		
C2A4		
C2C0		
C2DC		
C2F8		
C314		
C330		
C34C		
C368		
C384		
C3A0		
C3BC		
C3D8		
C3F4		
C410		
C42C		
C448		
C464		
C480		
C49C		
C4B8		
C4D4		
C4F0		
C50C		
C528		
C544		
C560		
C57C		
C598		
C5B4		
C5D0		
C5EC		
C608		
C624		
C640		
C65C		
C678		
C694		
C6B0		
C6CC		
C6E8		
C704		
C720		
C73C		
C758		
C774		
C790		
C7AC		
C7C8		
C7E4		
C800		
C81C		
C838		
C854		
C870		
C88C		
C8A8		
C8C4		
C8E0		
C8FC		
C918		
C934		
C950		
C96C		
C988		
C9A4		
C9C0		
C9DC		
C9F8		
CA14		
CA30		
CA4C		
CA68		
CA84		
CAA0		
CABC		
CAD8		
CAF4		
CB10		
CB2C		
CB48		
CB64		
CB80		
CB9C		
CBB8		
CBD4		
CBF0		
CC0C		
CC28		
CC44		
CC60		
CC7C		
CC98		
CCB4		
CCD0		
CCEC		
CD08		
CD24		
CD40		
CD5C		
CD78		
CD94		
CDB0		
CDCC		
CDE8		
CE04		
CE20		
CE3C		
CE58		
CE74		
CE90		
CEAC		
CEC8		
CEE4		
CF00		
CF1C		
CF38		
CF54		
CF70		
CF8C		
CFA8		
CFC4		
CFE0		
CFFC		
D018		
D034		
D050		
D06C		
D088		
D0A4		
D0C0		
D0DC		
D0F8		
D114		
D130		
D14C		
D168		
D184		
D1A0		
D1BC		
D1D8		
D1F4		
D210		
D22C		
D248		
D264		
D280		
D29C		
D2B8		
D2D4		
D2F0		
D30C		
D328		
D344		
D360		
D37C		
D398		
D3B4		
D3D0		
D3EC		
D408		
D424		
D440		
D45C		
D478		
D494		
D4B0		
D4CC		
D4E8		
D504		
D520		
D53C		
D558		
D574		
D590		
D5AC		
D5C8		
D5E4		
D600		
D61C		
D638		
D654		
D670		
D68C		
D6A8		
D6C4		
D6E0		
D6FC		
D718		
D734		
D750		
D76C		
D788		
END
}

sub lb_H3 {
    return <<'END';
AC01	AC1B	
AC1D	AC37	
AC39	AC53	
AC55	AC6F	
AC71	AC8B	
AC8D	ACA7	
ACA9	ACC3	
ACC5	ACDF	
ACE1	ACFB	
ACFD	AD17	
AD19	AD33	
AD35	AD4F	
AD51	AD6B	
AD6D	AD87	
AD89	ADA3	
ADA5	ADBF	
ADC1	ADDB	
ADDD	ADF7	
ADF9	AE13	
AE15	AE2F	
AE31	AE4B	
AE4D	AE67	
AE69	AE83	
AE85	AE9F	
AEA1	AEBB	
AEBD	AED7	
AED9	AEF3	
AEF5	AF0F	
AF11	AF2B	
AF2D	AF47	
AF49	AF63	
AF65	AF7F	
AF81	AF9B	
AF9D	AFB7	
AFB9	AFD3	
AFD5	AFEF	
AFF1	B00B	
B00D	B027	
B029	B043	
B045	B05F	
B061	B07B	
B07D	B097	
B099	B0B3	
B0B5	B0CF	
B0D1	B0EB	
B0ED	B107	
B109	B123	
B125	B13F	
B141	B15B	
B15D	B177	
B179	B193	
B195	B1AF	
B1B1	B1CB	
B1CD	B1E7	
B1E9	B203	
B205	B21F	
B221	B23B	
B23D	B257	
B259	B273	
B275	B28F	
B291	B2AB	
B2AD	B2C7	
B2C9	B2E3	
B2E5	B2FF	
B301	B31B	
B31D	B337	
B339	B353	
B355	B36F	
B371	B38B	
B38D	B3A7	
B3A9	B3C3	
B3C5	B3DF	
B3E1	B3FB	
B3FD	B417	
B419	B433	
B435	B44F	
B451	B46B	
B46D	B487	
B489	B4A3	
B4A5	B4BF	
B4C1	B4DB	
B4DD	B4F7	
B4F9	B513	
B515	B52F	
B531	B54B	
B54D	B567	
B569	B583	
B585	B59F	
B5A1	B5BB	
B5BD	B5D7	
B5D9	B5F3	
B5F5	B60F	
B611	B62B	
B62D	B647	
B649	B663	
B665	B67F	
B681	B69B	
B69D	B6B7	
B6B9	B6D3	
B6D5	B6EF	
B6F1	B70B	
B70D	B727	
B729	B743	
B745	B75F	
B761	B77B	
B77D	B797	
B799	B7B3	
B7B5	B7CF	
B7D1	B7EB	
B7ED	B807	
B809	B823	
B825	B83F	
B841	B85B	
B85D	B877	
B879	B893	
B895	B8AF	
B8B1	B8CB	
B8CD	B8E7	
B8E9	B903	
B905	B91F	
B921	B93B	
B93D	B957	
B959	B973	
B975	B98F	
B991	B9AB	
B9AD	B9C7	
B9C9	B9E3	
B9E5	B9FF	
BA01	BA1B	
BA1D	BA37	
BA39	BA53	
BA55	BA6F	
BA71	BA8B	
BA8D	BAA7	
BAA9	BAC3	
BAC5	BADF	
BAE1	BAFB	
BAFD	BB17	
BB19	BB33	
BB35	BB4F	
BB51	BB6B	
BB6D	BB87	
BB89	BBA3	
BBA5	BBBF	
BBC1	BBDB	
BBDD	BBF7	
BBF9	BC13	
BC15	BC2F	
BC31	BC4B	
BC4D	BC67	
BC69	BC83	
BC85	BC9F	
BCA1	BCBB	
BCBD	BCD7	
BCD9	BCF3	
BCF5	BD0F	
BD11	BD2B	
BD2D	BD47	
BD49	BD63	
BD65	BD7F	
BD81	BD9B	
BD9D	BDB7	
BDB9	BDD3	
BDD5	BDEF	
BDF1	BE0B	
BE0D	BE27	
BE29	BE43	
BE45	BE5F	
BE61	BE7B	
BE7D	BE97	
BE99	BEB3	
BEB5	BECF	
BED1	BEEB	
BEED	BF07	
BF09	BF23	
BF25	BF3F	
BF41	BF5B	
BF5D	BF77	
BF79	BF93	
BF95	BFAF	
BFB1	BFCB	
BFCD	BFE7	
BFE9	C003	
C005	C01F	
C021	C03B	
C03D	C057	
C059	C073	
C075	C08F	
C091	C0AB	
C0AD	C0C7	
C0C9	C0E3	
C0E5	C0FF	
C101	C11B	
C11D	C137	
C139	C153	
C155	C16F	
C171	C18B	
C18D	C1A7	
C1A9	C1C3	
C1C5	C1DF	
C1E1	C1FB	
C1FD	C217	
C219	C233	
C235	C24F	
C251	C26B	
C26D	C287	
C289	C2A3	
C2A5	C2BF	
C2C1	C2DB	
C2DD	C2F7	
C2F9	C313	
C315	C32F	
C331	C34B	
C34D	C367	
C369	C383	
C385	C39F	
C3A1	C3BB	
C3BD	C3D7	
C3D9	C3F3	
C3F5	C40F	
C411	C42B	
C42D	C447	
C449	C463	
C465	C47F	
C481	C49B	
C49D	C4B7	
C4B9	C4D3	
C4D5	C4EF	
C4F1	C50B	
C50D	C527	
C529	C543	
C545	C55F	
C561	C57B	
C57D	C597	
C599	C5B3	
C5B5	C5CF	
C5D1	C5EB	
C5ED	C607	
C609	C623	
C625	C63F	
C641	C65B	
C65D	C677	
C679	C693	
C695	C6AF	
C6B1	C6CB	
C6CD	C6E7	
C6E9	C703	
C705	C71F	
C721	C73B	
C73D	C757	
C759	C773	
C775	C78F	
C791	C7AB	
C7AD	C7C7	
C7C9	C7E3	
C7E5	C7FF	
C801	C81B	
C81D	C837	
C839	C853	
C855	C86F	
C871	C88B	
C88D	C8A7	
C8A9	C8C3	
C8C5	C8DF	
C8E1	C8FB	
C8FD	C917	
C919	C933	
C935	C94F	
C951	C96B	
C96D	C987	
C989	C9A3	
C9A5	C9BF	
C9C1	C9DB	
C9DD	C9F7	
C9F9	CA13	
CA15	CA2F	
CA31	CA4B	
CA4D	CA67	
CA69	CA83	
CA85	CA9F	
CAA1	CABB	
CABD	CAD7	
CAD9	CAF3	
CAF5	CB0F	
CB11	CB2B	
CB2D	CB47	
CB49	CB63	
CB65	CB7F	
CB81	CB9B	
CB9D	CBB7	
CBB9	CBD3	
CBD5	CBEF	
CBF1	CC0B	
CC0D	CC27	
CC29	CC43	
CC45	CC5F	
CC61	CC7B	
CC7D	CC97	
CC99	CCB3	
CCB5	CCCF	
CCD1	CCEB	
CCED	CD07	
CD09	CD23	
CD25	CD3F	
CD41	CD5B	
CD5D	CD77	
CD79	CD93	
CD95	CDAF	
CDB1	CDCB	
CDCD	CDE7	
CDE9	CE03	
CE05	CE1F	
CE21	CE3B	
CE3D	CE57	
CE59	CE73	
CE75	CE8F	
CE91	CEAB	
CEAD	CEC7	
CEC9	CEE3	
CEE5	CEFF	
CF01	CF1B	
CF1D	CF37	
CF39	CF53	
CF55	CF6F	
CF71	CF8B	
CF8D	CFA7	
CFA9	CFC3	
CFC5	CFDF	
CFE1	CFFB	
CFFD	D017	
D019	D033	
D035	D04F	
D051	D06B	
D06D	D087	
D089	D0A3	
D0A5	D0BF	
D0C1	D0DB	
D0DD	D0F7	
D0F9	D113	
D115	D12F	
D131	D14B	
D14D	D167	
D169	D183	
D185	D19F	
D1A1	D1BB	
D1BD	D1D7	
D1D9	D1F3	
D1F5	D20F	
D211	D22B	
D22D	D247	
D249	D263	
D265	D27F	
D281	D29B	
D29D	D2B7	
D2B9	D2D3	
D2D5	D2EF	
D2F1	D30B	
D30D	D327	
D329	D343	
D345	D35F	
D361	D37B	
D37D	D397	
D399	D3B3	
D3B5	D3CF	
D3D1	D3EB	
D3ED	D407	
D409	D423	
D425	D43F	
D441	D45B	
D45D	D477	
D479	D493	
D495	D4AF	
D4B1	D4CB	
D4CD	D4E7	
D4E9	D503	
D505	D51F	
D521	D53B	
D53D	D557	
D559	D573	
D575	D58F	
D591	D5AB	
D5AD	D5C7	
D5C9	D5E3	
D5E5	D5FF	
D601	D61B	
D61D	D637	
D639	D653	
D655	D66F	
D671	D68B	
D68D	D6A7	
D6A9	D6C3	
D6C5	D6DF	
D6E1	D6FB	
D6FD	D717	
D719	D733	
D735	D74F	
D751	D76B	
D76D	D787	
D789	D7A3	
END
}

sub lb_HY {
    return <<'END';
002D		
END
}

sub lb_ID {
    return <<'END';
2E80	2E99	
2E9B	2EF3	
2F00	2FD5	
2FF0	2FFB	
3000		
3003	3004	
3006	3007	
3012	3013	
3020	3029	
3030	303A	
303D	303F	
3042		
3044		
3046		
3048		
304A	3062	
3064	3082	
3084		
3086		
3088	308D	
308F	3094	
309F		
30A2		
30A4		
30A6		
30A8		
30AA	30C2	
30C4	30E2	
30E4		
30E6		
30E8	30ED	
30EF	30F4	
30F7	30FA	
30FF		
3105	312D	
3131	318E	
3190	31B7	
31C0	31E3	
3200	321E	
3220	3243	
3250	32FE	
3300	4DB5	
4E00	9FC3	
A000	A014	
A016	A48C	
A490	A4C6	
F900	FA2D	
FA30	FA6A	
FA70	FAD9	
FE30	FE34	
FE45	FE46	
FE49	FE4F	
FE51		
FE58		
FE5F	FE66	
FE68		
FE6B		
FF02	FF03	
FF06	FF07	
FF0A	FF0B	
FF0D		
FF0F	FF19	
FF1C	FF1E	
FF20	FF3A	
FF3C		
FF3E	FF5A	
FF5C		
FF5E		
FFE2	FFE4	
20000	2A6D6	
2F800	2FA1D	
END
}

sub lb_IN {
    return <<'END';
2024	2026	
FE19		
END
}

sub lb_IS {
    return <<'END';
002C		
002E		
003A	003B	
037E		
0589		
060C	060D	
07F8		
2044		
FE10		
FE13	FE14	
END
}

sub lb_JL {
    return <<'END';
1100	1159	
115F		
END
}

sub lb_JT {
    return <<'END';
11A8	11F9	
END
}

sub lb_JV {
    return <<'END';
1160	11A2	
END
}

sub lb_LF {
    return <<'END';
000A		
END
}

sub lb_NL {
    return <<'END';
0085		
END
}

sub lb_NS {
    return <<'END';
17D6		
203C	203D	
2047	2049	
3005		
301C		
303B	303C	
309B	309E	
30A0		
30FB		
30FD	30FE	
A015		
FE54	FE55	
FF1A	FF1B	
FF65		
FF9E	FF9F	
END
}

sub lb_NSid {
    return <<'END';
3041		
3043		
3045		
3047		
3049		
3063		
3083		
3085		
3087		
308E		
3095	3096	
30A1		
30A3		
30A5		
30A7		
30A9		
30C3		
30E3		
30E5		
30E7		
30EE		
30F5	30F6	
30FC		
31F0	31FF	
FF67	FF70	
END
}

sub lb_NU {
    return <<'END';
0030	0039	
0660	0669	
066B	066C	
06F0	06F9	
07C0	07C9	
0966	096F	
09E6	09EF	
0A66	0A6F	
0AE6	0AEF	
0B66	0B6F	
0BE6	0BEF	
0C66	0C6F	
0CE6	0CEF	
0D66	0D6F	
0E50	0E59	
0ED0	0ED9	
0F20	0F29	
1040	1049	
1090	1099	
17E0	17E9	
1810	1819	
1946	194F	
19D0	19D9	
1B50	1B59	
1BB0	1BB9	
1C40	1C49	
1C50	1C59	
A620	A629	
A8D0	A8D9	
A900	A909	
AA50	AA59	
104A0	104A9	
1D7CE	1D7FF	
END
}

sub lb_OP {
    return <<'END';
0028		
005B		
007B		
00A1		
00BF		
0F3A		
0F3C		
169B		
201A		
201E		
2045		
207D		
208D		
2329		
2768		
276A		
276C		
276E		
2770		
2772		
2774		
27C5		
27E6		
27E8		
27EA		
27EC		
27EE		
2983		
2985		
2987		
2989		
298B		
298D		
298F		
2991		
2993		
2995		
2997		
29D8		
29DA		
29FC		
2E18		
2E22		
2E24		
2E26		
2E28		
3008		
300A		
300C		
300E		
3010		
3014		
3016		
3018		
301A		
301D		
FD3E		
FE17		
FE35		
FE37		
FE39		
FE3B		
FE3D		
FE3F		
FE41		
FE43		
FE47		
FE59		
FE5B		
FE5D		
FF08		
FF3B		
FF5B		
FF5F		
FF62		
END
}

sub lb_PO {
    return <<'END';
0025		
00A2		
00B0		
0609	060B	
066A		
0D79		
2030	2037	
20A7		
2103		
2109		
FDFC		
FE6A		
FF05		
FFE0		
END
}

sub lb_PR {
    return <<'END';
0024		
002B		
005C		
00A3	00A5	
00B1		
09F2	09F3	
0AF1		
0BF9		
0E3F		
17DB		
20A0	20A6	
20A8	20B5	
2116		
2212	2213	
FE69		
FF04		
FFE1		
FFE5	FFE6	
END
}

sub lb_QU {
    return <<'END';
0022		
0027		
00AB		
00BB		
2018	2019	
201B	201D	
201F		
2039	203A	
275B	275E	
2E00	2E0D	
2E1C	2E1D	
2E20	2E21	
END
}

sub lb_SAal {
    return <<'END';
0E01	0E30	
0E32	0E33	
0E40	0E46	
0E81	0E82	
0E84		
0E87	0E88	
0E8A		
0E8D		
0E94	0E97	
0E99	0E9F	
0EA1	0EA3	
0EA5		
0EA7		
0EAA	0EAB	
0EAD	0EB0	
0EB2	0EB3	
0EBD		
0EC0	0EC4	
0EC6		
0EDC	0EDD	
1000	102A	
103F		
1050	1055	
105A	105D	
1061		
1065	1066	
106E	1070	
1075	1081	
108E		
109E	109F	
1780	17B5	
17D7		
17DC		
1950	196D	
1970	1974	
1980	19A9	
19C1	19C7	
19DE	19DF	
END
}

sub lb_SAcm {
    return <<'END';
0E31		
0E34	0E3A	
0E47	0E4E	
0EB1		
0EB4	0EB9	
0EBB	0EBC	
0EC8	0ECD	
102B	103E	
1056	1059	
105E	1060	
1062	1064	
1067	106D	
1071	1074	
1082	108D	
108F		
17B6	17D3	
17DD		
19B0	19C0	
19C8	19C9	
END
}

sub lb_SG {
    return <<'END';
D800	DFFF	
END
}

sub lb_SP {
    return <<'END';
0020		
END
}

sub lb_SY {
    return <<'END';
002F		
END
}

sub lb_WJ {
    return <<'END';
2060		
FEFF		
END
}

sub lb_XX {
    return <<'END';
E000	F8FF	
F0000	FFFFD	
100000	10FFFD	
END
}

sub lb_ZW {
    return <<'END';
200B		
END
}

our $ea_MAP = [
    [0x0000, 0x001F, 'z'],
    [0x0020, 0x007E, 'Na'],
    [0x007F, 0x009F, 'z'],
    [0x00A0, 0x00A0, 'N'],
    [0x00A1, 0x00A1, 'A'],
    [0x00A2, 0x00A3, 'Na'],
    [0x00A4, 0x00A4, 'A'],
    [0x00A5, 0x00A6, 'Na'],
    [0x00A7, 0x00A8, 'A'],
    [0x00A9, 0x00A9, 'N'],
    [0x00AA, 0x00AA, 'A'],
    [0x00AB, 0x00AB, 'N'],
    [0x00AC, 0x00AC, 'Na'],
    [0x00AD, 0x00AD, 'z'],
    [0x00AE, 0x00AE, 'A'],
    [0x00AF, 0x00AF, 'Na'],
    [0x00B0, 0x00B4, 'A'],
    [0x00B5, 0x00B5, 'N'],
    [0x00B6, 0x00BA, 'A'],
    [0x00BB, 0x00BB, 'N'],
    [0x00BC, 0x00BF, 'A'],
    [0x00C0, 0x00C5, 'N'],
    [0x00C6, 0x00C6, 'A'],
    [0x00C7, 0x00CF, 'N'],
    [0x00D0, 0x00D0, 'A'],
    [0x00D1, 0x00D6, 'N'],
    [0x00D7, 0x00D8, 'A'],
    [0x00D9, 0x00DD, 'N'],
    [0x00DE, 0x00E1, 'A'],
    [0x00E2, 0x00E5, 'N'],
    [0x00E6, 0x00E6, 'A'],
    [0x00E7, 0x00E7, 'N'],
    [0x00E8, 0x00EA, 'A'],
    [0x00EB, 0x00EB, 'N'],
    [0x00EC, 0x00ED, 'A'],
    [0x00EE, 0x00EF, 'N'],
    [0x00F0, 0x00F0, 'A'],
    [0x00F1, 0x00F1, 'N'],
    [0x00F2, 0x00F3, 'A'],
    [0x00F4, 0x00F6, 'N'],
    [0x00F7, 0x00FA, 'A'],
    [0x00FB, 0x00FB, 'N'],
    [0x00FC, 0x00FC, 'A'],
    [0x00FD, 0x00FD, 'N'],
    [0x00FE, 0x00FE, 'A'],
    [0x00FF, 0x0100, 'N'],
    [0x0101, 0x0101, 'A'],
    [0x0102, 0x0110, 'N'],
    [0x0111, 0x0111, 'A'],
    [0x0112, 0x0112, 'N'],
    [0x0113, 0x0113, 'A'],
    [0x0114, 0x011A, 'N'],
    [0x011B, 0x011B, 'A'],
    [0x011C, 0x0125, 'N'],
    [0x0126, 0x0127, 'A'],
    [0x0128, 0x012A, 'N'],
    [0x012B, 0x012B, 'A'],
    [0x012C, 0x0130, 'N'],
    [0x0131, 0x0133, 'A'],
    [0x0134, 0x0137, 'N'],
    [0x0138, 0x0138, 'A'],
    [0x0139, 0x013E, 'N'],
    [0x013F, 0x0142, 'A'],
    [0x0143, 0x0143, 'N'],
    [0x0144, 0x0144, 'A'],
    [0x0145, 0x0147, 'N'],
    [0x0148, 0x014B, 'A'],
    [0x014C, 0x014C, 'N'],
    [0x014D, 0x014D, 'A'],
    [0x014E, 0x0151, 'N'],
    [0x0152, 0x0153, 'A'],
    [0x0154, 0x0165, 'N'],
    [0x0166, 0x0167, 'A'],
    [0x0168, 0x016A, 'N'],
    [0x016B, 0x016B, 'A'],
    [0x016C, 0x01CD, 'N'],
    [0x01CE, 0x01CE, 'A'],
    [0x01CF, 0x01CF, 'N'],
    [0x01D0, 0x01D0, 'A'],
    [0x01D1, 0x01D1, 'N'],
    [0x01D2, 0x01D2, 'A'],
    [0x01D3, 0x01D3, 'N'],
    [0x01D4, 0x01D4, 'A'],
    [0x01D5, 0x01D5, 'N'],
    [0x01D6, 0x01D6, 'A'],
    [0x01D7, 0x01D7, 'N'],
    [0x01D8, 0x01D8, 'A'],
    [0x01D9, 0x01D9, 'N'],
    [0x01DA, 0x01DA, 'A'],
    [0x01DB, 0x01DB, 'N'],
    [0x01DC, 0x01DC, 'A'],
    [0x01DD, 0x0250, 'N'],
    [0x0251, 0x0251, 'A'],
    [0x0252, 0x0260, 'N'],
    [0x0261, 0x0261, 'A'],
    [0x0262, 0x02C3, 'N'],
    [0x02C4, 0x02C4, 'A'],
    [0x02C5, 0x02C6, 'N'],
    [0x02C7, 0x02C7, 'A'],
    [0x02C8, 0x02C8, 'N'],
    [0x02C9, 0x02CB, 'A'],
    [0x02CC, 0x02CC, 'N'],
    [0x02CD, 0x02CD, 'A'],
    [0x02CE, 0x02CF, 'N'],
    [0x02D0, 0x02D0, 'A'],
    [0x02D1, 0x02D7, 'N'],
    [0x02D8, 0x02DB, 'A'],
    [0x02DC, 0x02DC, 'N'],
    [0x02DD, 0x02DD, 'A'],
    [0x02DE, 0x02DE, 'N'],
    [0x02DF, 0x02DF, 'A'],
    [0x02E0, 0x02FF, 'N'],
    [0x0300, 0x036F, 'z'],
    [0x0370, 0x0377, 'N'],
    [0x037A, 0x037E, 'N'],
    [0x0384, 0x038A, 'N'],
    [0x038C, 0x038C, 'N'],
    [0x038E, 0x0390, 'N'],
    [0x0391, 0x03A1, 'A'],
    [0x03A3, 0x03A9, 'A'],
    [0x03AA, 0x03B0, 'N'],
    [0x03B1, 0x03C1, 'A'],
    [0x03C2, 0x03C2, 'N'],
    [0x03C3, 0x03C9, 'A'],
    [0x03CA, 0x0400, 'N'],
    [0x0401, 0x0401, 'A'],
    [0x0402, 0x040F, 'N'],
    [0x0410, 0x044F, 'A'],
    [0x0450, 0x0450, 'N'],
    [0x0451, 0x0451, 'A'],
    [0x0452, 0x0482, 'N'],
    [0x0483, 0x0489, 'z'],
    [0x048A, 0x0523, 'N'],
    [0x0531, 0x0556, 'N'],
    [0x0559, 0x055F, 'N'],
    [0x0561, 0x0587, 'N'],
    [0x0589, 0x058A, 'N'],
    [0x0591, 0x05BD, 'z'],
    [0x05BE, 0x05BE, 'N'],
    [0x05BF, 0x05BF, 'z'],
    [0x05C0, 0x05C0, 'N'],
    [0x05C1, 0x05C2, 'z'],
    [0x05C3, 0x05C3, 'N'],
    [0x05C4, 0x05C5, 'z'],
    [0x05C6, 0x05C6, 'N'],
    [0x05C7, 0x05C7, 'z'],
    [0x05D0, 0x05EA, 'N'],
    [0x05F0, 0x05F4, 'N'],
    [0x0600, 0x0603, 'z'],
    [0x0606, 0x060F, 'N'],
    [0x0610, 0x061A, 'z'],
    [0x061B, 0x061B, 'N'],
    [0x061E, 0x061F, 'N'],
    [0x0621, 0x064A, 'N'],
    [0x064B, 0x065E, 'z'],
    [0x0660, 0x066F, 'N'],
    [0x0670, 0x0670, 'z'],
    [0x0671, 0x06D5, 'N'],
    [0x06D6, 0x06E4, 'z'],
    [0x06E5, 0x06E6, 'N'],
    [0x06E7, 0x06E8, 'z'],
    [0x06E9, 0x06E9, 'N'],
    [0x06EA, 0x06ED, 'z'],
    [0x06EE, 0x070D, 'N'],
    [0x070F, 0x070F, 'z'],
    [0x0710, 0x0710, 'N'],
    [0x0711, 0x0711, 'z'],
    [0x0712, 0x072F, 'N'],
    [0x0730, 0x074A, 'z'],
    [0x074D, 0x07A5, 'N'],
    [0x07A6, 0x07B0, 'z'],
    [0x07B1, 0x07B1, 'N'],
    [0x07C0, 0x07EA, 'N'],
    [0x07EB, 0x07F3, 'z'],
    [0x07F4, 0x07FA, 'N'],
    [0x0901, 0x0903, 'z'],
    [0x0904, 0x0939, 'N'],
    [0x093C, 0x093C, 'z'],
    [0x093D, 0x093D, 'N'],
    [0x093E, 0x094D, 'z'],
    [0x0950, 0x0950, 'N'],
    [0x0951, 0x0954, 'z'],
    [0x0958, 0x0961, 'N'],
    [0x0962, 0x0963, 'z'],
    [0x0964, 0x0972, 'N'],
    [0x097B, 0x097F, 'N'],
    [0x0981, 0x0983, 'z'],
    [0x0985, 0x098C, 'N'],
    [0x098F, 0x0990, 'N'],
    [0x0993, 0x09A8, 'N'],
    [0x09AA, 0x09B0, 'N'],
    [0x09B2, 0x09B2, 'N'],
    [0x09B6, 0x09B9, 'N'],
    [0x09BC, 0x09BC, 'z'],
    [0x09BD, 0x09BD, 'N'],
    [0x09BE, 0x09C4, 'z'],
    [0x09C7, 0x09C8, 'z'],
    [0x09CB, 0x09CD, 'z'],
    [0x09CE, 0x09CE, 'N'],
    [0x09D7, 0x09D7, 'z'],
    [0x09DC, 0x09DD, 'N'],
    [0x09DF, 0x09E1, 'N'],
    [0x09E2, 0x09E3, 'z'],
    [0x09E6, 0x09FA, 'N'],
    [0x0A01, 0x0A03, 'z'],
    [0x0A05, 0x0A0A, 'N'],
    [0x0A0F, 0x0A10, 'N'],
    [0x0A13, 0x0A28, 'N'],
    [0x0A2A, 0x0A30, 'N'],
    [0x0A32, 0x0A33, 'N'],
    [0x0A35, 0x0A36, 'N'],
    [0x0A38, 0x0A39, 'N'],
    [0x0A3C, 0x0A3C, 'z'],
    [0x0A3E, 0x0A42, 'z'],
    [0x0A47, 0x0A48, 'z'],
    [0x0A4B, 0x0A4D, 'z'],
    [0x0A51, 0x0A51, 'z'],
    [0x0A59, 0x0A5C, 'N'],
    [0x0A5E, 0x0A5E, 'N'],
    [0x0A66, 0x0A6F, 'N'],
    [0x0A70, 0x0A71, 'z'],
    [0x0A72, 0x0A74, 'N'],
    [0x0A75, 0x0A75, 'z'],
    [0x0A81, 0x0A83, 'z'],
    [0x0A85, 0x0A8D, 'N'],
    [0x0A8F, 0x0A91, 'N'],
    [0x0A93, 0x0AA8, 'N'],
    [0x0AAA, 0x0AB0, 'N'],
    [0x0AB2, 0x0AB3, 'N'],
    [0x0AB5, 0x0AB9, 'N'],
    [0x0ABC, 0x0ABC, 'z'],
    [0x0ABD, 0x0ABD, 'N'],
    [0x0ABE, 0x0AC5, 'z'],
    [0x0AC7, 0x0AC9, 'z'],
    [0x0ACB, 0x0ACD, 'z'],
    [0x0AD0, 0x0AD0, 'N'],
    [0x0AE0, 0x0AE1, 'N'],
    [0x0AE2, 0x0AE3, 'z'],
    [0x0AE6, 0x0AEF, 'N'],
    [0x0AF1, 0x0AF1, 'N'],
    [0x0B01, 0x0B03, 'z'],
    [0x0B05, 0x0B0C, 'N'],
    [0x0B0F, 0x0B10, 'N'],
    [0x0B13, 0x0B28, 'N'],
    [0x0B2A, 0x0B30, 'N'],
    [0x0B32, 0x0B33, 'N'],
    [0x0B35, 0x0B39, 'N'],
    [0x0B3C, 0x0B3C, 'z'],
    [0x0B3D, 0x0B3D, 'N'],
    [0x0B3E, 0x0B44, 'z'],
    [0x0B47, 0x0B48, 'z'],
    [0x0B4B, 0x0B4D, 'z'],
    [0x0B56, 0x0B57, 'z'],
    [0x0B5C, 0x0B5D, 'N'],
    [0x0B5F, 0x0B61, 'N'],
    [0x0B62, 0x0B63, 'z'],
    [0x0B66, 0x0B71, 'N'],
    [0x0B82, 0x0B82, 'z'],
    [0x0B83, 0x0B83, 'N'],
    [0x0B85, 0x0B8A, 'N'],
    [0x0B8E, 0x0B90, 'N'],
    [0x0B92, 0x0B95, 'N'],
    [0x0B99, 0x0B9A, 'N'],
    [0x0B9C, 0x0B9C, 'N'],
    [0x0B9E, 0x0B9F, 'N'],
    [0x0BA3, 0x0BA4, 'N'],
    [0x0BA8, 0x0BAA, 'N'],
    [0x0BAE, 0x0BB9, 'N'],
    [0x0BBE, 0x0BC2, 'z'],
    [0x0BC6, 0x0BC8, 'z'],
    [0x0BCA, 0x0BCD, 'z'],
    [0x0BD0, 0x0BD0, 'N'],
    [0x0BD7, 0x0BD7, 'z'],
    [0x0BE6, 0x0BFA, 'N'],
    [0x0C01, 0x0C03, 'z'],
    [0x0C05, 0x0C0C, 'N'],
    [0x0C0E, 0x0C10, 'N'],
    [0x0C12, 0x0C28, 'N'],
    [0x0C2A, 0x0C33, 'N'],
    [0x0C35, 0x0C39, 'N'],
    [0x0C3D, 0x0C3D, 'N'],
    [0x0C3E, 0x0C44, 'z'],
    [0x0C46, 0x0C48, 'z'],
    [0x0C4A, 0x0C4D, 'z'],
    [0x0C55, 0x0C56, 'z'],
    [0x0C58, 0x0C59, 'N'],
    [0x0C60, 0x0C61, 'N'],
    [0x0C62, 0x0C63, 'z'],
    [0x0C66, 0x0C6F, 'N'],
    [0x0C78, 0x0C7F, 'N'],
    [0x0C82, 0x0C83, 'z'],
    [0x0C85, 0x0C8C, 'N'],
    [0x0C8E, 0x0C90, 'N'],
    [0x0C92, 0x0CA8, 'N'],
    [0x0CAA, 0x0CB3, 'N'],
    [0x0CB5, 0x0CB9, 'N'],
    [0x0CBC, 0x0CBC, 'z'],
    [0x0CBD, 0x0CBD, 'N'],
    [0x0CBE, 0x0CC4, 'z'],
    [0x0CC6, 0x0CC8, 'z'],
    [0x0CCA, 0x0CCD, 'z'],
    [0x0CD5, 0x0CD6, 'z'],
    [0x0CDE, 0x0CDE, 'N'],
    [0x0CE0, 0x0CE1, 'N'],
    [0x0CE2, 0x0CE3, 'z'],
    [0x0CE6, 0x0CEF, 'N'],
    [0x0CF1, 0x0CF2, 'N'],
    [0x0D02, 0x0D03, 'z'],
    [0x0D05, 0x0D0C, 'N'],
    [0x0D0E, 0x0D10, 'N'],
    [0x0D12, 0x0D28, 'N'],
    [0x0D2A, 0x0D39, 'N'],
    [0x0D3D, 0x0D3D, 'N'],
    [0x0D3E, 0x0D44, 'z'],
    [0x0D46, 0x0D48, 'z'],
    [0x0D4A, 0x0D4D, 'z'],
    [0x0D57, 0x0D57, 'z'],
    [0x0D60, 0x0D61, 'N'],
    [0x0D62, 0x0D63, 'z'],
    [0x0D66, 0x0D75, 'N'],
    [0x0D79, 0x0D7F, 'N'],
    [0x0D82, 0x0D83, 'z'],
    [0x0D85, 0x0D96, 'N'],
    [0x0D9A, 0x0DB1, 'N'],
    [0x0DB3, 0x0DBB, 'N'],
    [0x0DBD, 0x0DBD, 'N'],
    [0x0DC0, 0x0DC6, 'N'],
    [0x0DCA, 0x0DCA, 'z'],
    [0x0DCF, 0x0DD4, 'z'],
    [0x0DD6, 0x0DD6, 'z'],
    [0x0DD8, 0x0DDF, 'z'],
    [0x0DF2, 0x0DF3, 'z'],
    [0x0DF4, 0x0DF4, 'N'],
    [0x0E01, 0x0E30, 'N'],
    [0x0E31, 0x0E31, 'z'],
    [0x0E32, 0x0E33, 'N'],
    [0x0E34, 0x0E3A, 'z'],
    [0x0E3F, 0x0E46, 'N'],
    [0x0E47, 0x0E4E, 'z'],
    [0x0E4F, 0x0E5B, 'N'],
    [0x0E81, 0x0E82, 'N'],
    [0x0E84, 0x0E84, 'N'],
    [0x0E87, 0x0E88, 'N'],
    [0x0E8A, 0x0E8A, 'N'],
    [0x0E8D, 0x0E8D, 'N'],
    [0x0E94, 0x0E97, 'N'],
    [0x0E99, 0x0E9F, 'N'],
    [0x0EA1, 0x0EA3, 'N'],
    [0x0EA5, 0x0EA5, 'N'],
    [0x0EA7, 0x0EA7, 'N'],
    [0x0EAA, 0x0EAB, 'N'],
    [0x0EAD, 0x0EB0, 'N'],
    [0x0EB1, 0x0EB1, 'z'],
    [0x0EB2, 0x0EB3, 'N'],
    [0x0EB4, 0x0EB9, 'z'],
    [0x0EBB, 0x0EBC, 'z'],
    [0x0EBD, 0x0EBD, 'N'],
    [0x0EC0, 0x0EC4, 'N'],
    [0x0EC6, 0x0EC6, 'N'],
    [0x0EC8, 0x0ECD, 'z'],
    [0x0ED0, 0x0ED9, 'N'],
    [0x0EDC, 0x0EDD, 'N'],
    [0x0F00, 0x0F17, 'N'],
    [0x0F18, 0x0F19, 'z'],
    [0x0F1A, 0x0F34, 'N'],
    [0x0F35, 0x0F35, 'z'],
    [0x0F36, 0x0F36, 'N'],
    [0x0F37, 0x0F37, 'z'],
    [0x0F38, 0x0F38, 'N'],
    [0x0F39, 0x0F39, 'z'],
    [0x0F3A, 0x0F3D, 'N'],
    [0x0F3E, 0x0F3F, 'z'],
    [0x0F40, 0x0F47, 'N'],
    [0x0F49, 0x0F6C, 'N'],
    [0x0F71, 0x0F84, 'z'],
    [0x0F85, 0x0F85, 'N'],
    [0x0F86, 0x0F87, 'z'],
    [0x0F88, 0x0F8B, 'N'],
    [0x0F90, 0x0F97, 'z'],
    [0x0F99, 0x0FBC, 'z'],
    [0x0FBE, 0x0FC5, 'N'],
    [0x0FC6, 0x0FC6, 'z'],
    [0x0FC7, 0x0FCC, 'N'],
    [0x0FCE, 0x0FD4, 'N'],
    [0x1000, 0x102A, 'N'],
    [0x102B, 0x103E, 'z'],
    [0x103F, 0x1055, 'N'],
    [0x1056, 0x1059, 'z'],
    [0x105A, 0x105D, 'N'],
    [0x105E, 0x1060, 'z'],
    [0x1061, 0x1061, 'N'],
    [0x1062, 0x1064, 'z'],
    [0x1065, 0x1066, 'N'],
    [0x1067, 0x106D, 'z'],
    [0x106E, 0x1070, 'N'],
    [0x1071, 0x1074, 'z'],
    [0x1075, 0x1081, 'N'],
    [0x1082, 0x108D, 'z'],
    [0x108E, 0x108E, 'N'],
    [0x108F, 0x108F, 'z'],
    [0x1090, 0x1099, 'N'],
    [0x109E, 0x10C5, 'N'],
    [0x10D0, 0x10FC, 'N'],
    [0x1100, 0x1159, 'W'],
    [0x115F, 0x115F, 'W'],
    [0x1160, 0x11A2, 'N'],
    [0x11A8, 0x11F9, 'N'],
    [0x1200, 0x1248, 'N'],
    [0x124A, 0x124D, 'N'],
    [0x1250, 0x1256, 'N'],
    [0x1258, 0x1258, 'N'],
    [0x125A, 0x125D, 'N'],
    [0x1260, 0x1288, 'N'],
    [0x128A, 0x128D, 'N'],
    [0x1290, 0x12B0, 'N'],
    [0x12B2, 0x12B5, 'N'],
    [0x12B8, 0x12BE, 'N'],
    [0x12C0, 0x12C0, 'N'],
    [0x12C2, 0x12C5, 'N'],
    [0x12C8, 0x12D6, 'N'],
    [0x12D8, 0x1310, 'N'],
    [0x1312, 0x1315, 'N'],
    [0x1318, 0x135A, 'N'],
    [0x135F, 0x135F, 'z'],
    [0x1360, 0x137C, 'N'],
    [0x1380, 0x1399, 'N'],
    [0x13A0, 0x13F4, 'N'],
    [0x1401, 0x1676, 'N'],
    [0x1680, 0x169C, 'N'],
    [0x16A0, 0x16F0, 'N'],
    [0x1700, 0x170C, 'N'],
    [0x170E, 0x1711, 'N'],
    [0x1712, 0x1714, 'z'],
    [0x1720, 0x1731, 'N'],
    [0x1732, 0x1734, 'z'],
    [0x1735, 0x1736, 'N'],
    [0x1740, 0x1751, 'N'],
    [0x1752, 0x1753, 'z'],
    [0x1760, 0x176C, 'N'],
    [0x176E, 0x1770, 'N'],
    [0x1772, 0x1773, 'z'],
    [0x1780, 0x17B3, 'N'],
    [0x17B4, 0x17D3, 'z'],
    [0x17D4, 0x17DC, 'N'],
    [0x17DD, 0x17DD, 'z'],
    [0x17E0, 0x17E9, 'N'],
    [0x17F0, 0x17F9, 'N'],
    [0x1800, 0x180A, 'N'],
    [0x180B, 0x180D, 'z'],
    [0x180E, 0x180E, 'N'],
    [0x1810, 0x1819, 'N'],
    [0x1820, 0x1877, 'N'],
    [0x1880, 0x18A8, 'N'],
    [0x18A9, 0x18A9, 'z'],
    [0x18AA, 0x18AA, 'N'],
    [0x1900, 0x191C, 'N'],
    [0x1920, 0x192B, 'z'],
    [0x1930, 0x193B, 'z'],
    [0x1940, 0x1940, 'N'],
    [0x1944, 0x196D, 'N'],
    [0x1970, 0x1974, 'N'],
    [0x1980, 0x19A9, 'N'],
    [0x19B0, 0x19C0, 'z'],
    [0x19C1, 0x19C7, 'N'],
    [0x19C8, 0x19C9, 'z'],
    [0x19D0, 0x19D9, 'N'],
    [0x19DE, 0x1A16, 'N'],
    [0x1A17, 0x1A1B, 'z'],
    [0x1A1E, 0x1A1F, 'N'],
    [0x1B00, 0x1B04, 'z'],
    [0x1B05, 0x1B33, 'N'],
    [0x1B34, 0x1B44, 'z'],
    [0x1B45, 0x1B4B, 'N'],
    [0x1B50, 0x1B6A, 'N'],
    [0x1B6B, 0x1B73, 'z'],
    [0x1B74, 0x1B7C, 'N'],
    [0x1B80, 0x1B82, 'z'],
    [0x1B83, 0x1BA0, 'N'],
    [0x1BA1, 0x1BAA, 'z'],
    [0x1BAE, 0x1BB9, 'N'],
    [0x1C00, 0x1C23, 'N'],
    [0x1C24, 0x1C37, 'z'],
    [0x1C3B, 0x1C49, 'N'],
    [0x1C4D, 0x1C7F, 'N'],
    [0x1D00, 0x1DBF, 'N'],
    [0x1DC0, 0x1DE6, 'z'],
    [0x1DFE, 0x1DFF, 'z'],
    [0x1E00, 0x1F15, 'N'],
    [0x1F18, 0x1F1D, 'N'],
    [0x1F20, 0x1F45, 'N'],
    [0x1F48, 0x1F4D, 'N'],
    [0x1F50, 0x1F57, 'N'],
    [0x1F59, 0x1F59, 'N'],
    [0x1F5B, 0x1F5B, 'N'],
    [0x1F5D, 0x1F5D, 'N'],
    [0x1F5F, 0x1F7D, 'N'],
    [0x1F80, 0x1FB4, 'N'],
    [0x1FB6, 0x1FC4, 'N'],
    [0x1FC6, 0x1FD3, 'N'],
    [0x1FD6, 0x1FDB, 'N'],
    [0x1FDD, 0x1FEF, 'N'],
    [0x1FF2, 0x1FF4, 'N'],
    [0x1FF6, 0x1FFE, 'N'],
    [0x2000, 0x200A, 'N'],
    [0x200B, 0x200F, 'z'],
    [0x2010, 0x2010, 'A'],
    [0x2011, 0x2012, 'N'],
    [0x2013, 0x2016, 'A'],
    [0x2017, 0x2017, 'N'],
    [0x2018, 0x2019, 'A'],
    [0x201A, 0x201B, 'N'],
    [0x201C, 0x201D, 'A'],
    [0x201E, 0x201F, 'N'],
    [0x2020, 0x2022, 'A'],
    [0x2023, 0x2023, 'N'],
    [0x2024, 0x2027, 'A'],
    [0x2028, 0x202E, 'z'],
    [0x202F, 0x202F, 'N'],
    [0x2030, 0x2030, 'A'],
    [0x2031, 0x2031, 'N'],
    [0x2032, 0x2033, 'A'],
    [0x2034, 0x2034, 'N'],
    [0x2035, 0x2035, 'A'],
    [0x2036, 0x203A, 'N'],
    [0x203B, 0x203B, 'A'],
    [0x203C, 0x203D, 'N'],
    [0x203E, 0x203E, 'A'],
    [0x203F, 0x205F, 'N'],
    [0x2060, 0x2064, 'z'],
    [0x206A, 0x206F, 'z'],
    [0x2070, 0x2071, 'N'],
    [0x2074, 0x2074, 'A'],
    [0x2075, 0x207E, 'N'],
    [0x207F, 0x207F, 'A'],
    [0x2080, 0x2080, 'N'],
    [0x2081, 0x2084, 'A'],
    [0x2085, 0x208E, 'N'],
    [0x2090, 0x2094, 'N'],
    [0x20A0, 0x20A8, 'N'],
    [0x20A9, 0x20A9, 'H'],
    [0x20AA, 0x20AB, 'N'],
    [0x20AC, 0x20AC, 'A'],
    [0x20AD, 0x20B5, 'N'],
    [0x20D0, 0x20F0, 'z'],
    [0x2100, 0x2102, 'N'],
    [0x2103, 0x2103, 'A'],
    [0x2104, 0x2104, 'N'],
    [0x2105, 0x2105, 'A'],
    [0x2106, 0x2108, 'N'],
    [0x2109, 0x2109, 'A'],
    [0x210A, 0x2112, 'N'],
    [0x2113, 0x2113, 'A'],
    [0x2114, 0x2115, 'N'],
    [0x2116, 0x2116, 'A'],
    [0x2117, 0x2120, 'N'],
    [0x2121, 0x2122, 'A'],
    [0x2123, 0x2125, 'N'],
    [0x2126, 0x2126, 'A'],
    [0x2127, 0x212A, 'N'],
    [0x212B, 0x212B, 'A'],
    [0x212C, 0x214F, 'N'],
    [0x2153, 0x2154, 'A'],
    [0x2155, 0x215A, 'N'],
    [0x215B, 0x215E, 'A'],
    [0x215F, 0x215F, 'N'],
    [0x2160, 0x216B, 'A'],
    [0x216C, 0x216F, 'N'],
    [0x2170, 0x2179, 'A'],
    [0x217A, 0x2188, 'N'],
    [0x2190, 0x2199, 'A'],
    [0x219A, 0x21B7, 'N'],
    [0x21B8, 0x21B9, 'A'],
    [0x21BA, 0x21D1, 'N'],
    [0x21D2, 0x21D2, 'A'],
    [0x21D3, 0x21D3, 'N'],
    [0x21D4, 0x21D4, 'A'],
    [0x21D5, 0x21E6, 'N'],
    [0x21E7, 0x21E7, 'A'],
    [0x21E8, 0x21FF, 'N'],
    [0x2200, 0x2200, 'A'],
    [0x2201, 0x2201, 'N'],
    [0x2202, 0x2203, 'A'],
    [0x2204, 0x2206, 'N'],
    [0x2207, 0x2208, 'A'],
    [0x2209, 0x220A, 'N'],
    [0x220B, 0x220B, 'A'],
    [0x220C, 0x220E, 'N'],
    [0x220F, 0x220F, 'A'],
    [0x2210, 0x2210, 'N'],
    [0x2211, 0x2211, 'A'],
    [0x2212, 0x2214, 'N'],
    [0x2215, 0x2215, 'A'],
    [0x2216, 0x2219, 'N'],
    [0x221A, 0x221A, 'A'],
    [0x221B, 0x221C, 'N'],
    [0x221D, 0x2220, 'A'],
    [0x2221, 0x2222, 'N'],
    [0x2223, 0x2223, 'A'],
    [0x2224, 0x2224, 'N'],
    [0x2225, 0x2225, 'A'],
    [0x2226, 0x2226, 'N'],
    [0x2227, 0x222C, 'A'],
    [0x222D, 0x222D, 'N'],
    [0x222E, 0x222E, 'A'],
    [0x222F, 0x2233, 'N'],
    [0x2234, 0x2237, 'A'],
    [0x2238, 0x223B, 'N'],
    [0x223C, 0x223D, 'A'],
    [0x223E, 0x2247, 'N'],
    [0x2248, 0x2248, 'A'],
    [0x2249, 0x224B, 'N'],
    [0x224C, 0x224C, 'A'],
    [0x224D, 0x2251, 'N'],
    [0x2252, 0x2252, 'A'],
    [0x2253, 0x225F, 'N'],
    [0x2260, 0x2261, 'A'],
    [0x2262, 0x2263, 'N'],
    [0x2264, 0x2267, 'A'],
    [0x2268, 0x2269, 'N'],
    [0x226A, 0x226B, 'A'],
    [0x226C, 0x226D, 'N'],
    [0x226E, 0x226F, 'A'],
    [0x2270, 0x2281, 'N'],
    [0x2282, 0x2283, 'A'],
    [0x2284, 0x2285, 'N'],
    [0x2286, 0x2287, 'A'],
    [0x2288, 0x2294, 'N'],
    [0x2295, 0x2295, 'A'],
    [0x2296, 0x2298, 'N'],
    [0x2299, 0x2299, 'A'],
    [0x229A, 0x22A4, 'N'],
    [0x22A5, 0x22A5, 'A'],
    [0x22A6, 0x22BE, 'N'],
    [0x22BF, 0x22BF, 'A'],
    [0x22C0, 0x2311, 'N'],
    [0x2312, 0x2312, 'A'],
    [0x2313, 0x2328, 'N'],
    [0x2329, 0x232A, 'W'],
    [0x232B, 0x23E7, 'N'],
    [0x2400, 0x2426, 'N'],
    [0x2440, 0x244A, 'N'],
    [0x2460, 0x24E9, 'A'],
    [0x24EA, 0x24EA, 'N'],
    [0x24EB, 0x254B, 'A'],
    [0x254C, 0x254F, 'N'],
    [0x2550, 0x2573, 'A'],
    [0x2574, 0x257F, 'N'],
    [0x2580, 0x258F, 'A'],
    [0x2590, 0x2591, 'N'],
    [0x2592, 0x2595, 'A'],
    [0x2596, 0x259F, 'N'],
    [0x25A0, 0x25A1, 'A'],
    [0x25A2, 0x25A2, 'N'],
    [0x25A3, 0x25A9, 'A'],
    [0x25AA, 0x25B1, 'N'],
    [0x25B2, 0x25B3, 'A'],
    [0x25B4, 0x25B5, 'N'],
    [0x25B6, 0x25B7, 'A'],
    [0x25B8, 0x25BB, 'N'],
    [0x25BC, 0x25BD, 'A'],
    [0x25BE, 0x25BF, 'N'],
    [0x25C0, 0x25C1, 'A'],
    [0x25C2, 0x25C5, 'N'],
    [0x25C6, 0x25C8, 'A'],
    [0x25C9, 0x25CA, 'N'],
    [0x25CB, 0x25CB, 'A'],
    [0x25CC, 0x25CD, 'N'],
    [0x25CE, 0x25D1, 'A'],
    [0x25D2, 0x25E1, 'N'],
    [0x25E2, 0x25E5, 'A'],
    [0x25E6, 0x25EE, 'N'],
    [0x25EF, 0x25EF, 'A'],
    [0x25F0, 0x2604, 'N'],
    [0x2605, 0x2606, 'A'],
    [0x2607, 0x2608, 'N'],
    [0x2609, 0x2609, 'A'],
    [0x260A, 0x260D, 'N'],
    [0x260E, 0x260F, 'A'],
    [0x2610, 0x2613, 'N'],
    [0x2614, 0x2615, 'A'],
    [0x2616, 0x261B, 'N'],
    [0x261C, 0x261C, 'A'],
    [0x261D, 0x261D, 'N'],
    [0x261E, 0x261E, 'A'],
    [0x261F, 0x263F, 'N'],
    [0x2640, 0x2640, 'A'],
    [0x2641, 0x2641, 'N'],
    [0x2642, 0x2642, 'A'],
    [0x2643, 0x265F, 'N'],
    [0x2660, 0x2661, 'A'],
    [0x2662, 0x2662, 'N'],
    [0x2663, 0x2665, 'A'],
    [0x2666, 0x2666, 'N'],
    [0x2667, 0x266A, 'A'],
    [0x266B, 0x266B, 'N'],
    [0x266C, 0x266D, 'A'],
    [0x266E, 0x266E, 'N'],
    [0x266F, 0x266F, 'A'],
    [0x2670, 0x269D, 'N'],
    [0x26A0, 0x26BC, 'N'],
    [0x26C0, 0x26C3, 'N'],
    [0x2701, 0x2704, 'N'],
    [0x2706, 0x2709, 'N'],
    [0x270C, 0x2727, 'N'],
    [0x2729, 0x273C, 'N'],
    [0x273D, 0x273D, 'A'],
    [0x273E, 0x274B, 'N'],
    [0x274D, 0x274D, 'N'],
    [0x274F, 0x2752, 'N'],
    [0x2756, 0x2756, 'N'],
    [0x2758, 0x275E, 'N'],
    [0x2761, 0x2775, 'N'],
    [0x2776, 0x277F, 'A'],
    [0x2780, 0x2794, 'N'],
    [0x2798, 0x27AF, 'N'],
    [0x27B1, 0x27BE, 'N'],
    [0x27C0, 0x27CA, 'N'],
    [0x27CC, 0x27CC, 'N'],
    [0x27D0, 0x27E5, 'N'],
    [0x27E6, 0x27ED, 'Na'],
    [0x27EE, 0x2984, 'N'],
    [0x2985, 0x2986, 'Na'],
    [0x2987, 0x2B4C, 'N'],
    [0x2B50, 0x2B54, 'N'],
    [0x2C00, 0x2C2E, 'N'],
    [0x2C30, 0x2C5E, 'N'],
    [0x2C60, 0x2C6F, 'N'],
    [0x2C71, 0x2C7D, 'N'],
    [0x2C80, 0x2CEA, 'N'],
    [0x2CF9, 0x2D25, 'N'],
    [0x2D30, 0x2D65, 'N'],
    [0x2D6F, 0x2D6F, 'N'],
    [0x2D80, 0x2D96, 'N'],
    [0x2DA0, 0x2DA6, 'N'],
    [0x2DA8, 0x2DAE, 'N'],
    [0x2DB0, 0x2DB6, 'N'],
    [0x2DB8, 0x2DBE, 'N'],
    [0x2DC0, 0x2DC6, 'N'],
    [0x2DC8, 0x2DCE, 'N'],
    [0x2DD0, 0x2DD6, 'N'],
    [0x2DD8, 0x2DDE, 'N'],
    [0x2DE0, 0x2DFF, 'z'],
    [0x2E00, 0x2E30, 'N'],
    [0x2E80, 0x2E99, 'W'],
    [0x2E9B, 0x2EF3, 'W'],
    [0x2F00, 0x2FD5, 'W'],
    [0x2FF0, 0x2FFB, 'W'],
    [0x3000, 0x3000, 'F'],
    [0x3001, 0x3029, 'W'],
    [0x302A, 0x302F, 'z'],
    [0x3030, 0x303E, 'W'],
    [0x303F, 0x303F, 'N'],
    [0x3041, 0x3096, 'W'],
    [0x3099, 0x309A, 'z'],
    [0x309B, 0x30FF, 'W'],
    [0x3105, 0x312D, 'W'],
    [0x3131, 0x318E, 'W'],
    [0x3190, 0x31B7, 'W'],
    [0x31C0, 0x31E3, 'W'],
    [0x31F0, 0x321E, 'W'],
    [0x3220, 0x3243, 'W'],
    [0x3250, 0x32FE, 'W'],
    [0x3300, 0x4DB5, 'W'],
    [0x4DC0, 0x4DFF, 'N'],
    [0x4E00, 0x9FC3, 'W'],
    [0xA000, 0xA48C, 'W'],
    [0xA490, 0xA4C6, 'W'],
    [0xA500, 0xA62B, 'N'],
    [0xA640, 0xA65F, 'N'],
    [0xA662, 0xA66E, 'N'],
    [0xA66F, 0xA672, 'z'],
    [0xA673, 0xA673, 'N'],
    [0xA67C, 0xA67D, 'z'],
    [0xA67E, 0xA697, 'N'],
    [0xA700, 0xA78C, 'N'],
    [0xA7FB, 0xA801, 'N'],
    [0xA802, 0xA802, 'z'],
    [0xA803, 0xA805, 'N'],
    [0xA806, 0xA806, 'z'],
    [0xA807, 0xA80A, 'N'],
    [0xA80B, 0xA80B, 'z'],
    [0xA80C, 0xA822, 'N'],
    [0xA823, 0xA827, 'z'],
    [0xA828, 0xA82B, 'N'],
    [0xA840, 0xA877, 'N'],
    [0xA880, 0xA881, 'z'],
    [0xA882, 0xA8B3, 'N'],
    [0xA8B4, 0xA8C4, 'z'],
    [0xA8CE, 0xA8D9, 'N'],
    [0xA900, 0xA925, 'N'],
    [0xA926, 0xA92D, 'z'],
    [0xA92E, 0xA946, 'N'],
    [0xA947, 0xA953, 'z'],
    [0xA95F, 0xA95F, 'N'],
    [0xAA00, 0xAA28, 'N'],
    [0xAA29, 0xAA36, 'z'],
    [0xAA40, 0xAA42, 'N'],
    [0xAA43, 0xAA43, 'z'],
    [0xAA44, 0xAA4B, 'N'],
    [0xAA4C, 0xAA4D, 'z'],
    [0xAA50, 0xAA59, 'N'],
    [0xAA5C, 0xAA5F, 'N'],
    [0xAC00, 0xD7A3, 'W'],
    [0xD800, 0xDFFF, 'N'],
    [0xE000, 0xF8FF, 'A'],
    [0xF900, 0xFA2D, 'W'],
    [0xFA30, 0xFA6A, 'W'],
    [0xFA70, 0xFAD9, 'W'],
    [0xFB00, 0xFB06, 'N'],
    [0xFB13, 0xFB17, 'N'],
    [0xFB1D, 0xFB1D, 'N'],
    [0xFB1E, 0xFB1E, 'z'],
    [0xFB1F, 0xFB36, 'N'],
    [0xFB38, 0xFB3C, 'N'],
    [0xFB3E, 0xFB3E, 'N'],
    [0xFB40, 0xFB41, 'N'],
    [0xFB43, 0xFB44, 'N'],
    [0xFB46, 0xFBB1, 'N'],
    [0xFBD3, 0xFD3F, 'N'],
    [0xFD50, 0xFD8F, 'N'],
    [0xFD92, 0xFDC7, 'N'],
    [0xFDF0, 0xFDFD, 'N'],
    [0xFE00, 0xFE0F, 'z'],
    [0xFE10, 0xFE19, 'W'],
    [0xFE20, 0xFE26, 'z'],
    [0xFE30, 0xFE52, 'W'],
    [0xFE54, 0xFE66, 'W'],
    [0xFE68, 0xFE6B, 'W'],
    [0xFE70, 0xFE74, 'N'],
    [0xFE76, 0xFEFC, 'N'],
    [0xFEFF, 0xFEFF, 'z'],
    [0xFF01, 0xFF60, 'F'],
    [0xFF61, 0xFFBE, 'H'],
    [0xFFC2, 0xFFC7, 'H'],
    [0xFFCA, 0xFFCF, 'H'],
    [0xFFD2, 0xFFD7, 'H'],
    [0xFFDA, 0xFFDC, 'H'],
    [0xFFE0, 0xFFE6, 'F'],
    [0xFFE8, 0xFFEE, 'H'],
    [0xFFF9, 0xFFFB, 'z'],
    [0xFFFC, 0xFFFC, 'N'],
    [0xFFFD, 0xFFFD, 'A'],
    [0x10000, 0x1000B, 'N'],
    [0x1000D, 0x10026, 'N'],
    [0x10028, 0x1003A, 'N'],
    [0x1003C, 0x1003D, 'N'],
    [0x1003F, 0x1004D, 'N'],
    [0x10050, 0x1005D, 'N'],
    [0x10080, 0x100FA, 'N'],
    [0x10100, 0x10102, 'N'],
    [0x10107, 0x10133, 'N'],
    [0x10137, 0x1018A, 'N'],
    [0x10190, 0x1019B, 'N'],
    [0x101D0, 0x101FC, 'N'],
    [0x101FD, 0x101FD, 'z'],
    [0x10280, 0x1029C, 'N'],
    [0x102A0, 0x102D0, 'N'],
    [0x10300, 0x1031E, 'N'],
    [0x10320, 0x10323, 'N'],
    [0x10330, 0x1034A, 'N'],
    [0x10380, 0x1039D, 'N'],
    [0x1039F, 0x103C3, 'N'],
    [0x103C8, 0x103D5, 'N'],
    [0x10400, 0x1049D, 'N'],
    [0x104A0, 0x104A9, 'N'],
    [0x10800, 0x10805, 'N'],
    [0x10808, 0x10808, 'N'],
    [0x1080A, 0x10835, 'N'],
    [0x10837, 0x10838, 'N'],
    [0x1083C, 0x1083C, 'N'],
    [0x1083F, 0x1083F, 'N'],
    [0x10900, 0x10919, 'N'],
    [0x1091F, 0x10939, 'N'],
    [0x1093F, 0x1093F, 'N'],
    [0x10A00, 0x10A00, 'N'],
    [0x10A01, 0x10A03, 'z'],
    [0x10A05, 0x10A06, 'z'],
    [0x10A0C, 0x10A0F, 'z'],
    [0x10A10, 0x10A13, 'N'],
    [0x10A15, 0x10A17, 'N'],
    [0x10A19, 0x10A33, 'N'],
    [0x10A38, 0x10A3A, 'z'],
    [0x10A3F, 0x10A3F, 'z'],
    [0x10A40, 0x10A47, 'N'],
    [0x10A50, 0x10A58, 'N'],
    [0x12000, 0x1236E, 'N'],
    [0x12400, 0x12462, 'N'],
    [0x12470, 0x12473, 'N'],
    [0x1D000, 0x1D0F5, 'N'],
    [0x1D100, 0x1D126, 'N'],
    [0x1D129, 0x1D164, 'N'],
    [0x1D165, 0x1D169, 'z'],
    [0x1D16A, 0x1D16C, 'N'],
    [0x1D16D, 0x1D182, 'z'],
    [0x1D183, 0x1D184, 'N'],
    [0x1D185, 0x1D18B, 'z'],
    [0x1D18C, 0x1D1A9, 'N'],
    [0x1D1AA, 0x1D1AD, 'z'],
    [0x1D1AE, 0x1D1DD, 'N'],
    [0x1D200, 0x1D241, 'N'],
    [0x1D242, 0x1D244, 'z'],
    [0x1D245, 0x1D245, 'N'],
    [0x1D300, 0x1D356, 'N'],
    [0x1D360, 0x1D371, 'N'],
    [0x1D400, 0x1D454, 'N'],
    [0x1D456, 0x1D49C, 'N'],
    [0x1D49E, 0x1D49F, 'N'],
    [0x1D4A2, 0x1D4A2, 'N'],
    [0x1D4A5, 0x1D4A6, 'N'],
    [0x1D4A9, 0x1D4AC, 'N'],
    [0x1D4AE, 0x1D4B9, 'N'],
    [0x1D4BB, 0x1D4BB, 'N'],
    [0x1D4BD, 0x1D4C3, 'N'],
    [0x1D4C5, 0x1D505, 'N'],
    [0x1D507, 0x1D50A, 'N'],
    [0x1D50D, 0x1D514, 'N'],
    [0x1D516, 0x1D51C, 'N'],
    [0x1D51E, 0x1D539, 'N'],
    [0x1D53B, 0x1D53E, 'N'],
    [0x1D540, 0x1D544, 'N'],
    [0x1D546, 0x1D546, 'N'],
    [0x1D54A, 0x1D550, 'N'],
    [0x1D552, 0x1D6A5, 'N'],
    [0x1D6A8, 0x1D7CB, 'N'],
    [0x1D7CE, 0x1D7FF, 'N'],
    [0x1F000, 0x1F02B, 'N'],
    [0x1F030, 0x1F093, 'N'],
    [0x20000, 0x2FFFD, 'W'],
    [0x30000, 0x3FFFD, 'W'],
    [0xE0001, 0xE0001, 'z'],
    [0xE0020, 0xE007F, 'z'],
    [0xE0100, 0xE01EF, 'z'],
    [0xF0000, 0xFFFFD, 'A'],
    [0x100000, 0x10FFFD, 'A'],
];

our $lb_MAP = [
    [0x0000, 0x0008, 'CM'],
    [0x0009, 0x0009, 'BA'],
    [0x000A, 0x000A, 'LF'],
    [0x000B, 0x000C, 'BK'],
    [0x000D, 0x000D, 'CR'],
    [0x000E, 0x001F, 'CM'],
    [0x0020, 0x0020, 'SP'],
    [0x0021, 0x0021, 'EX'],
    [0x0022, 0x0022, 'QU'],
    [0x0023, 0x0023, 'AL'],
    [0x0024, 0x0024, 'PR'],
    [0x0025, 0x0025, 'PO'],
    [0x0026, 0x0026, 'AL'],
    [0x0027, 0x0027, 'QU'],
    [0x0028, 0x0028, 'OP'],
    [0x0029, 0x0029, 'CL'],
    [0x002A, 0x002A, 'AL'],
    [0x002B, 0x002B, 'PR'],
    [0x002C, 0x002C, 'IS'],
    [0x002D, 0x002D, 'HY'],
    [0x002E, 0x002E, 'IS'],
    [0x002F, 0x002F, 'SY'],
    [0x0030, 0x0039, 'NU'],
    [0x003A, 0x003B, 'IS'],
    [0x003C, 0x003E, 'AL'],
    [0x003F, 0x003F, 'EX'],
    [0x0040, 0x005A, 'AL'],
    [0x005B, 0x005B, 'OP'],
    [0x005C, 0x005C, 'PR'],
    [0x005D, 0x005D, 'CL'],
    [0x005E, 0x007A, 'AL'],
    [0x007B, 0x007B, 'OP'],
    [0x007C, 0x007C, 'BA'],
    [0x007D, 0x007D, 'CL'],
    [0x007E, 0x007E, 'AL'],
    [0x007F, 0x0084, 'CM'],
    [0x0085, 0x0085, 'NL'],
    [0x0086, 0x009F, 'CM'],
    [0x00A0, 0x00A0, 'GL'],
    [0x00A1, 0x00A1, 'OP'],
    [0x00A2, 0x00A2, 'PO'],
    [0x00A3, 0x00A5, 'PR'],
    [0x00A6, 0x00A6, 'AL'],
    [0x00A7, 0x00A8, 'AI'],
    [0x00A9, 0x00A9, 'AL'],
    [0x00AA, 0x00AA, 'AI'],
    [0x00AB, 0x00AB, 'QU'],
    [0x00AC, 0x00AC, 'AL'],
    [0x00AD, 0x00AD, 'BA'],
    [0x00AE, 0x00AF, 'AL'],
    [0x00B0, 0x00B0, 'PO'],
    [0x00B1, 0x00B1, 'PR'],
    [0x00B2, 0x00B3, 'AI'],
    [0x00B4, 0x00B4, 'BB'],
    [0x00B5, 0x00B5, 'AL'],
    [0x00B6, 0x00BA, 'AI'],
    [0x00BB, 0x00BB, 'QU'],
    [0x00BC, 0x00BE, 'AI'],
    [0x00BF, 0x00BF, 'OP'],
    [0x00C0, 0x00D6, 'AL'],
    [0x00D7, 0x00D7, 'AI'],
    [0x00D8, 0x00F6, 'AL'],
    [0x00F7, 0x00F7, 'AI'],
    [0x00F8, 0x02C6, 'AL'],
    [0x02C7, 0x02C7, 'AI'],
    [0x02C8, 0x02C8, 'BB'],
    [0x02C9, 0x02CB, 'AI'],
    [0x02CC, 0x02CC, 'BB'],
    [0x02CD, 0x02CD, 'AI'],
    [0x02CE, 0x02CF, 'AL'],
    [0x02D0, 0x02D0, 'AI'],
    [0x02D1, 0x02D7, 'AL'],
    [0x02D8, 0x02DB, 'AI'],
    [0x02DC, 0x02DC, 'AL'],
    [0x02DD, 0x02DD, 'AI'],
    [0x02DE, 0x02DE, 'AL'],
    [0x02DF, 0x02DF, 'BB'],
    [0x02E0, 0x02FF, 'AL'],
    [0x0300, 0x034E, 'CM'],
    [0x034F, 0x034F, 'GL'],
    [0x0350, 0x035B, 'CM'],
    [0x035C, 0x0362, 'GL'],
    [0x0363, 0x036F, 'CM'],
    [0x0370, 0x0377, 'AL'],
    [0x037A, 0x037D, 'AL'],
    [0x037E, 0x037E, 'IS'],
    [0x0384, 0x038A, 'AL'],
    [0x038C, 0x038C, 'AL'],
    [0x038E, 0x03A1, 'AL'],
    [0x03A3, 0x0482, 'AL'],
    [0x0483, 0x0489, 'CM'],
    [0x048A, 0x0523, 'AL'],
    [0x0531, 0x0556, 'AL'],
    [0x0559, 0x055F, 'AL'],
    [0x0561, 0x0587, 'AL'],
    [0x0589, 0x0589, 'IS'],
    [0x058A, 0x058A, 'BA'],
    [0x0591, 0x05BD, 'CM'],
    [0x05BE, 0x05BE, 'BA'],
    [0x05BF, 0x05BF, 'CM'],
    [0x05C0, 0x05C0, 'AL'],
    [0x05C1, 0x05C2, 'CM'],
    [0x05C3, 0x05C3, 'AL'],
    [0x05C4, 0x05C5, 'CM'],
    [0x05C6, 0x05C6, 'EX'],
    [0x05C7, 0x05C7, 'CM'],
    [0x05D0, 0x05EA, 'AL'],
    [0x05F0, 0x05F4, 'AL'],
    [0x0600, 0x0603, 'AL'],
    [0x0606, 0x0608, 'AL'],
    [0x0609, 0x060B, 'PO'],
    [0x060C, 0x060D, 'IS'],
    [0x060E, 0x060F, 'AL'],
    [0x0610, 0x061A, 'CM'],
    [0x061B, 0x061B, 'EX'],
    [0x061E, 0x061F, 'EX'],
    [0x0621, 0x064A, 'AL'],
    [0x064B, 0x065E, 'CM'],
    [0x0660, 0x0669, 'NU'],
    [0x066A, 0x066A, 'PO'],
    [0x066B, 0x066C, 'NU'],
    [0x066D, 0x066F, 'AL'],
    [0x0670, 0x0670, 'CM'],
    [0x0671, 0x06D3, 'AL'],
    [0x06D4, 0x06D4, 'EX'],
    [0x06D5, 0x06D5, 'AL'],
    [0x06D6, 0x06DC, 'CM'],
    [0x06DD, 0x06DD, 'AL'],
    [0x06DE, 0x06E4, 'CM'],
    [0x06E5, 0x06E6, 'AL'],
    [0x06E7, 0x06E8, 'CM'],
    [0x06E9, 0x06E9, 'AL'],
    [0x06EA, 0x06ED, 'CM'],
    [0x06EE, 0x06EF, 'AL'],
    [0x06F0, 0x06F9, 'NU'],
    [0x06FA, 0x070D, 'AL'],
    [0x070F, 0x0710, 'AL'],
    [0x0711, 0x0711, 'CM'],
    [0x0712, 0x072F, 'AL'],
    [0x0730, 0x074A, 'CM'],
    [0x074D, 0x07A5, 'AL'],
    [0x07A6, 0x07B0, 'CM'],
    [0x07B1, 0x07B1, 'AL'],
    [0x07C0, 0x07C9, 'NU'],
    [0x07CA, 0x07EA, 'AL'],
    [0x07EB, 0x07F3, 'CM'],
    [0x07F4, 0x07F7, 'AL'],
    [0x07F8, 0x07F8, 'IS'],
    [0x07F9, 0x07F9, 'EX'],
    [0x07FA, 0x07FA, 'AL'],
    [0x0901, 0x0903, 'CM'],
    [0x0904, 0x0939, 'AL'],
    [0x093C, 0x093C, 'CM'],
    [0x093D, 0x093D, 'AL'],
    [0x093E, 0x094D, 'CM'],
    [0x0950, 0x0950, 'AL'],
    [0x0951, 0x0954, 'CM'],
    [0x0958, 0x0961, 'AL'],
    [0x0962, 0x0963, 'CM'],
    [0x0964, 0x0965, 'BA'],
    [0x0966, 0x096F, 'NU'],
    [0x0970, 0x0972, 'AL'],
    [0x097B, 0x097F, 'AL'],
    [0x0981, 0x0983, 'CM'],
    [0x0985, 0x098C, 'AL'],
    [0x098F, 0x0990, 'AL'],
    [0x0993, 0x09A8, 'AL'],
    [0x09AA, 0x09B0, 'AL'],
    [0x09B2, 0x09B2, 'AL'],
    [0x09B6, 0x09B9, 'AL'],
    [0x09BC, 0x09BC, 'CM'],
    [0x09BD, 0x09BD, 'AL'],
    [0x09BE, 0x09C4, 'CM'],
    [0x09C7, 0x09C8, 'CM'],
    [0x09CB, 0x09CD, 'CM'],
    [0x09CE, 0x09CE, 'AL'],
    [0x09D7, 0x09D7, 'CM'],
    [0x09DC, 0x09DD, 'AL'],
    [0x09DF, 0x09E1, 'AL'],
    [0x09E2, 0x09E3, 'CM'],
    [0x09E6, 0x09EF, 'NU'],
    [0x09F0, 0x09F1, 'AL'],
    [0x09F2, 0x09F3, 'PR'],
    [0x09F4, 0x09FA, 'AL'],
    [0x0A01, 0x0A03, 'CM'],
    [0x0A05, 0x0A0A, 'AL'],
    [0x0A0F, 0x0A10, 'AL'],
    [0x0A13, 0x0A28, 'AL'],
    [0x0A2A, 0x0A30, 'AL'],
    [0x0A32, 0x0A33, 'AL'],
    [0x0A35, 0x0A36, 'AL'],
    [0x0A38, 0x0A39, 'AL'],
    [0x0A3C, 0x0A3C, 'CM'],
    [0x0A3E, 0x0A42, 'CM'],
    [0x0A47, 0x0A48, 'CM'],
    [0x0A4B, 0x0A4D, 'CM'],
    [0x0A51, 0x0A51, 'CM'],
    [0x0A59, 0x0A5C, 'AL'],
    [0x0A5E, 0x0A5E, 'AL'],
    [0x0A66, 0x0A6F, 'NU'],
    [0x0A70, 0x0A71, 'CM'],
    [0x0A72, 0x0A74, 'AL'],
    [0x0A75, 0x0A75, 'CM'],
    [0x0A81, 0x0A83, 'CM'],
    [0x0A85, 0x0A8D, 'AL'],
    [0x0A8F, 0x0A91, 'AL'],
    [0x0A93, 0x0AA8, 'AL'],
    [0x0AAA, 0x0AB0, 'AL'],
    [0x0AB2, 0x0AB3, 'AL'],
    [0x0AB5, 0x0AB9, 'AL'],
    [0x0ABC, 0x0ABC, 'CM'],
    [0x0ABD, 0x0ABD, 'AL'],
    [0x0ABE, 0x0AC5, 'CM'],
    [0x0AC7, 0x0AC9, 'CM'],
    [0x0ACB, 0x0ACD, 'CM'],
    [0x0AD0, 0x0AD0, 'AL'],
    [0x0AE0, 0x0AE1, 'AL'],
    [0x0AE2, 0x0AE3, 'CM'],
    [0x0AE6, 0x0AEF, 'NU'],
    [0x0AF1, 0x0AF1, 'PR'],
    [0x0B01, 0x0B03, 'CM'],
    [0x0B05, 0x0B0C, 'AL'],
    [0x0B0F, 0x0B10, 'AL'],
    [0x0B13, 0x0B28, 'AL'],
    [0x0B2A, 0x0B30, 'AL'],
    [0x0B32, 0x0B33, 'AL'],
    [0x0B35, 0x0B39, 'AL'],
    [0x0B3C, 0x0B3C, 'CM'],
    [0x0B3D, 0x0B3D, 'AL'],
    [0x0B3E, 0x0B44, 'CM'],
    [0x0B47, 0x0B48, 'CM'],
    [0x0B4B, 0x0B4D, 'CM'],
    [0x0B56, 0x0B57, 'CM'],
    [0x0B5C, 0x0B5D, 'AL'],
    [0x0B5F, 0x0B61, 'AL'],
    [0x0B62, 0x0B63, 'CM'],
    [0x0B66, 0x0B6F, 'NU'],
    [0x0B70, 0x0B71, 'AL'],
    [0x0B82, 0x0B82, 'CM'],
    [0x0B83, 0x0B83, 'AL'],
    [0x0B85, 0x0B8A, 'AL'],
    [0x0B8E, 0x0B90, 'AL'],
    [0x0B92, 0x0B95, 'AL'],
    [0x0B99, 0x0B9A, 'AL'],
    [0x0B9C, 0x0B9C, 'AL'],
    [0x0B9E, 0x0B9F, 'AL'],
    [0x0BA3, 0x0BA4, 'AL'],
    [0x0BA8, 0x0BAA, 'AL'],
    [0x0BAE, 0x0BB9, 'AL'],
    [0x0BBE, 0x0BC2, 'CM'],
    [0x0BC6, 0x0BC8, 'CM'],
    [0x0BCA, 0x0BCD, 'CM'],
    [0x0BD0, 0x0BD0, 'AL'],
    [0x0BD7, 0x0BD7, 'CM'],
    [0x0BE6, 0x0BEF, 'NU'],
    [0x0BF0, 0x0BF8, 'AL'],
    [0x0BF9, 0x0BF9, 'PR'],
    [0x0BFA, 0x0BFA, 'AL'],
    [0x0C01, 0x0C03, 'CM'],
    [0x0C05, 0x0C0C, 'AL'],
    [0x0C0E, 0x0C10, 'AL'],
    [0x0C12, 0x0C28, 'AL'],
    [0x0C2A, 0x0C33, 'AL'],
    [0x0C35, 0x0C39, 'AL'],
    [0x0C3D, 0x0C3D, 'AL'],
    [0x0C3E, 0x0C44, 'CM'],
    [0x0C46, 0x0C48, 'CM'],
    [0x0C4A, 0x0C4D, 'CM'],
    [0x0C55, 0x0C56, 'CM'],
    [0x0C58, 0x0C59, 'AL'],
    [0x0C60, 0x0C61, 'AL'],
    [0x0C62, 0x0C63, 'CM'],
    [0x0C66, 0x0C6F, 'NU'],
    [0x0C78, 0x0C7F, 'AL'],
    [0x0C82, 0x0C83, 'CM'],
    [0x0C85, 0x0C8C, 'AL'],
    [0x0C8E, 0x0C90, 'AL'],
    [0x0C92, 0x0CA8, 'AL'],
    [0x0CAA, 0x0CB3, 'AL'],
    [0x0CB5, 0x0CB9, 'AL'],
    [0x0CBC, 0x0CBC, 'CM'],
    [0x0CBD, 0x0CBD, 'AL'],
    [0x0CBE, 0x0CC4, 'CM'],
    [0x0CC6, 0x0CC8, 'CM'],
    [0x0CCA, 0x0CCD, 'CM'],
    [0x0CD5, 0x0CD6, 'CM'],
    [0x0CDE, 0x0CDE, 'AL'],
    [0x0CE0, 0x0CE1, 'AL'],
    [0x0CE2, 0x0CE3, 'CM'],
    [0x0CE6, 0x0CEF, 'NU'],
    [0x0CF1, 0x0CF2, 'AL'],
    [0x0D02, 0x0D03, 'CM'],
    [0x0D05, 0x0D0C, 'AL'],
    [0x0D0E, 0x0D10, 'AL'],
    [0x0D12, 0x0D28, 'AL'],
    [0x0D2A, 0x0D39, 'AL'],
    [0x0D3D, 0x0D3D, 'AL'],
    [0x0D3E, 0x0D44, 'CM'],
    [0x0D46, 0x0D48, 'CM'],
    [0x0D4A, 0x0D4D, 'CM'],
    [0x0D57, 0x0D57, 'CM'],
    [0x0D60, 0x0D61, 'AL'],
    [0x0D62, 0x0D63, 'CM'],
    [0x0D66, 0x0D6F, 'NU'],
    [0x0D70, 0x0D75, 'AL'],
    [0x0D79, 0x0D79, 'PO'],
    [0x0D7A, 0x0D7F, 'AL'],
    [0x0D82, 0x0D83, 'CM'],
    [0x0D85, 0x0D96, 'AL'],
    [0x0D9A, 0x0DB1, 'AL'],
    [0x0DB3, 0x0DBB, 'AL'],
    [0x0DBD, 0x0DBD, 'AL'],
    [0x0DC0, 0x0DC6, 'AL'],
    [0x0DCA, 0x0DCA, 'CM'],
    [0x0DCF, 0x0DD4, 'CM'],
    [0x0DD6, 0x0DD6, 'CM'],
    [0x0DD8, 0x0DDF, 'CM'],
    [0x0DF2, 0x0DF3, 'CM'],
    [0x0DF4, 0x0DF4, 'AL'],
    [0x0E01, 0x0E30, 'SAal'],
    [0x0E31, 0x0E31, 'SAcm'],
    [0x0E32, 0x0E33, 'SAal'],
    [0x0E34, 0x0E3A, 'SAcm'],
    [0x0E3F, 0x0E3F, 'PR'],
    [0x0E40, 0x0E46, 'SAal'],
    [0x0E47, 0x0E4E, 'SAcm'],
    [0x0E4F, 0x0E4F, 'AL'],
    [0x0E50, 0x0E59, 'NU'],
    [0x0E5A, 0x0E5B, 'BA'],
    [0x0E81, 0x0E82, 'SAal'],
    [0x0E84, 0x0E84, 'SAal'],
    [0x0E87, 0x0E88, 'SAal'],
    [0x0E8A, 0x0E8A, 'SAal'],
    [0x0E8D, 0x0E8D, 'SAal'],
    [0x0E94, 0x0E97, 'SAal'],
    [0x0E99, 0x0E9F, 'SAal'],
    [0x0EA1, 0x0EA3, 'SAal'],
    [0x0EA5, 0x0EA5, 'SAal'],
    [0x0EA7, 0x0EA7, 'SAal'],
    [0x0EAA, 0x0EAB, 'SAal'],
    [0x0EAD, 0x0EB0, 'SAal'],
    [0x0EB1, 0x0EB1, 'SAcm'],
    [0x0EB2, 0x0EB3, 'SAal'],
    [0x0EB4, 0x0EB9, 'SAcm'],
    [0x0EBB, 0x0EBC, 'SAcm'],
    [0x0EBD, 0x0EBD, 'SAal'],
    [0x0EC0, 0x0EC4, 'SAal'],
    [0x0EC6, 0x0EC6, 'SAal'],
    [0x0EC8, 0x0ECD, 'SAcm'],
    [0x0ED0, 0x0ED9, 'NU'],
    [0x0EDC, 0x0EDD, 'SAal'],
    [0x0F00, 0x0F00, 'AL'],
    [0x0F01, 0x0F04, 'BB'],
    [0x0F05, 0x0F05, 'AL'],
    [0x0F06, 0x0F07, 'BB'],
    [0x0F08, 0x0F08, 'GL'],
    [0x0F09, 0x0F0A, 'BB'],
    [0x0F0B, 0x0F0B, 'BA'],
    [0x0F0C, 0x0F0C, 'GL'],
    [0x0F0D, 0x0F11, 'EX'],
    [0x0F12, 0x0F12, 'GL'],
    [0x0F13, 0x0F13, 'AL'],
    [0x0F14, 0x0F14, 'EX'],
    [0x0F15, 0x0F17, 'AL'],
    [0x0F18, 0x0F19, 'CM'],
    [0x0F1A, 0x0F1F, 'AL'],
    [0x0F20, 0x0F29, 'NU'],
    [0x0F2A, 0x0F33, 'AL'],
    [0x0F34, 0x0F34, 'BA'],
    [0x0F35, 0x0F35, 'CM'],
    [0x0F36, 0x0F36, 'AL'],
    [0x0F37, 0x0F37, 'CM'],
    [0x0F38, 0x0F38, 'AL'],
    [0x0F39, 0x0F39, 'CM'],
    [0x0F3A, 0x0F3A, 'OP'],
    [0x0F3B, 0x0F3B, 'CL'],
    [0x0F3C, 0x0F3C, 'OP'],
    [0x0F3D, 0x0F3D, 'CL'],
    [0x0F3E, 0x0F3F, 'CM'],
    [0x0F40, 0x0F47, 'AL'],
    [0x0F49, 0x0F6C, 'AL'],
    [0x0F71, 0x0F7E, 'CM'],
    [0x0F7F, 0x0F7F, 'BA'],
    [0x0F80, 0x0F84, 'CM'],
    [0x0F85, 0x0F85, 'BA'],
    [0x0F86, 0x0F87, 'CM'],
    [0x0F88, 0x0F8B, 'AL'],
    [0x0F90, 0x0F97, 'CM'],
    [0x0F99, 0x0FBC, 'CM'],
    [0x0FBE, 0x0FBF, 'BA'],
    [0x0FC0, 0x0FC5, 'AL'],
    [0x0FC6, 0x0FC6, 'CM'],
    [0x0FC7, 0x0FCC, 'AL'],
    [0x0FCE, 0x0FCF, 'AL'],
    [0x0FD0, 0x0FD1, 'BB'],
    [0x0FD2, 0x0FD2, 'BA'],
    [0x0FD3, 0x0FD3, 'BB'],
    [0x0FD4, 0x0FD4, 'AL'],
    [0x1000, 0x102A, 'SAal'],
    [0x102B, 0x103E, 'SAcm'],
    [0x103F, 0x103F, 'SAal'],
    [0x1040, 0x1049, 'NU'],
    [0x104A, 0x104B, 'BA'],
    [0x104C, 0x104F, 'AL'],
    [0x1050, 0x1055, 'SAal'],
    [0x1056, 0x1059, 'SAcm'],
    [0x105A, 0x105D, 'SAal'],
    [0x105E, 0x1060, 'SAcm'],
    [0x1061, 0x1061, 'SAal'],
    [0x1062, 0x1064, 'SAcm'],
    [0x1065, 0x1066, 'SAal'],
    [0x1067, 0x106D, 'SAcm'],
    [0x106E, 0x1070, 'SAal'],
    [0x1071, 0x1074, 'SAcm'],
    [0x1075, 0x1081, 'SAal'],
    [0x1082, 0x108D, 'SAcm'],
    [0x108E, 0x108E, 'SAal'],
    [0x108F, 0x108F, 'SAcm'],
    [0x1090, 0x1099, 'NU'],
    [0x109E, 0x109F, 'SAal'],
    [0x10A0, 0x10C5, 'AL'],
    [0x10D0, 0x10FC, 'AL'],
    [0x1100, 0x1159, 'JL'],
    [0x115F, 0x115F, 'JL'],
    [0x1160, 0x11A2, 'JV'],
    [0x11A8, 0x11F9, 'JT'],
    [0x1200, 0x1248, 'AL'],
    [0x124A, 0x124D, 'AL'],
    [0x1250, 0x1256, 'AL'],
    [0x1258, 0x1258, 'AL'],
    [0x125A, 0x125D, 'AL'],
    [0x1260, 0x1288, 'AL'],
    [0x128A, 0x128D, 'AL'],
    [0x1290, 0x12B0, 'AL'],
    [0x12B2, 0x12B5, 'AL'],
    [0x12B8, 0x12BE, 'AL'],
    [0x12C0, 0x12C0, 'AL'],
    [0x12C2, 0x12C5, 'AL'],
    [0x12C8, 0x12D6, 'AL'],
    [0x12D8, 0x1310, 'AL'],
    [0x1312, 0x1315, 'AL'],
    [0x1318, 0x135A, 'AL'],
    [0x135F, 0x135F, 'CM'],
    [0x1360, 0x1360, 'AL'],
    [0x1361, 0x1361, 'BA'],
    [0x1362, 0x137C, 'AL'],
    [0x1380, 0x1399, 'AL'],
    [0x13A0, 0x13F4, 'AL'],
    [0x1401, 0x1676, 'AL'],
    [0x1680, 0x1680, 'BA'],
    [0x1681, 0x169A, 'AL'],
    [0x169B, 0x169B, 'OP'],
    [0x169C, 0x169C, 'CL'],
    [0x16A0, 0x16EA, 'AL'],
    [0x16EB, 0x16ED, 'BA'],
    [0x16EE, 0x16F0, 'AL'],
    [0x1700, 0x170C, 'AL'],
    [0x170E, 0x1711, 'AL'],
    [0x1712, 0x1714, 'CM'],
    [0x1720, 0x1731, 'AL'],
    [0x1732, 0x1734, 'CM'],
    [0x1735, 0x1736, 'BA'],
    [0x1740, 0x1751, 'AL'],
    [0x1752, 0x1753, 'CM'],
    [0x1760, 0x176C, 'AL'],
    [0x176E, 0x1770, 'AL'],
    [0x1772, 0x1773, 'CM'],
    [0x1780, 0x17B5, 'SAal'],
    [0x17B6, 0x17D3, 'SAcm'],
    [0x17D4, 0x17D5, 'BA'],
    [0x17D6, 0x17D6, 'NS'],
    [0x17D7, 0x17D7, 'SAal'],
    [0x17D8, 0x17D8, 'BA'],
    [0x17D9, 0x17D9, 'AL'],
    [0x17DA, 0x17DA, 'BA'],
    [0x17DB, 0x17DB, 'PR'],
    [0x17DC, 0x17DC, 'SAal'],
    [0x17DD, 0x17DD, 'SAcm'],
    [0x17E0, 0x17E9, 'NU'],
    [0x17F0, 0x17F9, 'AL'],
    [0x1800, 0x1801, 'AL'],
    [0x1802, 0x1803, 'EX'],
    [0x1804, 0x1805, 'BA'],
    [0x1806, 0x1806, 'BB'],
    [0x1807, 0x1807, 'AL'],
    [0x1808, 0x1809, 'EX'],
    [0x180A, 0x180A, 'AL'],
    [0x180B, 0x180D, 'CM'],
    [0x180E, 0x180E, 'GL'],
    [0x1810, 0x1819, 'NU'],
    [0x1820, 0x1877, 'AL'],
    [0x1880, 0x18A8, 'AL'],
    [0x18A9, 0x18A9, 'CM'],
    [0x18AA, 0x18AA, 'AL'],
    [0x1900, 0x191C, 'AL'],
    [0x1920, 0x192B, 'CM'],
    [0x1930, 0x193B, 'CM'],
    [0x1940, 0x1940, 'AL'],
    [0x1944, 0x1945, 'EX'],
    [0x1946, 0x194F, 'NU'],
    [0x1950, 0x196D, 'SAal'],
    [0x1970, 0x1974, 'SAal'],
    [0x1980, 0x19A9, 'SAal'],
    [0x19B0, 0x19C0, 'SAcm'],
    [0x19C1, 0x19C7, 'SAal'],
    [0x19C8, 0x19C9, 'SAcm'],
    [0x19D0, 0x19D9, 'NU'],
    [0x19DE, 0x19DF, 'SAal'],
    [0x19E0, 0x1A16, 'AL'],
    [0x1A17, 0x1A1B, 'CM'],
    [0x1A1E, 0x1A1F, 'AL'],
    [0x1B00, 0x1B04, 'CM'],
    [0x1B05, 0x1B33, 'AL'],
    [0x1B34, 0x1B44, 'CM'],
    [0x1B45, 0x1B4B, 'AL'],
    [0x1B50, 0x1B59, 'NU'],
    [0x1B5A, 0x1B60, 'BA'],
    [0x1B61, 0x1B6A, 'AL'],
    [0x1B6B, 0x1B73, 'CM'],
    [0x1B74, 0x1B7C, 'AL'],
    [0x1B80, 0x1B82, 'CM'],
    [0x1B83, 0x1BA0, 'AL'],
    [0x1BA1, 0x1BAA, 'CM'],
    [0x1BAE, 0x1BAF, 'AL'],
    [0x1BB0, 0x1BB9, 'NU'],
    [0x1C00, 0x1C23, 'AL'],
    [0x1C24, 0x1C37, 'CM'],
    [0x1C3B, 0x1C3F, 'BA'],
    [0x1C40, 0x1C49, 'NU'],
    [0x1C4D, 0x1C4F, 'AL'],
    [0x1C50, 0x1C59, 'NU'],
    [0x1C5A, 0x1C7D, 'AL'],
    [0x1C7E, 0x1C7F, 'BA'],
    [0x1D00, 0x1DBF, 'AL'],
    [0x1DC0, 0x1DE6, 'CM'],
    [0x1DFE, 0x1DFF, 'CM'],
    [0x1E00, 0x1F15, 'AL'],
    [0x1F18, 0x1F1D, 'AL'],
    [0x1F20, 0x1F45, 'AL'],
    [0x1F48, 0x1F4D, 'AL'],
    [0x1F50, 0x1F57, 'AL'],
    [0x1F59, 0x1F59, 'AL'],
    [0x1F5B, 0x1F5B, 'AL'],
    [0x1F5D, 0x1F5D, 'AL'],
    [0x1F5F, 0x1F7D, 'AL'],
    [0x1F80, 0x1FB4, 'AL'],
    [0x1FB6, 0x1FC4, 'AL'],
    [0x1FC6, 0x1FD3, 'AL'],
    [0x1FD6, 0x1FDB, 'AL'],
    [0x1FDD, 0x1FEF, 'AL'],
    [0x1FF2, 0x1FF4, 'AL'],
    [0x1FF6, 0x1FFC, 'AL'],
    [0x1FFD, 0x1FFD, 'BB'],
    [0x1FFE, 0x1FFE, 'AL'],
    [0x2000, 0x2006, 'BA'],
    [0x2007, 0x2007, 'GL'],
    [0x2008, 0x200A, 'BA'],
    [0x200B, 0x200B, 'ZW'],
    [0x200C, 0x200F, 'CM'],
    [0x2010, 0x2010, 'BA'],
    [0x2011, 0x2011, 'GL'],
    [0x2012, 0x2013, 'BA'],
    [0x2014, 0x2014, 'B2'],
    [0x2015, 0x2016, 'AI'],
    [0x2017, 0x2017, 'AL'],
    [0x2018, 0x2019, 'QU'],
    [0x201A, 0x201A, 'OP'],
    [0x201B, 0x201D, 'QU'],
    [0x201E, 0x201E, 'OP'],
    [0x201F, 0x201F, 'QU'],
    [0x2020, 0x2021, 'AI'],
    [0x2022, 0x2023, 'AL'],
    [0x2024, 0x2026, 'IN'],
    [0x2027, 0x2027, 'BA'],
    [0x2028, 0x2029, 'BK'],
    [0x202A, 0x202E, 'CM'],
    [0x202F, 0x202F, 'GL'],
    [0x2030, 0x2037, 'PO'],
    [0x2038, 0x2038, 'AL'],
    [0x2039, 0x203A, 'QU'],
    [0x203B, 0x203B, 'AI'],
    [0x203C, 0x203D, 'NS'],
    [0x203E, 0x2043, 'AL'],
    [0x2044, 0x2044, 'IS'],
    [0x2045, 0x2045, 'OP'],
    [0x2046, 0x2046, 'CL'],
    [0x2047, 0x2049, 'NS'],
    [0x204A, 0x2055, 'AL'],
    [0x2056, 0x2056, 'BA'],
    [0x2057, 0x2057, 'AL'],
    [0x2058, 0x205B, 'BA'],
    [0x205C, 0x205C, 'AL'],
    [0x205D, 0x205F, 'BA'],
    [0x2060, 0x2060, 'WJ'],
    [0x2061, 0x2064, 'AL'],
    [0x206A, 0x206F, 'CM'],
    [0x2070, 0x2071, 'AL'],
    [0x2074, 0x2074, 'AI'],
    [0x2075, 0x207C, 'AL'],
    [0x207D, 0x207D, 'OP'],
    [0x207E, 0x207E, 'CL'],
    [0x207F, 0x207F, 'AI'],
    [0x2080, 0x2080, 'AL'],
    [0x2081, 0x2084, 'AI'],
    [0x2085, 0x208C, 'AL'],
    [0x208D, 0x208D, 'OP'],
    [0x208E, 0x208E, 'CL'],
    [0x2090, 0x2094, 'AL'],
    [0x20A0, 0x20A6, 'PR'],
    [0x20A7, 0x20A7, 'PO'],
    [0x20A8, 0x20B5, 'PR'],
    [0x20D0, 0x20F0, 'CM'],
    [0x2100, 0x2102, 'AL'],
    [0x2103, 0x2103, 'PO'],
    [0x2104, 0x2104, 'AL'],
    [0x2105, 0x2105, 'AI'],
    [0x2106, 0x2108, 'AL'],
    [0x2109, 0x2109, 'PO'],
    [0x210A, 0x2112, 'AL'],
    [0x2113, 0x2113, 'AI'],
    [0x2114, 0x2115, 'AL'],
    [0x2116, 0x2116, 'PR'],
    [0x2117, 0x2120, 'AL'],
    [0x2121, 0x2122, 'AI'],
    [0x2123, 0x212A, 'AL'],
    [0x212B, 0x212B, 'AI'],
    [0x212C, 0x214F, 'AL'],
    [0x2153, 0x2153, 'AL'],
    [0x2154, 0x2155, 'AI'],
    [0x2156, 0x215A, 'AL'],
    [0x215B, 0x215B, 'AI'],
    [0x215C, 0x215D, 'AL'],
    [0x215E, 0x215E, 'AI'],
    [0x215F, 0x215F, 'AL'],
    [0x2160, 0x216B, 'AI'],
    [0x216C, 0x216F, 'AL'],
    [0x2170, 0x2179, 'AI'],
    [0x217A, 0x2188, 'AL'],
    [0x2190, 0x2199, 'AI'],
    [0x219A, 0x21D1, 'AL'],
    [0x21D2, 0x21D2, 'AI'],
    [0x21D3, 0x21D3, 'AL'],
    [0x21D4, 0x21D4, 'AI'],
    [0x21D5, 0x21FF, 'AL'],
    [0x2200, 0x2200, 'AI'],
    [0x2201, 0x2201, 'AL'],
    [0x2202, 0x2203, 'AI'],
    [0x2204, 0x2206, 'AL'],
    [0x2207, 0x2208, 'AI'],
    [0x2209, 0x220A, 'AL'],
    [0x220B, 0x220B, 'AI'],
    [0x220C, 0x220E, 'AL'],
    [0x220F, 0x220F, 'AI'],
    [0x2210, 0x2210, 'AL'],
    [0x2211, 0x2211, 'AI'],
    [0x2212, 0x2213, 'PR'],
    [0x2214, 0x2214, 'AL'],
    [0x2215, 0x2215, 'AI'],
    [0x2216, 0x2219, 'AL'],
    [0x221A, 0x221A, 'AI'],
    [0x221B, 0x221C, 'AL'],
    [0x221D, 0x2220, 'AI'],
    [0x2221, 0x2222, 'AL'],
    [0x2223, 0x2223, 'AI'],
    [0x2224, 0x2224, 'AL'],
    [0x2225, 0x2225, 'AI'],
    [0x2226, 0x2226, 'AL'],
    [0x2227, 0x222C, 'AI'],
    [0x222D, 0x222D, 'AL'],
    [0x222E, 0x222E, 'AI'],
    [0x222F, 0x2233, 'AL'],
    [0x2234, 0x2237, 'AI'],
    [0x2238, 0x223B, 'AL'],
    [0x223C, 0x223D, 'AI'],
    [0x223E, 0x2247, 'AL'],
    [0x2248, 0x2248, 'AI'],
    [0x2249, 0x224B, 'AL'],
    [0x224C, 0x224C, 'AI'],
    [0x224D, 0x2251, 'AL'],
    [0x2252, 0x2252, 'AI'],
    [0x2253, 0x225F, 'AL'],
    [0x2260, 0x2261, 'AI'],
    [0x2262, 0x2263, 'AL'],
    [0x2264, 0x2267, 'AI'],
    [0x2268, 0x2269, 'AL'],
    [0x226A, 0x226B, 'AI'],
    [0x226C, 0x226D, 'AL'],
    [0x226E, 0x226F, 'AI'],
    [0x2270, 0x2281, 'AL'],
    [0x2282, 0x2283, 'AI'],
    [0x2284, 0x2285, 'AL'],
    [0x2286, 0x2287, 'AI'],
    [0x2288, 0x2294, 'AL'],
    [0x2295, 0x2295, 'AI'],
    [0x2296, 0x2298, 'AL'],
    [0x2299, 0x2299, 'AI'],
    [0x229A, 0x22A4, 'AL'],
    [0x22A5, 0x22A5, 'AI'],
    [0x22A6, 0x22BE, 'AL'],
    [0x22BF, 0x22BF, 'AI'],
    [0x22C0, 0x2311, 'AL'],
    [0x2312, 0x2312, 'AI'],
    [0x2313, 0x2328, 'AL'],
    [0x2329, 0x2329, 'OP'],
    [0x232A, 0x232A, 'CL'],
    [0x232B, 0x23E7, 'AL'],
    [0x2400, 0x2426, 'AL'],
    [0x2440, 0x244A, 'AL'],
    [0x2460, 0x24FE, 'AI'],
    [0x24FF, 0x24FF, 'AL'],
    [0x2500, 0x254B, 'AI'],
    [0x254C, 0x254F, 'AL'],
    [0x2550, 0x2574, 'AI'],
    [0x2575, 0x257F, 'AL'],
    [0x2580, 0x258F, 'AI'],
    [0x2590, 0x2591, 'AL'],
    [0x2592, 0x2595, 'AI'],
    [0x2596, 0x259F, 'AL'],
    [0x25A0, 0x25A1, 'AI'],
    [0x25A2, 0x25A2, 'AL'],
    [0x25A3, 0x25A9, 'AI'],
    [0x25AA, 0x25B1, 'AL'],
    [0x25B2, 0x25B3, 'AI'],
    [0x25B4, 0x25B5, 'AL'],
    [0x25B6, 0x25B7, 'AI'],
    [0x25B8, 0x25BB, 'AL'],
    [0x25BC, 0x25BD, 'AI'],
    [0x25BE, 0x25BF, 'AL'],
    [0x25C0, 0x25C1, 'AI'],
    [0x25C2, 0x25C5, 'AL'],
    [0x25C6, 0x25C8, 'AI'],
    [0x25C9, 0x25CA, 'AL'],
    [0x25CB, 0x25CB, 'AI'],
    [0x25CC, 0x25CD, 'AL'],
    [0x25CE, 0x25D1, 'AI'],
    [0x25D2, 0x25E1, 'AL'],
    [0x25E2, 0x25E5, 'AI'],
    [0x25E6, 0x25EE, 'AL'],
    [0x25EF, 0x25EF, 'AI'],
    [0x25F0, 0x2604, 'AL'],
    [0x2605, 0x2606, 'AI'],
    [0x2607, 0x2608, 'AL'],
    [0x2609, 0x2609, 'AI'],
    [0x260A, 0x260D, 'AL'],
    [0x260E, 0x260F, 'AI'],
    [0x2610, 0x2613, 'AL'],
    [0x2614, 0x2617, 'AI'],
    [0x2618, 0x261B, 'AL'],
    [0x261C, 0x261C, 'AI'],
    [0x261D, 0x261D, 'AL'],
    [0x261E, 0x261E, 'AI'],
    [0x261F, 0x263F, 'AL'],
    [0x2640, 0x2640, 'AI'],
    [0x2641, 0x2641, 'AL'],
    [0x2642, 0x2642, 'AI'],
    [0x2643, 0x265F, 'AL'],
    [0x2660, 0x2661, 'AI'],
    [0x2662, 0x2662, 'AL'],
    [0x2663, 0x2665, 'AI'],
    [0x2666, 0x2666, 'AL'],
    [0x2667, 0x266A, 'AI'],
    [0x266B, 0x266B, 'AL'],
    [0x266C, 0x266D, 'AI'],
    [0x266E, 0x266E, 'AL'],
    [0x266F, 0x266F, 'AI'],
    [0x2670, 0x269D, 'AL'],
    [0x26A0, 0x26BC, 'AL'],
    [0x26C0, 0x26C3, 'AL'],
    [0x2701, 0x2704, 'AL'],
    [0x2706, 0x2709, 'AL'],
    [0x270C, 0x2727, 'AL'],
    [0x2729, 0x274B, 'AL'],
    [0x274D, 0x274D, 'AL'],
    [0x274F, 0x2752, 'AL'],
    [0x2756, 0x2756, 'AL'],
    [0x2758, 0x275A, 'AL'],
    [0x275B, 0x275E, 'QU'],
    [0x2761, 0x2761, 'AL'],
    [0x2762, 0x2763, 'EX'],
    [0x2764, 0x2767, 'AL'],
    [0x2768, 0x2768, 'OP'],
    [0x2769, 0x2769, 'CL'],
    [0x276A, 0x276A, 'OP'],
    [0x276B, 0x276B, 'CL'],
    [0x276C, 0x276C, 'OP'],
    [0x276D, 0x276D, 'CL'],
    [0x276E, 0x276E, 'OP'],
    [0x276F, 0x276F, 'CL'],
    [0x2770, 0x2770, 'OP'],
    [0x2771, 0x2771, 'CL'],
    [0x2772, 0x2772, 'OP'],
    [0x2773, 0x2773, 'CL'],
    [0x2774, 0x2774, 'OP'],
    [0x2775, 0x2775, 'CL'],
    [0x2776, 0x2793, 'AI'],
    [0x2794, 0x2794, 'AL'],
    [0x2798, 0x27AF, 'AL'],
    [0x27B1, 0x27BE, 'AL'],
    [0x27C0, 0x27C4, 'AL'],
    [0x27C5, 0x27C5, 'OP'],
    [0x27C6, 0x27C6, 'CL'],
    [0x27C7, 0x27CA, 'AL'],
    [0x27CC, 0x27CC, 'AL'],
    [0x27D0, 0x27E5, 'AL'],
    [0x27E6, 0x27E6, 'OP'],
    [0x27E7, 0x27E7, 'CL'],
    [0x27E8, 0x27E8, 'OP'],
    [0x27E9, 0x27E9, 'CL'],
    [0x27EA, 0x27EA, 'OP'],
    [0x27EB, 0x27EB, 'CL'],
    [0x27EC, 0x27EC, 'OP'],
    [0x27ED, 0x27ED, 'CL'],
    [0x27EE, 0x27EE, 'OP'],
    [0x27EF, 0x27EF, 'CL'],
    [0x27F0, 0x2982, 'AL'],
    [0x2983, 0x2983, 'OP'],
    [0x2984, 0x2984, 'CL'],
    [0x2985, 0x2985, 'OP'],
    [0x2986, 0x2986, 'CL'],
    [0x2987, 0x2987, 'OP'],
    [0x2988, 0x2988, 'CL'],
    [0x2989, 0x2989, 'OP'],
    [0x298A, 0x298A, 'CL'],
    [0x298B, 0x298B, 'OP'],
    [0x298C, 0x298C, 'CL'],
    [0x298D, 0x298D, 'OP'],
    [0x298E, 0x298E, 'CL'],
    [0x298F, 0x298F, 'OP'],
    [0x2990, 0x2990, 'CL'],
    [0x2991, 0x2991, 'OP'],
    [0x2992, 0x2992, 'CL'],
    [0x2993, 0x2993, 'OP'],
    [0x2994, 0x2994, 'CL'],
    [0x2995, 0x2995, 'OP'],
    [0x2996, 0x2996, 'CL'],
    [0x2997, 0x2997, 'OP'],
    [0x2998, 0x2998, 'CL'],
    [0x2999, 0x29D7, 'AL'],
    [0x29D8, 0x29D8, 'OP'],
    [0x29D9, 0x29D9, 'CL'],
    [0x29DA, 0x29DA, 'OP'],
    [0x29DB, 0x29DB, 'CL'],
    [0x29DC, 0x29FB, 'AL'],
    [0x29FC, 0x29FC, 'OP'],
    [0x29FD, 0x29FD, 'CL'],
    [0x29FE, 0x2B4C, 'AL'],
    [0x2B50, 0x2B54, 'AL'],
    [0x2C00, 0x2C2E, 'AL'],
    [0x2C30, 0x2C5E, 'AL'],
    [0x2C60, 0x2C6F, 'AL'],
    [0x2C71, 0x2C7D, 'AL'],
    [0x2C80, 0x2CEA, 'AL'],
    [0x2CF9, 0x2CF9, 'EX'],
    [0x2CFA, 0x2CFC, 'BA'],
    [0x2CFD, 0x2CFD, 'AL'],
    [0x2CFE, 0x2CFE, 'EX'],
    [0x2CFF, 0x2CFF, 'BA'],
    [0x2D00, 0x2D25, 'AL'],
    [0x2D30, 0x2D65, 'AL'],
    [0x2D6F, 0x2D6F, 'AL'],
    [0x2D80, 0x2D96, 'AL'],
    [0x2DA0, 0x2DA6, 'AL'],
    [0x2DA8, 0x2DAE, 'AL'],
    [0x2DB0, 0x2DB6, 'AL'],
    [0x2DB8, 0x2DBE, 'AL'],
    [0x2DC0, 0x2DC6, 'AL'],
    [0x2DC8, 0x2DCE, 'AL'],
    [0x2DD0, 0x2DD6, 'AL'],
    [0x2DD8, 0x2DDE, 'AL'],
    [0x2DE0, 0x2DFF, 'CM'],
    [0x2E00, 0x2E0D, 'QU'],
    [0x2E0E, 0x2E15, 'BA'],
    [0x2E16, 0x2E16, 'AL'],
    [0x2E17, 0x2E17, 'BA'],
    [0x2E18, 0x2E18, 'OP'],
    [0x2E19, 0x2E19, 'BA'],
    [0x2E1A, 0x2E1B, 'AL'],
    [0x2E1C, 0x2E1D, 'QU'],
    [0x2E1E, 0x2E1F, 'AL'],
    [0x2E20, 0x2E21, 'QU'],
    [0x2E22, 0x2E22, 'OP'],
    [0x2E23, 0x2E23, 'CL'],
    [0x2E24, 0x2E24, 'OP'],
    [0x2E25, 0x2E25, 'CL'],
    [0x2E26, 0x2E26, 'OP'],
    [0x2E27, 0x2E27, 'CL'],
    [0x2E28, 0x2E28, 'OP'],
    [0x2E29, 0x2E29, 'CL'],
    [0x2E2A, 0x2E2D, 'BA'],
    [0x2E2E, 0x2E2E, 'EX'],
    [0x2E2F, 0x2E2F, 'AL'],
    [0x2E30, 0x2E30, 'BA'],
    [0x2E80, 0x2E99, 'ID'],
    [0x2E9B, 0x2EF3, 'ID'],
    [0x2F00, 0x2FD5, 'ID'],
    [0x2FF0, 0x2FFB, 'ID'],
    [0x3000, 0x3000, 'ID'],
    [0x3001, 0x3002, 'CL'],
    [0x3003, 0x3004, 'ID'],
    [0x3005, 0x3005, 'NS'],
    [0x3006, 0x3007, 'ID'],
    [0x3008, 0x3008, 'OP'],
    [0x3009, 0x3009, 'CL'],
    [0x300A, 0x300A, 'OP'],
    [0x300B, 0x300B, 'CL'],
    [0x300C, 0x300C, 'OP'],
    [0x300D, 0x300D, 'CL'],
    [0x300E, 0x300E, 'OP'],
    [0x300F, 0x300F, 'CL'],
    [0x3010, 0x3010, 'OP'],
    [0x3011, 0x3011, 'CL'],
    [0x3012, 0x3013, 'ID'],
    [0x3014, 0x3014, 'OP'],
    [0x3015, 0x3015, 'CL'],
    [0x3016, 0x3016, 'OP'],
    [0x3017, 0x3017, 'CL'],
    [0x3018, 0x3018, 'OP'],
    [0x3019, 0x3019, 'CL'],
    [0x301A, 0x301A, 'OP'],
    [0x301B, 0x301B, 'CL'],
    [0x301C, 0x301C, 'NS'],
    [0x301D, 0x301D, 'OP'],
    [0x301E, 0x301F, 'CL'],
    [0x3020, 0x3029, 'ID'],
    [0x302A, 0x302F, 'CM'],
    [0x3030, 0x303A, 'ID'],
    [0x303B, 0x303C, 'NS'],
    [0x303D, 0x303F, 'ID'],
    [0x3041, 0x3041, 'NSid'],
    [0x3042, 0x3042, 'ID'],
    [0x3043, 0x3043, 'NSid'],
    [0x3044, 0x3044, 'ID'],
    [0x3045, 0x3045, 'NSid'],
    [0x3046, 0x3046, 'ID'],
    [0x3047, 0x3047, 'NSid'],
    [0x3048, 0x3048, 'ID'],
    [0x3049, 0x3049, 'NSid'],
    [0x304A, 0x3062, 'ID'],
    [0x3063, 0x3063, 'NSid'],
    [0x3064, 0x3082, 'ID'],
    [0x3083, 0x3083, 'NSid'],
    [0x3084, 0x3084, 'ID'],
    [0x3085, 0x3085, 'NSid'],
    [0x3086, 0x3086, 'ID'],
    [0x3087, 0x3087, 'NSid'],
    [0x3088, 0x308D, 'ID'],
    [0x308E, 0x308E, 'NSid'],
    [0x308F, 0x3094, 'ID'],
    [0x3095, 0x3096, 'NSid'],
    [0x3099, 0x309A, 'CM'],
    [0x309B, 0x309E, 'NS'],
    [0x309F, 0x309F, 'ID'],
    [0x30A0, 0x30A0, 'NS'],
    [0x30A1, 0x30A1, 'NSid'],
    [0x30A2, 0x30A2, 'ID'],
    [0x30A3, 0x30A3, 'NSid'],
    [0x30A4, 0x30A4, 'ID'],
    [0x30A5, 0x30A5, 'NSid'],
    [0x30A6, 0x30A6, 'ID'],
    [0x30A7, 0x30A7, 'NSid'],
    [0x30A8, 0x30A8, 'ID'],
    [0x30A9, 0x30A9, 'NSid'],
    [0x30AA, 0x30C2, 'ID'],
    [0x30C3, 0x30C3, 'NSid'],
    [0x30C4, 0x30E2, 'ID'],
    [0x30E3, 0x30E3, 'NSid'],
    [0x30E4, 0x30E4, 'ID'],
    [0x30E5, 0x30E5, 'NSid'],
    [0x30E6, 0x30E6, 'ID'],
    [0x30E7, 0x30E7, 'NSid'],
    [0x30E8, 0x30ED, 'ID'],
    [0x30EE, 0x30EE, 'NSid'],
    [0x30EF, 0x30F4, 'ID'],
    [0x30F5, 0x30F6, 'NSid'],
    [0x30F7, 0x30FA, 'ID'],
    [0x30FB, 0x30FB, 'NS'],
    [0x30FC, 0x30FC, 'NSid'],
    [0x30FD, 0x30FE, 'NS'],
    [0x30FF, 0x30FF, 'ID'],
    [0x3105, 0x312D, 'ID'],
    [0x3131, 0x318E, 'ID'],
    [0x3190, 0x31B7, 'ID'],
    [0x31C0, 0x31E3, 'ID'],
    [0x31F0, 0x31FF, 'NSid'],
    [0x3200, 0x321E, 'ID'],
    [0x3220, 0x3243, 'ID'],
    [0x3250, 0x32FE, 'ID'],
    [0x3300, 0x4DB5, 'ID'],
    [0x4DC0, 0x4DFF, 'AL'],
    [0x4E00, 0x9FC3, 'ID'],
    [0xA000, 0xA014, 'ID'],
    [0xA015, 0xA015, 'NS'],
    [0xA016, 0xA48C, 'ID'],
    [0xA490, 0xA4C6, 'ID'],
    [0xA500, 0xA60C, 'AL'],
    [0xA60D, 0xA60D, 'BA'],
    [0xA60E, 0xA60E, 'EX'],
    [0xA60F, 0xA60F, 'BA'],
    [0xA610, 0xA61F, 'AL'],
    [0xA620, 0xA629, 'NU'],
    [0xA62A, 0xA62B, 'AL'],
    [0xA640, 0xA65F, 'AL'],
    [0xA662, 0xA66E, 'AL'],
    [0xA66F, 0xA672, 'CM'],
    [0xA673, 0xA673, 'AL'],
    [0xA67C, 0xA67D, 'CM'],
    [0xA67E, 0xA697, 'AL'],
    [0xA700, 0xA78C, 'AL'],
    [0xA7FB, 0xA801, 'AL'],
    [0xA802, 0xA802, 'CM'],
    [0xA803, 0xA805, 'AL'],
    [0xA806, 0xA806, 'CM'],
    [0xA807, 0xA80A, 'AL'],
    [0xA80B, 0xA80B, 'CM'],
    [0xA80C, 0xA822, 'AL'],
    [0xA823, 0xA827, 'CM'],
    [0xA828, 0xA82B, 'AL'],
    [0xA840, 0xA873, 'AL'],
    [0xA874, 0xA875, 'BB'],
    [0xA876, 0xA877, 'EX'],
    [0xA880, 0xA881, 'CM'],
    [0xA882, 0xA8B3, 'AL'],
    [0xA8B4, 0xA8C4, 'CM'],
    [0xA8CE, 0xA8CF, 'BA'],
    [0xA8D0, 0xA8D9, 'NU'],
    [0xA900, 0xA909, 'NU'],
    [0xA90A, 0xA925, 'AL'],
    [0xA926, 0xA92D, 'CM'],
    [0xA92E, 0xA92F, 'BA'],
    [0xA930, 0xA946, 'AL'],
    [0xA947, 0xA953, 'CM'],
    [0xA95F, 0xA95F, 'AL'],
    [0xAA00, 0xAA28, 'AL'],
    [0xAA29, 0xAA36, 'CM'],
    [0xAA40, 0xAA42, 'AL'],
    [0xAA43, 0xAA43, 'CM'],
    [0xAA44, 0xAA4B, 'AL'],
    [0xAA4C, 0xAA4D, 'CM'],
    [0xAA50, 0xAA59, 'NU'],
    [0xAA5C, 0xAA5C, 'AL'],
    [0xAA5D, 0xAA5F, 'BA'],
    [0xAC00, 0xAC00, 'H2'],
    [0xAC01, 0xAC1B, 'H3'],
    [0xAC1C, 0xAC1C, 'H2'],
    [0xAC1D, 0xAC37, 'H3'],
    [0xAC38, 0xAC38, 'H2'],
    [0xAC39, 0xAC53, 'H3'],
    [0xAC54, 0xAC54, 'H2'],
    [0xAC55, 0xAC6F, 'H3'],
    [0xAC70, 0xAC70, 'H2'],
    [0xAC71, 0xAC8B, 'H3'],
    [0xAC8C, 0xAC8C, 'H2'],
    [0xAC8D, 0xACA7, 'H3'],
    [0xACA8, 0xACA8, 'H2'],
    [0xACA9, 0xACC3, 'H3'],
    [0xACC4, 0xACC4, 'H2'],
    [0xACC5, 0xACDF, 'H3'],
    [0xACE0, 0xACE0, 'H2'],
    [0xACE1, 0xACFB, 'H3'],
    [0xACFC, 0xACFC, 'H2'],
    [0xACFD, 0xAD17, 'H3'],
    [0xAD18, 0xAD18, 'H2'],
    [0xAD19, 0xAD33, 'H3'],
    [0xAD34, 0xAD34, 'H2'],
    [0xAD35, 0xAD4F, 'H3'],
    [0xAD50, 0xAD50, 'H2'],
    [0xAD51, 0xAD6B, 'H3'],
    [0xAD6C, 0xAD6C, 'H2'],
    [0xAD6D, 0xAD87, 'H3'],
    [0xAD88, 0xAD88, 'H2'],
    [0xAD89, 0xADA3, 'H3'],
    [0xADA4, 0xADA4, 'H2'],
    [0xADA5, 0xADBF, 'H3'],
    [0xADC0, 0xADC0, 'H2'],
    [0xADC1, 0xADDB, 'H3'],
    [0xADDC, 0xADDC, 'H2'],
    [0xADDD, 0xADF7, 'H3'],
    [0xADF8, 0xADF8, 'H2'],
    [0xADF9, 0xAE13, 'H3'],
    [0xAE14, 0xAE14, 'H2'],
    [0xAE15, 0xAE2F, 'H3'],
    [0xAE30, 0xAE30, 'H2'],
    [0xAE31, 0xAE4B, 'H3'],
    [0xAE4C, 0xAE4C, 'H2'],
    [0xAE4D, 0xAE67, 'H3'],
    [0xAE68, 0xAE68, 'H2'],
    [0xAE69, 0xAE83, 'H3'],
    [0xAE84, 0xAE84, 'H2'],
    [0xAE85, 0xAE9F, 'H3'],
    [0xAEA0, 0xAEA0, 'H2'],
    [0xAEA1, 0xAEBB, 'H3'],
    [0xAEBC, 0xAEBC, 'H2'],
    [0xAEBD, 0xAED7, 'H3'],
    [0xAED8, 0xAED8, 'H2'],
    [0xAED9, 0xAEF3, 'H3'],
    [0xAEF4, 0xAEF4, 'H2'],
    [0xAEF5, 0xAF0F, 'H3'],
    [0xAF10, 0xAF10, 'H2'],
    [0xAF11, 0xAF2B, 'H3'],
    [0xAF2C, 0xAF2C, 'H2'],
    [0xAF2D, 0xAF47, 'H3'],
    [0xAF48, 0xAF48, 'H2'],
    [0xAF49, 0xAF63, 'H3'],
    [0xAF64, 0xAF64, 'H2'],
    [0xAF65, 0xAF7F, 'H3'],
    [0xAF80, 0xAF80, 'H2'],
    [0xAF81, 0xAF9B, 'H3'],
    [0xAF9C, 0xAF9C, 'H2'],
    [0xAF9D, 0xAFB7, 'H3'],
    [0xAFB8, 0xAFB8, 'H2'],
    [0xAFB9, 0xAFD3, 'H3'],
    [0xAFD4, 0xAFD4, 'H2'],
    [0xAFD5, 0xAFEF, 'H3'],
    [0xAFF0, 0xAFF0, 'H2'],
    [0xAFF1, 0xB00B, 'H3'],
    [0xB00C, 0xB00C, 'H2'],
    [0xB00D, 0xB027, 'H3'],
    [0xB028, 0xB028, 'H2'],
    [0xB029, 0xB043, 'H3'],
    [0xB044, 0xB044, 'H2'],
    [0xB045, 0xB05F, 'H3'],
    [0xB060, 0xB060, 'H2'],
    [0xB061, 0xB07B, 'H3'],
    [0xB07C, 0xB07C, 'H2'],
    [0xB07D, 0xB097, 'H3'],
    [0xB098, 0xB098, 'H2'],
    [0xB099, 0xB0B3, 'H3'],
    [0xB0B4, 0xB0B4, 'H2'],
    [0xB0B5, 0xB0CF, 'H3'],
    [0xB0D0, 0xB0D0, 'H2'],
    [0xB0D1, 0xB0EB, 'H3'],
    [0xB0EC, 0xB0EC, 'H2'],
    [0xB0ED, 0xB107, 'H3'],
    [0xB108, 0xB108, 'H2'],
    [0xB109, 0xB123, 'H3'],
    [0xB124, 0xB124, 'H2'],
    [0xB125, 0xB13F, 'H3'],
    [0xB140, 0xB140, 'H2'],
    [0xB141, 0xB15B, 'H3'],
    [0xB15C, 0xB15C, 'H2'],
    [0xB15D, 0xB177, 'H3'],
    [0xB178, 0xB178, 'H2'],
    [0xB179, 0xB193, 'H3'],
    [0xB194, 0xB194, 'H2'],
    [0xB195, 0xB1AF, 'H3'],
    [0xB1B0, 0xB1B0, 'H2'],
    [0xB1B1, 0xB1CB, 'H3'],
    [0xB1CC, 0xB1CC, 'H2'],
    [0xB1CD, 0xB1E7, 'H3'],
    [0xB1E8, 0xB1E8, 'H2'],
    [0xB1E9, 0xB203, 'H3'],
    [0xB204, 0xB204, 'H2'],
    [0xB205, 0xB21F, 'H3'],
    [0xB220, 0xB220, 'H2'],
    [0xB221, 0xB23B, 'H3'],
    [0xB23C, 0xB23C, 'H2'],
    [0xB23D, 0xB257, 'H3'],
    [0xB258, 0xB258, 'H2'],
    [0xB259, 0xB273, 'H3'],
    [0xB274, 0xB274, 'H2'],
    [0xB275, 0xB28F, 'H3'],
    [0xB290, 0xB290, 'H2'],
    [0xB291, 0xB2AB, 'H3'],
    [0xB2AC, 0xB2AC, 'H2'],
    [0xB2AD, 0xB2C7, 'H3'],
    [0xB2C8, 0xB2C8, 'H2'],
    [0xB2C9, 0xB2E3, 'H3'],
    [0xB2E4, 0xB2E4, 'H2'],
    [0xB2E5, 0xB2FF, 'H3'],
    [0xB300, 0xB300, 'H2'],
    [0xB301, 0xB31B, 'H3'],
    [0xB31C, 0xB31C, 'H2'],
    [0xB31D, 0xB337, 'H3'],
    [0xB338, 0xB338, 'H2'],
    [0xB339, 0xB353, 'H3'],
    [0xB354, 0xB354, 'H2'],
    [0xB355, 0xB36F, 'H3'],
    [0xB370, 0xB370, 'H2'],
    [0xB371, 0xB38B, 'H3'],
    [0xB38C, 0xB38C, 'H2'],
    [0xB38D, 0xB3A7, 'H3'],
    [0xB3A8, 0xB3A8, 'H2'],
    [0xB3A9, 0xB3C3, 'H3'],
    [0xB3C4, 0xB3C4, 'H2'],
    [0xB3C5, 0xB3DF, 'H3'],
    [0xB3E0, 0xB3E0, 'H2'],
    [0xB3E1, 0xB3FB, 'H3'],
    [0xB3FC, 0xB3FC, 'H2'],
    [0xB3FD, 0xB417, 'H3'],
    [0xB418, 0xB418, 'H2'],
    [0xB419, 0xB433, 'H3'],
    [0xB434, 0xB434, 'H2'],
    [0xB435, 0xB44F, 'H3'],
    [0xB450, 0xB450, 'H2'],
    [0xB451, 0xB46B, 'H3'],
    [0xB46C, 0xB46C, 'H2'],
    [0xB46D, 0xB487, 'H3'],
    [0xB488, 0xB488, 'H2'],
    [0xB489, 0xB4A3, 'H3'],
    [0xB4A4, 0xB4A4, 'H2'],
    [0xB4A5, 0xB4BF, 'H3'],
    [0xB4C0, 0xB4C0, 'H2'],
    [0xB4C1, 0xB4DB, 'H3'],
    [0xB4DC, 0xB4DC, 'H2'],
    [0xB4DD, 0xB4F7, 'H3'],
    [0xB4F8, 0xB4F8, 'H2'],
    [0xB4F9, 0xB513, 'H3'],
    [0xB514, 0xB514, 'H2'],
    [0xB515, 0xB52F, 'H3'],
    [0xB530, 0xB530, 'H2'],
    [0xB531, 0xB54B, 'H3'],
    [0xB54C, 0xB54C, 'H2'],
    [0xB54D, 0xB567, 'H3'],
    [0xB568, 0xB568, 'H2'],
    [0xB569, 0xB583, 'H3'],
    [0xB584, 0xB584, 'H2'],
    [0xB585, 0xB59F, 'H3'],
    [0xB5A0, 0xB5A0, 'H2'],
    [0xB5A1, 0xB5BB, 'H3'],
    [0xB5BC, 0xB5BC, 'H2'],
    [0xB5BD, 0xB5D7, 'H3'],
    [0xB5D8, 0xB5D8, 'H2'],
    [0xB5D9, 0xB5F3, 'H3'],
    [0xB5F4, 0xB5F4, 'H2'],
    [0xB5F5, 0xB60F, 'H3'],
    [0xB610, 0xB610, 'H2'],
    [0xB611, 0xB62B, 'H3'],
    [0xB62C, 0xB62C, 'H2'],
    [0xB62D, 0xB647, 'H3'],
    [0xB648, 0xB648, 'H2'],
    [0xB649, 0xB663, 'H3'],
    [0xB664, 0xB664, 'H2'],
    [0xB665, 0xB67F, 'H3'],
    [0xB680, 0xB680, 'H2'],
    [0xB681, 0xB69B, 'H3'],
    [0xB69C, 0xB69C, 'H2'],
    [0xB69D, 0xB6B7, 'H3'],
    [0xB6B8, 0xB6B8, 'H2'],
    [0xB6B9, 0xB6D3, 'H3'],
    [0xB6D4, 0xB6D4, 'H2'],
    [0xB6D5, 0xB6EF, 'H3'],
    [0xB6F0, 0xB6F0, 'H2'],
    [0xB6F1, 0xB70B, 'H3'],
    [0xB70C, 0xB70C, 'H2'],
    [0xB70D, 0xB727, 'H3'],
    [0xB728, 0xB728, 'H2'],
    [0xB729, 0xB743, 'H3'],
    [0xB744, 0xB744, 'H2'],
    [0xB745, 0xB75F, 'H3'],
    [0xB760, 0xB760, 'H2'],
    [0xB761, 0xB77B, 'H3'],
    [0xB77C, 0xB77C, 'H2'],
    [0xB77D, 0xB797, 'H3'],
    [0xB798, 0xB798, 'H2'],
    [0xB799, 0xB7B3, 'H3'],
    [0xB7B4, 0xB7B4, 'H2'],
    [0xB7B5, 0xB7CF, 'H3'],
    [0xB7D0, 0xB7D0, 'H2'],
    [0xB7D1, 0xB7EB, 'H3'],
    [0xB7EC, 0xB7EC, 'H2'],
    [0xB7ED, 0xB807, 'H3'],
    [0xB808, 0xB808, 'H2'],
    [0xB809, 0xB823, 'H3'],
    [0xB824, 0xB824, 'H2'],
    [0xB825, 0xB83F, 'H3'],
    [0xB840, 0xB840, 'H2'],
    [0xB841, 0xB85B, 'H3'],
    [0xB85C, 0xB85C, 'H2'],
    [0xB85D, 0xB877, 'H3'],
    [0xB878, 0xB878, 'H2'],
    [0xB879, 0xB893, 'H3'],
    [0xB894, 0xB894, 'H2'],
    [0xB895, 0xB8AF, 'H3'],
    [0xB8B0, 0xB8B0, 'H2'],
    [0xB8B1, 0xB8CB, 'H3'],
    [0xB8CC, 0xB8CC, 'H2'],
    [0xB8CD, 0xB8E7, 'H3'],
    [0xB8E8, 0xB8E8, 'H2'],
    [0xB8E9, 0xB903, 'H3'],
    [0xB904, 0xB904, 'H2'],
    [0xB905, 0xB91F, 'H3'],
    [0xB920, 0xB920, 'H2'],
    [0xB921, 0xB93B, 'H3'],
    [0xB93C, 0xB93C, 'H2'],
    [0xB93D, 0xB957, 'H3'],
    [0xB958, 0xB958, 'H2'],
    [0xB959, 0xB973, 'H3'],
    [0xB974, 0xB974, 'H2'],
    [0xB975, 0xB98F, 'H3'],
    [0xB990, 0xB990, 'H2'],
    [0xB991, 0xB9AB, 'H3'],
    [0xB9AC, 0xB9AC, 'H2'],
    [0xB9AD, 0xB9C7, 'H3'],
    [0xB9C8, 0xB9C8, 'H2'],
    [0xB9C9, 0xB9E3, 'H3'],
    [0xB9E4, 0xB9E4, 'H2'],
    [0xB9E5, 0xB9FF, 'H3'],
    [0xBA00, 0xBA00, 'H2'],
    [0xBA01, 0xBA1B, 'H3'],
    [0xBA1C, 0xBA1C, 'H2'],
    [0xBA1D, 0xBA37, 'H3'],
    [0xBA38, 0xBA38, 'H2'],
    [0xBA39, 0xBA53, 'H3'],
    [0xBA54, 0xBA54, 'H2'],
    [0xBA55, 0xBA6F, 'H3'],
    [0xBA70, 0xBA70, 'H2'],
    [0xBA71, 0xBA8B, 'H3'],
    [0xBA8C, 0xBA8C, 'H2'],
    [0xBA8D, 0xBAA7, 'H3'],
    [0xBAA8, 0xBAA8, 'H2'],
    [0xBAA9, 0xBAC3, 'H3'],
    [0xBAC4, 0xBAC4, 'H2'],
    [0xBAC5, 0xBADF, 'H3'],
    [0xBAE0, 0xBAE0, 'H2'],
    [0xBAE1, 0xBAFB, 'H3'],
    [0xBAFC, 0xBAFC, 'H2'],
    [0xBAFD, 0xBB17, 'H3'],
    [0xBB18, 0xBB18, 'H2'],
    [0xBB19, 0xBB33, 'H3'],
    [0xBB34, 0xBB34, 'H2'],
    [0xBB35, 0xBB4F, 'H3'],
    [0xBB50, 0xBB50, 'H2'],
    [0xBB51, 0xBB6B, 'H3'],
    [0xBB6C, 0xBB6C, 'H2'],
    [0xBB6D, 0xBB87, 'H3'],
    [0xBB88, 0xBB88, 'H2'],
    [0xBB89, 0xBBA3, 'H3'],
    [0xBBA4, 0xBBA4, 'H2'],
    [0xBBA5, 0xBBBF, 'H3'],
    [0xBBC0, 0xBBC0, 'H2'],
    [0xBBC1, 0xBBDB, 'H3'],
    [0xBBDC, 0xBBDC, 'H2'],
    [0xBBDD, 0xBBF7, 'H3'],
    [0xBBF8, 0xBBF8, 'H2'],
    [0xBBF9, 0xBC13, 'H3'],
    [0xBC14, 0xBC14, 'H2'],
    [0xBC15, 0xBC2F, 'H3'],
    [0xBC30, 0xBC30, 'H2'],
    [0xBC31, 0xBC4B, 'H3'],
    [0xBC4C, 0xBC4C, 'H2'],
    [0xBC4D, 0xBC67, 'H3'],
    [0xBC68, 0xBC68, 'H2'],
    [0xBC69, 0xBC83, 'H3'],
    [0xBC84, 0xBC84, 'H2'],
    [0xBC85, 0xBC9F, 'H3'],
    [0xBCA0, 0xBCA0, 'H2'],
    [0xBCA1, 0xBCBB, 'H3'],
    [0xBCBC, 0xBCBC, 'H2'],
    [0xBCBD, 0xBCD7, 'H3'],
    [0xBCD8, 0xBCD8, 'H2'],
    [0xBCD9, 0xBCF3, 'H3'],
    [0xBCF4, 0xBCF4, 'H2'],
    [0xBCF5, 0xBD0F, 'H3'],
    [0xBD10, 0xBD10, 'H2'],
    [0xBD11, 0xBD2B, 'H3'],
    [0xBD2C, 0xBD2C, 'H2'],
    [0xBD2D, 0xBD47, 'H3'],
    [0xBD48, 0xBD48, 'H2'],
    [0xBD49, 0xBD63, 'H3'],
    [0xBD64, 0xBD64, 'H2'],
    [0xBD65, 0xBD7F, 'H3'],
    [0xBD80, 0xBD80, 'H2'],
    [0xBD81, 0xBD9B, 'H3'],
    [0xBD9C, 0xBD9C, 'H2'],
    [0xBD9D, 0xBDB7, 'H3'],
    [0xBDB8, 0xBDB8, 'H2'],
    [0xBDB9, 0xBDD3, 'H3'],
    [0xBDD4, 0xBDD4, 'H2'],
    [0xBDD5, 0xBDEF, 'H3'],
    [0xBDF0, 0xBDF0, 'H2'],
    [0xBDF1, 0xBE0B, 'H3'],
    [0xBE0C, 0xBE0C, 'H2'],
    [0xBE0D, 0xBE27, 'H3'],
    [0xBE28, 0xBE28, 'H2'],
    [0xBE29, 0xBE43, 'H3'],
    [0xBE44, 0xBE44, 'H2'],
    [0xBE45, 0xBE5F, 'H3'],
    [0xBE60, 0xBE60, 'H2'],
    [0xBE61, 0xBE7B, 'H3'],
    [0xBE7C, 0xBE7C, 'H2'],
    [0xBE7D, 0xBE97, 'H3'],
    [0xBE98, 0xBE98, 'H2'],
    [0xBE99, 0xBEB3, 'H3'],
    [0xBEB4, 0xBEB4, 'H2'],
    [0xBEB5, 0xBECF, 'H3'],
    [0xBED0, 0xBED0, 'H2'],
    [0xBED1, 0xBEEB, 'H3'],
    [0xBEEC, 0xBEEC, 'H2'],
    [0xBEED, 0xBF07, 'H3'],
    [0xBF08, 0xBF08, 'H2'],
    [0xBF09, 0xBF23, 'H3'],
    [0xBF24, 0xBF24, 'H2'],
    [0xBF25, 0xBF3F, 'H3'],
    [0xBF40, 0xBF40, 'H2'],
    [0xBF41, 0xBF5B, 'H3'],
    [0xBF5C, 0xBF5C, 'H2'],
    [0xBF5D, 0xBF77, 'H3'],
    [0xBF78, 0xBF78, 'H2'],
    [0xBF79, 0xBF93, 'H3'],
    [0xBF94, 0xBF94, 'H2'],
    [0xBF95, 0xBFAF, 'H3'],
    [0xBFB0, 0xBFB0, 'H2'],
    [0xBFB1, 0xBFCB, 'H3'],
    [0xBFCC, 0xBFCC, 'H2'],
    [0xBFCD, 0xBFE7, 'H3'],
    [0xBFE8, 0xBFE8, 'H2'],
    [0xBFE9, 0xC003, 'H3'],
    [0xC004, 0xC004, 'H2'],
    [0xC005, 0xC01F, 'H3'],
    [0xC020, 0xC020, 'H2'],
    [0xC021, 0xC03B, 'H3'],
    [0xC03C, 0xC03C, 'H2'],
    [0xC03D, 0xC057, 'H3'],
    [0xC058, 0xC058, 'H2'],
    [0xC059, 0xC073, 'H3'],
    [0xC074, 0xC074, 'H2'],
    [0xC075, 0xC08F, 'H3'],
    [0xC090, 0xC090, 'H2'],
    [0xC091, 0xC0AB, 'H3'],
    [0xC0AC, 0xC0AC, 'H2'],
    [0xC0AD, 0xC0C7, 'H3'],
    [0xC0C8, 0xC0C8, 'H2'],
    [0xC0C9, 0xC0E3, 'H3'],
    [0xC0E4, 0xC0E4, 'H2'],
    [0xC0E5, 0xC0FF, 'H3'],
    [0xC100, 0xC100, 'H2'],
    [0xC101, 0xC11B, 'H3'],
    [0xC11C, 0xC11C, 'H2'],
    [0xC11D, 0xC137, 'H3'],
    [0xC138, 0xC138, 'H2'],
    [0xC139, 0xC153, 'H3'],
    [0xC154, 0xC154, 'H2'],
    [0xC155, 0xC16F, 'H3'],
    [0xC170, 0xC170, 'H2'],
    [0xC171, 0xC18B, 'H3'],
    [0xC18C, 0xC18C, 'H2'],
    [0xC18D, 0xC1A7, 'H3'],
    [0xC1A8, 0xC1A8, 'H2'],
    [0xC1A9, 0xC1C3, 'H3'],
    [0xC1C4, 0xC1C4, 'H2'],
    [0xC1C5, 0xC1DF, 'H3'],
    [0xC1E0, 0xC1E0, 'H2'],
    [0xC1E1, 0xC1FB, 'H3'],
    [0xC1FC, 0xC1FC, 'H2'],
    [0xC1FD, 0xC217, 'H3'],
    [0xC218, 0xC218, 'H2'],
    [0xC219, 0xC233, 'H3'],
    [0xC234, 0xC234, 'H2'],
    [0xC235, 0xC24F, 'H3'],
    [0xC250, 0xC250, 'H2'],
    [0xC251, 0xC26B, 'H3'],
    [0xC26C, 0xC26C, 'H2'],
    [0xC26D, 0xC287, 'H3'],
    [0xC288, 0xC288, 'H2'],
    [0xC289, 0xC2A3, 'H3'],
    [0xC2A4, 0xC2A4, 'H2'],
    [0xC2A5, 0xC2BF, 'H3'],
    [0xC2C0, 0xC2C0, 'H2'],
    [0xC2C1, 0xC2DB, 'H3'],
    [0xC2DC, 0xC2DC, 'H2'],
    [0xC2DD, 0xC2F7, 'H3'],
    [0xC2F8, 0xC2F8, 'H2'],
    [0xC2F9, 0xC313, 'H3'],
    [0xC314, 0xC314, 'H2'],
    [0xC315, 0xC32F, 'H3'],
    [0xC330, 0xC330, 'H2'],
    [0xC331, 0xC34B, 'H3'],
    [0xC34C, 0xC34C, 'H2'],
    [0xC34D, 0xC367, 'H3'],
    [0xC368, 0xC368, 'H2'],
    [0xC369, 0xC383, 'H3'],
    [0xC384, 0xC384, 'H2'],
    [0xC385, 0xC39F, 'H3'],
    [0xC3A0, 0xC3A0, 'H2'],
    [0xC3A1, 0xC3BB, 'H3'],
    [0xC3BC, 0xC3BC, 'H2'],
    [0xC3BD, 0xC3D7, 'H3'],
    [0xC3D8, 0xC3D8, 'H2'],
    [0xC3D9, 0xC3F3, 'H3'],
    [0xC3F4, 0xC3F4, 'H2'],
    [0xC3F5, 0xC40F, 'H3'],
    [0xC410, 0xC410, 'H2'],
    [0xC411, 0xC42B, 'H3'],
    [0xC42C, 0xC42C, 'H2'],
    [0xC42D, 0xC447, 'H3'],
    [0xC448, 0xC448, 'H2'],
    [0xC449, 0xC463, 'H3'],
    [0xC464, 0xC464, 'H2'],
    [0xC465, 0xC47F, 'H3'],
    [0xC480, 0xC480, 'H2'],
    [0xC481, 0xC49B, 'H3'],
    [0xC49C, 0xC49C, 'H2'],
    [0xC49D, 0xC4B7, 'H3'],
    [0xC4B8, 0xC4B8, 'H2'],
    [0xC4B9, 0xC4D3, 'H3'],
    [0xC4D4, 0xC4D4, 'H2'],
    [0xC4D5, 0xC4EF, 'H3'],
    [0xC4F0, 0xC4F0, 'H2'],
    [0xC4F1, 0xC50B, 'H3'],
    [0xC50C, 0xC50C, 'H2'],
    [0xC50D, 0xC527, 'H3'],
    [0xC528, 0xC528, 'H2'],
    [0xC529, 0xC543, 'H3'],
    [0xC544, 0xC544, 'H2'],
    [0xC545, 0xC55F, 'H3'],
    [0xC560, 0xC560, 'H2'],
    [0xC561, 0xC57B, 'H3'],
    [0xC57C, 0xC57C, 'H2'],
    [0xC57D, 0xC597, 'H3'],
    [0xC598, 0xC598, 'H2'],
    [0xC599, 0xC5B3, 'H3'],
    [0xC5B4, 0xC5B4, 'H2'],
    [0xC5B5, 0xC5CF, 'H3'],
    [0xC5D0, 0xC5D0, 'H2'],
    [0xC5D1, 0xC5EB, 'H3'],
    [0xC5EC, 0xC5EC, 'H2'],
    [0xC5ED, 0xC607, 'H3'],
    [0xC608, 0xC608, 'H2'],
    [0xC609, 0xC623, 'H3'],
    [0xC624, 0xC624, 'H2'],
    [0xC625, 0xC63F, 'H3'],
    [0xC640, 0xC640, 'H2'],
    [0xC641, 0xC65B, 'H3'],
    [0xC65C, 0xC65C, 'H2'],
    [0xC65D, 0xC677, 'H3'],
    [0xC678, 0xC678, 'H2'],
    [0xC679, 0xC693, 'H3'],
    [0xC694, 0xC694, 'H2'],
    [0xC695, 0xC6AF, 'H3'],
    [0xC6B0, 0xC6B0, 'H2'],
    [0xC6B1, 0xC6CB, 'H3'],
    [0xC6CC, 0xC6CC, 'H2'],
    [0xC6CD, 0xC6E7, 'H3'],
    [0xC6E8, 0xC6E8, 'H2'],
    [0xC6E9, 0xC703, 'H3'],
    [0xC704, 0xC704, 'H2'],
    [0xC705, 0xC71F, 'H3'],
    [0xC720, 0xC720, 'H2'],
    [0xC721, 0xC73B, 'H3'],
    [0xC73C, 0xC73C, 'H2'],
    [0xC73D, 0xC757, 'H3'],
    [0xC758, 0xC758, 'H2'],
    [0xC759, 0xC773, 'H3'],
    [0xC774, 0xC774, 'H2'],
    [0xC775, 0xC78F, 'H3'],
    [0xC790, 0xC790, 'H2'],
    [0xC791, 0xC7AB, 'H3'],
    [0xC7AC, 0xC7AC, 'H2'],
    [0xC7AD, 0xC7C7, 'H3'],
    [0xC7C8, 0xC7C8, 'H2'],
    [0xC7C9, 0xC7E3, 'H3'],
    [0xC7E4, 0xC7E4, 'H2'],
    [0xC7E5, 0xC7FF, 'H3'],
    [0xC800, 0xC800, 'H2'],
    [0xC801, 0xC81B, 'H3'],
    [0xC81C, 0xC81C, 'H2'],
    [0xC81D, 0xC837, 'H3'],
    [0xC838, 0xC838, 'H2'],
    [0xC839, 0xC853, 'H3'],
    [0xC854, 0xC854, 'H2'],
    [0xC855, 0xC86F, 'H3'],
    [0xC870, 0xC870, 'H2'],
    [0xC871, 0xC88B, 'H3'],
    [0xC88C, 0xC88C, 'H2'],
    [0xC88D, 0xC8A7, 'H3'],
    [0xC8A8, 0xC8A8, 'H2'],
    [0xC8A9, 0xC8C3, 'H3'],
    [0xC8C4, 0xC8C4, 'H2'],
    [0xC8C5, 0xC8DF, 'H3'],
    [0xC8E0, 0xC8E0, 'H2'],
    [0xC8E1, 0xC8FB, 'H3'],
    [0xC8FC, 0xC8FC, 'H2'],
    [0xC8FD, 0xC917, 'H3'],
    [0xC918, 0xC918, 'H2'],
    [0xC919, 0xC933, 'H3'],
    [0xC934, 0xC934, 'H2'],
    [0xC935, 0xC94F, 'H3'],
    [0xC950, 0xC950, 'H2'],
    [0xC951, 0xC96B, 'H3'],
    [0xC96C, 0xC96C, 'H2'],
    [0xC96D, 0xC987, 'H3'],
    [0xC988, 0xC988, 'H2'],
    [0xC989, 0xC9A3, 'H3'],
    [0xC9A4, 0xC9A4, 'H2'],
    [0xC9A5, 0xC9BF, 'H3'],
    [0xC9C0, 0xC9C0, 'H2'],
    [0xC9C1, 0xC9DB, 'H3'],
    [0xC9DC, 0xC9DC, 'H2'],
    [0xC9DD, 0xC9F7, 'H3'],
    [0xC9F8, 0xC9F8, 'H2'],
    [0xC9F9, 0xCA13, 'H3'],
    [0xCA14, 0xCA14, 'H2'],
    [0xCA15, 0xCA2F, 'H3'],
    [0xCA30, 0xCA30, 'H2'],
    [0xCA31, 0xCA4B, 'H3'],
    [0xCA4C, 0xCA4C, 'H2'],
    [0xCA4D, 0xCA67, 'H3'],
    [0xCA68, 0xCA68, 'H2'],
    [0xCA69, 0xCA83, 'H3'],
    [0xCA84, 0xCA84, 'H2'],
    [0xCA85, 0xCA9F, 'H3'],
    [0xCAA0, 0xCAA0, 'H2'],
    [0xCAA1, 0xCABB, 'H3'],
    [0xCABC, 0xCABC, 'H2'],
    [0xCABD, 0xCAD7, 'H3'],
    [0xCAD8, 0xCAD8, 'H2'],
    [0xCAD9, 0xCAF3, 'H3'],
    [0xCAF4, 0xCAF4, 'H2'],
    [0xCAF5, 0xCB0F, 'H3'],
    [0xCB10, 0xCB10, 'H2'],
    [0xCB11, 0xCB2B, 'H3'],
    [0xCB2C, 0xCB2C, 'H2'],
    [0xCB2D, 0xCB47, 'H3'],
    [0xCB48, 0xCB48, 'H2'],
    [0xCB49, 0xCB63, 'H3'],
    [0xCB64, 0xCB64, 'H2'],
    [0xCB65, 0xCB7F, 'H3'],
    [0xCB80, 0xCB80, 'H2'],
    [0xCB81, 0xCB9B, 'H3'],
    [0xCB9C, 0xCB9C, 'H2'],
    [0xCB9D, 0xCBB7, 'H3'],
    [0xCBB8, 0xCBB8, 'H2'],
    [0xCBB9, 0xCBD3, 'H3'],
    [0xCBD4, 0xCBD4, 'H2'],
    [0xCBD5, 0xCBEF, 'H3'],
    [0xCBF0, 0xCBF0, 'H2'],
    [0xCBF1, 0xCC0B, 'H3'],
    [0xCC0C, 0xCC0C, 'H2'],
    [0xCC0D, 0xCC27, 'H3'],
    [0xCC28, 0xCC28, 'H2'],
    [0xCC29, 0xCC43, 'H3'],
    [0xCC44, 0xCC44, 'H2'],
    [0xCC45, 0xCC5F, 'H3'],
    [0xCC60, 0xCC60, 'H2'],
    [0xCC61, 0xCC7B, 'H3'],
    [0xCC7C, 0xCC7C, 'H2'],
    [0xCC7D, 0xCC97, 'H3'],
    [0xCC98, 0xCC98, 'H2'],
    [0xCC99, 0xCCB3, 'H3'],
    [0xCCB4, 0xCCB4, 'H2'],
    [0xCCB5, 0xCCCF, 'H3'],
    [0xCCD0, 0xCCD0, 'H2'],
    [0xCCD1, 0xCCEB, 'H3'],
    [0xCCEC, 0xCCEC, 'H2'],
    [0xCCED, 0xCD07, 'H3'],
    [0xCD08, 0xCD08, 'H2'],
    [0xCD09, 0xCD23, 'H3'],
    [0xCD24, 0xCD24, 'H2'],
    [0xCD25, 0xCD3F, 'H3'],
    [0xCD40, 0xCD40, 'H2'],
    [0xCD41, 0xCD5B, 'H3'],
    [0xCD5C, 0xCD5C, 'H2'],
    [0xCD5D, 0xCD77, 'H3'],
    [0xCD78, 0xCD78, 'H2'],
    [0xCD79, 0xCD93, 'H3'],
    [0xCD94, 0xCD94, 'H2'],
    [0xCD95, 0xCDAF, 'H3'],
    [0xCDB0, 0xCDB0, 'H2'],
    [0xCDB1, 0xCDCB, 'H3'],
    [0xCDCC, 0xCDCC, 'H2'],
    [0xCDCD, 0xCDE7, 'H3'],
    [0xCDE8, 0xCDE8, 'H2'],
    [0xCDE9, 0xCE03, 'H3'],
    [0xCE04, 0xCE04, 'H2'],
    [0xCE05, 0xCE1F, 'H3'],
    [0xCE20, 0xCE20, 'H2'],
    [0xCE21, 0xCE3B, 'H3'],
    [0xCE3C, 0xCE3C, 'H2'],
    [0xCE3D, 0xCE57, 'H3'],
    [0xCE58, 0xCE58, 'H2'],
    [0xCE59, 0xCE73, 'H3'],
    [0xCE74, 0xCE74, 'H2'],
    [0xCE75, 0xCE8F, 'H3'],
    [0xCE90, 0xCE90, 'H2'],
    [0xCE91, 0xCEAB, 'H3'],
    [0xCEAC, 0xCEAC, 'H2'],
    [0xCEAD, 0xCEC7, 'H3'],
    [0xCEC8, 0xCEC8, 'H2'],
    [0xCEC9, 0xCEE3, 'H3'],
    [0xCEE4, 0xCEE4, 'H2'],
    [0xCEE5, 0xCEFF, 'H3'],
    [0xCF00, 0xCF00, 'H2'],
    [0xCF01, 0xCF1B, 'H3'],
    [0xCF1C, 0xCF1C, 'H2'],
    [0xCF1D, 0xCF37, 'H3'],
    [0xCF38, 0xCF38, 'H2'],
    [0xCF39, 0xCF53, 'H3'],
    [0xCF54, 0xCF54, 'H2'],
    [0xCF55, 0xCF6F, 'H3'],
    [0xCF70, 0xCF70, 'H2'],
    [0xCF71, 0xCF8B, 'H3'],
    [0xCF8C, 0xCF8C, 'H2'],
    [0xCF8D, 0xCFA7, 'H3'],
    [0xCFA8, 0xCFA8, 'H2'],
    [0xCFA9, 0xCFC3, 'H3'],
    [0xCFC4, 0xCFC4, 'H2'],
    [0xCFC5, 0xCFDF, 'H3'],
    [0xCFE0, 0xCFE0, 'H2'],
    [0xCFE1, 0xCFFB, 'H3'],
    [0xCFFC, 0xCFFC, 'H2'],
    [0xCFFD, 0xD017, 'H3'],
    [0xD018, 0xD018, 'H2'],
    [0xD019, 0xD033, 'H3'],
    [0xD034, 0xD034, 'H2'],
    [0xD035, 0xD04F, 'H3'],
    [0xD050, 0xD050, 'H2'],
    [0xD051, 0xD06B, 'H3'],
    [0xD06C, 0xD06C, 'H2'],
    [0xD06D, 0xD087, 'H3'],
    [0xD088, 0xD088, 'H2'],
    [0xD089, 0xD0A3, 'H3'],
    [0xD0A4, 0xD0A4, 'H2'],
    [0xD0A5, 0xD0BF, 'H3'],
    [0xD0C0, 0xD0C0, 'H2'],
    [0xD0C1, 0xD0DB, 'H3'],
    [0xD0DC, 0xD0DC, 'H2'],
    [0xD0DD, 0xD0F7, 'H3'],
    [0xD0F8, 0xD0F8, 'H2'],
    [0xD0F9, 0xD113, 'H3'],
    [0xD114, 0xD114, 'H2'],
    [0xD115, 0xD12F, 'H3'],
    [0xD130, 0xD130, 'H2'],
    [0xD131, 0xD14B, 'H3'],
    [0xD14C, 0xD14C, 'H2'],
    [0xD14D, 0xD167, 'H3'],
    [0xD168, 0xD168, 'H2'],
    [0xD169, 0xD183, 'H3'],
    [0xD184, 0xD184, 'H2'],
    [0xD185, 0xD19F, 'H3'],
    [0xD1A0, 0xD1A0, 'H2'],
    [0xD1A1, 0xD1BB, 'H3'],
    [0xD1BC, 0xD1BC, 'H2'],
    [0xD1BD, 0xD1D7, 'H3'],
    [0xD1D8, 0xD1D8, 'H2'],
    [0xD1D9, 0xD1F3, 'H3'],
    [0xD1F4, 0xD1F4, 'H2'],
    [0xD1F5, 0xD20F, 'H3'],
    [0xD210, 0xD210, 'H2'],
    [0xD211, 0xD22B, 'H3'],
    [0xD22C, 0xD22C, 'H2'],
    [0xD22D, 0xD247, 'H3'],
    [0xD248, 0xD248, 'H2'],
    [0xD249, 0xD263, 'H3'],
    [0xD264, 0xD264, 'H2'],
    [0xD265, 0xD27F, 'H3'],
    [0xD280, 0xD280, 'H2'],
    [0xD281, 0xD29B, 'H3'],
    [0xD29C, 0xD29C, 'H2'],
    [0xD29D, 0xD2B7, 'H3'],
    [0xD2B8, 0xD2B8, 'H2'],
    [0xD2B9, 0xD2D3, 'H3'],
    [0xD2D4, 0xD2D4, 'H2'],
    [0xD2D5, 0xD2EF, 'H3'],
    [0xD2F0, 0xD2F0, 'H2'],
    [0xD2F1, 0xD30B, 'H3'],
    [0xD30C, 0xD30C, 'H2'],
    [0xD30D, 0xD327, 'H3'],
    [0xD328, 0xD328, 'H2'],
    [0xD329, 0xD343, 'H3'],
    [0xD344, 0xD344, 'H2'],
    [0xD345, 0xD35F, 'H3'],
    [0xD360, 0xD360, 'H2'],
    [0xD361, 0xD37B, 'H3'],
    [0xD37C, 0xD37C, 'H2'],
    [0xD37D, 0xD397, 'H3'],
    [0xD398, 0xD398, 'H2'],
    [0xD399, 0xD3B3, 'H3'],
    [0xD3B4, 0xD3B4, 'H2'],
    [0xD3B5, 0xD3CF, 'H3'],
    [0xD3D0, 0xD3D0, 'H2'],
    [0xD3D1, 0xD3EB, 'H3'],
    [0xD3EC, 0xD3EC, 'H2'],
    [0xD3ED, 0xD407, 'H3'],
    [0xD408, 0xD408, 'H2'],
    [0xD409, 0xD423, 'H3'],
    [0xD424, 0xD424, 'H2'],
    [0xD425, 0xD43F, 'H3'],
    [0xD440, 0xD440, 'H2'],
    [0xD441, 0xD45B, 'H3'],
    [0xD45C, 0xD45C, 'H2'],
    [0xD45D, 0xD477, 'H3'],
    [0xD478, 0xD478, 'H2'],
    [0xD479, 0xD493, 'H3'],
    [0xD494, 0xD494, 'H2'],
    [0xD495, 0xD4AF, 'H3'],
    [0xD4B0, 0xD4B0, 'H2'],
    [0xD4B1, 0xD4CB, 'H3'],
    [0xD4CC, 0xD4CC, 'H2'],
    [0xD4CD, 0xD4E7, 'H3'],
    [0xD4E8, 0xD4E8, 'H2'],
    [0xD4E9, 0xD503, 'H3'],
    [0xD504, 0xD504, 'H2'],
    [0xD505, 0xD51F, 'H3'],
    [0xD520, 0xD520, 'H2'],
    [0xD521, 0xD53B, 'H3'],
    [0xD53C, 0xD53C, 'H2'],
    [0xD53D, 0xD557, 'H3'],
    [0xD558, 0xD558, 'H2'],
    [0xD559, 0xD573, 'H3'],
    [0xD574, 0xD574, 'H2'],
    [0xD575, 0xD58F, 'H3'],
    [0xD590, 0xD590, 'H2'],
    [0xD591, 0xD5AB, 'H3'],
    [0xD5AC, 0xD5AC, 'H2'],
    [0xD5AD, 0xD5C7, 'H3'],
    [0xD5C8, 0xD5C8, 'H2'],
    [0xD5C9, 0xD5E3, 'H3'],
    [0xD5E4, 0xD5E4, 'H2'],
    [0xD5E5, 0xD5FF, 'H3'],
    [0xD600, 0xD600, 'H2'],
    [0xD601, 0xD61B, 'H3'],
    [0xD61C, 0xD61C, 'H2'],
    [0xD61D, 0xD637, 'H3'],
    [0xD638, 0xD638, 'H2'],
    [0xD639, 0xD653, 'H3'],
    [0xD654, 0xD654, 'H2'],
    [0xD655, 0xD66F, 'H3'],
    [0xD670, 0xD670, 'H2'],
    [0xD671, 0xD68B, 'H3'],
    [0xD68C, 0xD68C, 'H2'],
    [0xD68D, 0xD6A7, 'H3'],
    [0xD6A8, 0xD6A8, 'H2'],
    [0xD6A9, 0xD6C3, 'H3'],
    [0xD6C4, 0xD6C4, 'H2'],
    [0xD6C5, 0xD6DF, 'H3'],
    [0xD6E0, 0xD6E0, 'H2'],
    [0xD6E1, 0xD6FB, 'H3'],
    [0xD6FC, 0xD6FC, 'H2'],
    [0xD6FD, 0xD717, 'H3'],
    [0xD718, 0xD718, 'H2'],
    [0xD719, 0xD733, 'H3'],
    [0xD734, 0xD734, 'H2'],
    [0xD735, 0xD74F, 'H3'],
    [0xD750, 0xD750, 'H2'],
    [0xD751, 0xD76B, 'H3'],
    [0xD76C, 0xD76C, 'H2'],
    [0xD76D, 0xD787, 'H3'],
    [0xD788, 0xD788, 'H2'],
    [0xD789, 0xD7A3, 'H3'],
    [0xD800, 0xDFFF, 'SG'],
    [0xE000, 0xF8FF, 'XX'],
    [0xF900, 0xFA2D, 'ID'],
    [0xFA30, 0xFA6A, 'ID'],
    [0xFA70, 0xFAD9, 'ID'],
    [0xFB00, 0xFB06, 'AL'],
    [0xFB13, 0xFB17, 'AL'],
    [0xFB1D, 0xFB1D, 'AL'],
    [0xFB1E, 0xFB1E, 'CM'],
    [0xFB1F, 0xFB36, 'AL'],
    [0xFB38, 0xFB3C, 'AL'],
    [0xFB3E, 0xFB3E, 'AL'],
    [0xFB40, 0xFB41, 'AL'],
    [0xFB43, 0xFB44, 'AL'],
    [0xFB46, 0xFBB1, 'AL'],
    [0xFBD3, 0xFD3D, 'AL'],
    [0xFD3E, 0xFD3E, 'OP'],
    [0xFD3F, 0xFD3F, 'CL'],
    [0xFD50, 0xFD8F, 'AL'],
    [0xFD92, 0xFDC7, 'AL'],
    [0xFDF0, 0xFDFB, 'AL'],
    [0xFDFC, 0xFDFC, 'PO'],
    [0xFDFD, 0xFDFD, 'AL'],
    [0xFE00, 0xFE0F, 'CM'],
    [0xFE10, 0xFE10, 'IS'],
    [0xFE11, 0xFE12, 'CL'],
    [0xFE13, 0xFE14, 'IS'],
    [0xFE15, 0xFE16, 'EX'],
    [0xFE17, 0xFE17, 'OP'],
    [0xFE18, 0xFE18, 'CL'],
    [0xFE19, 0xFE19, 'IN'],
    [0xFE20, 0xFE26, 'CM'],
    [0xFE30, 0xFE34, 'ID'],
    [0xFE35, 0xFE35, 'OP'],
    [0xFE36, 0xFE36, 'CL'],
    [0xFE37, 0xFE37, 'OP'],
    [0xFE38, 0xFE38, 'CL'],
    [0xFE39, 0xFE39, 'OP'],
    [0xFE3A, 0xFE3A, 'CL'],
    [0xFE3B, 0xFE3B, 'OP'],
    [0xFE3C, 0xFE3C, 'CL'],
    [0xFE3D, 0xFE3D, 'OP'],
    [0xFE3E, 0xFE3E, 'CL'],
    [0xFE3F, 0xFE3F, 'OP'],
    [0xFE40, 0xFE40, 'CL'],
    [0xFE41, 0xFE41, 'OP'],
    [0xFE42, 0xFE42, 'CL'],
    [0xFE43, 0xFE43, 'OP'],
    [0xFE44, 0xFE44, 'CL'],
    [0xFE45, 0xFE46, 'ID'],
    [0xFE47, 0xFE47, 'OP'],
    [0xFE48, 0xFE48, 'CL'],
    [0xFE49, 0xFE4F, 'ID'],
    [0xFE50, 0xFE50, 'CL'],
    [0xFE51, 0xFE51, 'ID'],
    [0xFE52, 0xFE52, 'CL'],
    [0xFE54, 0xFE55, 'NS'],
    [0xFE56, 0xFE57, 'EX'],
    [0xFE58, 0xFE58, 'ID'],
    [0xFE59, 0xFE59, 'OP'],
    [0xFE5A, 0xFE5A, 'CL'],
    [0xFE5B, 0xFE5B, 'OP'],
    [0xFE5C, 0xFE5C, 'CL'],
    [0xFE5D, 0xFE5D, 'OP'],
    [0xFE5E, 0xFE5E, 'CL'],
    [0xFE5F, 0xFE66, 'ID'],
    [0xFE68, 0xFE68, 'ID'],
    [0xFE69, 0xFE69, 'PR'],
    [0xFE6A, 0xFE6A, 'PO'],
    [0xFE6B, 0xFE6B, 'ID'],
    [0xFE70, 0xFE74, 'AL'],
    [0xFE76, 0xFEFC, 'AL'],
    [0xFEFF, 0xFEFF, 'WJ'],
    [0xFF01, 0xFF01, 'EX'],
    [0xFF02, 0xFF03, 'ID'],
    [0xFF04, 0xFF04, 'PR'],
    [0xFF05, 0xFF05, 'PO'],
    [0xFF06, 0xFF07, 'ID'],
    [0xFF08, 0xFF08, 'OP'],
    [0xFF09, 0xFF09, 'CL'],
    [0xFF0A, 0xFF0B, 'ID'],
    [0xFF0C, 0xFF0C, 'CL'],
    [0xFF0D, 0xFF0D, 'ID'],
    [0xFF0E, 0xFF0E, 'CL'],
    [0xFF0F, 0xFF19, 'ID'],
    [0xFF1A, 0xFF1B, 'NS'],
    [0xFF1C, 0xFF1E, 'ID'],
    [0xFF1F, 0xFF1F, 'EX'],
    [0xFF20, 0xFF3A, 'ID'],
    [0xFF3B, 0xFF3B, 'OP'],
    [0xFF3C, 0xFF3C, 'ID'],
    [0xFF3D, 0xFF3D, 'CL'],
    [0xFF3E, 0xFF5A, 'ID'],
    [0xFF5B, 0xFF5B, 'OP'],
    [0xFF5C, 0xFF5C, 'ID'],
    [0xFF5D, 0xFF5D, 'CL'],
    [0xFF5E, 0xFF5E, 'ID'],
    [0xFF5F, 0xFF5F, 'OP'],
    [0xFF60, 0xFF61, 'CL'],
    [0xFF62, 0xFF62, 'OP'],
    [0xFF63, 0xFF64, 'CL'],
    [0xFF65, 0xFF65, 'NS'],
    [0xFF66, 0xFF66, 'AL'],
    [0xFF67, 0xFF70, 'NSid'],
    [0xFF71, 0xFF9D, 'AL'],
    [0xFF9E, 0xFF9F, 'NS'],
    [0xFFA0, 0xFFBE, 'AL'],
    [0xFFC2, 0xFFC7, 'AL'],
    [0xFFCA, 0xFFCF, 'AL'],
    [0xFFD2, 0xFFD7, 'AL'],
    [0xFFDA, 0xFFDC, 'AL'],
    [0xFFE0, 0xFFE0, 'PO'],
    [0xFFE1, 0xFFE1, 'PR'],
    [0xFFE2, 0xFFE4, 'ID'],
    [0xFFE5, 0xFFE6, 'PR'],
    [0xFFE8, 0xFFEE, 'AL'],
    [0xFFF9, 0xFFFB, 'CM'],
    [0xFFFC, 0xFFFC, 'CB'],
    [0xFFFD, 0xFFFD, 'AI'],
    [0x10000, 0x1000B, 'AL'],
    [0x1000D, 0x10026, 'AL'],
    [0x10028, 0x1003A, 'AL'],
    [0x1003C, 0x1003D, 'AL'],
    [0x1003F, 0x1004D, 'AL'],
    [0x10050, 0x1005D, 'AL'],
    [0x10080, 0x100FA, 'AL'],
    [0x10100, 0x10102, 'BA'],
    [0x10107, 0x10133, 'AL'],
    [0x10137, 0x1018A, 'AL'],
    [0x10190, 0x1019B, 'AL'],
    [0x101D0, 0x101FC, 'AL'],
    [0x101FD, 0x101FD, 'CM'],
    [0x10280, 0x1029C, 'AL'],
    [0x102A0, 0x102D0, 'AL'],
    [0x10300, 0x1031E, 'AL'],
    [0x10320, 0x10323, 'AL'],
    [0x10330, 0x1034A, 'AL'],
    [0x10380, 0x1039D, 'AL'],
    [0x1039F, 0x1039F, 'BA'],
    [0x103A0, 0x103C3, 'AL'],
    [0x103C8, 0x103CF, 'AL'],
    [0x103D0, 0x103D0, 'BA'],
    [0x103D1, 0x103D5, 'AL'],
    [0x10400, 0x1049D, 'AL'],
    [0x104A0, 0x104A9, 'NU'],
    [0x10800, 0x10805, 'AL'],
    [0x10808, 0x10808, 'AL'],
    [0x1080A, 0x10835, 'AL'],
    [0x10837, 0x10838, 'AL'],
    [0x1083C, 0x1083C, 'AL'],
    [0x1083F, 0x1083F, 'AL'],
    [0x10900, 0x10919, 'AL'],
    [0x1091F, 0x1091F, 'BA'],
    [0x10920, 0x10939, 'AL'],
    [0x1093F, 0x1093F, 'AL'],
    [0x10A00, 0x10A00, 'AL'],
    [0x10A01, 0x10A03, 'CM'],
    [0x10A05, 0x10A06, 'CM'],
    [0x10A0C, 0x10A0F, 'CM'],
    [0x10A10, 0x10A13, 'AL'],
    [0x10A15, 0x10A17, 'AL'],
    [0x10A19, 0x10A33, 'AL'],
    [0x10A38, 0x10A3A, 'CM'],
    [0x10A3F, 0x10A3F, 'CM'],
    [0x10A40, 0x10A47, 'AL'],
    [0x10A50, 0x10A57, 'BA'],
    [0x10A58, 0x10A58, 'AL'],
    [0x12000, 0x1236E, 'AL'],
    [0x12400, 0x12462, 'AL'],
    [0x12470, 0x12473, 'BA'],
    [0x1D000, 0x1D0F5, 'AL'],
    [0x1D100, 0x1D126, 'AL'],
    [0x1D129, 0x1D164, 'AL'],
    [0x1D165, 0x1D169, 'CM'],
    [0x1D16A, 0x1D16C, 'AL'],
    [0x1D16D, 0x1D182, 'CM'],
    [0x1D183, 0x1D184, 'AL'],
    [0x1D185, 0x1D18B, 'CM'],
    [0x1D18C, 0x1D1A9, 'AL'],
    [0x1D1AA, 0x1D1AD, 'CM'],
    [0x1D1AE, 0x1D1DD, 'AL'],
    [0x1D200, 0x1D241, 'AL'],
    [0x1D242, 0x1D244, 'CM'],
    [0x1D245, 0x1D245, 'AL'],
    [0x1D300, 0x1D356, 'AL'],
    [0x1D360, 0x1D371, 'AL'],
    [0x1D400, 0x1D454, 'AL'],
    [0x1D456, 0x1D49C, 'AL'],
    [0x1D49E, 0x1D49F, 'AL'],
    [0x1D4A2, 0x1D4A2, 'AL'],
    [0x1D4A5, 0x1D4A6, 'AL'],
    [0x1D4A9, 0x1D4AC, 'AL'],
    [0x1D4AE, 0x1D4B9, 'AL'],
    [0x1D4BB, 0x1D4BB, 'AL'],
    [0x1D4BD, 0x1D4C3, 'AL'],
    [0x1D4C5, 0x1D505, 'AL'],
    [0x1D507, 0x1D50A, 'AL'],
    [0x1D50D, 0x1D514, 'AL'],
    [0x1D516, 0x1D51C, 'AL'],
    [0x1D51E, 0x1D539, 'AL'],
    [0x1D53B, 0x1D53E, 'AL'],
    [0x1D540, 0x1D544, 'AL'],
    [0x1D546, 0x1D546, 'AL'],
    [0x1D54A, 0x1D550, 'AL'],
    [0x1D552, 0x1D6A5, 'AL'],
    [0x1D6A8, 0x1D7CB, 'AL'],
    [0x1D7CE, 0x1D7FF, 'NU'],
    [0x1F000, 0x1F02B, 'AL'],
    [0x1F030, 0x1F093, 'AL'],
    [0x20000, 0x2A6D6, 'ID'],
    [0x2F800, 0x2FA1D, 'ID'],
    [0xE0001, 0xE0001, 'CM'],
    [0xE0020, 0xE007F, 'CM'],
    [0xE0100, 0xE01EF, 'CM'],
    [0xF0000, 0xFFFFD, 'XX'],
    [0x100000, 0x10FFFD, 'XX'],
];

1;
