#!perl -T

use Test::More tests => 4;
use Test::Exception;

use Test::MockFile::Light module => 'main';

my $file_name = 'foo.txt';

define_file_mocker($file_name);

lives_ok {
	open *D, "< $file_name" or die $!;
} 'opening file using glob';

lives_ok {
	<D>;
} 'reading from file using glob';

my $fh;

lives_ok {
	open $fh, "< $file_name" or die $!;
} 'opening file using scalar';

lives_ok {
	<$fh>;
} 'reading from file using scalar';
