use strict;
use Test::More tests => 1;
use Data::EDI::X12;



my $string = q[ISA*00*          *00*          *01*945592918      *01*031958655      *160726*1853*^*00501*000004227*0*P*>~GS*DX*945592918*031958655*20160726*1853*000000001*X*005010~ST*894*0001~G82*D*44372*031958655*U061*945592918*001*20160726*20160726*20639197*20160725~LS*0100~G83*1*6.000000*EA**PI*000000000000736356**6.74*1*Lemongrass Coconut O~G83*2*3.000000*EA**PI*000000000000726695**5.99*1*Zinc Sunscreen Sport~G83*3*1.000000*CA**PI*000000000000726107**34.59*12*Zinc Sunstick - Unsc~LE*0100~G84*10*93*93~G86*XXXXXX~G85*XXXXXX~SE*12*0001~GE*1*000000001~IEA*1*000004227~];


my $x12 = Data::EDI::X12->new({ spec_file => 't/894.yaml', new_lines => 0, truncate_null => 1 });


my $record = $x12->read_record($string);

   use Data::Dumper;
warn Dumper $record;

my $out = $x12->write_record($record);



cmp_ok($string, 'eq', $out, 'Data::EDI::X12 generates a sane file');


