use ExtUtils::MakeMaker;

require 5.008;

WriteMakefile
  ( NAME        => 'Geo::Point'
  , VERSION     => '0.07'
  , PREREQ_PM   =>
     { Test::More    => 0.47
     , Geo::Distance => 0.06
     , Geo::Proj4    => 0.96
     , Math::Polygon => 0.003
     , Math::Trig    => 1.00
     }
  , AUTHOR      => 'Mark Overmeer'
  , ABSTRACT    => 'Geographical structures'
  , LICENSE     => 'perl'
  );

#### the next lines are added for OODoc, which generates the
#### distribution.
sub MY::postamble { <<'__POSTAMBLE' }

# for DIST
RAWDIR          = ../public_html/geopoint/raw
DISTDIR         = ../public_html/geopoint/source
LICENSE         = artistic

# for POD
FIRST_YEAR      = 2005
EMAIL           = geo@overmeer.net
WEBSITE         = http://perl.overmeer.net/geo/

# for HTML
EXTENDS		= ../MathPolygon:../GeoProj4:../GeoWKT
HTML_OUTPUT     = ../public_html/geo/html
HTML_DOCROOT    = /geo/html
HTML_PACKAGE    = ../public_html/geo/htmlpkg

__POSTAMBLE

