
# copied from Text::CSV_XS (0.26) t/30_types.t and modified for Text::CSV_PP

use strict;
use Test::More tests => 21;

BEGIN {
    use_ok "Text::CSV_PP", ();
    plan skip_all => "Cannot load Text::CSV_PP" if $@;
    }

$| = 1;

my $csv = Text::CSV_PP->new ({
    types => [
	Text::CSV_PP::IV (),
	Text::CSV_PP::PV (),
	Text::CSV_PP::NV (),
	],
    });

ok ($csv,					"CSV_XS->new ()");

is (@{$csv->{types}}, 3,			"->{types} as hash");
is ($csv->{types}[0], Text::CSV_PP::IV (),	"type IV");
is ($csv->{types}[1], Text::CSV_PP::PV (),	"type PV");
is ($csv->{types}[2], Text::CSV_PP::NV (),	"type NV");

is (ref ($csv->types), "ARRAY",			"->types () as method");
is ($csv->types ()->[0], Text::CSV_PP::IV (),	"type IV");
is ($csv->types ()->[1], Text::CSV_PP::PV (),	"type PV");
is ($csv->types ()->[2], Text::CSV_PP::NV (),	"type NV");

is (length $csv->{_types}, 3,			"->{_types}");
my $inp = join "", map { chr $_ }
    Text::CSV_PP::IV (), Text::CSV_PP::PV (), Text::CSV_PP::NV ();
# should be "\001\000\002"
is ($csv->{_types}, $inp,			"IV PV NV");

ok ($csv->combine ("", "", "1.00"),		"combine ()");
is ($csv->string, ',,1.00',			"string");

my $warning;
$SIG{__WARN__} = sub { $warning = shift };

ok ($csv->parse ($csv->string ()),		"parse (combine ())");
like ($warning, qr/numeric/,			"numeric warning");

my @fields = $csv->fields ();
is ($fields[0], "0",				"Field 1");
is ($fields[1], "",				"Field 2");
is ($fields[2], "1",				"Field 3");

is ($csv->types (0), undef,			"delete types");
is ($csv->types,     undef,			"types gone");
