#!/usr/bin/perl 

use strict;
use warnings;

use LaTeX::Table;
use LaTeX::Encode;

my $test_data = [
    [ 'Lisa',   '0', '0' ],
    [ 'Marge',  '0', '1' ],
    [ 'Homer',  'two', '6' ],
    [],
    [ 'Wiggum', '0', '5' ],
    [ 'Otto',   'one', '3' ],
    [ 'Barney', 'eight', '16.5' ],
];

my $test_data_large = [];

for my $i ( 1 .. 6 ) {
    $test_data_large = [ @$test_data_large, @$test_data ];
}

my $table = LaTeX::Table->new(
    {   tablepos    => 'htb',
        maincaption => 'Beer Counter',
        caption     => 'Number of beers before and after 4pm.',
        size        => 'large',
    }
);

my $themes = {
            'Custom' => {
                'HEADER_FONT_STYLE'  => 'sc',
                'HEADER_CENTERED'     => 1,
                'CAPTION_FONT_STYLE' => 'sc',
                'VERTICAL_LINES'      => [ 1, 2, 1 ],
                'HORIZONTAL_LINES'    => [ 1, 2, 0 ],
            },
        };

$table->set_custom_themes($themes);


foreach my $theme ( keys %{ $table->get_available_themes } ) {

    my $test_header
        = [ [ 'Name', 'Beers:2|c|' ], [ '', 'before 4pm', 'after 4pm' ] ];

    # no vertical lines in the miami theme
    if ( $theme eq 'Miami' ) {
        $test_header
            = [ [ 'Name', 'Beers:2c' ], [ '', 'before 4pm', 'after 4pm' ] ];
    }

    $table->set_filename("$theme.tex");
    $table->set_theme($theme);
    $table->set_label("${theme}example");
    $table->set_type('std');
    $table->set_header($test_header);
    $table->set_data($test_data);
    $table->generate( );
    $table->set_type('xtab');
    $table->set_filename("${theme}multipage.tex");
    $table->set_label("${theme}mpexample");
    $table->set_xentrystretch(-0.1);
    $table->set_header($test_header);
    $table->set_data($test_data_large);
    $table->generate( );
}

open my $OUT, '>', 'examples.tex';
foreach my $line (<DATA>) {
    print $OUT $line;
}
foreach my $theme ( keys %{ $table->get_available_themes } ) {
    print $OUT "\\section{$theme}\n \\input{$theme.tex}\n";
    print $OUT "\\input{${theme}multipage.tex} \\clearpage \\newpage\n";
}

my $header = [ [ 'Character', 'Fullname', 'Voice' ], ];
my $data = [
    [ 'Homer', 'Homer Jay Simpson',               'Dan Castellaneta', ],
    [ 'Marge', 'Marjorie Simpson (née Bouvier)', 'Julie Kavner', ],
    [ 'Bart',  'Bartholomew Jojo Simpson',        'Nancy Cartwright', ],
    [ 'Lisa',  'Elizabeth Marie Simpson',         'Yeardley Smith', ],
    [   'Maggie',
        'Margaret Simpson',
        'Elizabeth Taylor, Nancy Cartwright, James Earl Jones,'
            . 'Yeardley Smith, Harry Shearer',
    ],
];

$table = LaTeX::Table->new(
    {   header    => $header,
        data      => $data,
        label     => 'wrap1',
        text_wrap => [ 15, 30, 30 ],
        caption   => 'Text::Wrap example',
    }
);

print ${OUT} '\section{Text::Wrap example}' . "\n";
print ${OUT} <<'EOT'
Table~\ref{wrap1} demonstrates the \texttt{text\_wrap} feature. 
EOT
;
#Note the ecoding problems in the Marge Fullname column. Using LaTeX::Encode
#in a \texttt{callback} function fixes this problem (see~\ref{wrap2}).
#EOT
#;
print ${OUT} $table->generate_string;
#$table->set_callback(sub { my ( $row, $col, $value ) = @_; return
#        latex_encode($value) });
#$table->set_label('wrap2');
#$table->set_caption(
#    'Text::Wrap example with LaTeX::Encode callback function.');
#print ${OUT} $table->generate_string;

print ${OUT} "\\end{document}\n";


close $OUT;

__DATA__
\documentclass[twoside,12pt]{report}
\usepackage[margin=10pt,font=small,labelfont=bf]{caption}
\usepackage{url}
\usepackage{graphics, graphicx}
\usepackage{xtab}
\begin{document}
\chapter{Examples}
This document is generated by \texttt{generate\_examples.pl} from
\textsc{LaTeX::Table}. For each theme, two example tables are shown, one of type
\textit{std}, the standard \LaTeX~table, and one of type \textit{xtab}. Note that the
second column is left justified because this column contains numbers and
strings, whereas the third column is a number column and therefore right
justified.
