use Test::More tests => 23;
BEGIN { use_ok('Number::Range') };

ok($range = Number::Range->new("10..100"));
ok($range->inrange(10)   == 1);
ok($range->inrange(1000) == 0);
$range = Number::Range->new("10..50,60..100");
ok($range->inrange(10) == 1);
ok($range->inrange(55) == 0);
ok($range->inrange(75) == 1);
$range = Number::Range->new("10..100","150..200");
ok($range->inrange(10)  == 1);
ok($range->inrange(125) == 0);
ok($range->inrange(155) == 1);
$range = Number::Range->new("-10..10");
ok($range->inrange(10)  == 1);
ok($range->inrange(-10) == 1);
ok($range->inrange(0)   == 1);
$range->addrange("20..30");
ok($range->inrange(25) == 1);
ok($range->inrange(10) == 1);
ok($range->inrange(15) == 0);
$range->delrange("-10..0");
ok($range->inrange(-10) == 0);
ok($range->inrange(10)  == 1);
ok($range->inrange(25) == 1);
ok($range->inrange(10,25));
@test = $range->inrange(10,25,1000);
@rc   = qw/1 1 0/;
is_deeply(\@rc, \@test);
$range = Number::Range->new("1..100,150..200");
$rangeformat = $range->range;
cmp_ok("1..100,150..200", 'eq', $rangeformat);
ok($range->size == 151);

