# Lempel–Ziv–Welch (LZW) algorithm implementation in Perl 6

## Synopsis

```perl
my $data = 'Тексты - это не энциклопедические и не лингвистические системы.' x 255;

# create LWZ object
my $lzw = LZW::Revolunet.new;

# set dictionary size, by default 57344
$lzw.set_dictsize( 97000 );

# compress
my $cmp  = $lzw.compress( $lzw.encode_utf8($data) );

# decompress
my $dcmp = $lzw.decode_utf8( $lzw.decompress($cmp) );

# validate
if ( !($dcmp eq $data) ) {
    die "decompressed data is corrupted";
}

# compress/decompress statistics
('compression ratio ' ~ floor($cmp.chars/$dcmp.chars*100) ~ '%').say;
```

## Description

**LZW::Revolunet** — Perl6 implementation of universal lossless data compression [algorithm](https://en.wikipedia.org/wiki/Lzw) created by Abraham Lempel, Jacob Ziv, and Terry Welch. This module is based on JavaScript implementation ([lzw_encoder.js](https://gist.github.com/revolunet/843889)) by [Julien Bouquillon](https://github.com/revolunet)

## License

**LZW::Revolunet** is free and opensource software, so you can redistribute it and/or modify it under the terms of the [The Artistic License 2.0](https://opensource.org/licenses/Artistic-2.0).

## Author

Please contact me via [LinkedIn](https://www.linkedin.com/in/knarkhov/) or [Twitter](https://twitter.com/CondemnedCell). Your feedback is welcome at [narkhov.pro](https://narkhov.pro/contact-information.html).

## See also

[LZW Data Compression](https://www2.cs.duke.edu/csed/curious/compression/lzw.html)
