
use strict;
use warnings;

use Test::More;
use Test::DZil;
use Test::Differences qw( eq_or_diff );
use Dist::Zilla::Util::Test::KENTNL 1.003001 qw( dztest );
require Module::Install;

# ABSTRACT: Really basic test to make sure this works

my $test = dztest();
my $ini;
$test->add_file( 'dist.ini', $ini = simple_ini( [ 'GatherDir', {} ], [ 'ModuleInstall', {} ], ) );
$test->build_ok;

{
  my $distini = $test->test_has_built_file('dist.ini');
  eq_or_diff( $distini->slurp_raw, $ini, 'ini is expected content' );
}

{
  my $mkf     = $test->test_has_built_file('Makefile.PL');
  my $version = $Dist::Zilla::Plugin::ModuleInstall::VERSION;
  my $miver   = $Module::Install::VERSION;

  eq_or_diff( $mkf->slurp_raw, <<"EOF", 'Makefile.PL is expected content' );
use strict;
use warnings;
# Warning: This code was generated by Dist::Zilla::Plugin::ModuleInstall Version ${version}
# As part of Dist::Zilla's build generation.
# Do not modify this file, instead, modify the dist.ini that configures its generation.
use inc::Module::Install $miver;
name 'DZT-Sample';

abstract "Sample\\ DZ\\ Dist";

author "E\\.\\ Xavier\\ Ample\\ \\<example\\\@example\\.org\\>";

version "0\\.001";

license "perl";


# configure requires => configure_requires
configure_requires  "ExtUtils\\:\\:MakeMaker" => "6\\.42";


# build requires => requires
requires  "ExtUtils\\:\\:MakeMaker" => "6\\.42";


# runtime requires => requires

# runtime recommends => recommends

# test requires => test_requires

# :ExecFiles
WriteAll();
EOF
}

my ( $msg, ) = grep { $_->{level} eq 'info' and $_->{message} =~ q^inc/Module/Install\.pm^ } @{ $test->builder->log_events };

ok( $msg, "Notice about adding inc::Module::Install" );

note explain $test->builder->log_messages;
done_testing;

