#include "slib.hh"
#include <string.h>

template <class T>
os_typespec* Foo<T>::thetype = T::get_os_typespec();

template <class T>
void Foo<T>::initialize() {
  objectstore::initialize();

};



template <class T>
Foo<T>::Foo(int x,char* s1, char* s2) {
 id = x;
 database_name = new char[strlen(s1)+1];
 strcpy(database_name,s1);
 rootname = new char[strlen(s2)+1];
 strcpy(rootname,s2);
 db = os_database::open(database_name,0,0664);
 OS_BEGIN_TXN(tx1,0,os_transaction::update) 
   cont_obj = os_reference(new(db,thetype) T);
   db->create_root(rootname)->set_value((T*)cont_obj.resolve(),thetype);
 OS_END_TXN(tx1);
}

template <class T>
Foo<T>::~Foo(){
 delete database_name;
 delete rootname;
 db->close();
}


template <class T>
int Foo<T>::get_id() {return id;}

template <class T>
char* Foo<T>::get_database() { return database_name;}

template <class T>
char *Foo<T>::get_rootname() { return rootname;}

template <class T>
T Foo<T>::get_object() {
  T temp;
  OS_BEGIN_TXN(txn,0,os_transaction::update) 
   temp = *(T*)(cont_obj.resolve());
  OS_END_TXN(txn)
 return temp;
}

template <class T>
int Foo<T>::delete_object() {
  if (!cont_obj) return 0;
  OS_BEGIN_TXN(txn1,0,os_transaction::update)
   delete (T*)(cont_obj.resolve());
  OS_END_TXN(txn1);
  return 1;
}


template <class T>
int Foo<T>::replace_object(T replacer) {
  if (!cont_obj) return 0;
  OS_BEGIN_TXN(txn2,0,os_transaction::update)
    delete (T*)(cont_obj.resolve());
    cont_obj = os_reference(new(db,thetype) T(replacer));
  OS_END_TXN(txn2);
 return 1;
}



