use strict;
use warnings;
use Test::More;

my $script = 'bin/implode';
plan skip_all => "Cannot test without $script" unless -x $script;

$script = do $script or die "do $script: $@";
$script = bless {verbose => $ENV{HARNESS_IS_VERBOSE}}, $script;

ok !$App::implode::explodedir, 'no explodedir';
$script->exploder('test-mjaaccp1379132vhgv3');
my $dir = $App::implode::explodedir ? $$App::implode::explodedir : '/tmp/no-such-exploder-explodedir';
ok -d $dir, "got $dir";
ok -e "$dir/bin/implode", "got $dir/bin/implode";
ok -x "$dir/bin/implode", "can execute $dir/bin/implode";
like $ENV{PATH},     qr{^$dir/bin:},       'PATH';
like $ENV{PERL5LIB}, qr{^$dir/lib/perl5:}, 'PERL5LIB';

undef $App::implode::explodedir;
ok !-d $dir, "remove_tree $dir";

done_testing;

__END__
BZh91AY&SY cw=v
w f          
 ҦeOT3L"aP0a4Ah
mi FODSj?TѦ14z41I&  1M2`&    4bdɓ`400L
4
 
 A
  d 2 ɦF24  4 4iCMQ頌            ` &04  
4
 
 A
  d 2 ɦF24  4 4iC@&M
C"?bLɥ6O*=MhdA=@  zCCO]z`95=>FԂe1*ulv8IхLt1vVQ1k80"1
,HR!VTPTA<,E{
FeԄcsJVA*A!51@ӂttO:$vPDL(<XPJzD83DMq!9<,s,HNd)kr5ȹRc)cHQUZR)K(K)RRƥTUE0J0kةfQ))h-*)eUJ"HsRIԉCV}O} 
y&̀ @ `u}-|Ivi;;l}[ `"\%h 5H&~wo9T~][C,&hmvHmHZߵN@fICE BMIK)eD)*J%TJ"~h)yNBtJP\UFuͮ,=c;u^${BR]<sYDdjv'5V|S0>#_`>+m#i)'Ve&K9u.u!Vea<M	z'6fpf "*vjCܕ$XX.u(RT"TA   (%=<ML    "@ @ @ A	UURQf>)CTCجS?A6>c4*e'eɠ2T)K,Һ(0M
]b9Vb4YCЉ`h*%Zyk`&SK"d3O]}Nv'].Ѹ45QN&޳s
8ɉ9TC;0	c3)uML"T(cS%уKJbUR~l>C[i̳a7Sr9faT,;Qwud?-5
q:fhK7:Z\L!pRhhzSIKj
llfoMcnz	dVMi1CUffSmsZLSƳ|{q6lSl5ΖR?V0bznol<i&h렙zyQjcSsȺkL!RE(~J),dK}u?
E$]g2TJkT%RhQTJGL%Sʦٹqs6oCL5)SFc#o'`9i_h]wiY1x<aeC'hjjS3#d1jne|ZG:哢'ؚEXjr7&0#ⶭw+&5*
pViӆ35ooS1Qg;q&ɾ`x٣3Qr˪q7r̓zTާJc,J)YL.`RT*;ҡsnWp'TȻ̺EySAi̻g$9S[N<
ÝRck<1OZY8j=&{I#GӭS)gؔwL8eḺTr[M׎Uӊfbt[vfˬLWyJuckHDfNМNDnz.+o;}h.rWS-|+mhZ>/[~loiF(ծJJZ'1֡	ȁ) sf<nAauJKJb99!TTTuӚ${P]$>IԷs1z\ApϢ/yR^dXğY,I*LIwF$FI6OY%a?R|{)i|9'-}i>SMLDbfzɘs
0{,S{FAc23I&LSJTޗ.t&)s5!dj]B|fgvYt충tptMk~ԎdS58Y˴YӝSL̓34#LMshο)4	RS-]lW
Ȟf֦Sm{&֜=XT;9R旤m|	gphS2Rr}:>I3#cƖfPOJ'
珻|g4I<BmDa5*`L!Ψ4H5;\ҤE*}s
}5L^׈XZSu.w,d84KhFgdS%e܌#;['qy.O:ӭg1f)d22de
5n`&/m,ԔJe8,H{,pdFtSֆ'#,Լ^Yfv*`RLl!)͋S)Ƒc6:jRR٪)E/0*TŤ2*-,)>jkRaLTsiC|LS&ɡv+<ld˳VN"I8'ɮq6+k{JUR(P0M*LMk!I	7GiZ`ͪN8jQR0Z&i]q)RR)yyx֚&$}.jS0F,S{I(\}#ΎF;IR)K7N]/<II*+r8L|Rs(FhGYO
a
<S#Sh]Nu䴰!ƨ)*DREb:*uIlO<J晨Illluӷ-ἳY31N\4"JJ/&ęi*Zany ZRaF!x^T܍
JҒfZE-
8I5F+!5F/'ST&i5DhXB|SK4NٓSTI%T%,
CKY3Du]pQK\xǱ=M'ǉ#䞂nydNDq،dĠQ[$zŦ+)f%Zi{UkYDJeEtKH]f
^Wx˖;lNɲb5':0x̞g?d׃#8JIQڑqyt0SpIN^I%]^gLn)srK}Jy'<a$$(s9&rM/BШiYtQ,  SZٱw8/;30l1R.2T]{I6RNEL,0K<,TJb#}BlkxY;s
JT2$wIIǙܞێgR&saCwUUUUUUUUUUUU]ϙhE1G>QJGXSI<TCO2D\藞vr>iRk!&Լ%LeEI,
-N'S>t=zO	wib]qҔu05ѷ%°"{UJCH
X 
