#!/usr/local/bin/perl
# Test Geo::Ellipsoid range
use Test::More tests => 244;
use Test::Number::Delta relative => 1e-6;
use Geo::Ellipsoid;
use blib;
use strict;
use warnings;

my $e = Geo::Ellipsoid->new(units=>'degrees');
my $r;
$r = $e->range(-88.000000,0.000000,-88.000000,0.000000);
delta_within( $r, 4.42570343052329e-11, 1.0 );

$r = $e->range(-88.000000,0.000000,-88.000000,90.000000);
delta_within( $r, 315884.900023524, 1.0 );

$r = $e->range(-88.000000,0.000000,-88.000000,180.000000);
delta_within( $r, 446774.084269156, 1.0 );

$r = $e->range(-88.000000,0.000000,-88.000000,270.000000);
delta_within( $r, 315884.900023524, 1.0 );

$r = $e->range(-88.000000,0.000000,0.000000,0.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(-88.000000,0.000000,0.000000,90.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(-88.000000,0.000000,0.000000,180.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(-88.000000,0.000000,0.000000,270.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(-88.000000,0.000000,88.000000,0.000000);
delta_within( $r, 19557157.3741893, 1.0 );

$r = $e->range(-88.000000,0.000000,88.000000,90.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(-88.000000,0.000000,88.000000,180.000000);
delta_within( $r, 20003807.9975341, 1.0 );

$r = $e->range(-88.000000,0.000000,88.000000,270.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(-88.000000,90.000000,-88.000000,0.000000);
delta_within( $r, 315884.900023524, 1.0 );

$r = $e->range(-88.000000,90.000000,-88.000000,90.000000);
delta_within( $r, 4.42570343052329e-11, 1.0 );

$r = $e->range(-88.000000,90.000000,-88.000000,180.000000);
delta_within( $r, 315884.900023524, 1.0 );

$r = $e->range(-88.000000,90.000000,-88.000000,270.000000);
delta_within( $r, 446774.084269156, 1.0 );

$r = $e->range(-88.000000,90.000000,0.000000,0.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(-88.000000,90.000000,0.000000,90.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(-88.000000,90.000000,0.000000,180.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(-88.000000,90.000000,0.000000,270.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(-88.000000,90.000000,88.000000,0.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(-88.000000,90.000000,88.000000,90.000000);
delta_within( $r, 19557157.3741893, 1.0 );

$r = $e->range(-88.000000,90.000000,88.000000,180.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(-88.000000,90.000000,88.000000,270.000000);
delta_within( $r, 20003807.9975341, 1.0 );

$r = $e->range(-88.000000,180.000000,-88.000000,0.000000);
delta_within( $r, 446774.084269156, 1.0 );

$r = $e->range(-88.000000,180.000000,-88.000000,90.000000);
delta_within( $r, 315884.900023524, 1.0 );

$r = $e->range(-88.000000,180.000000,-88.000000,180.000000);
delta_within( $r, 4.42570343052329e-11, 1.0 );

$r = $e->range(-88.000000,180.000000,-88.000000,270.000000);
delta_within( $r, 315884.900023524, 1.0 );

$r = $e->range(-88.000000,180.000000,0.000000,0.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(-88.000000,180.000000,0.000000,90.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(-88.000000,180.000000,0.000000,180.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(-88.000000,180.000000,0.000000,270.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(-88.000000,180.000000,88.000000,0.000000);
delta_within( $r, 20003807.9975341, 1.0 );

$r = $e->range(-88.000000,180.000000,88.000000,90.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(-88.000000,180.000000,88.000000,180.000000);
delta_within( $r, 19557157.3741893, 1.0 );

$r = $e->range(-88.000000,180.000000,88.000000,270.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(-88.000000,270.000000,-88.000000,0.000000);
delta_within( $r, 315884.900023524, 1.0 );

$r = $e->range(-88.000000,270.000000,-88.000000,90.000000);
delta_within( $r, 446774.084269156, 1.0 );

$r = $e->range(-88.000000,270.000000,-88.000000,180.000000);
delta_within( $r, 315884.900023524, 1.0 );

$r = $e->range(-88.000000,270.000000,-88.000000,270.000000);
delta_within( $r, 4.42570343052329e-11, 1.0 );

$r = $e->range(-88.000000,270.000000,0.000000,0.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(-88.000000,270.000000,0.000000,90.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(-88.000000,270.000000,0.000000,180.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(-88.000000,270.000000,0.000000,270.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(-88.000000,270.000000,88.000000,0.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(-88.000000,270.000000,88.000000,90.000000);
delta_within( $r, 20003807.9975341, 1.0 );

$r = $e->range(-88.000000,270.000000,88.000000,180.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(-88.000000,270.000000,88.000000,270.000000);
delta_within( $r, 19557157.3741893, 1.0 );

$r = $e->range(0.000000,0.000000,-88.000000,0.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(0.000000,0.000000,-88.000000,90.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,0.000000,-88.000000,180.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(0.000000,0.000000,-88.000000,270.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,0.000000,0.000000,0.000000);
delta_within( $r, 0, 1.0 );

$r = $e->range(0.000000,0.000000,0.000000,90.000000);
delta_within( $r, 10018754.1713946, 1.0 );

$r = $e->range(0.000000,0.000000,0.000000,180.000000);
delta_within( $r, 19903593.3902804, 1.0 );

$r = $e->range(0.000000,0.000000,0.000000,270.000000);
delta_within( $r, 10018754.1713946, 1.0 );

$r = $e->range(0.000000,0.000000,88.000000,0.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(0.000000,0.000000,88.000000,90.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,0.000000,88.000000,180.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(0.000000,0.000000,88.000000,270.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,90.000000,-88.000000,0.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,90.000000,-88.000000,90.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(0.000000,90.000000,-88.000000,180.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,90.000000,-88.000000,270.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(0.000000,90.000000,0.000000,0.000000);
delta_within( $r, 10018754.1713946, 1.0 );

$r = $e->range(0.000000,90.000000,0.000000,90.000000);
delta_within( $r, 0, 1.0 );

$r = $e->range(0.000000,90.000000,0.000000,180.000000);
delta_within( $r, 10018754.1713946, 1.0 );

$r = $e->range(0.000000,90.000000,0.000000,270.000000);
delta_within( $r, 19903593.3902804, 1.0 );

$r = $e->range(0.000000,90.000000,88.000000,0.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,90.000000,88.000000,90.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(0.000000,90.000000,88.000000,180.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,90.000000,88.000000,270.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(0.000000,180.000000,-88.000000,0.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(0.000000,180.000000,-88.000000,90.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,180.000000,-88.000000,180.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(0.000000,180.000000,-88.000000,270.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,180.000000,0.000000,0.000000);
delta_within( $r, 19903593.3902804, 1.0 );

$r = $e->range(0.000000,180.000000,0.000000,90.000000);
delta_within( $r, 10018754.1713946, 1.0 );

$r = $e->range(0.000000,180.000000,0.000000,180.000000);
delta_within( $r, 0, 1.0 );

$r = $e->range(0.000000,180.000000,0.000000,270.000000);
delta_within( $r, 10018754.1713946, 1.0 );

$r = $e->range(0.000000,180.000000,88.000000,0.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(0.000000,180.000000,88.000000,90.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,180.000000,88.000000,180.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(0.000000,180.000000,88.000000,270.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,270.000000,-88.000000,0.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,270.000000,-88.000000,90.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(0.000000,270.000000,-88.000000,180.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,270.000000,-88.000000,270.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(0.000000,270.000000,0.000000,0.000000);
delta_within( $r, 10018754.1713946, 1.0 );

$r = $e->range(0.000000,270.000000,0.000000,90.000000);
delta_within( $r, 19903593.3902804, 1.0 );

$r = $e->range(0.000000,270.000000,0.000000,180.000000);
delta_within( $r, 10018754.1713946, 1.0 );

$r = $e->range(0.000000,270.000000,0.000000,270.000000);
delta_within( $r, 0, 1.0 );

$r = $e->range(0.000000,270.000000,88.000000,0.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,270.000000,88.000000,90.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(0.000000,270.000000,88.000000,180.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(0.000000,270.000000,88.000000,270.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(88.000000,0.000000,-88.000000,0.000000);
delta_within( $r, 19557157.3741893, 1.0 );

$r = $e->range(88.000000,0.000000,-88.000000,90.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(88.000000,0.000000,-88.000000,180.000000);
delta_within( $r, 20003807.9975341, 1.0 );

$r = $e->range(88.000000,0.000000,-88.000000,270.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(88.000000,0.000000,0.000000,0.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(88.000000,0.000000,0.000000,90.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(88.000000,0.000000,0.000000,180.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(88.000000,0.000000,0.000000,270.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(88.000000,0.000000,88.000000,0.000000);
delta_within( $r, 4.42570343052329e-11, 1.0 );

$r = $e->range(88.000000,0.000000,88.000000,90.000000);
delta_within( $r, 315884.900023531, 1.0 );

$r = $e->range(88.000000,0.000000,88.000000,180.000000);
delta_within( $r, 446774.084269165, 1.0 );

$r = $e->range(88.000000,0.000000,88.000000,270.000000);
delta_within( $r, 315884.900023531, 1.0 );

$r = $e->range(88.000000,90.000000,-88.000000,0.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(88.000000,90.000000,-88.000000,90.000000);
delta_within( $r, 19557157.3741893, 1.0 );

$r = $e->range(88.000000,90.000000,-88.000000,180.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(88.000000,90.000000,-88.000000,270.000000);
delta_within( $r, 20003807.9975341, 1.0 );

$r = $e->range(88.000000,90.000000,0.000000,0.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(88.000000,90.000000,0.000000,90.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(88.000000,90.000000,0.000000,180.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(88.000000,90.000000,0.000000,270.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(88.000000,90.000000,88.000000,0.000000);
delta_within( $r, 315884.900023531, 1.0 );

$r = $e->range(88.000000,90.000000,88.000000,90.000000);
delta_within( $r, 4.42570343052329e-11, 1.0 );

$r = $e->range(88.000000,90.000000,88.000000,180.000000);
delta_within( $r, 315884.900023531, 1.0 );

$r = $e->range(88.000000,90.000000,88.000000,270.000000);
delta_within( $r, 446774.084269165, 1.0 );

$r = $e->range(88.000000,180.000000,-88.000000,0.000000);
delta_within( $r, 20003807.9975341, 1.0 );

$r = $e->range(88.000000,180.000000,-88.000000,90.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(88.000000,180.000000,-88.000000,180.000000);
delta_within( $r, 19557157.3741893, 1.0 );

$r = $e->range(88.000000,180.000000,-88.000000,270.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(88.000000,180.000000,0.000000,0.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(88.000000,180.000000,0.000000,90.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(88.000000,180.000000,0.000000,180.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(88.000000,180.000000,0.000000,270.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(88.000000,180.000000,88.000000,0.000000);
delta_within( $r, 446774.084269165, 1.0 );

$r = $e->range(88.000000,180.000000,88.000000,90.000000);
delta_within( $r, 315884.900023531, 1.0 );

$r = $e->range(88.000000,180.000000,88.000000,180.000000);
delta_within( $r, 4.42570343052329e-11, 1.0 );

$r = $e->range(88.000000,180.000000,88.000000,270.000000);
delta_within( $r, 315884.900023531, 1.0 );

$r = $e->range(88.000000,270.000000,-88.000000,0.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(88.000000,270.000000,-88.000000,90.000000);
delta_within( $r, 20003807.9975341, 1.0 );

$r = $e->range(88.000000,270.000000,-88.000000,180.000000);
delta_within( $r, 19688067.1505702, 1.0 );

$r = $e->range(88.000000,270.000000,-88.000000,270.000000);
delta_within( $r, 19557157.3741893, 1.0 );

$r = $e->range(88.000000,270.000000,0.000000,0.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(88.000000,270.000000,0.000000,90.000000);
delta_within( $r, 10225352.7713638, 1.0 );

$r = $e->range(88.000000,270.000000,0.000000,180.000000);
delta_within( $r, 10001986.3061488, 1.0 );

$r = $e->range(88.000000,270.000000,0.000000,270.000000);
delta_within( $r, 9778578.68709464, 1.0 );

$r = $e->range(88.000000,270.000000,88.000000,0.000000);
delta_within( $r, 315884.900023531, 1.0 );

$r = $e->range(88.000000,270.000000,88.000000,90.000000);
delta_within( $r, 446774.084269165, 1.0 );

$r = $e->range(88.000000,270.000000,88.000000,180.000000);
delta_within( $r, 315884.900023531, 1.0 );

$r = $e->range(88.000000,270.000000,88.000000,270.000000);
delta_within( $r, 4.42570343052329e-11, 1.0 );

$r = $e->range(-59.250954,269.964713,-72.653102,313.367482);
delta_within( $r, 2387346.51422899, 1.0 );

$r = $e->range(13.914631,282.887733,34.594948,132.755857);
delta_within( $r, 13782750.5185808, 1.0 );

$r = $e->range(67.302734,268.234235,-9.711736,127.342153);
delta_within( $r, 12984079.3534998, 1.0 );

$r = $e->range(41.853534,93.679920,-19.027121,279.644382);
delta_within( $r, 17412055.9828005, 1.0 );

$r = $e->range(62.106325,207.283752,38.796947,29.881529);
delta_within( $r, 8816750.73468368, 1.0 );

$r = $e->range(-7.951477,39.580853,8.141044,140.647165);
delta_within( $r, 11352059.5743174, 1.0 );

$r = $e->range(12.345376,345.263922,66.189437,58.748224);
delta_within( $r, 8016409.18217187, 1.0 );

$r = $e->range(-40.408393,93.729994,76.337054,156.932149);
delta_within( $r, 13682231.8156387, 1.0 );

$r = $e->range(52.102956,45.942126,-75.202977,338.631126);
delta_within( $r, 14942581.9119076, 1.0 );

$r = $e->range(-85.396513,55.515935,-21.207163,55.705212);
delta_within( $r, 7141784.38067274, 1.0 );

$r = $e->range(5.280015,315.665457,-12.489941,95.006241);
delta_within( $r, 15498242.5513826, 1.0 );

$r = $e->range(-33.552990,277.233007,-70.669641,277.575212);
delta_within( $r, 4129662.43256577, 1.0 );

$r = $e->range(36.935201,78.710277,47.122919,148.216696);
delta_within( $r, 5672981.44859635, 1.0 );

$r = $e->range(26.788828,334.784252,0.435342,247.478645);
delta_within( $r, 9725798.54814913, 1.0 );

$r = $e->range(-11.503629,218.988327,13.780554,227.743816);
delta_within( $r, 2958575.3358753, 1.0 );

$r = $e->range(-6.583383,227.607764,-65.106912,345.874110);
delta_within( $r, 10613239.9928186, 1.0 );

$r = $e->range(-64.012500,160.805906,-31.574797,342.930268);
delta_within( $r, 9406332.56564806, 1.0 );

$r = $e->range(-25.526896,143.354960,-71.769322,343.830865);
delta_within( $r, 9098060.67595932, 1.0 );

$r = $e->range(87.231051,207.349229,65.864472,53.955321);
delta_within( $r, 2973794.67858556, 1.0 );

$r = $e->range(73.647077,234.450903,-78.505046,343.799779);
delta_within( $r, 18164152.9202468, 1.0 );

$r = $e->range(83.927298,282.795619,54.929667,205.651325);
delta_within( $r, 3812029.99530698, 1.0 );

$r = $e->range(-39.134570,346.518379,14.305871,157.269106);
delta_within( $r, 17109470.1691379, 1.0 );

$r = $e->range(-22.421489,332.426739,-84.834112,276.789592);
delta_within( $r, 7203676.36756746, 1.0 );

$r = $e->range(40.159219,212.748966,-13.340063,231.171501);
delta_within( $r, 6221685.46012325, 1.0 );

$r = $e->range(44.417291,24.846678,-80.406909,278.752912);
delta_within( $r, 15134246.4794779, 1.0 );

$r = $e->range(36.630627,43.655923,-35.381356,26.822827);
delta_within( $r, 8160706.81634357, 1.0 );

$r = $e->range(33.814762,131.384200,41.299938,70.051002);
delta_within( $r, 5370034.84714641, 1.0 );

$r = $e->range(-62.173407,58.245260,59.801920,198.337306);
delta_within( $r, 17869766.2475336, 1.0 );

$r = $e->range(-32.914255,189.985094,-12.020048,76.924247);
delta_within( $r, 11360231.9369249, 1.0 );

$r = $e->range(41.328831,0.492949,15.516809,171.877678);
delta_within( $r, 13648833.6676988, 1.0 );

$r = $e->range(79.174434,274.377083,-67.007887,5.320166);
delta_within( $r, 17199896.0041268, 1.0 );

$r = $e->range(-0.001195,304.117753,63.386740,32.763058);
delta_within( $r, 9937736.96428576, 1.0 );

$r = $e->range(64.395482,284.016319,14.125715,35.816077);
delta_within( $r, 9606094.02801337, 1.0 );

$r = $e->range(59.070193,268.990763,73.506884,184.371272);
delta_within( $r, 3712054.44887264, 1.0 );

$r = $e->range(69.221855,346.301076,11.971944,170.600523);
delta_within( $r, 10991466.3265512, 1.0 );

$r = $e->range(-14.839766,234.124251,68.436283,210.936486);
delta_within( $r, 9420758.84081371, 1.0 );

$r = $e->range(-49.947821,359.764786,-61.347691,250.415053);
delta_within( $r, 6167599.92891697, 1.0 );

$r = $e->range(36.275284,355.034035,26.747567,235.757036);
delta_within( $r, 10574525.7672411, 1.0 );

$r = $e->range(61.956727,245.437140,84.626689,119.397052);
delta_within( $r, 3513863.87778135, 1.0 );

$r = $e->range(54.014791,57.371114,65.390242,216.992405);
delta_within( $r, 6648562.11548952, 1.0 );

$r = $e->range(-14.407400,353.288548,66.401439,167.053343);
delta_within( $r, 14211208.6901202, 1.0 );

$r = $e->range(-45.568153,304.069875,61.783688,265.142366);
delta_within( $r, 12401282.7510462, 1.0 );

$r = $e->range(-66.204938,171.649788,51.180657,179.133361);
delta_within( $r, 13033442.3911617, 1.0 );

$r = $e->range(12.387314,159.861758,-83.658835,119.465377);
delta_within( $r, 10829509.5704501, 1.0 );

$r = $e->range(-13.206616,209.725263,-74.148669,242.959763);
delta_within( $r, 7085914.00647912, 1.0 );

$r = $e->range(15.738507,84.854820,44.036265,345.007357);
delta_within( $r, 9572921.67092144, 1.0 );

$r = $e->range(65.565980,26.794838,7.165798,137.813405);
delta_within( $r, 10226902.3891183, 1.0 );

$r = $e->range(-89.667751,257.981187,-80.341572,7.576067);
delta_within( $r, 1091685.81116208, 1.0 );

$r = $e->range(46.541007,226.425777,77.582559,197.258652);
delta_within( $r, 3685264.01125291, 1.0 );

$r = $e->range(-15.473927,141.465980,-54.435715,110.910346);
delta_within( $r, 5064895.77709337, 1.0 );

$r = $e->range(-52.334998,219.992892,-23.050833,57.834091);
delta_within( $r, 11475560.6751982, 1.0 );

$r = $e->range(-7.159774,289.072816,-56.983265,258.457540);
delta_within( $r, 6135074.65509657, 1.0 );

$r = $e->range(-4.196435,51.031553,24.058567,87.322753);
delta_within( $r, 5023899.04799815, 1.0 );

$r = $e->range(-67.652957,313.732597,-71.386156,271.586522);
delta_within( $r, 1660409.90595933, 1.0 );

$r = $e->range(-21.495536,200.424780,-75.917093,135.855002);
delta_within( $r, 7019726.39295296, 1.0 );

$r = $e->range(22.533161,284.263825,-14.155207,296.727744);
delta_within( $r, 4280010.12154108, 1.0 );

$r = $e->range(9.344977,262.152203,-2.013487,94.386354);
delta_within( $r, 18449665.9432568, 1.0 );

$r = $e->range(-0.376040,176.244258,-1.529740,305.845852);
delta_within( $r, 14423734.2144593, 1.0 );

$r = $e->range(75.401673,130.305234,8.242361,217.631502);
delta_within( $r, 9046151.06883651, 1.0 );

$r = $e->range(19.738510,158.695298,37.209780,77.814439);
delta_within( $r, 7924143.43717978, 1.0 );

$r = $e->range(47.822247,110.299360,51.524056,32.324924);
delta_within( $r, 5370228.68016772, 1.0 );

$r = $e->range(71.747223,336.092025,84.128794,222.676574);
delta_within( $r, 2373490.55772175, 1.0 );

$r = $e->range(-77.954568,40.691029,23.517948,26.717480);
delta_within( $r, 11295702.8119205, 1.0 );

$r = $e->range(10.333298,84.313406,20.153222,336.438821);
delta_within( $r, 11445995.4323242, 1.0 );

$r = $e->range(12.906411,206.733155,-6.402276,43.507509);
delta_within( $r, 18056629.8463095, 1.0 );

$r = $e->range(-47.487015,359.498721,10.299597,310.960507);
delta_within( $r, 7994361.92626302, 1.0 );

$r = $e->range(-38.318437,262.779852,57.826419,175.943954);
delta_within( $r, 13335704.3099086, 1.0 );

$r = $e->range(16.748547,40.377857,-61.506088,251.664078);
delta_within( $r, 14458771.1110672, 1.0 );

$r = $e->range(17.067788,317.877537,-12.401527,75.628131);
delta_within( $r, 13337609.2428058, 1.0 );

$r = $e->range(-57.208230,247.494628,-50.737489,95.206424);
delta_within( $r, 7772006.22766487, 1.0 );

$r = $e->range(-49.841955,177.356139,-41.792872,160.579825);
delta_within( $r, 1575547.64969953, 1.0 );

$r = $e->range(-47.475272,106.843903,27.113505,269.915143);
delta_within( $r, 17310278.8481573, 1.0 );

$r = $e->range(34.666165,152.960690,46.720069,143.422437);
delta_within( $r, 1559923.48397848, 1.0 );

$r = $e->range(-22.681576,230.794842,6.087350,323.707746);
delta_within( $r, 10572763.8220759, 1.0 );

$r = $e->range(27.970395,335.040139,-88.231065,62.080991);
delta_within( $r, 13085335.6954737, 1.0 );

$r = $e->range(25.808871,275.774114,31.740387,277.375893);
delta_within( $r, 675725.333438778, 1.0 );

$r = $e->range(45.986532,322.536805,-50.794083,229.175856);
delta_within( $r, 13953948.1374991, 1.0 );

$r = $e->range(17.494026,224.034545,-24.264719,25.530801);
delta_within( $r, 17965507.3531682, 1.0 );

$r = $e->range(-44.552076,129.996443,-2.946633,181.334105);
delta_within( $r, 6807788.5252225, 1.0 );

$r = $e->range(-37.816059,85.936197,29.247477,323.170028);
delta_within( $r, 14706545.4827415, 1.0 );

$r = $e->range(30.861009,15.545439,60.769966,205.929510);
delta_within( $r, 9804641.6548905, 1.0 );

$r = $e->range(-56.909608,9.518430,-4.443063,202.739897);
delta_within( $r, 13098475.531576, 1.0 );

$r = $e->range(-59.778517,219.758248,25.579668,110.301202);
delta_within( $r, 13512312.4108798, 1.0 );

$r = $e->range(82.221120,275.743098,24.479559,24.731901);
delta_within( $r, 7599186.99464375, 1.0 );

$r = $e->range(-66.482427,272.564728,-3.542695,257.290127);
delta_within( $r, 7085763.41378554, 1.0 );

$r = $e->range(-69.252209,230.640539,-18.297118,254.265464);
delta_within( $r, 5890965.07279852, 1.0 );

$r = $e->range(51.113328,253.823581,-41.662645,280.971459);
delta_within( $r, 10611264.6198801, 1.0 );

$r = $e->range(-65.854390,99.691638,-75.374219,76.773535);
delta_within( $r, 1341411.2953883, 1.0 );

$r = $e->range(-54.703787,222.914699,19.210089,197.750208);
delta_within( $r, 8532380.89660347, 1.0 );

$r = $e->range(12.156497,45.130760,-77.037944,317.821511);
delta_within( $r, 11244996.5932223, 1.0 );

$r = $e->range(-62.410271,203.679753,-33.008089,120.526333);
delta_within( $r, 6468870.05226223, 1.0 );

$r = $e->range(-52.993406,243.455936,-82.847048,15.254084);
delta_within( $r, 4692974.24163806, 1.0 );

$r = $e->range(56.873155,23.266927,37.404405,147.424699);
delta_within( $r, 8320802.57201009, 1.0 );

$r = $e->range(69.812806,338.284240,-89.456181,126.278650);
delta_within( $r, 17801346.7151877, 1.0 );

$r = $e->range(78.916953,356.912286,-25.430764,351.624329);
delta_within( $r, 11582869.9286414, 1.0 );

$r = $e->range(-85.258035,122.791865,62.315250,157.757983);
delta_within( $r, 16468047.7945594, 1.0 );

$r = $e->range(36.633751,205.416787,-71.376286,65.110415);
delta_within( $r, 15518071.8417664, 1.0 );

$r = $e->range(-46.759865,246.329948,87.319232,184.898940);
delta_within( $r, 15033799.1996245, 1.0 );

$r = $e->range(72.161234,168.054555,-4.615513,146.711647);
delta_within( $r, 8658001.58424714, 1.0 );

$r = $e->range(46.528455,41.408793,-63.744034,251.688039);
delta_within( $r, 17336212.6585499, 1.0 );

