static const char *marpaESLIFJSON_decode_extended_grammars =
  "                   #######################################################\n"
  "                   # >>>>>>>>>>>>>>> Extended JSON Grammar <<<<<<<<<<<<<<<\n"
  "                   #######################################################\n"
  "\n"
  "# --------------------------------------------------\n"
  "# Meta settings\n"
  "# --------------------------------------------------\n"
  ":desc              ::= 'Extended JSON Grammar'\n"
  ":default           ::= regex-action => marpaESLIFJsonRegexAction fallback-encoding => UTF-8\n"
  "\n"
  "# -----------------------------------------------------------\n"
  "# Discard unsignificant whitespaces, Perl comment C++ comment\n"
  "# -----------------------------------------------------------\n"
  ":discard           ::= /[\\x{9}\\x{A}\\x{D}\\x{20}]+|#[^\\n]*|\\/\\/[^\\n]*|\\/\\*(?:(?:[^\\*]+|\\*(?!\\/))*)\\*\\//u\n"
  "\n"
  "# ----------------\n"
  "# Start is a value\n"
  "# ----------------\n"
  ":start             ::= value\n"
  "\n"
  "# ----------\n"
  "# JSON value\n"
  "# ----------\n"
  "value              ::= object\n"
  "                     | array\n"
  "                     | string\n"
  "                     | constant_or_number\n"
  "\n"
  "# -----------\n"
  "# JSON object\n"
  "# -----------\n"
  "object             ::= /\\{(?C10)/ members /\\}(?C20)/\n"
  "members            ::= pair*              separator => commas proper => 0 # Multiple commas everywhere\n"
  "pair               ::= string ':' value\n"
  "\n"
  "# ----------\n"
  "# JSON Array\n"
  "# ----------\n"
  "array              ::= /\\[(?C30)/ elements /\\](?C40)/\n"
  "elements           ::= value*             separator => commas proper => 0 # Multiple commas everywhere\n"
  "\n"
  "# -----------\n"
  "# JSON String\n"
  "# -----------\n"
  "string             ::= /\"(?C50)(?:((?:[^\"\\\\]+)|(?:\\\\[\"\\\\\\/bfnrt])|(?:(?:\\\\u[[:xdigit:]]{4})+))(?C51))*\"(?C52)/\n"
  "\n"
  "# -----------------------\n"
  "# JSON constant or number\n"
  "# -----------------------\n"
  "constant_or_number ::= /true(?C60)|false(?C61)|null(?C62)|(?:[+-]?(?:[0-9]+)(?:\\.[0-9]+)?(?:E[+-]?[0-9]+)?)(?C63)|(?:\\+?Inf(?:inity)?)(?C64)|(?:-?Inf(?:inity)?)(?C65)|(?:\\+?NaN)(?C66)|(?:-?NaN)(?C67)/i\n"
  "\n"
  "# ---------\n"
  "# Separator\n"
  "# ---------\n"
  "comma              ::= ','\n"
  "commas             ::= comma+\n"
  ;
