package Daje::Plugin::Perl::Generate::BaseClass;
use Mojo::Base -base, -signatures;

our $VERSION = '0.01';

has 'config';
has 'template';

sub generate($self) {
    my $tpl = $self->template->get_data_section('baseclass');

    my $base_name_space = $self->config->{CLASS}->{base_name_space};

    my $date = localtime();
    $tpl =~ s/<<date>>/$date/ig;
    $tpl =~ s/<<base_name_space>>/$base_name_space/ig;

    my $output = Daje::Plugin::Output::Class->new(
        config         => $self->config(),
        table_name     => "Base",
        perl           => $tpl,
        name_space_dir => "base_space_dir",
    );
    $output->save_file();
}

1;
#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Plugin::Perl::Generate::BaseClass


=head1 REQUIRES

L<Mojo::Base> 


=head1 METHODS

=head2 generate($self)

 generate($self)();


=cut

