#!/bin/perl

use strict;
use warnings;
use Test::More;
use Scalar::Util qw(looks_like_number);

use Arcus::Client;

open(STDERR, '>', '/dev/null');

my $cache = Arcus::Client->new({
  zk_address => [ "127.0.0.1:2181" ],
  service_code => "test",
  namespace => "perl-test:",
});

ok($cache->set("key", "value"));
is($cache->get("key"), "value", "Get After Set - Value");

ok($cache->delete("key"));
is($cache->get("key"), undef, "Get After Delete Is Undef");

is($cache->get(), undef, "Get Without Key Is Undef");
is($cache->get(""), undef, "Get With Empty String Key Is Undef");
is($cache->get(undef), undef, "Get With Undef Key Is Undef");

ok($cache->set("key", ""));
is($cache->get("key"), "", "Get After Set Empty String Returns Empty String");

ok($cache->set("key", "value"));
my $ref = $cache->gets("key");

ok($ref, "Gets After Set Is Not Undef");
ok(looks_like_number($ref->[0]), "Gets After Set - Cas Is Number");
is($ref->[1], "value", "Gets After Set - Value");

ok($cache->delete("key"));
is($cache->gets("key"), undef, "Gets After Delete Is Undef");

is($cache->gets(), undef, "Gets Without Key Is Undef");
is($cache->gets(""), undef, "Gets With Empty String Key Is Undef");
is($cache->gets(undef), undef, "Gets With Undef Key Is Undef");

ok($cache->flush_all);

ok($cache->set("key", ""));
$ref = $cache->get_or_set("key", sub {
  return "value";
}, 60);
is($ref, "", "Get Or Set To Stored Value Returns Old Value");

ok($cache->delete("key"));
$ref = $cache->get_or_set("key", sub {
  return "value";
}, 60);
is($ref, "value", "Get Or Set To Not Stored Value Returns Callback Value");

done_testing();
