#!/bin/perl

use strict;
use warnings;
use Test::More;

use Arcus::Client;

open(STDERR, '>', '/dev/null');

my $cache = Arcus::Client->new({
  zk_address => [ "127.0.0.1:2181" ],
  service_code => "test",
  namespace => "perl-test:",
});

ok($cache->add("iek", 129), "Add Test");
is($cache->get("iek"), 129, "Get Test");

ok($cache->delete("iek"), "Delete Test");
ok(!$cache->get("iek"), "Get Fail Test");
ok(!$cache->delete("iek"), "Delete Fail Test");

# ok($cache->add("iek", 129), "Add Test");
# is($cache->get("iek"), 129, "Get Test");
#
# ok($cache->delete("iek", 1), "Delete After 1s Test");
# is($cache->get("iek"), 129, "Get Test");
#
# sleep(1);
# ok(!$cache->get("iek"), "Get After 1s Fail Test");
# ok(!$cache->delete("iek"), "Delete After 1s Fail Test");

ok($cache->flush_all, "Flush All");
done_testing();
