use 5.014000;
use ExtUtils::MakeMaker;
use Cwd 'abs_path';
use FindBin '$Bin';
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $cache_hit = $ARGV[0] =~ /CACHE_HIT=(\d+)/ ? $1 : 0;
system("./deps/install.sh") unless $cache_hit;

my $src_path = abs_path($FindBin::Bin);
WriteMakefile(
  NAME              => 'Arcus::Base',
  DISTNAME          => 'Arcus-Client',
  VERSION           => '0.5.0',
  PREREQ_PM         => {},
  AUTHOR            => 'JaM2in <koo05131@jam2in.com>',
  LIBS              => ["-L$src_path/lib/Arcus/Deps/lib -lmemcached -lmemcachedutil"], # e.g., '-lm'
  DEFINE            => '',
  INC               => "-I$src_path/lib/Arcus/Deps/include",
  dynamic_lib       => { OTHERLDFLAGS => "-Wl,-rpath,$src_path/lib/Arcus/Deps/lib,-rpath,\$(DESTINSTALLSITEARCH)/Arcus/Deps/lib" }
);
