use Game::AI::Messaging::Message;

class Game::AI::Messaging::AIMessage is Game::AI::Messaging::Message {

	has $.timestamp is rw; ### UNIX timestamp ofthis message

	method BUILD($originator, $acceptor, $friend-or-foe, $msg-body) {

		Game::AI::Messaging::Message.new($originator, $acceptor, $friend-or-foe, $msg-body);

	}

	method split-message {

		return (self.originator, self.acceptor, self.friend-or-foe, self.msg-body, self.timestamp);
	}

	method split-message($msg) {

		if ($msg.elems > 4) {

			return ($msg.originator, $msg.acceptor, $msg.friend-or-foe, $msg.actual, $msg.timestamp);
		} else {
			return ($msg.originator, $msg.acceptor, $msg.friend-or-foe, $msg.actual);
		}
	}

	method timestamp {
		return $.timestamp;
	}

}
