unit module Bayes::Learn;
use Mathx::Stat;

class Bayes::Learn::Hypothesis is Mathx::Stat::DistributionPopulation {

	has @.hs;

	method BUILD(@distribution) { ### The 
		.population = @distribution; ### posterior

		@hs = <>; ### hopothesis list

	}

	method addh($h) { ### add a new hypothesis, which helps Bayesian learning
		push(@hs, $h);
	}

	method hMAP(@condps, $hidx) { ### Maximum a posteriori, 1 hypothesis
		my $prob = new Probability(.population);		
		my $condprob = new Probability(@condps); 

		my @indices = 0..^.population.length;

		return $prob.Bayes(@indices, $condprob.population, $hidx);
	}

	method hMAP(@condps) { ### Brute Force MAP learner

		my $max = 0.0;
		my $h = 0.0;
		loop (my $i = 0; $i < .hs.length; $i++) {
			if (my $p = self.hMAP(@condps, $i) > $max) {
				$max = $p;
				$h = .hs.nth($i);
			}
		}
		return $h;
	}

	method hML(@condps) { ### Learning a real valued function 
			      ### hML = argmax (D|h) 
			      ### = argmax Product(p(d_i,h))
			 
		my $max = 0.0;
		my $hh = 0.0;

		for .hs -> $h {
			my $sum = 0.0;
			loop (my $i = 0; $i < .hs.length; $i++) {
				$sum += - (self.nth($i) - $h) * (self.nth($i) - $h);
			}	
			if ($sum > $max) {
				$max = $sum;
				$hh = $h;
			}
		}

		return $hh;
	}
		

}	
