/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.server;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.seleniumhq.jetty7.http.HttpParser;
import org.seleniumhq.jetty7.io.Buffer;
import org.seleniumhq.jetty7.server.AbstractHttpConnection;

public class HttpInput
extends ServletInputStream {
    protected final AbstractHttpConnection _connection;
    protected final HttpParser _parser;

    public HttpInput(AbstractHttpConnection connection) {
        this._connection = connection;
        this._parser = (HttpParser)connection.getParser();
    }

    public int read() throws IOException {
        int c = -1;
        Buffer content = this._parser.blockForContent(this._connection.getMaxIdleTime());
        if (content != null) {
            c = 0xFF & content.get();
        }
        return c;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int l = -1;
        Buffer content = this._parser.blockForContent(this._connection.getMaxIdleTime());
        if (content != null) {
            l = content.get(b, off, len);
        }
        return l;
    }

    public int available() throws IOException {
        return this._parser.available();
    }
}

