/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogLevelMapping;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.logging.SessionLogs;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.SimplePropertyDescriptor;

public class BeanToJsonConverter {
    private static final int MAX_DEPTH = 5;

    public String convert(Object object) {
        if (object == null) {
            return null;
        }
        try {
            JsonElement json = this.convertObject(object);
            return new GsonBuilder().disableHtmlEscaping().serializeNulls().create().toJson(json);
        }
        catch (Exception e) {
            throw new WebDriverException("Unable to convert: " + object, e);
        }
    }

    public JsonElement convertObject(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        try {
            return this.convertObject(object, 5);
        }
        catch (Exception e) {
            throw new WebDriverException("Unable to convert: " + object, e);
        }
    }

    private JsonElement convertObject(Object toConvert, int maxDepth) throws Exception {
        if (toConvert == null) {
            return JsonNull.INSTANCE;
        }
        if (toConvert instanceof Boolean) {
            return new JsonPrimitive((Boolean)toConvert);
        }
        if (toConvert instanceof CharSequence) {
            return new JsonPrimitive(String.valueOf(toConvert));
        }
        if (toConvert instanceof Number) {
            return new JsonPrimitive((Number)toConvert);
        }
        if (toConvert instanceof Level) {
            return new JsonPrimitive(LogLevelMapping.getName((Level)toConvert));
        }
        if (toConvert.getClass().isEnum() || toConvert instanceof Enum) {
            return new JsonPrimitive(toConvert.toString());
        }
        if (toConvert instanceof LoggingPreferences) {
            LoggingPreferences prefs = (LoggingPreferences)toConvert;
            JsonObject converted = new JsonObject();
            for (String logType : prefs.getEnabledLogTypes()) {
                converted.addProperty(logType, LogLevelMapping.getName(prefs.getLevel(logType)));
            }
            return converted;
        }
        if (toConvert instanceof SessionLogs) {
            return this.convertObject(((SessionLogs)toConvert).getAll(), maxDepth - 1);
        }
        if (toConvert instanceof LogEntries) {
            return this.convertObject(((LogEntries)toConvert).getAll(), maxDepth - 1);
        }
        if (toConvert instanceof Map) {
            JsonObject converted = new JsonObject();
            Iterator logType = ((Map)toConvert).entrySet().iterator();
            while (logType.hasNext()) {
                Map.Entry objectEntry;
                Map.Entry entry = objectEntry = logType.next();
                converted.add((String)entry.getKey(), this.convertObject(entry.getValue(), maxDepth - 1));
            }
            return converted;
        }
        if (toConvert instanceof JsonElement) {
            return (JsonElement)toConvert;
        }
        if (toConvert instanceof Collection) {
            JsonArray array = new JsonArray();
            for (Object o : (Collection)toConvert) {
                array.add(this.convertObject(o, maxDepth - 1));
            }
            return array;
        }
        if (toConvert.getClass().isArray()) {
            JsonArray converted = new JsonArray();
            int length = Array.getLength(toConvert);
            int i = 0;
            while (i < length) {
                converted.add(this.convertObject(Array.get(toConvert, i), maxDepth - 1));
                ++i;
            }
            return converted;
        }
        if (toConvert instanceof SessionId) {
            JsonObject converted = new JsonObject();
            converted.addProperty("value", toConvert.toString());
            return converted;
        }
        if (toConvert instanceof Date) {
            return new JsonPrimitive(TimeUnit.MILLISECONDS.toSeconds(((Date)toConvert).getTime()));
        }
        if (toConvert instanceof File) {
            return new JsonPrimitive(((File)toConvert).getAbsolutePath());
        }
        Method toMap = this.getMethod(toConvert, "toMap");
        if (toMap == null) {
            toMap = this.getMethod(toConvert, "asMap");
        }
        if (toMap != null) {
            try {
                return this.convertObject(toMap.invoke(toConvert, new Object[0]), maxDepth - 1);
            }
            catch (IllegalArgumentException e) {
                throw new WebDriverException(e);
            }
            catch (IllegalAccessException e) {
                throw new WebDriverException(e);
            }
            catch (InvocationTargetException e) {
                throw new WebDriverException(e);
            }
        }
        Method toList = this.getMethod(toConvert, "toList");
        if (toList == null) {
            toList = this.getMethod(toConvert, "asList");
        }
        if (toList != null) {
            try {
                return this.convertObject(toList.invoke(toConvert, new Object[0]), maxDepth - 1);
            }
            catch (IllegalArgumentException e) {
                throw new WebDriverException(e);
            }
            catch (IllegalAccessException e) {
                throw new WebDriverException(e);
            }
            catch (InvocationTargetException e) {
                throw new WebDriverException(e);
            }
        }
        Method toJson = this.getMethod(toConvert, "toJson");
        if (toJson != null) {
            try {
                Object res = toJson.invoke(toConvert, new Object[0]);
                if (res instanceof JsonElement) {
                    return (JsonElement)res;
                }
                try {
                    return new JsonParser().parse((String)res);
                }
                catch (JsonParseException jsonParseException) {
                    return new JsonPrimitive((String)res);
                }
            }
            catch (IllegalArgumentException e) {
                throw new WebDriverException(e);
            }
            catch (IllegalAccessException e) {
                throw new WebDriverException(e);
            }
            catch (InvocationTargetException e) {
                throw new WebDriverException(e);
            }
        }
        try {
            return this.mapObject(toConvert, maxDepth - 1, toConvert instanceof Cookie);
        }
        catch (Exception e) {
            throw new WebDriverException(e);
        }
    }

    private Method getMethod(Object toConvert, String methodName) {
        try {
            return toConvert.getClass().getMethod(methodName, new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    private JsonElement mapObject(Object toConvert, int maxDepth, boolean skipNulls) throws Exception {
        if (maxDepth < 1) {
            return JsonNull.INSTANCE;
        }
        JsonObject mapped = new JsonObject();
        SimplePropertyDescriptor[] simplePropertyDescriptorArray = SimplePropertyDescriptor.getPropertyDescriptors(toConvert.getClass());
        int n = simplePropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimplePropertyDescriptor pd = simplePropertyDescriptorArray[n2];
            if ("class".equals(pd.getName())) {
                mapped.addProperty("class", toConvert.getClass().getName());
            } else {
                Method readMethod = pd.getReadMethod();
                if (readMethod != null && readMethod.getParameterTypes().length <= 0) {
                    readMethod.setAccessible(true);
                    Object result = readMethod.invoke(toConvert, new Object[0]);
                    if (!skipNulls || result != null) {
                        mapped.add(pd.getName(), this.convertObject(result, maxDepth - 1));
                    }
                }
            }
            ++n2;
        }
        return mapped;
    }
}

