/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class HtmlLink
extends HtmlElement {
    public static final String TAG_NAME = "link";
    private WebResponse cachedWebResponse_;

    HtmlLink(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getCharsetAttribute() {
        return this.getAttribute("charset");
    }

    public final String getHrefAttribute() {
        return this.getAttribute("href");
    }

    public final String getHrefLangAttribute() {
        return this.getAttribute("hreflang");
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getRelAttribute() {
        return this.getAttribute("rel");
    }

    public final String getRevAttribute() {
        return this.getAttribute("rev");
    }

    public final String getMediaAttribute() {
        return this.getAttribute("media");
    }

    public final String getTargetAttribute() {
        return this.getAttribute("target");
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded) throws IOException {
        if (downloadIfNeeded && this.cachedWebResponse_ == null) {
            WebClient webclient = this.getPage().getWebClient();
            this.cachedWebResponse_ = webclient.loadWebResponse(this.getWebRequest());
        }
        return this.cachedWebResponse_;
    }

    public WebRequest getWebRequest() throws MalformedURLException {
        HtmlPage page = (HtmlPage)this.getPage();
        URL url = page.getFullyQualifiedUrl(this.getHrefAttribute());
        WebRequest request = new WebRequest(url);
        request.setAdditionalHeader("Referer", page.getUrl().toExternalForm());
        return request;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (this.hasFeature(BrowserVersionFeatures.CSS_DISPLAY_BLOCK2)) {
            return HtmlElement.DisplayStyle.NONE;
        }
        return HtmlElement.DisplayStyle.INLINE;
    }
}

