/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsxClass
public final class DOMTokenList
extends SimpleScriptable {
    private String attributeName_;

    public DOMTokenList() {
    }

    public DOMTokenList(Node node, String attributeName) {
        this.setDomNode((DomNode)node.getDomNodeOrDie(), false);
        this.setParentScope(node.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributeName_ = attributeName;
    }

    @JsxGetter
    public int getLength() {
        Object value = this.getDefaultValue((Class)null);
        return ((String)value).split(" ").length;
    }

    @Override
    public String getDefaultValue(Class<?> hint) {
        DomAttr attr = (DomAttr)((DomNode)this.getDomNodeOrDie()).getAttributes().getNamedItem(this.attributeName_);
        if (attr != null) {
            String value = attr.getValue();
            return value;
        }
        return "";
    }

    @JsxFunction
    public void add(String token) {
        if (!this.contains(token)) {
            DomAttr attr = (DomAttr)((DomNode)this.getDomNodeOrDie()).getAttributes().getNamedItem(this.attributeName_);
            attr.setValue(attr.getValue() + ' ' + token);
        }
    }

    @JsxFunction
    public void remove(String token) {
        DomAttr attr;
        if (this.contains(token) && (attr = (DomAttr)((DomNode)this.getDomNodeOrDie()).getAttributes().getNamedItem(this.attributeName_)) != null) {
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(attr.getValue().split(" ")));
            values.remove(token);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < values.size(); ++i) {
                builder.append((String)values.get(i));
                if (i >= values.size() - 1) continue;
                builder.append(' ');
            }
            attr.setValue(builder.toString());
        }
    }

    @JsxFunction
    public boolean toggle(String token) {
        if (this.contains(token)) {
            this.remove(token);
            return false;
        }
        this.add(token);
        return true;
    }

    @JsxFunction
    public boolean contains(String token) {
        DomAttr attr = (DomAttr)((DomNode)this.getDomNodeOrDie()).getAttributes().getNamedItem(this.attributeName_);
        if (attr != null) {
            List<String> values = Arrays.asList(attr.getValue().split(" "));
            return values.contains(token);
        }
        return false;
    }

    @JsxFunction
    public Object item(int index) {
        List<String> values;
        DomAttr attr = (DomAttr)((DomNode)this.getDomNodeOrDie()).getAttributes().getNamedItem(this.attributeName_);
        if (attr != null && index < (values = Arrays.asList(attr.getValue().split(" "))).size()) {
            return values.get(index);
        }
        return null;
    }
}

