package Tk::TabbedForm::CScaleItem;

=head1 NAME

Tk::TabbedForm::CScaleItem - Scale widget for Tk::TabbedForm.

=cut

use strict;
use warnings;
use Tk;
use base qw(Tk::Derived Tk::TabbedForm::CBaseClass);
Construct Tk::Widget 'CScaleItem';
require Tk::Scale;

=head1 SYNOPSIS

 require Tk::TabbedForm::CScaleItem;
 my $bool = $window->CScaleItem(@options)->pack;

=head1 DESCRIPTION

Inherits L<Tk::TabbedForm::CBaseClass>.  Provides a Scale widget for L<Tk::TabbedForm>.

You should never create an instance directly like above. This should
be handled by L<Tk::TabbedForm>.

=head1 B<CONFIG VARIABLES>

All options, except I<-variable>, of L<Tk::Scale> are available.

=cut

sub Populate {
	my ($self,$args) = @_;

	$self->SUPER::Populate($args);

	$self->ConfigSpecs(
		DEFAULT => [$self->Subwidget('Scale')],
	);
}

sub createHandler {
	my ($self, $var) = @_;
	my $c = $self->Scale(
		-orient => 'horizontal',
		-variable => $var,
	)->pack(-side => 'left', -padx => 2, -expand => 1, -fill => 'x');
	$self->Advertise(Scale => $c);
}


=head1 LICENSE

Same as Perl.

=head1 AUTHOR

Hans Jeuken (hanje at cpan dot org)

=head1 BUGS

Unknown. If you find any, please contact the author.

=head1 SEE ALSO

=over 4

=item L<Tk::Scale>

=item L<Tk::TabbedForm>

=item L<Tk::TabbedForm::CBaseClass>

=back

=cut


1;

__END__
