package Tk::TabbedForm::CFloatItem;

=head1 NAME

Tk::TabbedForm::CFloatItem - Floating numbers entry widget for Tk::TabbedForm.

=cut

use strict;
use warnings;
use Tk;
use base qw(Tk::Derived Tk::TabbedForm::CTextItem);
Construct Tk::Widget 'CFloatItem';

use Scalar::Util::Numeric qw(isfloat isint);

=head1 SYNOPSIS

 require Tk::TabbedForm::CFloatItem;
 my $bool = $window->CFloatItem(@options)->pack;

=head1 DESCRIPTION

Inherits L<Tk::TabbedForm::CTextItem>. Provides an entry for floating point numbers to L<Tk::TabbedForm>.

You should never create an instance directly like above. This should
be handled by L<Tk::TabbedForm>.

=cut

sub validate {
	my $self = shift;
	my $var = $self->variable;
	my $flag = 0;
	$flag = 1 if $$var eq '';
	$flag = 1 if isint $$var;
	$flag = 1 if isfloat $$var;
	$self->validUpdate($flag);
	return 1
}

=back

=head1 LICENSE

Same as Perl.

=head1 AUTHOR

Hans Jeuken (hanje at cpan dot org)

=head1 BUGS

Unknown. If you find any, please contact the author.

=head1 SEE ALSO

=over 4

=item L<Tk::TabbedForm>

=item L<Tk::TabbedForm::CBaseClass>

=item L<Tk::TabbedForm::CTextItem>

=back

=cut


1;

__END__
