package Foo::Testmysqlorm::Team::ResultClass;

use Modern::Perl;
use Moose;
use namespace::autoclean;
use Method::Signatures;
use Data::Printer alias => 'pdump';

has city => (
## type:    varchar(30)
## key:
## autoinc: no
## null:    no
## default:
    is      => 'rw',
    isa     => 'Str|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{city}++;
    },
);

has league_id => (
## type:    int(11)
## key:     MUL
## autoinc: no
## null:    no
## default:
    is      => 'rw',
    isa     => 'Num|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{league_id}++;
    },
);

has team_id => (
## type:    int(11)
## key:     PRI
## autoinc: yes
## null:    no
## default:
    is      => 'rw',
    isa     => 'Num|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{team_id}++;
    },
);

has team_name => (
## type:    varchar(20)
## key:     MUL
## autoinc: no
## null:    no
## default:
    is      => 'rw',
    isa     => 'Str|HashRef',
    trigger => sub {
        my $self = shift;
        $self->_touched->{team_name}++;
    },
);

has _touched => (
    is      => 'rw',
    isa     => 'HashRef',
    default => sub { {} },
);

method get_touched_attributes (
) {
    my @attr = keys %{ $self->_touched };

    return @attr;
}

1;
