package Foo::Testmysqlorm::League;

use Modern::Perl;
use Moose;
use namespace::autoclean;
use Method::Signatures;
use Data::Printer alias => 'pdump';
use Foo::Testmysqlorm::League::ResultClass;
use Foo::Testmysqlorm::League::ResultClassX;

extends 'MySQL::ORM';

with 'Foo::Testmysqlorm::League::CustomRole';

has table_name => (
    is       => 'ro',
    isa      => 'Str',
    init_arg => undef,
    default  => 'league',
);

method delete (
    Num|HashRef :$league_id,
    Str|HashRef :$league_name,
    Num|HashRef :$sport_id
) {
    my %a = @_;
    my %w;

    foreach my $arg ( keys %a ) {
        $w{$arg} = $a{$arg};
    }

    my $ret = $self->SUPER::delete(
        table => $self->table_name,
        where => \%w
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

method get_id (
    Num|HashRef :$sport_id,
    Str|HashRef :$league_name
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        $where{$arg} = $a{$arg};
    }

    my $rows = $self->SUPER::select(
        table => $self->table_name,
        where => \%where
    );

    if ( @$rows == 1 ) {
        my $row = shift @$rows;
        return $row->{league_id};
    }

    confess "too many rows returned" if @$rows > 1;

    return;
}

method insert (
    Str|HashRef :$league_name,
    Num|HashRef :$sport_id
) {
    my %a = @_;
    my %v;

    foreach my $arg ( keys %a ) {
        $v{$arg} = $a{$arg};
    }

    my $ret = $self->SUPER::insert(
        table  => $self->table_name,
        values => \%v
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

method is_primary_key_autoinc (
) {
    return 1;
}

method select (
    Num|HashRef :$league_id,
    Str|HashRef :$league_name,
    Num|HashRef :$sport_id,
    ArrayRef :$order_by
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        next if $arg eq 'order_by';
        $where{$arg} = $a{$arg};
    }

    my %s;
    $s{table}    = $self->table_name;
    $s{where}    = \%where;
    $s{order_by} = $order_by if $order_by;

    my $rows = $self->SUPER::select(%s);

    my @obj;
    foreach my $row (@$rows) {
        push @obj, Foo::Testmysqlorm::League::ResultClass->new(%$row);
    }

    return @obj;
}

method select_one (
    Num|HashRef :$league_id,
    Str|HashRef :$league_name,
    Num|HashRef :$sport_id
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        $where{$arg} = $a{$arg};
    }

    my $row = $self->SUPER::select_one(
        table => $self->table_name,
        where => \%where
    );
    if ($row) {
        return Foo::Testmysqlorm::League::ResultClass->new(%$row);
    }

    return;
}

method selectx (
    Num|HashRef :$league_id,
    Str|HashRef :$league_name,
    Num|HashRef :$sport_id,
    Str|HashRef :$sport_name,
    Bool :$left_join,
    ArrayRef :$order_by
) {
    my %table2alias = (
        'league' => 't1',
        'sport'  => 't2',
    );

    my %arg2table = (
        league_id   => 'league',
        league_name => 'league',
        sport_id    => 'league',
        sport_name  => 'sport',
    );

    my $sql = qq{
        select
            t1.league_id,
            t1.league_name,
            t1.sport_id,
            t2.sport_name
        from
            league t1
        left
            join sport t2 on (
                t1.sport_id = t2.sport_id
            )
    };

    my %a = $self->prune_ddl_args( [@_] );

    my %where;

    foreach my $arg ( keys %a ) {
        my $table = $arg2table{$arg};
        my $alias = $table2alias{$table};
        my $col   = "$alias.$arg";
        $where{$col} = $a{$arg};
    }

    my ( $where, @bind ) = $self->make_where_clause( where => \%where );
    $sql .= $where;

    if ($order_by) {
        my @order;
        foreach my $col (@$order_by) {
            my $table = $arg2table{$col};
            my $alias = $table2alias{$table};
            push @order, "$alias.$col";
        }
        $sql .= "order by " . join( ', ', @order );
    }

    my $sth = $self->dbh->prepare($sql);
    $sth->execute(@bind);

    my @obj;

    while ( my $row = $sth->fetchrow_hashref ) {
        push @obj, Foo::Testmysqlorm::League::ResultClassX->new(%$row);
    }

    return @obj;
}

method selectx_one (
    Num|HashRef :$league_id,
    Str|HashRef :$league_name,
    Num|HashRef :$sport_id,
    Str|HashRef :$sport_name,
    Bool :$left_join
) {
    my @rows = $self->selectx(@_);
    if (@rows) {
        return shift @rows;
    }

    return;
}

method update (
    Foo::Testmysqlorm::League::ResultClass :$set,
    Num|HashRef :$league_id,
    Str|HashRef :$league_name,
    Num|HashRef :$sport_id
) {
    my %a = @_;
    my %where;

    foreach my $arg ( keys %a ) {
        next if $arg eq 'set';
        $where{$arg} = $a{$arg};
    }

    my %values;
    my @attrs = $set->get_touched_attributes;
    foreach my $attr (@attrs) {
        $values{$attr} = $set->$attr;
    }

    my $ret = $self->SUPER::update(
        table  => $self->table_name,
        values => \%values,
        where  => \%where
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

method upsert (
    Str|HashRef :$league_name,
    Num|HashRef :$sport_id
) {
    my %a = @_;
    my %v;

    foreach my $arg ( keys %a ) {
        $v{$arg} = $a{$arg};
    }

    my $ret = $self->SUPER::upsert(
        table  => $self->table_name,
        values => \%v
    );

    if ( defined $ret ) {

        # convert 0E0 to zero if necessary
        return int($ret);
    }

    return;
}

1;
