#include <stdio.h>
#include <EXTERN.h>
#include <perl.h>
static PerlInterpreter *my_perl;
static void
PerlPower(int a, int b)
{
  dSP;                            /* initialize stack pointer      */
  ENTER;                          /* everything created after here */
  SAVETMPS;                       /* ...is a temporary variable.   */
  PUSHMARK(sp);                   /* remember the stack pointer    */
  XPUSHs(sv_2mortal(newSViv(a))); /* push the base onto the stack  */
  XPUSHs(sv_2mortal(newSViv(b))); /* push the exponent onto stack  */
  PUTBACK;                      /* make local stack pointer global */
  perl_call_pv("expo", G_SCALAR); /* call the function             */
  SPAGAIN;                        /* refresh stack pointer         */
                                  /* pop the return value from stack */
  printf ("%d to the %dth power is %d.\n", a, b, POPi);
  PUTBACK;
  FREETMPS;                       /* free that return value        */
  LEAVE;                       /* ...and the XPUSHed "mortal" args.*/
}
int main (int argc, char **argv, char **env)
{
  char *my_argv[2];
  my_perl = perl_alloc();
  perl_construct( my_perl );
  my_argv[1] = (char *) malloc(10);
  sprintf(my_argv[1], "power.pl");
  perl_parse(my_perl, NULL, argc, my_argv, NULL);
  PerlPower(3, 4);                      /*** Compute 3 ** 4 ***/
  perl_destruct(my_perl);
  perl_free(my_perl);
}
