package Locales::DB::Language::st;

# Auto generated from CLDR

$Locales::DB::Language::st::VERSION = '0.02';

$Locales::DB::Language::st::cldr_version = '1.7.1';

%Locales::DB::Language::st::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::st::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Seburu',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => "Se\-amhari",
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => "Se\-arab",
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => "Se\-azerbaijani",
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => "Se\-belarusia",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => "Se\-bulgaria",
    'bh'    => "Se\-bihari",
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => "Se\-bengali",
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'Breton',
    'bra'   => 'Braj',
    'bs'    => "Se\-bosnia",
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => "Se\-catalia",
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => "Se\-czech",
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => "Se\-welsh",
    'da'    => "Se\-dutch",
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => "Se\-jeremane",
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => "Se\-greek",
    'elx'   => 'Elamite',
    'en'    => 'Senyesemane',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => "Se\-esperanto",
    'es'    => 'Sespain',
    'es_es' => "Iberian\ Spanish",
    'et'    => "Se\-estonia",
    'eu'    => "Se\-basque",
    'ewo'   => 'Ewondo',
    'fa'    => "Se\-persia",
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => "Se\-finnish",
    'fil'   => "Se\-tagalog",
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => "Se\-foroese",
    'fon'   => 'Fon',
    'fr'    => "Se\-french",
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Se\-frisia",
    'ga'    => "Se\-irish",
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Se\-scots\ gaelic",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => "Se\-galicia",
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => "Se\-gujarati",
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => "Se\-hebrew",
    'hi'    => "Se\-hindi",
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => "Se\-croatia",
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => "Se\-hungaria",
    'hup'   => 'Hupa',
    'hy'    => 'Armenian',
    'hz'    => 'Herero',
    'ia'    => "Se\-interlingua",
    'iba'   => 'Iban',
    'id'    => "Se\-indonesia",
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => "Se\-iceland",
    'it'    => "Se\-tariana",
    'iu'    => 'Inuktitut',
    'ja'    => "Se\-japane",
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => "Se\-javane",
    'ka'    => "Se\-geogia",
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => "Se\-kannada",
    'ko'    => "Se\-korea",
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'Kurdish',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kyrgyz',
    'la'    => "Se\-latino",
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => "Se\-Lithuano",
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Latvian',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => "Se\-masedonia",
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => "Se\-malayalam",
    'mn'    => 'Mongolian',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => "Se\-marathi",
    'ms'    => "Se\-malay",
    'mt'    => "Se\-maltese",
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => "Se\-nepali",
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'Dutch',
    'nl_be' => 'Flemish',
    'nn'    => "Se\-norway\ \(Nynorsk\)",
    'no'    => "Se\-norway",
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => "Se\-occitan",
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => "Se\-punjabi",
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => "Se\-polish",
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pashto',
    'pt'    => "Se\-portugal",
    'pt_br' => "Seputukesi\ \(sa\ Brazil\)",
    'pt_pt' => "Se\-portugal\ \(Portugal\)",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => "Se\-romania",
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => "Se\-rushia",
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Serbo\-Croatian",
    'shn'   => 'Shan',
    'si'    => "Se\-sinhali",
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => "Se\-slovak",
    'sl'    => "Se\-slovania",
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somali',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => "Se\-albanian",
    'sr'    => "Se\-serbian",
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'Sesotho',
    'su'    => "Se\-sundanese",
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => "Se\-sweden",
    'sw'    => "Se\-swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => "Se\-tamil",
    'tai'   => "Tai\ Language",
    'te'    => "Se\-telegu",
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => "Se\-thai",
    'ti'    => "Se\-tigrinya",
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => "Se\-klingon",
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => "Se\-theki",
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => "Se\-ukrania",
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => "Se\-urdu",
    'uz'    => "Se\-uzbek",
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => "Se\-vietnam",
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => "se\ Xhosa",
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Chinese',
    'znd'   => 'Zande',
    'zu'    => "se\ Zulu",
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::st::name_to_code = (
    'abkhazian'                     => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afroasiaticlanguage'           => 'afa',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armenian'                      => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'assamese'                      => 'as',
    'asturian'                      => 'ast',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basa'                          => 'bas',
    'bashkir'                       => 'ba',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'braj'                          => 'bra',
    'breton'                        => 'br',
    'britishenglish'                => 'en_gb',
    'buginese'                      => 'bug',
    'buriat'                        => 'bua',
    'burmese'                       => 'my',
    'caddo'                         => 'cad',
    'canadianenglish'               => 'en_ca',
    'canadianfrench'                => 'fr_ca',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chinese'                       => 'zh',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dutch'                         => 'nl',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'fijian'                        => 'fj',
    'finnougrianlanguage'           => 'fiu',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'guarani'                       => 'gn',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'hausa'                         => 'ha',
    'hawaiian'                      => 'haw',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberianspanish'                => 'es_es',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'ingush'                        => 'inh',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'jju'                           => 'kaj',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashmiri'                      => 'ks',
    'kashubian'                     => 'csb',
    'kawi'                          => 'kaw',
    'kazakh'                        => 'kk',
    'khasi'                         => 'kha',
    'khmer'                         => 'km',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kinyarwanda'                   => 'rw',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurdish'                       => 'ku',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kyrgyz'                        => 'ky',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'lao'                           => 'lo',
    'latvian'                       => 'lv',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxembourgish'                 => 'lb',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'malagasy'                      => 'mg',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maori'                         => 'mi',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongolian'                     => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'nahuatl'                       => 'nah',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsami'                  => 'se',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    "norwegianbokm\Ã\¥l"          => 'nb',
    'nubianlanguage'                => 'nub',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'pashto'                        => 'ps',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'rhaetoromance'                 => 'rm',
    'romancelanguage'               => 'roa',
    'romany'                        => 'rom',
    'rundi'                         => 'rn',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samilanguage'                  => 'smi',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sanskrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'sealbanian'                    => 'sq',
    'seamhari'                      => 'am',
    'searab'                        => 'ar',
    'seazerbaijani'                 => 'az',
    'sebasque'                      => 'eu',
    'sebelarusia'                   => 'be',
    'sebengali'                     => 'bn',
    'sebihari'                      => 'bh',
    'sebosnia'                      => 'bs',
    'sebulgaria'                    => 'bg',
    'seburu'                        => 'af',
    'secatalia'                     => 'ca',
    'secroatia'                     => 'hr',
    'seczech'                       => 'cs',
    'sedutch'                       => 'da',
    'seesperanto'                   => 'eo',
    'seestonia'                     => 'et',
    'sefinnish'                     => 'fi',
    'seforoese'                     => 'fo',
    'sefrench'                      => 'fr',
    'sefrisia'                      => 'fy',
    'segalicia'                     => 'gl',
    'segeogia'                      => 'ka',
    'segreek'                       => 'el',
    'segujarati'                    => 'gu',
    'sehebrew'                      => 'he',
    'sehindi'                       => 'hi',
    'sehungaria'                    => 'hu',
    'seiceland'                     => 'is',
    'seindonesia'                   => 'id',
    'seinterlingua'                 => 'ia',
    'seirish'                       => 'ga',
    'sejapane'                      => 'ja',
    'sejavane'                      => 'jv',
    'sejeremane'                    => 'de',
    'sekannada'                     => 'kn',
    'seklingon'                     => 'tlh',
    'sekorea'                       => 'ko',
    'selatino'                      => 'la',
    'selithuano'                    => 'lt',
    'selkup'                        => 'sel',
    'semalay'                       => 'ms',
    'semalayalam'                   => 'ml',
    'semaltese'                     => 'mt',
    'semarathi'                     => 'mr',
    'semasedonia'                   => 'mk',
    'semiticlanguage'               => 'sem',
    'senepali'                      => 'ne',
    'senorway'                      => 'no',
    'senorwaynynorsk'               => 'nn',
    'senyesemane'                   => 'en',
    'seoccitan'                     => 'oc',
    'sepersia'                      => 'fa',
    'sepolish'                      => 'pl',
    'seportugal'                    => 'pt',
    'seportugalportugal'            => 'pt_pt',
    'sepunjabi'                     => 'pa',
    'seputukesisabrazil'            => 'pt_br',
    'serbocroatian'                 => 'sh',
    'serer'                         => 'srr',
    'seromania'                     => 'ro',
    'serushia'                      => 'ru',
    'sescotsgaelic'                 => 'gd',
    'seserbian'                     => 'sr',
    'sesinhali'                     => 'si',
    'seslovak'                      => 'sk',
    'seslovania'                    => 'sl',
    'sesotho'                       => 'st',
    'sespain'                       => 'es',
    'sesundanese'                   => 'su',
    'seswahili'                     => 'sw',
    'sesweden'                      => 'sv',
    'setagalog'                     => 'fil',
    'setamil'                       => 'ta',
    'setariana'                     => 'it',
    'setelegu'                      => 'te',
    'sethai'                        => 'th',
    'setheki'                       => 'tr',
    'setigrinya'                    => 'ti',
    'seukrania'                     => 'uk',
    'seurdu'                        => 'ur',
    'seuzbek'                       => 'uz',
    'sevietnam'                     => 'vi',
    'sewelsh'                       => 'cy',
    'sexhosa'                       => 'xh',
    'sezulu'                        => 'zu',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sindhi'                        => 'sd',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'sogdien'                       => 'sog',
    'somali'                        => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'susu'                          => 'sus',
    'swati'                         => 'ss',
    'swissfrench'                   => 'fr_ch',
    'swissgerman'                   => 'gsw',
    'swisshighgerman'               => 'de_ch',
    'syriac'                        => 'syr',
    'tagalog'                       => 'tl',
    'tahitian'                      => 'ty',
    'tailanguage'                   => 'tai',
    'tajik'                         => 'tg',
    'tamashek'                      => 'tmh',
    'taroko'                        => 'trv',
    'tatar'                         => 'tt',
    'tereno'                        => 'ter',
    'tetum'                         => 'tet',
    'tibetan'                       => 'bo',
    'tigre'                         => 'tig',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turkmen'                       => 'tk',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    "u\.s\.english"                 => 'en_us',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'umbundu'                       => 'umb',
    'unknownorinvalidlanguage'      => 'und',
    'uppersorbian'                  => 'hsb',
    'uyghur'                        => 'ug',
    'vai'                           => 'vai',
    'venda'                         => 've',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wolof'                         => 'wo',
    'yakut'                         => 'sah',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yiddish'                       => 'yi',
    'yoruba'                        => 'yo',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zuni'                          => 'zun',
);

1;
