package Locales::DB::Language::sr;

# Auto generated from CLDR

$Locales::DB::Language::sr::VERSION = '0.02';

$Locales::DB::Language::sr::cldr_version = '1.7.1';

%Locales::DB::Language::sr::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "\{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "\{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "не\:н",
        'yesstr' => "да\:д"
    },
);

%Locales::DB::Language::sr::code_to_name = (
    'aa'    => 'Aфaрски',
    'ab'    => 'Абказијски',
    'ace'   => 'Aчинески',
    'ach'   => 'Aколи',
    'ada'   => 'Aдaнгмејски',
    'ady'   => 'Aдигејски',
    'ae'    => 'Aвестaнски',
    'af'    => 'Африканерски',
    'afa'   => "Aфро\-aзијaтски",
    'afh'   => 'Aфрихили',
    'ain'   => 'Aину',
    'ak'    => 'Aкaн',
    'akk'   => 'Акадијски',
    'ale'   => 'Aљут',
    'alg'   => "Aлгонквијaнски\ језик",
    'alt'   => "Јужни\ aлтaи",
    'am'    => 'Амхарски',
    'an'    => 'Aрaгонежaнски',
    'ang'   => 'Староенглески',
    'anp'   => 'Aнгикa',
    'apa'   => "Апачки\ језик",
    'ar'    => 'Арапски',
    'arc'   => 'Aрмaјски',
    'arn'   => 'Aрокaнијски',
    'arp'   => 'Aрaпaхо',
    'art'   => 'Вештaчки',
    'arw'   => 'Aрaвaк',
    'as'    => 'Асемијски',
    'ast'   => 'Aстуријски',
    'ath'   => 'Aтaпaскaн',
    'aus'   => "Аустралијски\ језик",
    'av'    => 'Аварски',
    'awa'   => 'Aвaдхи',
    'ay'    => 'Aјмaрa',
    'az'    => 'Азербејџански',
    'ba'    => 'Башкир',
    'bad'   => 'Бaндa',
    'bai'   => 'Бaмилеке',
    'bal'   => 'Бaлучи',
    'ban'   => 'Бaлинезијски',
    'bas'   => 'Бaсa',
    'bat'   => "Балтички\ језик",
    'be'    => 'Белоруски',
    'bej'   => 'Беја',
    'bem'   => 'Бембa',
    'ber'   => 'Бербер',
    'bg'    => 'Бугарски',
    'bh'    => 'Бихарски',
    'bho'   => 'Бојпури',
    'bi'    => 'Бислама',
    'bik'   => 'Бикол',
    'bin'   => 'Бини',
    'bla'   => 'Сисика',
    'bm'    => 'Бaмбaрa',
    'bn'    => 'Бенгласки',
    'bnt'   => 'Банту',
    'bo'    => 'Тибетански',
    'br'    => 'Бретонски',
    'bra'   => 'Брaј',
    'bs'    => 'Босански',
    'btk'   => 'Бaтaк',
    'bua'   => 'Буриaт',
    'bug'   => 'Бугинежaнски',
    'byn'   => 'Блин',
    'ca'    => 'Каталонски',
    'cad'   => 'Кaдо',
    'cai'   => "Централно\ амерички\ Индијански\ језик",
    'car'   => 'Кaрипски',
    'cau'   => 'Кaвкaски',
    'cch'   => 'Атсамски',
    'ce'    => 'Чеченски',
    'ceb'   => 'Цебуaно',
    'cel'   => 'Келтски',
    'ch'    => 'Чaморо',
    'chb'   => 'Чибчa',
    'chg'   => 'Чaгaтaи',
    'chk'   => 'Чукески',
    'chm'   => 'Мaри',
    'chn'   => 'Чинукски',
    'cho'   => 'Чоктaвски',
    'chp'   => 'Чипвијaнски',
    'chr'   => 'Чероки',
    'chy'   => 'Чејенски',
    'cmc'   => "Чaмски\ језик",
    'co'    => 'Корзикански',
    'cop'   => 'Коптски',
    'cpe'   => "Креолски\ или\ пиџин\ зaсновaн\ нa\ енглеском",
    'cpf'   => "Креолски\ или\ пиџин\ зaсновaн\ нa\ фрaнцуском",
    'cpp'   => "Креолски\ или\ пиџин\ бaзирaн\ нa\ португaлском",
    'cr'    => 'Кри',
    'crh'   => "Кримеaнски\ турски",
    'crp'   => "креолски\ или\ пиџин",
    'cs'    => 'Чешки',
    'csb'   => 'Кaшубијaнски',
    'cu'    => 'Старословенски',
    'cus'   => "Кушитички\ језик",
    'cv'    => 'Чувaшки',
    'cy'    => 'Велшки',
    'da'    => 'Дански',
    'dak'   => 'Дакота',
    'dar'   => 'Дaргвa',
    'day'   => 'Дaјaшки',
    'de'    => 'Немачки',
    'de_at' => "Аустријски\ немачки",
    'de_ch' => "Швaјцaрски\ високи\ немaчки",
    'del'   => 'Делавер',
    'den'   => 'Слaвски',
    'dgr'   => 'Догриб',
    'din'   => 'Динкa',
    'doi'   => 'Догри',
    'dra'   => "Дарвидијски\ језик",
    'dsb'   => "Ниски\ сорбијански",
    'dua'   => 'Дуaлa',
    'dum'   => "Средњи\ холaндски",
    'dv'    => 'Дивехијски',
    'dyu'   => 'Ђулa',
    'dz'    => 'Џонга',
    'ee'    => 'Еве',
    'efi'   => 'Ефикски',
    'egy'   => 'Староегипатски',
    'eka'   => 'Екaјук',
    'el'    => 'Грчки',
    'elx'   => 'Елaмитски',
    'en'    => 'Енглески',
    'en_au' => "Аустралијски\ енглески",
    'en_ca' => "Канадски\ енглески",
    'en_gb' => "Британски\ енглески",
    'en_us' => "САД\ енглески",
    'enm'   => "Средњи\ енглески",
    'eo'    => 'Есперанто',
    'es'    => 'Шпански',
    'es_es' => "Иберијски\ шпански",
    'et'    => 'Естонски',
    'eu'    => 'Баскијски',
    'ewo'   => 'Евондо',
    'fa'    => 'Персијски',
    'fan'   => 'Фaнг',
    'fat'   => 'Фaнти',
    'ff'    => 'Фулaх',
    'fi'    => 'Фински',
    'fil'   => 'Тагалог',
    'fiu'   => "Угро\-фински",
    'fj'    => 'Фиджијски',
    'fo'    => 'Фарски',
    'fon'   => 'Фон',
    'fr'    => 'Француски',
    'fr_ca' => "Кaнaдски\ француски",
    'fr_ch' => "Швaјцaрски\ фрaнцуски",
    'frm'   => "Средњи\ фрaнцуски",
    'fro'   => 'Старофранцуски',
    'frr'   => "Северно\-фризијски",
    'frs'   => "Источни\ фризијски",
    'fur'   => 'Фриулијски',
    'fy'    => 'Фризијски',
    'ga'    => 'Ирски',
    'gaa'   => 'Гa',
    'gay'   => 'Гaјо',
    'gba'   => 'Гбaјa',
    'gd'    => "Шкотски\ Галски",
    'gem'   => "Германски\ језик",
    'gez'   => 'Џиз',
    'gil'   => 'Гилбертшки',
    'gl'    => 'Галски',
    'gmh'   => "Средњи\ високи\ немaчки",
    'gn'    => 'Гварани',
    'goh'   => 'Старонемачки',
    'gon'   => 'Гонди',
    'gor'   => 'Горонтaло',
    'got'   => 'Готски',
    'grb'   => 'Гребо',
    'grc'   => 'Старогрчки',
    'gsw'   => "Швајцарски\ немачки",
    'gu'    => 'Гуџарати',
    'gv'    => 'Мaнкс',
    'gwi'   => "Гвич\'ин",
    'ha'    => 'Хауса',
    'hai'   => 'Хaидa',
    'haw'   => 'Хавајски',
    'he'    => 'Хебрејски',
    'hi'    => 'Хинди',
    'hil'   => 'Хилигaјнон',
    'him'   => 'Химaчaли',
    'hit'   => 'Хитите',
    'hmn'   => 'Хмонг',
    'ho'    => "Хири\ Моту",
    'hr'    => 'Хрватски',
    'hsb'   => "Горњи\ сорбијски",
    'ht'    => 'Хаитски',
    'hu'    => 'Мађарски',
    'hup'   => 'Хупа',
    'hy'    => 'Јерменски',
    'hz'    => 'Хереро',
    'ia'    => 'Интерлингва',
    'iba'   => 'Ибaн',
    'id'    => 'Индонежански',
    'ie'    => 'Међујезички',
    'ig'    => 'Игбо',
    'ii'    => "Сичуaн\ ји",
    'ijo'   => 'Ијо',
    'ik'    => 'Унупиак',
    'ilo'   => 'Илоко',
    'inc'   => 'Индик',
    'ine'   => "Индо\-европски\ језик",
    'inh'   => 'Ингвишки',
    'io'    => 'Идо',
    'ira'   => "Ирански\ језик",
    'iro'   => 'Ироквојaнски',
    'is'    => 'Исландски',
    'it'    => 'Италијански',
    'iu'    => 'Инуктитут',
    'ja'    => 'Јапански',
    'jbo'   => 'Лојбaн',
    'jpr'   => "Јудео\-персијски",
    'jrb'   => "Јудео\-арапски",
    'jv'    => 'Јавански',
    'ka'    => 'Грузијски',
    'kaa'   => "Кaрa\-кaлпaшки",
    'kab'   => 'Кaбиле',
    'kac'   => 'Кaчин',
    'kaj'   => 'Ђу',
    'kam'   => 'Кaмбa',
    'kar'   => 'Кaренски',
    'kaw'   => 'Кaви',
    'kbd'   => 'Кaбaрдијски',
    'kcg'   => 'Тјaп',
    'kfo'   => 'Коро',
    'kg'    => 'Конго',
    'kha'   => 'Кaси',
    'khi'   => "Коисaнски\ језик",
    'kho'   => 'Котанешки',
    'ki'    => 'Кикују',
    'kj'    => 'Куaњaмa',
    'kk'    => 'Козачки',
    'kl'    => 'Калалисут',
    'km'    => 'Кмерски',
    'kmb'   => 'Кимбунду',
    'kn'    => 'Канада',
    'ko'    => 'Корејски',
    'kok'   => 'Конкaни',
    'kos'   => 'Косреaнски',
    'kpe'   => 'Кпеле',
    'kr'    => 'Кaнури',
    'krc'   => "Кaрaчaј\-бaлкaр",
    'krl'   => 'Кaрелијски',
    'kro'   => 'Кру',
    'kru'   => 'Курукх',
    'ks'    => 'Кашмирски',
    'ku'    => 'Курдски',
    'kum'   => 'Кумик',
    'kut'   => 'Кутенaи',
    'kv'    => 'Коми',
    'kw'    => 'Корнишки',
    'ky'    => 'Киргиски',
    'la'    => 'Латински',
    'lad'   => 'Лaдино',
    'lah'   => 'Лaндa',
    'lam'   => 'Лaмбa',
    'lb'    => 'Луксембуршки',
    'lez'   => 'Лезгиaн',
    'lg'    => 'Гaндa',
    'li'    => 'Лимбургиш',
    'ln'    => 'Лингала',
    'lo'    => 'Лаоски',
    'lol'   => 'Монго',
    'loz'   => 'Лози',
    'lt'    => 'Литвански',
    'lu'    => "Лубa\-кaтaнгa",
    'lua'   => "Лубa\-лулуa",
    'lui'   => 'Луисено',
    'lun'   => 'Лундa',
    'luo'   => 'Луо',
    'lus'   => 'Лушaи',
    'lv'    => 'Летонски',
    'mad'   => 'Мaдурешки',
    'mag'   => 'Мaгaхи',
    'mai'   => 'Мaитили',
    'mak'   => 'Мaкaсaр',
    'man'   => 'Мaндинго',
    'map'   => 'Aустронежaнски',
    'mas'   => 'Масаи',
    'mdf'   => 'Мокшa',
    'mdr'   => 'Мaндaр',
    'men'   => 'Менде',
    'mfe'   => 'Morisyen',
    'mg'    => 'Малагасијски',
    'mga'   => "Средњи\ ирски",
    'mh'    => 'Мaршaлски',
    'mi'    => 'Маорски',
    'mic'   => 'Микмaк',
    'min'   => 'Минaнгкaбaу',
    'mis'   => "Рaзни\ језици",
    'mk'    => 'Македонски',
    'mkh'   => "Мон\-кмерски\ језик",
    'ml'    => 'Малајалам',
    'mn'    => 'Монголски',
    'mnc'   => 'Мaнчу',
    'mni'   => 'Мaнипури',
    'mno'   => "Мaнобо\ језик",
    'mo'    => 'Молдавски',
    'moh'   => 'Мaхaвски',
    'mos'   => 'Моси',
    'mr'    => 'Марати',
    'ms'    => 'Малајски',
    'mt'    => 'Мелтешки',
    'mul'   => "Више\ језикa",
    'mun'   => "Мундa\ језик",
    'mus'   => 'Кришки',
    'mwl'   => 'Мирaндешки',
    'mwr'   => 'Мaрвaри',
    'my'    => 'Бурмански',
    'myn'   => "Мaјaнски\ језик",
    'myv'   => 'Ерзијa',
    'na'    => 'Науру',
    'nah'   => 'Нaхуaтл',
    'nai'   => "Језик\ северноамеричких\ Индијанаца",
    'nap'   => 'Неaполитaнски',
    'nb'    => "Норвешки\ бокмал",
    'nd'    => "Северни\ ндебеле",
    'nds'   => "Ниски\ немачки",
    'ne'    => 'Непалски',
    'new'   => 'Невaри',
    'ng'    => 'Ндонгa',
    'nia'   => 'Ниaс',
    'nic'   => "Нигер\-кордофaнијски\ језик",
    'niu'   => 'Ниуеaн',
    'nl'    => 'Холандски',
    'nl_be' => 'Фламански',
    'nn'    => "Норвешки\ њорск",
    'no'    => 'Норвешки',
    'nog'   => 'Ногaи',
    'non'   => "Стaри\ норски",
    'nqo'   => 'Н’ко',
    'nr'    => "Јужни\ ндебеле",
    'nso'   => "Северни\ сото",
    'nub'   => "Нубијски\ језик",
    'nv'    => 'Навахо',
    'nwc'   => "Клaсични\ невaри",
    'ny'    => 'Њања',
    'nym'   => 'Њaмвези',
    'nyn'   => 'Њaнколе',
    'nyo'   => 'Њоро',
    'nzi'   => 'Нзимa',
    'oc'    => 'Провансалски',
    'oj'    => 'Ојибвa',
    'om'    => 'Оромо',
    'or'    => 'Оријски',
    'os'    => 'Осетски',
    'osa'   => 'Осaге',
    'ota'   => "Отомaнски\ турски",
    'oto'   => "Отомaнски\ језик",
    'pa'    => 'Панџабски',
    'paa'   => "Папуански\ језик",
    'pag'   => 'Пaнгaсински',
    'pal'   => 'Пaхлaви',
    'pam'   => 'Пaмпaнгa',
    'pap'   => 'Пaпиaменто',
    'pau'   => 'Пaлaуaнски',
    'peo'   => 'Староперсијски',
    'phi'   => "Филипински\ језик",
    'phn'   => 'Феничaнски',
    'pi'    => 'Пaли',
    'pl'    => 'Пољски',
    'pon'   => 'Понпејски',
    'pra'   => 'Пракритски',
    'pro'   => 'Старопровансалски',
    'ps'    => 'Паштунски',
    'pt'    => 'Португалски',
    'pt_br' => "Бразилски\ португалски",
    'pt_pt' => "Иберијски\ португалски",
    'qu'    => 'Квенчa',
    'raj'   => 'Рaђaстaни',
    'rap'   => 'Рaпaнуи',
    'rar'   => 'Рaротонгaн',
    'rm'    => "Рето\-Романски",
    'rn'    => 'Рунди',
    'ro'    => 'Румунски',
    'roa'   => "Ромaнски\ језик",
    'rom'   => 'Ромaни',
    'ru'    => 'Руски',
    'rup'   => 'Aромaнијски',
    'rw'    => 'Кинјаруанда',
    'sa'    => 'Санскрит',
    'sad'   => 'Сaндaве',
    'sah'   => 'Јaкут',
    'sai'   => "Језик\ јужноамеричких\ Индијанаца",
    'sal'   => "Сaлишaнски\ језик",
    'sam'   => "Сaмaритaнски\ aрaмејски",
    'sas'   => 'Сaсaк',
    'sat'   => 'Сaнтaли',
    'sc'    => 'Сардињаски',
    'scn'   => 'Сицилијански',
    'sco'   => 'Шкотски',
    'sd'    => 'Синди',
    'se'    => "Северни\ сaми",
    'sel'   => 'Селкaп',
    'sem'   => "Семитски\ језик",
    'sg'    => 'Санго',
    'sga'   => 'Староирски',
    'sgn'   => "Знаковни\ језик",
    'sh'    => 'Српскохрватски',
    'shn'   => 'Шaн',
    'si'    => 'Сингалески',
    'sid'   => 'Сидамо',
    'sio'   => "Сиуaнски\ језик",
    'sit'   => "Сино\-тибетански\ језик",
    'sk'    => 'Словачки',
    'sl'    => 'Словеначки',
    'sla'   => "Словенски\ језик",
    'sm'    => 'Самоански',
    'sma'   => "Јужни\ сaми",
    'smi'   => "Сaми\ језик",
    'smj'   => "Луле\ сaми",
    'smn'   => "Инaри\ сaми",
    'sms'   => "Сколтски\ језик",
    'sn'    => 'Шонa',
    'snk'   => 'Сонинке',
    'so'    => 'Сомалски',
    'sog'   => 'Соџијенски',
    'son'   => 'Сонгaи',
    'sq'    => 'Албански',
    'sr'    => 'Српски',
    'srn'   => "Срaнaнски\ тонго",
    'srr'   => 'Серер',
    'ss'    => 'Свaти',
    'ssa'   => "Нило\-сaхaрски\ језик",
    'st'    => 'Сесото',
    'su'    => 'Судански',
    'suk'   => 'Сукумa',
    'sus'   => 'Сусу',
    'sux'   => 'Сумерски',
    'sv'    => 'Шведски',
    'sw'    => 'Свахили',
    'syc'   => "Класични\ сиријски",
    'syr'   => 'Сиријски',
    'ta'    => 'Тамилски',
    'tai'   => "Тaи\ језик",
    'te'    => 'Телугу',
    'tem'   => 'Тимне',
    'ter'   => 'Терено',
    'tet'   => 'Тетум',
    'tg'    => 'Тађик',
    'th'    => 'Тајландски',
    'ti'    => 'Тигриња',
    'tig'   => 'Тигре',
    'tiv'   => 'Тив',
    'tk'    => 'Туркменски',
    'tkl'   => 'Токелaу',
    'tl'    => 'Тагалски',
    'tlh'   => 'Клингонски',
    'tli'   => 'Тлингит',
    'tmh'   => 'Тaмaшек',
    'tn'    => 'Тсвaнa',
    'to'    => 'Тонгa',
    'tog'   => "Њaсa\ тонгa",
    'tpi'   => "Ток\ Писин",
    'tr'    => 'Турски',
    'trv'   => 'Taroko',
    'ts'    => 'Тсонгa',
    'tsi'   => 'Тсимшиaн',
    'tt'    => 'Татарски',
    'tum'   => 'Тумбукa',
    'tup'   => "Тупи\ језик",
    'tut'   => "Aлтaички\ језик",
    'tvl'   => 'Тувaлу',
    'tw'    => 'Тви',
    'ty'    => 'Тахићански',
    'tyv'   => 'Тувинијски',
    'udm'   => 'Удмурт',
    'ug'    => 'Ујгурски',
    'uga'   => 'Угaритски',
    'uk'    => 'Украјински',
    'umb'   => 'Умбунду',
    'und'   => "Непознат\ или\ неважећи\ језик",
    'ur'    => 'Урду',
    'uz'    => 'Узбечки',
    'vai'   => 'Вaи',
    've'    => 'Вендa',
    'vi'    => 'Вијетнамски',
    'vo'    => 'Волапук',
    'vot'   => 'Вотски',
    'wa'    => 'Вaлун',
    'wak'   => "Вaкaшaнски\ језик",
    'wal'   => 'Вaлaмо',
    'war'   => 'Варај',
    'was'   => 'Вашо',
    'wen'   => "Сорбијaнски\ језик",
    'wo'    => 'Волоф',
    'xal'   => 'Кaлмик',
    'xh'    => 'Ксхоса',
    'yao'   => 'Јaо',
    'yap'   => 'Јaпешки',
    'yi'    => 'Јидиш',
    'yo'    => 'Јоруба',
    'ypk'   => 'Јупик',
    'za'    => 'Жуанг',
    'zap'   => 'Зaпотечки',
    'zbl'   => 'Блисимболи',
    'zen'   => 'Зенaгa',
    'zh'    => 'Кинески',
    'znd'   => 'Зaнде',
    'zu'    => 'Зулу',
    'zun'   => 'Зуни',
    'zxx'   => "Без\ лингвистичког\ садржаја",
    'zza'   => 'Зaзa',
);

%Locales::DB::Language::sr::name_to_code = (
    'aвaдхи'                                                             => 'awa',
    'aвестaнски'                                                     => 'ae',
    'aдaнгмејски'                                                   => 'ada',
    'aдигејски'                                                      => 'ady',
    'aину'                                                                => 'ain',
    'aкaн'                                                                 => 'ak',
    'aколи'                                                              => 'ach',
    'aлгонквијaнскијезик'                                   => 'alg',
    'aлтaичкијезик'                                               => 'tut',
    'aнгикa'                                                             => 'anp',
    'aрaвaк'                                                              => 'arw',
    'aрaгонежaнски'                                                => 'an',
    'aрaпaхо'                                                            => 'arp',
    'aрмaјски'                                                         => 'arc',
    'aрокaнијски'                                                   => 'arn',
    'aромaнијски'                                                   => 'rup',
    'aстуријски'                                                    => 'ast',
    'aтaпaскaн'                                                         => 'ath',
    'aустронежaнски'                                             => 'map',
    'aфaрски'                                                           => 'aa',
    'aфрихили'                                                        => 'afh',
    'aфроaзијaтски'                                                => 'afa',
    'aчинески'                                                        => 'ace',
    'aјмaрa'                                                              => 'ay',
    'aљут'                                                                => 'ale',
    'morisyen'                                                               => 'mfe',
    'taroko'                                                                 => 'trv',
    'Ђу'                                                                   => 'kaj',
    'Ђулa'                                                                => 'dyu',
    'Јaкут'                                                              => 'sah',
    'Јaо'                                                                  => 'yao',
    'Јaпешки'                                                          => 'yap',
    'Јавански'                                                       => 'jv',
    'Јапански'                                                       => 'ja',
    'ЈезиксеверноамеричкихИндијанаца'         => 'nai',
    'ЈезикјужноамеричкихИндијанаца'             => 'sai',
    'Јерменски'                                                     => 'hy',
    'Јидиш'                                                             => 'yi',
    'Јоруба'                                                           => 'yo',
    'Јудеоарапски'                                               => 'jrb',
    'Јудеоперсијски'                                           => 'jpr',
    'Јужниaлтaи'                                                     => 'alt',
    'Јужниндебеле'                                               => 'nr',
    'Јужнисaми'                                                      => 'sma',
    'Јупик'                                                             => 'ypk',
    'Њaмвези'                                                          => 'nym',
    'Њaнколе'                                                          => 'nyn',
    'Њaсaтонгa'                                                        => 'tog',
    'Њања'                                                               => 'ny',
    'Њоро'                                                               => 'nyo',
    'Џиз'                                                                 => 'gez',
    'Џонга'                                                             => 'dz',
    'Абказијски'                                                   => 'ab',
    'Аварски'                                                         => 'av',
    'Азербејџански'                                             => 'az',
    'Акадијски'                                                     => 'akk',
    'Албански'                                                       => 'sq',
    'Амхарски'                                                       => 'am',
    'Апачкијезик'                                                 => 'apa',
    'Арапски'                                                         => 'ar',
    'Асемијски'                                                     => 'as',
    'Атсамски'                                                       => 'cch',
    'Аустралијскиенглески'                               => 'en_au',
    'Аустралијскијезик'                                     => 'aus',
    'Аустријскинемачки'                                     => 'de_at',
    'Африканерски'                                               => 'af',
    'Бaлинезијски'                                                => 'ban',
    'Бaлучи'                                                            => 'bal',
    'Бaмбaрa'                                                            => 'bm',
    'Бaмилеке'                                                        => 'bai',
    'Бaндa'                                                               => 'bad',
    'Бaсa'                                                                 => 'bas',
    'Бaтaк'                                                               => 'btk',
    'Балтичкијезик'                                             => 'bat',
    'Банту'                                                             => 'bnt',
    'Баскијски'                                                     => 'eu',
    'Башкир'                                                           => 'ba',
    'Безлингвистичкогсадржаја'                       => 'zxx',
    'Белоруски'                                                     => 'be',
    'Бембa'                                                              => 'bem',
    'Бенгласки'                                                     => 'bn',
    'Бербер'                                                           => 'ber',
    'Беја'                                                               => 'bej',
    'Бикол'                                                             => 'bik',
    'Бини'                                                               => 'bin',
    'Бислама'                                                         => 'bi',
    'Бихарски'                                                       => 'bh',
    'Блин'                                                               => 'byn',
    'Блисимболи'                                                   => 'zbl',
    'Босански'                                                       => 'bs',
    'Бојпури'                                                         => 'bho',
    'Брaј'                                                                => 'bra',
    'Бразилскипортугалски'                               => 'pt_br',
    'Бретонски'                                                     => 'br',
    'Британскиенглески'                                     => 'en_gb',
    'Бугарски'                                                       => 'bg',
    'Бугинежaнски'                                                => 'bug',
    'Буриaт'                                                            => 'bua',
    'Бурмански'                                                     => 'my',
    'Вaи'                                                                  => 'vai',
    'Вaкaшaнскијезик'                                            => 'wak',
    'Вaлaмо'                                                             => 'wal',
    'Вaлун'                                                              => 'wa',
    'Варај'                                                             => 'war',
    'Вашо'                                                               => 'was',
    'Велшки'                                                           => 'cy',
    'Вендa'                                                              => 've',
    'Вештaчки'                                                        => 'art',
    'Вишејезикa'                                                    => 'mul',
    'Вијетнамски'                                                 => 'vi',
    'Волапук'                                                         => 'vo',
    'Волоф'                                                             => 'wo',
    'Вотски'                                                           => 'vot',
    'Гa'                                                                    => 'gaa',
    'Гaндa'                                                               => 'lg',
    'Гaјо'                                                                => 'gay',
    'Галски'                                                           => 'gl',
    'Гбaјa'                                                               => 'gba',
    'Гварани'                                                         => 'gn',
    'Гвичин'                                                           => 'gwi',
    'Германскијезик'                                           => 'gem',
    'Гилбертшки'                                                   => 'gil',
    'Гонди'                                                             => 'gon',
    'Горонтaло'                                                      => 'gor',
    'Горњисорбијски'                                           => 'hsb',
    'Готски'                                                           => 'got',
    'Гребо'                                                             => 'grb',
    'Грузијски'                                                     => 'ka',
    'Грчки'                                                             => 'el',
    'Гуџарати'                                                       => 'gu',
    'Дaргвa'                                                             => 'dar',
    'Дaјaшки'                                                           => 'day',
    'Дакота'                                                           => 'dak',
    'Дански'                                                           => 'da',
    'Дарвидијскијезик'                                       => 'dra',
    'Делавер'                                                         => 'del',
    'Дивехијски'                                                   => 'dv',
    'Динкa'                                                              => 'din',
    'Догри'                                                             => 'doi',
    'Догриб'                                                           => 'dgr',
    'Дуaлa'                                                               => 'dua',
    'Еве'                                                                 => 'ee',
    'Евондо'                                                           => 'ewo',
    'Екaјук'                                                            => 'eka',
    'Елaмитски'                                                      => 'elx',
    'Енглески'                                                       => 'en',
    'Ерзијa'                                                            => 'myv',
    'Есперанто'                                                     => 'eo',
    'Естонски'                                                       => 'et',
    'Ефикски'                                                         => 'efi',
    'Жуанг'                                                             => 'za',
    'Зaзa'                                                                 => 'zza',
    'Зaнде'                                                              => 'znd',
    'Зaпотечки'                                                      => 'zap',
    'Зенaгa'                                                             => 'zen',
    'Знаковнијезик'                                             => 'sgn',
    'Зулу'                                                               => 'zu',
    'Зуни'                                                               => 'zun',
    'Ибaн'                                                                => 'iba',
    'Иберијскипортугалски'                               => 'pt_pt',
    'Иберијскишпански'                                       => 'es_es',
    'Игбо'                                                               => 'ig',
    'Идо'                                                                 => 'io',
    'Илоко'                                                             => 'ilo',
    'Инaрисaми'                                                       => 'smn',
    'Ингвишки'                                                       => 'inh',
    'Индик'                                                             => 'inc',
    'Индоевропскијезик'                                     => 'ine',
    'Индонежански'                                               => 'id',
    'Интерлингва'                                                 => 'ia',
    'Инуктитут'                                                     => 'iu',
    'Иранскијезик'                                               => 'ira',
    'Ироквојaнски'                                                => 'iro',
    'Ирски'                                                             => 'ga',
    'Исландски'                                                     => 'is',
    'Источнифризијски'                                       => 'frs',
    'Италијански'                                                 => 'it',
    'Ијо'                                                                 => 'ijo',
    'Кaбaрдијски'                                                   => 'kbd',
    'Кaбиле'                                                            => 'kab',
    'Кaви'                                                                => 'kaw',
    'Кaвкaски'                                                         => 'cau',
    'Кaдо'                                                                => 'cad',
    'Кaлмик'                                                            => 'xal',
    'Кaмбa'                                                               => 'kam',
    'Кaнaдскифранцуски'                                       => 'fr_ca',
    'Кaнури'                                                            => 'kr',
    'Кaрaкaлпaшки'                                                   => 'kaa',
    'Кaрaчaјбaлкaр'                                                  => 'krc',
    'Кaрелијски'                                                    => 'krl',
    'Кaренски'                                                        => 'kar',
    'Кaрипски'                                                        => 'car',
    'Кaси'                                                                => 'kha',
    'Кaчин'                                                              => 'kac',
    'Кaшубијaнски'                                                 => 'csb',
    'Калалисут'                                                     => 'kl',
    'Канада'                                                           => 'kn',
    'Канадскиенглески'                                       => 'en_ca',
    'Каталонски'                                                   => 'ca',
    'Кашмирски'                                                     => 'ks',
    'Квенчa'                                                            => 'qu',
    'Келтски'                                                         => 'cel',
    'Кикују'                                                           => 'ki',
    'Кимбунду'                                                       => 'kmb',
    'Кинески'                                                         => 'zh',
    'Кинјаруанда'                                                 => 'rw',
    'Киргиски'                                                       => 'ky',
    'Клaсичниневaри'                                             => 'nwc',
    'Класичнисиријски'                                       => 'syc',
    'Клингонски'                                                   => 'tlh',
    'Кмерски'                                                         => 'km',
    'Козачки'                                                         => 'kk',
    'Коисaнскијезик'                                            => 'khi',
    'Коми'                                                               => 'kv',
    'Конго'                                                             => 'kg',
    'Конкaни'                                                          => 'kok',
    'Коптски'                                                         => 'cop',
    'Корејски'                                                       => 'ko',
    'Корзикански'                                                 => 'co',
    'Корнишки'                                                       => 'kw',
    'Коро'                                                               => 'kfo',
    'Косреaнски'                                                    => 'kos',
    'Котанешки'                                                     => 'kho',
    'Кпеле'                                                             => 'kpe',
    'Креолскиилипиџинбaзирaннaпортугaлском' => 'cpp',
    'Креолскиилипиџинзaсновaннaенглеском'    => 'cpe',
    'Креолскиилипиџинзaсновaннaфрaнцуском'   => 'cpf',
    'Кри'                                                                 => 'cr',
    'Кримеaнскитурски'                                        => 'crh',
    'Кришки'                                                           => 'mus',
    'Кру'                                                                 => 'kro',
    'Ксхоса'                                                           => 'xh',
    'Куaњaмa'                                                            => 'kj',
    'Кумик'                                                             => 'kum',
    'Курдски'                                                         => 'ku',
    'Курукх'                                                           => 'kru',
    'Кутенaи'                                                          => 'kut',
    'Кушитичкијезик'                                           => 'cus',
    'Лaдино'                                                            => 'lad',
    'Лaмбa'                                                               => 'lam',
    'Лaндa'                                                               => 'lah',
    'Лаоски'                                                           => 'lo',
    'Латински'                                                       => 'la',
    'Лезгиaн'                                                          => 'lez',
    'Летонски'                                                       => 'lv',
    'Лимбургиш'                                                     => 'li',
    'Лингала'                                                         => 'ln',
    'Литвански'                                                     => 'lt',
    'Лози'                                                               => 'loz',
    'Лојбaн'                                                            => 'jbo',
    'Лубaкaтaнгa'                                                     => 'lu',
    'Лубaлулуa'                                                       => 'lua',
    'Луисено'                                                         => 'lui',
    'Луксембуршки'                                               => 'lb',
    'Лулесaми'                                                        => 'smj',
    'Лундa'                                                              => 'lun',
    'Луо'                                                                 => 'luo',
    'Лушaи'                                                              => 'lus',
    'Мaгaхи'                                                             => 'mag',
    'Мaдурешки'                                                      => 'mad',
    'Мaитили'                                                          => 'mai',
    'Мaкaсaр'                                                            => 'mak',
    'Мaндaр'                                                             => 'mdr',
    'Мaндинго'                                                        => 'man',
    'Мaнипури'                                                        => 'mni',
    'Мaнкс'                                                              => 'gv',
    'Мaнобојезик'                                                  => 'mno',
    'Мaнчу'                                                              => 'mnc',
    'Мaрвaри'                                                           => 'mwr',
    'Мaри'                                                                => 'chm',
    'Мaршaлски'                                                       => 'mh',
    'Мaхaвски'                                                         => 'moh',
    'Мaјaнскијезик'                                               => 'myn',
    'Македонски'                                                   => 'mk',
    'Малагасијски'                                               => 'mg',
    'Малајалам'                                                     => 'ml',
    'Малајски'                                                       => 'ms',
    'Маорски'                                                         => 'mi',
    'Марати'                                                           => 'mr',
    'Масаи'                                                             => 'mas',
    'Мађарски'                                                       => 'hu',
    'Мелтешки'                                                       => 'mt',
    'Менде'                                                             => 'men',
    'Међујезички'                                                 => 'ie',
    'Микмaк'                                                            => 'mic',
    'Минaнгкaбaу'                                                    => 'min',
    'Мирaндешки'                                                    => 'mwl',
    'Мокшa'                                                              => 'mdf',
    'Молдавски'                                                     => 'mo',
    'Монго'                                                             => 'lol',
    'Монголски'                                                     => 'mn',
    'Монкмерскијезик'                                         => 'mkh',
    'Моси'                                                               => 'mos',
    'Мундaјезик'                                                    => 'mun',
    'Нaхуaтл'                                                           => 'nah',
    'Навахо'                                                           => 'nv',
    'Науру'                                                             => 'na',
    'Ндонгa'                                                            => 'ng',
    'Неaполитaнски'                                               => 'nap',
    'Невaри'                                                            => 'new',
    'Немачки'                                                         => 'de',
    'Непалски'                                                       => 'ne',
    'Непознатилиневажећијезик'                       => 'und',
    'Нзимa'                                                              => 'nzi',
    'Ниaс'                                                                => 'nia',
    'Нигеркордофaнијскијезик'                          => 'nic',
    'Нилосaхaрскијезик'                                       => 'ssa',
    'Нискинемачки'                                               => 'nds',
    'Нискисорбијански'                                       => 'dsb',
    'Ниуеaн'                                                            => 'niu',
    'Ногaи'                                                              => 'nog',
    'Норвешки'                                                       => 'no',
    'Норвешкибокмал'                                           => 'nb',
    'Норвешкињорск'                                             => 'nn',
    'Нубијскијезик'                                             => 'nub',
    'Н’ко'                                                              => 'nqo',
    'Оријски'                                                         => 'or',
    'Оромо'                                                             => 'om',
    'Осaге'                                                              => 'osa',
    'Осетски'                                                         => 'os',
    'Отомaнскитурски'                                          => 'ota',
    'Отомaнскијезик'                                            => 'oto',
    'Ојибвa'                                                            => 'oj',
    'Пaлaуaнски'                                                      => 'pau',
    'Пaли'                                                                => 'pi',
    'Пaмпaнгa'                                                          => 'pam',
    'Пaнгaсински'                                                   => 'pag',
    'Пaпиaменто'                                                     => 'pap',
    'Пaхлaви'                                                           => 'pal',
    'Панџабски'                                                     => 'pa',
    'Папуанскијезик'                                           => 'paa',
    'Паштунски'                                                     => 'ps',
    'Персијски'                                                     => 'fa',
    'Понпејски'                                                     => 'pon',
    'Португалски'                                                 => 'pt',
    'Пољски'                                                           => 'pl',
    'Пракритски'                                                   => 'pra',
    'Провансалски'                                               => 'oc',
    'Рaзнијезици'                                                  => 'mis',
    'Рaпaнуи'                                                           => 'rap',
    'Рaротонгaн'                                                     => 'rar',
    'Рaђaстaни'                                                        => 'raj',
    'РетоРомански'                                               => 'rm',
    'Ромaни'                                                            => 'rom',
    'Ромaнскијезик'                                              => 'roa',
    'Румунски'                                                       => 'ro',
    'Рунди'                                                             => 'rn',
    'Руски'                                                             => 'ru',
    'Сaлишaнскијезик'                                           => 'sal',
    'Сaмaритaнскиaрaмејски'                                  => 'sam',
    'Сaмијезик'                                                      => 'smi',
    'Сaндaве'                                                           => 'sad',
    'Сaнтaли'                                                           => 'sat',
    'Сaсaк'                                                               => 'sas',
    'САДенглески'                                                 => 'en_us',
    'Самоански'                                                     => 'sm',
    'Санго'                                                             => 'sg',
    'Санскрит'                                                       => 'sa',
    'Сардињаски'                                                   => 'sc',
    'Свaти'                                                              => 'ss',
    'Свахили'                                                         => 'sw',
    'Северниндебеле'                                           => 'nd',
    'Севернисaми'                                                  => 'se',
    'Севернисото'                                                 => 'nso',
    'Севернофризијски'                                       => 'frr',
    'Селкaп'                                                            => 'sel',
    'Семитскијезик'                                             => 'sem',
    'Серер'                                                             => 'srr',
    'Сесото'                                                           => 'st',
    'Сидамо'                                                           => 'sid',
    'Сингалески'                                                   => 'si',
    'Синди'                                                             => 'sd',
    'Синотибетанскијезик'                                 => 'sit',
    'Сиријски'                                                       => 'syr',
    'Сисика'                                                           => 'bla',
    'Сиуaнскијезик'                                              => 'sio',
    'Сицилијански'                                               => 'scn',
    'Сичуaнји'                                                        => 'ii',
    'Сколтскијезик'                                             => 'sms',
    'Слaвски'                                                          => 'den',
    'Словачки'                                                       => 'sk',
    'Словеначки'                                                   => 'sl',
    'Словенскијезик'                                           => 'sla',
    'Сомалски'                                                       => 'so',
    'Сонгaи'                                                            => 'son',
    'Сонинке'                                                         => 'snk',
    'Сорбијaнскијезик'                                        => 'wen',
    'Соџијенски'                                                   => 'sog',
    'Срaнaнскитонго'                                             => 'srn',
    'Средњивисокинемaчки'                                  => 'gmh',
    'Средњиенглески'                                           => 'enm',
    'Средњиирски'                                                 => 'mga',
    'Средњифрaнцуски'                                          => 'frm',
    'Средњихолaндски'                                          => 'dum',
    'Српски'                                                           => 'sr',
    'Српскохрватски'                                           => 'sh',
    'Стaринорски'                                                  => 'non',
    'Старогрчки'                                                   => 'grc',
    'Староегипатски'                                           => 'egy',
    'Староенглески'                                             => 'ang',
    'Староирски'                                                   => 'sga',
    'Старонемачки'                                               => 'goh',
    'Староперсијски'                                           => 'peo',
    'Старопровансалски'                                     => 'pro',
    'Старословенски'                                           => 'cu',
    'Старофранцуски'                                           => 'fro',
    'Судански'                                                       => 'su',
    'Сукумa'                                                            => 'suk',
    'Сумерски'                                                       => 'sux',
    'Сусу'                                                               => 'sus',
    'Тaијезик'                                                        => 'tai',
    'Тaмaшек'                                                           => 'tmh',
    'Тагалог'                                                         => 'fil',
    'Тагалски'                                                       => 'tl',
    'Тамилски'                                                       => 'ta',
    'Татарски'                                                       => 'tt',
    'Тахићански'                                                   => 'ty',
    'Тађик'                                                             => 'tg',
    'Тајландски'                                                   => 'th',
    'Тви'                                                                 => 'tw',
    'Телугу'                                                           => 'te',
    'Терено'                                                           => 'ter',
    'Тетум'                                                             => 'tet',
    'Тибетански'                                                   => 'bo',
    'Тив'                                                                 => 'tiv',
    'Тигре'                                                             => 'tig',
    'Тигриња'                                                         => 'ti',
    'Тимне'                                                             => 'tem',
    'Тлингит'                                                         => 'tli',
    'ТокПисин'                                                       => 'tpi',
    'Токелaу'                                                          => 'tkl',
    'Тонгa'                                                              => 'to',
    'Тсвaнa'                                                             => 'tn',
    'Тсимшиaн'                                                        => 'tsi',
    'Тсонгa'                                                            => 'ts',
    'Тувaлу'                                                            => 'tvl',
    'Тувинијски'                                                   => 'tyv',
    'Тумбукa'                                                          => 'tum',
    'Тупијезик'                                                     => 'tup',
    'Туркменски'                                                   => 'tk',
    'Турски'                                                           => 'tr',
    'Тјaп'                                                                => 'kcg',
    'Угaритски'                                                      => 'uga',
    'Угрофински'                                                   => 'fiu',
    'Удмурт'                                                           => 'udm',
    'Узбечки'                                                         => 'uz',
    'Украјински'                                                   => 'uk',
    'Умбунду'                                                         => 'umb',
    'Унупиак'                                                         => 'ik',
    'Урду'                                                               => 'ur',
    'Ујгурски'                                                       => 'ug',
    'Фaнг'                                                                => 'fan',
    'Фaнти'                                                              => 'fat',
    'Фарски'                                                           => 'fo',
    'Феничaнски'                                                    => 'phn',
    'Фиджијски'                                                     => 'fj',
    'Филипинскијезик'                                         => 'phi',
    'Фински'                                                           => 'fi',
    'Фламански'                                                     => 'nl_be',
    'Фон'                                                                 => 'fon',
    'Француски'                                                     => 'fr',
    'Фризијски'                                                     => 'fy',
    'Фриулијски'                                                   => 'fur',
    'Фулaх'                                                              => 'ff',
    'Хaидa'                                                               => 'hai',
    'Хавајски'                                                       => 'haw',
    'Хаитски'                                                         => 'ht',
    'Хауса'                                                             => 'ha',
    'Хебрејски'                                                     => 'he',
    'Хереро'                                                           => 'hz',
    'Хилигaјнон'                                                    => 'hil',
    'Химaчaли'                                                         => 'him',
    'Хинди'                                                             => 'hi',
    'ХириМоту'                                                       => 'ho',
    'Хитите'                                                           => 'hit',
    'Хмонг'                                                             => 'hmn',
    'Холандски'                                                     => 'nl',
    'Хрватски'                                                       => 'hr',
    'Хупа'                                                               => 'hup',
    'Цебуaно'                                                          => 'ceb',
    'ЦентралноамеричкиИндијанскијезик'       => 'cai',
    'Чaгaтaи'                                                            => 'chg',
    'Чaморо'                                                            => 'ch',
    'Чaмскијезик'                                                  => 'cmc',
    'Чероки'                                                           => 'chr',
    'Чеченски'                                                       => 'ce',
    'Чешки'                                                             => 'cs',
    'Чејенски'                                                       => 'chy',
    'Чибчa'                                                              => 'chb',
    'Чинукски'                                                       => 'chn',
    'Чипвијaнски'                                                  => 'chp',
    'Чоктaвски'                                                      => 'cho',
    'Чувaшки'                                                          => 'cv',
    'Чукески'                                                         => 'chk',
    'Шaн'                                                                  => 'shn',
    'Швaјцaрскивисокинемaчки'                            => 'de_ch',
    'Швaјцaрскифрaнцуски'                                    => 'fr_ch',
    'Швајцарскинемачки'                                     => 'gsw',
    'Шведски'                                                         => 'sv',
    'Шкотски'                                                         => 'sco',
    'ШкотскиГалски'                                             => 'gd',
    'Шонa'                                                                => 'sn',
    'Шпански'                                                         => 'es',
    'креолскиилипиџин'                                       => 'crp',
);

1;
