# ABSTRACT: An object which contains a reference address
package Net::Object::Peer::RefAddr;

use strictures 2;

our $VERSION = '0.05'; # TRIAL

use Scalar::Util qw[ refaddr ];
use namespace::clean;


use overload
  '0+' => sub {0 + ${ $_[0] }},

  '""' => sub { "${$_[0]}" },

  '+'  => sub { my ( $me, $you ) = @_;
		$$me + $you;
	    },

  '==' => sub { my ( $me, $you ) = @_;
		0+$me == 0+$you;
	    },

  'eq' => sub { my ( $me, $you ) = @_;
		"$me" eq "$you";
	    },
;

#pod =begin pod_coverage
#pod
#pod =head4 does
#pod
#pod =end pod_coverage
#pod
#pod =cut

*does = \&UNIVERSAL::DOES;

#pod =method  new
#pod
#pod   $obj = Net::Object::Peer::RefAddr->new( $reference | $refaddr );
#pod
#pod =cut

sub new {

    my ( $class, $thing ) = @_;

    bless( \( ref $thing ? refaddr( $thing ) : $thing ), $class );
}

1;

#
# This file is part of Net-Object-Peer
#
# This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

=pod

=head1 NAME

Net::Object::Peer::RefAddr - An object which contains a reference address

=head1 VERSION

version 0.05

=head1 DESCRIPTION

B<Net::Object::Peer::RefAddr> is a class whose only purpose is
to identify the contents as a refaddr.

=head1 METHODS

=head2 new

  $obj = Net::Object::Peer::RefAddr->new( $reference | $refaddr );

=begin pod_coverage

=head4 does

=end pod_coverage

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut

__END__

#pod =head1 DESCRIPTION
#pod
#pod B<Net::Object::Peer::RefAddr> is a class whose only purpose is
#pod to identify the contents as a refaddr.
