# ABSTRACT: The payload for a Net::Object::Peer unsubscription event

package Net::Object::Peer::UnsubscribeEvent;

use 5.10.0;
use strict;
use warnings;

our $VERSION = '0.01'; # TRIAL

use Types::Standard qw[ ArrayRef Str is_ArrayRef ];

use namespace::clean;

use Moo;
extends 'Net::Object::Peer::Event';

#pod =attr event_names
#pod
#pod =cut

has event_names => (
    is      => 'ro',
    isa     => ArrayRef [Str],
    default => '%all%',
    coerce  => sub { is_ArrayRef( $_[0] ) ? $_[0] : [ $_[0] ] },
);

1;

#
# This file is part of Net-Object-Peer
#
# This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

=pod

=head1 NAME

Net::Object::Peer::UnsubscribeEvent - The payload for a Net::Object::Peer unsubscription event

=head1 VERSION

version 0.01

=head1 DESCRIPTION

A B<Net::Object::Peer::UnsubscribeEvent> is sent to a subscriber of
a peer's C<unsubscribe> event.  It is derived from L<Net::Object::Peer::Event>.

=head1 ATTRIBUTES

=head2 event_names

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut

__END__

#pod =head1 DESCRIPTION
#pod
#pod A B<Net::Object::Peer::UnsubscribeEvent> is sent to a subscriber of
#pod a peer's C<unsubscribe> event.  It is derived from L<Net::Object::Peer::Event>.
#pod
