# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::MY;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210919194242;

my $formatters = [
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '[4-79]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '
            1(?:
              [02469]|
              [378][1-9]
            )|
            8
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3-$4',
                  'leading_digits' => '1[36-8]',
                  'pattern' => '(\\d)(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '1',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              2[0-36-9]|
              3[0-368]|
              4[0-278]|
              5[0-24-8]|
              6[0-467]|
              7[1246-9]|
              8\\d|
              9[0-57]
            )\\d|
            4(?:
              2[0-689]|
              [3-79]\\d|
              8[1-35689]
            )|
            5(?:
              2[0-589]|
              [3468]\\d|
              5[0-489]|
              7[1-9]|
              9[23]
            )|
            6(?:
              2[2-9]|
              3[1357-9]|
              [46]\\d|
              5[0-6]|
              7[0-35-9]|
              85|
              9[015-8]
            )|
            7(?:
              [2579]\\d|
              3[03-68]|
              4[0-8]|
              6[5-9]|
              8[0-35-9]
            )|
            8(?:
              [24][2-8]|
              3[2-5]|
              5[2-7]|
              6[2-589]|
              7[2-578]|
              [89][2-9]
            )|
            9(?:
              0[57]|
              13|
              [25-7]\\d|
              [3489][0-8]
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            3(?:
              2[0-36-9]|
              3[0-368]|
              4[0-278]|
              5[0-24-8]|
              6[0-467]|
              7[1246-9]|
              8\\d|
              9[0-57]
            )\\d|
            4(?:
              2[0-689]|
              [3-79]\\d|
              8[1-35689]
            )|
            5(?:
              2[0-589]|
              [3468]\\d|
              5[0-489]|
              7[1-9]|
              9[23]
            )|
            6(?:
              2[2-9]|
              3[1357-9]|
              [46]\\d|
              5[0-6]|
              7[0-35-9]|
              85|
              9[015-8]
            )|
            7(?:
              [2579]\\d|
              3[03-68]|
              4[0-8]|
              6[5-9]|
              8[0-35-9]
            )|
            8(?:
              [24][2-8]|
              3[2-5]|
              5[2-7]|
              6[2-589]|
              7[2-578]|
              [89][2-9]
            )|
            9(?:
              0[57]|
              13|
              [25-7]\\d|
              [3489][0-8]
            )
          )\\d{5}
        ',
                'mobile' => '
          1(?:
            1888[69]|
            4400|
            8(?:
              47|
              8[27]
            )[0-4]
          )\\d{4}|
          1(?:
            0(?:
              [23568]\\d|
              4[0-6]|
              7[016-9]|
              9[0-8]
            )|
            1(?:
              [1-5]\\d\\d|
              6(?:
                0[5-9]|
                [1-9]\\d
              )|
              7(?:
                [0134]\\d|
                2[1-9]|
                5[0-6]
              )
            )|
            (?:
              (?:
                [269]|
                59
              )\\d|
              [37][1-9]|
              4[235-9]
            )\\d|
            8(?:
              1[23]|
              [236]\\d|
              4[06]|
              5[7-9]|
              7[016-9]|
              8[01]|
              9[0-8]
            )
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(1600\\d{6})',
                'toll_free' => '1[378]00\\d{6}',
                'voip' => '
          15(?:
            4(?:
              6[0-4]\\d|
              8(?:
                0[125]|
                [17]\\d|
                21|
                3[01]|
                4[01589]|
                5[014]|
                6[02]
              )
            )|
            6(?:
              32[0-6]|
              78\\d
            )
          )\\d{4}
        '
              };
my %areanames = ();
$areanames{en} = {"6036150", "Kuala\ Lumpur",
"6086486", "Balingan",
"603551", "Kinrara",
"6037200", "Kuala\ Lumpur",
"6087504", "Labuan",
"6085615", "Miri",
"6084844", "Mukah",
"607832", "Penawar",
"6032268", "Kuala\ Lumpur",
"6039076", "Cheras",
"6079010", "Tenggara",
"604451", "Jeniang",
"6087889", "Membakut",
"6032118", "Kuala\ Lumpur",
"6089202", "Elopura",
"604898", "Penang",
"6088787", "Tuaran",
"605367", "Pusing",
"6032386", "Kuala\ Lumpur",
"607253", "Johor\ Bahru",
"609571", "Kuantan",
"604936", "Kangar",
"6039101", "Cheras",
"6033268", "Kuala\ Selangor",
"6037652", "Kuala\ Lumpur",
"6085622", "Miri",
"6083592", "Lubuk\ Antu",
"6085667", "Miri",
"6083439", "Saratok",
"6089968", "Lahad\ Datu",
"6083337", "Bandar\ Sri\ Aman",
"6082687", "Kuching",
"6082807", "Simunjan",
"606695", "Linggi",
"605477", "Kampar",
"604454", "Sungai\ Petani",
"605673", "Bruas",
"6082592", "Kota\ Samarahan",
"6038952", "Cheras",
"609592", "Kuantan",
"6087503", "Labuan",
"6089506", "Beluran",
"604599", "Parit\ Buntar",
"6038605", "Kinrara",
"6088909", "Papar",
"60537", "Pusing",
"6033148", "Banting",
"604768", "Alor\ Setar",
"6084234", "Sibu",
"606643", "Port\ Dickson",
"6039078", "Cheras",
"6082530", "Kuching",
"606659", "Sepang",
"6032266", "Kuala\ Lumpur",
"609370", "Dong",
"606252", "Melaka",
"604928", "Changlon",
"6088902", "Papar",
"6082764", "Bau",
"605716", "Parit\ Buntar",
"6087851", "Kuala\ Penyu",
"6086488", "Balingan",
"6085784", "Bakun",
"604555", "Tasek\ Gelugor",
"6082541", "Sejingkat",
"6088663", "Kotamarudu",
"604747", "Alor\ Setar",
"6093260", "Padang\ Tengku",
"606468", "Ayer\ Hitam",
"607446", "Senggarang",
"6082885", "Serian",
"6038959", "Cheras",
"6083477", "Betong",
"606480", "Ayer\ Hitam",
"607965", "Kota\ Tinggi",
"6032388", "Kuala\ Lumpur",
"609270", "Mentakab",
"606385", "Tangga\ Batu",
"605783", "Kuala\ Kangsar",
"606352", "Tangga\ Batu",
"6088793", "Tuaran",
"6038687", "Putrajaya",
"6032857", "Kuala\ Lumpur",
"605721", "Parit\ Buntar",
"6085770", "Long\ Lama",
"6032116", "Kuala\ Lumpur",
"609475", "Maran",
"606637", "Seremban",
"6037876", "Kuala\ Lumpur",
"609949", "Ayer\ Lanas",
"6089465", "Elopura",
"606433", "Jelai",
"6089966", "Lahad\ Datu",
"6032787", "Kuala\ Lumpur",
"6035480", "Kinrara",
"6088794", "Tuaran",
"605348", "Batu\ Gajah",
"605629", "Telukintan",
"609460", "Maran",
"609888", "Kemasik",
"609860", "Chukai",
"609265", "Jerantut",
"6034296", "Kuala\ Lumpur",
"6093140", "Kuala\ Lipis",
"607970", "Segamat",
"606798", "Mantin",
"6089209", "Elopura",
"6082763", "Bau",
"6087250", "Beaufort",
"6088705", "Kota\ Kinabalu",
"6082755", "Kuching",
"605322", "Ipoh",
"6086360", "Bintulu",
"6088664", "Kota\ Marudu",
"609365", "Dong",
"606278", "Melaka",
"605546", "Ipoh",
"605527", "Ipoh",
"6033270", "Batang\ Berjuntai",
"6085462", "Miri",
"607590", "Senai",
"6039231", "Kuala\ Lumpur",
"607789", "Keluang",
"604923", "Changlon",
"6089513", "Beluran",
"607684", "Pontian",
"6032688", "Kuala\ Lumpur",
"6082580", "Kota\ Samarahan",
"6086324", "Bintulu",
"6084620", "Sarikei",
"6085766", "Marudi",
"606463", "Palong",
"606667", "Sepang",
"604981", "Kangar",
"6089983", "Tawau",
"6033284", "Kuala\ Selangor",
"6034065", "Kuala\ Lumpur",
"6084363", "Sibu",
"6032270", "Kuala\ Lumpur",
"6036191", "Kuala\ Lumpur",
"604619", "Penang",
"604714", "Alor\ Setar",
"606438", "Simpang\ Empat",
"609824", "Kerteh",
"6082305", "Kuching",
"6088355", "Kota\ Kinabalu",
"6089862", "Lahad\ Datu",
"6086292", "Bintulu",
"6082222", "Kuching",
"6088363", "Kota\ Kinabalu",
"6036042", "Kampong\ Suharto",
"6084364", "Sibu",
"6089984", "Tawau",
"6089557", "Kinabatangan",
"6033283", "Kuala\ Selangor",
"607919", "Labis",
"6089275", "Elopura",
"6089619", "Elopura",
"609687", "Bukit\ Bading",
"6087212", "Beaufort",
"609821", "Sri\ Gading",
"6037972", "Kuala\ Lumpur",
"60667", "Seremban",
"6085287", "Lawas",
"6088401", "Kota\ Kinabalu",
"605395", "Besout",
"606793", "Mantin",
"6087485", "Labuan",
"6088364", "Kota\ Kinabalu",
"6087832", "Menumbok",
"605243", "Ipoh",
"609430", "Pekan",
"6037261", "Kuala\ Lumpur",
"604984", "Kangar",
"607427", "Senggarang",
"6032772", "Kuala\ Lumpur",
"6089514", "Beluran",
"6087731", "Tenom",
"60448", "Kulim",
"6084806", "Kapit",
"6082393", "Sejingkat",
"6086323", "Bintulu",
"6087225", "Beaufort",
"6085733", "Batu\ Niah",
"6082720", "Lundu",
"605890", "Semanggol",
"609816", "Dungun",
"609830", "Paka",
"609235", "Genting",
"6087302", "Keningau",
"606426", "Ayer\ Hitam",
"6085768", "Marudi",
"6086301", "Bintulu",
"6036125", "Kuala\ Lumpur",
"6036262", "Kuala\ Lumpur",
"604966", "Kuah",
"6087407", "Labuan",
"6084772", "Song",
"6037610", "Kuala\ Lumpur",
"6032686", "Kuala\ Lumpur",
"605685", "Sitiawan",
"6038526", "Mantin",
"604893", "Penang",
"605237", "Ipoh",
"6047453", "Alor\ Setar",
"6084871", "Mukah",
"604701", "Bedong",
"6089612", "Elopura",
"606411", "Simpang\ Empat",
"604240", "Penang",
"608742", "Labuan",
"6035590", "Kinrara",
"605359", "Batu\ Gajah",
"6087219", "Beaufort",
"607862", "Tiram",
"6032336", "Kuala\ Lumpur",
"608244", "Kuching",
"603620", "Kuala\ Lumpur",
"6089869", "Lahad\ Datu",
"6033620", "Kelang",
"608241", "Kuching",
"6033297", "Kelang",
"607679", "Pontian",
"604704", "Pokok\ Sena",
"607272", "Johor\ Bahru",
"6036049", "Kerling",
"6047454", "Alor\ Setar",
"609958", "Batu\ Gajah",
"6036091", "Rawang",
"6032021", "Kuala\ Lumpur",
"604609", "Penang",
"605856", "Taiping",
"606229", "Melaka",
"605920", "Sitiawan",
"609602", "Bandar\ Permaisuri",
"6036142", "Kuala\ Lumpur",
"609525", "Kuantan",
"6036690", "Batuarang",
"6032297", "Kuala\ Lumpur",
"605678", "Bruas",
"6088975", "Kota\ Belud",
"607666", "Kulai",
"606648", "Port\ Dickson",
"6033363", "Kelang",
"6033103", "Pulau\ Ketam",
"6084808", "Sibu",
"604323", "Penang",
"606664", "Tekok\ Kemang",
"6084719", "Pakan",
"607883", "Kota\ Tinggi",
"6087237", "Beaufort",
"6036037", "Rawang",
"607421", "Kampung\ Parit\ Tengah",
"6035126", "Kinrara",
"6037480", "Kuala\ Lumpur",
"6082862", "Kota\ Samarahan",
"607687", "Pontian",
"607483", "Batu\ Pahat",
"609919", "Ayer\ Lanas",
"606551", "Simpang\ Empat",
"607830", "Penggerang",
"604223", "Penang",
"609827", "Paka",
"6092410", "Telemong",
"609681", "Kuala\ Brang",
"6034032", "Kuala\ Lumpur",
"6082761", "Bau",
"604281", "Penang",
"6032240", "Kuala\ Lumpur",
"6032725", "Kuala\ Lumpur",
"6087854", "Bongawan",
"6036179", "Kuala\ Lumpur",
"606603", "Seremban",
"604717", "Pokok\ Sena",
"606776", "Seremban",
"6082544", "Kuching",
"6039772", "Kuala\ Lumpur",
"6084661", "Sarikei",
"6084892", "Selangau",
"608852", "Kota\ Kinabalu",
"606499", "Batu\ Kikir",
"609684", "Bukit\ Bading",
"609789", "Pasir\ Putih",
"606973", "Bukit\ Gambir",
"6035565", "Kinrara",
"6082543", "Kuching",
"605530", "Tanjung\ Rambutan",
"6088661", "Kotamarudu",
"606554", "Tampin",
"6058301", "Taiping",
"6033160", "Kelang",
"609590", "Kuantan",
"6089856", "Kunak",
"6087853", "Kuala\ Penyu",
"6088791", "Tuaran",
"605318", "Ipoh",
"6082275", "Kuching",
"6087770", "Tambunan",
"6085456", "Miri",
"6082827", "Asajaya",
"607219", "Johor\ Bahru",
"608233", "Kuching",
"607424", "Rengit",
"604987", "Kangar",
"605583", "Chemor",
"606661", "Tekok\ Kemang",
"6032742", "Kuala\ Lumpur",
"6032300", "Kuala\ Lumpur",
"607209", "Johor\ Bahru",
"6085759", "Marudi",
"604672", "Penang",
"609774", "Kota\ Bharu",
"6088742", "Kinarut",
"606350", "Tangga\ Batu",
"609679", "Jerteh",
"604940", "Kangar",
"609272", "Lanchang",
"604568", "Sungai\ Bakap",
"6087501", "Labuan",
"605208", "Ipoh",
"608247", "Sejingkat",
"6037949", "Kuala\ Lumpur",
"6082625", "Kuching",
"609666", "Kuala\ Brang",
"604799", "Pokok\ Sena",
"6084830", "Matu",
"609294", "Kuala\ Krau",
"6088830", "Tuaran",
"6039779", "Kuala\ Lumpur",
"605732", "Parit\ Buntar",
"605506", "Ipoh",
"6039195", "Kuala\ Lumpur",
"6088967", "Tenghilan",
"6084811", "Mukah",
"6038761", "Semenyih",
"609358", "Raub",
"6038090", "Kinrara",
"6084231", "Sibu",
"605320", "Ipoh",
"606613", "Kuala\ Klawang",
"604476", "Kupang",
"6089672", "Elopura",
"6039021", "Kuala\ Lumpur",
"6035652", "Kinrara",
"609862", "Chukai",
"604469", "Jeniang",
"609771", "Kota\ Bharu",
"6036137", "Kuala\ Lumpur",
"6035878", "Kinrara",
"603798", "Kuala\ Lumpur",
"609556", "Kuantan",
"6039103", "Cheras",
"604869", "Penang",
"607297", "Johor\ Bahru",
"6085609", "Miri",
"6038691", "Semenyih",
"605220", "Ipoh",
"609610", "Bandar\ Permaisuri",
"6035030", "Kinrara",
"6036412", "Kuala\ Lumpur",
"6032023", "Kuala\ Lumpur",
"6038966", "Cheras",
"6082325", "Serian",
"6036093", "Rawang",
"6035192", "Kinrara",
"609725", "Kota\ Bharu",
"6084874", "Mukah",
"604415", "Sungai\ Petani",
"603404", "Kuala\ Lumpur",
"6089296", "Elopura",
"604538", "Tasek\ Gelugor",
"6036285", "Kuala\ Lumpur",
"604210", "Penang",
"608829", "Kota\ Kinabalu",
"6084880", "Daro",
"6088535", "Kota\ Kinabalu",
"6083325", "Bandar\ Sri\ Aman",
"605203", "Chemor",
"6086461", "Belaga",
"604563", "Sungai\ Bakap",
"6082312", "Kuching",
"6048640", "Penang",
"6033259", "Kelang",
"6033361", "Kelang",
"6088880", "Ranau",
"6033101", "Pulau\ Ketam",
"6086257", "Bintulu",
"604310", "Penang",
"6082650", "Kuching",
"6082506", "Kuching",
"6086303", "Bintulu",
"6085407", "Miri",
"609353", "Raub",
"6082700", "Lundu",
"609832", "Merchang",
"605892", "Semanggol",
"6084750", "Kanowit",
"6037666", "Kuala\ Lumpur",
"6089959", "Lahad\ Datu",
"6087768", "Tambunan",
"6084873", "Mukah",
"6036187", "Kuala\ Lumpur",
"6047451", "Alor\ Setar",
"6036094", "Rawang",
"603745", "Kuala\ Lumpur",
"608542", "Miri",
"6032024", "Kuala\ Lumpur",
"607571", "Senai",
"6083342", "Bandar\ Sri\ Aman",
"603401", "Kuala\ Lumpur",
"607756", "Renggam",
"6047931", "Pokok\ Sena",
"6087315", "Keningau",
"6085485", "Kampung\ Bakam",
"6036087", "Rawang",
"604511", "Padang\ Serai",
"609970", "Machang",
"604242", "Penang",
"604744", "Alor\ Setar",
"6033281", "Kuala\ Selangor",
"6039388", "Cheras",
"607265", "Johor\ Bahru",
"607860", "Senai",
"607488", "Batu\ Pahat",
"606757", "Mantin",
"609249", "Bera",
"6088403", "Kota\ Kinabalu",
"606545", "Durian\ Tunggal",
"6036105", "Genting",
"6085740", "Mu",
"6085225", "Limbang",
"6087733", "Tenom",
"6033124", "Tk\ Panglima\ Garang",
"6089736", "Tawau",
"604228", "Penang",
"6089952", "Balung",
"607365", "Johor\ Bahru",
"6077120", "Keluang",
"605889", "Taiping",
"606985", "Muar",
"606634", "Seremban",
"6083465", "Debak",
"608873", "Kinarut",
"6086321", "Bintulu",
"6082391", "Kuching",
"6038082", "Kinrara",
"604526", "Kulim",
"6033123", "Tk\ Panglima\ Garang",
"6087734", "Tenom",
"6089511", "Beluran",
"6082319", "Kuching",
"6087766", "Tambunan",
"6084828", "Daro",
"6032600", "Kuala\ Lumpur",
"606631", "Seremban",
"606978", "Tangkak",
"6085710", "Bekenu",
"6087462", "Labuan",
"609846", "Kuala\ Brang",
"605727", "Parit\ Buntar",
"6034051", "Kuala\ Lumpur",
"604405", "Padang\ Serai",
"606620", "Port\ Dickson",
"605286", "Ipoh",
"607475", "Sri\ Gading",
"6036193", "Kuala\ Lumpur",
"605313", "Ipoh",
"6084361", "Sibu",
"6089981", "Tawau",
"6038325", "Putrajaya",
"603414", "Kuala\ Lumpur",
"6039018", "Cheras",
"6085242", "Limbang",
"6083417", "Betong",
"6088361", "Kota\ Kinabalu",
"6036419", "Kuala\ Lumpur",
"604741", "Alor\ Setar",
"609965", "Kuala\ Krai",
"6038051", "Kinrara",
"6033176", "Kelang",
"604200", "Penang",
"6088404", "Kota\ Kinabalu",
"6032380", "Kuala\ Lumpur",
"6036272", "Kuala\ Lumpur",
"606681", "Seremban",
"6033630", "Banting",
"6084762", "Kanowit",
"609551", "Kuantan",
"6032031", "Kuala\ Lumpur",
"604967", "Kuah",
"6095071", "Kuantan",
"609776", "Bachok",
"6034812", "Kuala\ Lumpur",
"6082627", "Kuching",
"6082290", "Kuching",
"606427", "Kuala\ Pilah",
"605310", "Ipoh",
"6035623", "Kinrara",
"6039070", "Cheras",
"6082538", "Kuching",
"609598", "Gambang",
"6088861", "Bongawan",
"604471", "Sungai\ Bakap",
"609769", "Bachok",
"607793", "Endau",
"609664", "Batu\ Rakit",
"608465", "Sarikei",
"605415", "Tapah",
"604762", "Alor\ Setar",
"6036156", "Kuala\ Lumpur",
"6086480", "Balingan",
"605210", "Ipoh",
"605236", "Ipoh",
"607745", "Renggam",
"6084692", "Bintangor",
"604264", "Penang",
"6038741", "Semenyih",
"6033010", "Pulau\ Ketam",
"6035624", "Kinrara",
"605501", "Ipoh",
"605857", "Taiping",
"607515", "Tanjung\ Kupang",
"604261", "Penang",
"6036135", "Kuala\ Lumpur",
"60497", "Kangar",
"6089706", "Tawau",
"6033326", "Kelang",
"607838", "Penawar",
"605439", "Tapah",
"604892", "Penang",
"6082662", "Kota\ Samarahan",
"6083496", "Lingga",
"6086286", "Bintulu",
"605839", "Selama",
"607863", "Tiram",
"606666", "Sepang",
"609455", "Bukit\ Ibam",
"608759", "Labuan",
"6032110", "Kuala\ Lumpur",
"6087450", "Labuan",
"6038891", "Putrajaya",
"6032727", "Kuala\ Lumpur",
"6037870", "Kuala\ Lumpur",
"6082669", "Kota\ Samarahan",
"6033260", "Kuala\ Selangor",
"6085472", "Miri",
"605526", "Ipoh",
"6083564", "Engkilili",
"6082842", "Damai\ Beach",
"606792", "Sepang",
"6087822", "Sipitang",
"606294", "Melaka",
"609250", "Triang",
"609855", "Chukai",
"6035522", "Kinrara",
"605649", "Hutan\ Melintang",
"6033110", "Pulau\ Ketam",
"605242", "Ipoh",
"6088611", "Kudat",
"6036158", "Kuala\ Lumpur",
"605744", "Manong",
"605328", "Ipoh",
"6037884", "Kuala\ Lumpur",
"607505", "Tanjung\ Kupang",
"6038075", "Kinrara",
"6082741", "Lundu",
"6082536", "Kuching",
"6032260", "Kuala\ Lumpur",
"6036035", "Batuarang",
"609350", "Raub",
"6082730", "Lundu",
"607414", "Rengit",
"606391", "Tangga\ Batu",
"6084699", "Bintangor",
"6089708", "Tawau",
"6084641", "Sarikei",
"606771", "Seremban",
"6039170", "Kuala\ Lumpur",
"604922", "Kangar",
"6039221", "Kuala\ Lumpur",
"6037883", "Kuala\ Lumpur",
"604313", "Penang",
"6082555", "Kuching",
"606462", "Palong",
"6082825", "Asajaya",
"609686", "Kuala\ Brang",
"6082711", "Semantan",
"6035545", "Kinrara",
"605805", "Taiping",
"6088641", "Kudat",
"6033140", "Banting",
"608564", "Miri",
"604560", "Kepala\ Batas",
"603888", "Putrajaya",
"6038995", "Cheras",
"6034290", "Kuala\ Lumpur",
"6034819", "Kuala\ Lumpur",
"609817", "Dungun",
"6035567", "Kinrara",
"606358", "Tangga\ Batu",
"6089247", "Elopura",
"607950", "Aver\ Panas",
"6084380", "Sibu",
"607426", "Parit\ Betak",
"609417", "Nenasi",
"6083555", "Bandar\ Sri\ Aman",
"604727", "Bedong",
"6037717", "Kuala\ Lumpur",
"6036279", "Kuala\ Lumpur",
"6083563", "Engkilili",
"6083467", "Sebuyau",
"6039133", "Kuala\ Lumpur",
"6039410", "Cheras",
"607447", "Batu\ Pahat",
"605717", "Parit\ Buntar",
"6032276", "Kuala\ Lumpur",
"605281", "Ipoh",
"6085760", "Marudi",
"609841", "Dungun",
"605323", "Ipoh",
"6034009", "Kuala\ Lumpur",
"6037866", "Kuala\ Lumpur",
"6032223", "Kuala\ Lumpur",
"6089713", "Tawau",
"6082780", "Gedong",
"6089561", "Kinabatangan",
"6088201", "Kota\ Kinabalu",
"6034102", "Kuala\ Lumpur",
"605381", "Batugajah",
"604524", "Tasek\ Gelugor",
"6086590", "Tatau",
"606253", "Melaka",
"6038588", "Putrajaya",
"6082850", "Serian",
"6033181", "Banting",
"6082520", "Kuching",
"604521", "Tasek\ Gelugor",
"6033392", "Kelang",
"6032224", "Kuala\ Lumpur",
"6092871", "Kuala\ Krau",
"6089714", "Tawau",
"6084680", "Sarikei",
"609844", "Dungun",
"6087442", "Labuan",
"6066920", "Linggi",
"6088330", "Kota\ Kinabalu",
"606353", "Tangga\ Batu",
"604218", "Penang",
"605782", "Kuala\ Kangsar",
"6088674", "Kudat",
"6032181", "Kuala\ Lumpur",
"604943", "Kangar",
"6089923", "Tawau",
"6032392", "Kuala\ Lumpur",
"6033224", "Sabak\ Bernam",
"605547", "Ipoh",
"6039134", "Kuala\ Lumpur",
"604530", "Tasek\ Gelugor",
"6035161", "Kinrara",
"6088341", "Kota\ Kinabalu",
"6082282", "Kuching",
"606432", "Gemencheh",
"6034289", "Kuala\ Lumpur",
"609952", "Machang",
"609634", "Bandar\ Permaisuri",
"6086255", "Bintulu",
"6032081", "Kuala\ Lumpur",
"605379", "Batu\ Gajah",
"6032278", "Kuala\ Lumpur",
"605799", "Lenggong",
"607278", "Johor\ Bahru",
"6032330", "Kuala\ Lumpur",
"607751", "Lavang\-Lavang",
"603806", "Kinrara",
"6089901", "Merotai",
"604959", "Kuah",
"6084392", "Sibu",
"6083327", "Bandar\ Sri\ Aman",
"6039549", "Cheras",
"6088537", "Kota\ Kinabalu",
"6087718", "Tenom",
"605672", "Sitiawan",
"604308", "Tasek\ Gelugor",
"606970", "Muar",
"6038726", "Semenyih",
"6033081", "Kelang",
"608221", "Kuching",
"605533", "Tanjung\ Rambutan",
"609593", "Gambang",
"6036287", "Kuala\ Lumpur",
"6038520", "Kinrara",
"6032800", "Kuala\ Lumpur",
"6033341", "Kelang",
"6085493", "Sundar",
"606642", "Port\ Dickson",
"6084224", "Sibu",
"6087317", "Keningau",
"604331", "Penang",
"6034251", "Kuala\ Lumpur",
"6089805", "Lahad\ Datu",
"605469", "Kampar",
"606965", "Tangkak",
"608224", "Kuching",
"604220", "Penang",
"6032201", "Kuala\ Lumpur",
"6084223", "Sibu",
"6085494", "Bekenu",
"603209", "Kuala\ Lumpur",
"6038780", "Mantin",
"6036185", "Kuala\ Lumpur",
"607468", "Sri\ Gading",
"6089894", "Kunak",
"6092620", "Jerantut",
"607659", "Linggiu",
"604320", "Penang",
"607868", "Tiram",
"607252", "Johor\ Bahru",
"607880", "Kota\ Tinggi",
"607754", "Ayer\ Hitam",
"609978", "Kuala\ Krai",
"605476", "Kampar",
"605691", "Sitiawan",
"609631", "Kuala\ Brang",
"6036462", "Kerling",
"6085405", "Miri",
"6085632", "Miri",
"605541", "Ipoh",
"6032246", "Kuala\ Lumpur",
"605212", "Ipoh",
"604760", "Alor\ Setar",
"6039223", "Kuala\ Lumpur",
"605714", "Parit\ Buntar",
"6088614", "Kudat",
"60794", "Gemas",
"6084614", "Rejang",
"6082713", "Semantan",
"6039059", "Cheras",
"607444", "Senggarang",
"6082887", "Serian",
"6088657", "Kotamarudu",
"6083475", "Debak",
"605312", "Ipoh",
"6088519", "Kota\ Kinabalu",
"6035120", "Kinrara",
"608891", "Papar",
"6033855", "Sabak\ Bernam",
"6084308", "Sibu",
"6038894", "Putrajaya",
"6088308", "Kota\ Kinabalu",
"6038893", "Putrajaya",
"605726", "Parit\ Buntar",
"604918", "Alor\ Setar",
"6087472", "Labuan",
"604890", "Penang",
"609447", "Bandar\ Tun\ Razak",
"6087776", "Keningau",
"6085450", "Miri",
"6033216", "Sabak\ Bernam",
"6039224", "Kuala\ Lumpur",
"6033134", "Kelang",
"6089726", "Tawau",
"607441", "Senggarang",
"6087437", "Labuan",
"6033166", "Kelang",
"6088613", "Kudat",
"6089850", "Kunak",
"6089520", "Telupid",
"6084644", "Sarikei",
"6084613", "Selalang",
"607705", "Keluang",
"605287", "Pusing",
"608872", "Kinarut",
"6032785", "Kuala\ Lumpur",
"60464", "Penang",
"608921", "Elopura",
"606270", "Melaka",
"609352", "Sungai\ Koyan",
"605893", "Taiping",
"609833", "Bukit\ Besi",
"605240", "Ipoh",
"606475", "Ayer\ Hitam",
"6088785", "Tuaran",
"609637", "Kuala\ Brang",
"6089289", "Elopura",
"608543", "Miri",
"6032034", "Kuala\ Lumpur",
"609754", "Bachok",
"606790", "Mantin",
"609659", "Batu\ Rakit",
"6039081", "Cheras",
"609868", "Chukai",
"609252", "Triang",
"604908", "Kangar",
"6087802", "Sipitang",
"609285", "Mentakab",
"609468", "Maran",
"609480", "Maran",
"6085617", "Miri",
"6037859", "Kuala\ Lumpur",
"604685", "Penang",
"604259", "Penang",
"60443", "Sungai\ Petani",
"6087479", "Labuan",
"6084306", "Sibu",
"6082894", "Serian",
"6035020", "Kinrara",
"604931", "Changlon",
"6088512", "Kota\ Kinabalu",
"609751", "Kota\ Bharu",
"607739", "Kluang",
"609278", "Mentakab",
"605763", "Lenggong",
"6082685", "Kuching",
"6082805", "Simunjan",
"607757", "Renggam",
"606460", "Bahau",
"605609", "Teluk\ Intan",
"6088863", "Bongawan",
"6038744", "Semenyih",
"6035621", "Kinrara",
"604562", "Kepala\ Batas",
"6063131", "Melaka",
"6085665", "Miri",
"6089728", "Tawau",
"6033168", "Kelang",
"6039201", "Kuala\ Lumpur",
"6088982", "Tenghilan",
"604920", "Kangar",
"606265", "Sungai\ Rambai",
"609838", "Merchang",
"606424", "Batu\ Kikir",
"605898", "Semanggol",
"6034253", "Kuala\ Lumpur",
"604367", "Serdang",
"609404", "Pekan",
"6038708", "Mantin",
"6033197", "Banting",
"607661", "Kulai",
"6034265", "Kuala\ Lumpur",
"6089538", "Elopura",
"6088886", "Ranau",
"6033084", "Kelang",
"6088606", "Kudat",
"6084221", "Sibu",
"6033344", "Kelang",
"6036242", "Kuala\ Lumpur",
"604964", "Kuah",
"6032203", "Kuala\ Lumpur",
"608988", "Lahad\ Datu",
"609438", "Perwira\ Jaya",
"606612", "Kuala\ Klawang",
"604267", "Penang",
"604903", "Kuah",
"609863", "Chukai",
"607899", "Tiram",
"6039769", "Cheras",
"6087405", "Labuan",
"605507", "Ipoh",
"6032084", "Kuala\ Lumpur",
"6036127", "Kuala\ Lumpur",
"6035036", "Kinrara",
"6045960", "Parit\ Buntar",
"606319", "Melaka",
"609667", "Kuala\ Brang",
"6086860", "Bintulu",
"6089290", "Elopura",
"608246", "Kuching",
"6089849", "Kunak",
"6034217", "Kuala\ Lumpur",
"6032083", "Kuala\ Lumpur",
"607407", "Parit\ Sulong",
"604673", "Penang",
"606430", "Gemencheh",
"6039010", "Cheras",
"6057970", "Grik",
"605854", "Sungai\ Nyior",
"606235", "Melaka",
"6086457", "Belaga",
"605768", "Lenggong",
"6088977", "Kota\ Belud",
"605599", "Chemor",
"609539", "Kuantan",
"6089903", "Merotai",
"6032295", "Kuala\ Lumpur",
"609801", "Paka",
"609557", "Kuantan",
"6038872", "Putrajaya",
"604961", "Kuah",
"6037660", "Kuala\ Lumpur",
"608975", "Tawau",
"6082402", "Kuching",
"6033083", "Kelang",
"607296", "Johor\ Bahru",
"6084820", "Daro",
"6089792", "Semporna",
"608849", "Kota\ Kinabalu",
"6033343", "Kelang",
"6085491", "Miri",
"606335", "Melaka",
"605733", "Parit\ Buntar",
"607598", "Senai",
"6085718", "Bekenu",
"606421", "Bahau",
"6033183", "Banting",
"607929", "Aver\ Panas",
"6037831", "Kuala\ Lumpur",
"607686", "Pontian",
"604783", "Lubuk\ Merbau",
"6088357", "Kota\ Kinabalu",
"606640", "Port\ Dickson",
"6088204", "Kota\ Kinabalu",
"6038706", "Mantin",
"606972", "Bukit\ Gambir",
"605670", "Sitiawan",
"6089730", "Tawau",
"6085540", "Miri",
"6088608", "Kudat",
"6082658", "Kuching",
"6089536", "Elopura",
"6088888", "Ranau",
"6089921", "Balung",
"6098700", "Kemasik",
"604716", "Alor\ Setar",
"609826", "Kerteh",
"609950", "Machang",
"6037732", "Kuala\ Lumpur",
"6088343", "Kota\ Kinabalu",
"6035163", "Kinrara",
"6089669", "Elopura",
"607882", "Kota\ Tinggi",
"607250", "Johor\ Bahru",
"604913", "Alor\ Setar",
"6039131", "Kuala\ Lumpur",
"604248", "Penang",
"6087227", "Beaufort",
"6033170", "Kelang",
"6088671", "Kudat",
"605517", "Tanjung\ Rambutan",
"6039140", "Kuala\ Lumpur",
"6084671", "Sarikei",
"6035164", "Kinrara",
"609329", "Padangtengku",
"607482", "Kangkar\ Baru",
"6088344", "Kota\ Kinabalu",
"605665", "Sitiawan",
"606958", "Bukit\ Gambir",
"6038656", "Cheras",
"609414", "Kuala\ Rompin",
"604629", "Penang",
"604986", "Kangar",
"604222", "Penang",
"6085285", "Lawas",
"6082708", "Kota\ Samarahan",
"6033184", "Banting",
"6034022", "Kuala\ Lumpur",
"609505", "Kuantan",
"6038022", "Kinrara",
"60676", "Seremban",
"6088203", "Kota\ Kinabalu",
"6086381", "Tatau",
"6089563", "Kinabatangan",
"606525", "Jasin",
"6089277", "Elopura",
"6089711", "Tawau",
"6087760", "Tenom",
"609229", "Bilut\ Valley",
"609814", "Paka",
"6033322", "Kelang",
"6038950", "Cheras",
"609583", "Gebeng",
"607760", "Keluang",
"607788", "Kahang",
"6089702", "Tawau",
"606653", "Port\ Dickson",
"6082590", "Kuching",
"608245", "Kuching",
"6085401", "Miri",
"609521", "Kuantan",
"6082492", "Kuching",
"6086422", "Sebauh",
"6082539", "Kuching",
"6087403", "Labuan",
"607527", "Kangkar\ Pulai",
"604618", "Penang",
"6085779", "Long\ Lama",
"60458", "Sungai\ Bakap",
"6036181", "Kuala\ Lumpur",
"605684", "Sitiawan",
"606439", "Simpang\ Empat",
"6086282", "Bintulu",
"6082666", "Kota\ Samarahan",
"6034255", "Kuala\ Lumpur",
"607918", "Aver\ Panas",
"605623", "Telukintan",
"606336", "Melaka",
"605427", "Tapah",
"6033345", "Kelang",
"6034816", "Kuala\ Lumpur",
"6062710", "Sungai\ Rambai",
"6032107", "Kuala\ Lumpur",
"6034264", "Kuala\ Lumpur",
"6033085", "Kelang",
"6087828", "Kuala\ Penyu",
"6037650", "Kuala\ Lumpur",
"6085620", "Miri",
"605681", "Sitiawan",
"6085297", "Lawas",
"6084766", "Kanowit",
"6084734", "Julau",
"6036276", "Kuala\ Lumpur",
"608976", "Tawau",
"607295", "Johor\ Bahru",
"607890", "Linggiu",
"6084696", "Bintangor",
"6037202", "Kuala\ Lumpur",
"6082383", "Kuching",
"6086251", "Bintulu",
"6032085", "Kuala\ Lumpur",
"6087404", "Labuan",
"604705", "Alor\ Setar",
"606415", "Tampin",
"6088345", "Kota\ Kinabalu",
"609825", "Kerteh",
"609220", "Bentong",
"6035165", "Kinrara",
"606514", "Jasin",
"6089517", "Beluran",
"6033007", "Kuala\ Selangor",
"6085270", "Lawas",
"605771", "Grik",
"6082798", "Tebedu",
"604620", "Penang",
"6087874", "Weston",
"6084367", "Sibu",
"6035482", "Kinrara",
"607908", "Bekok",
"6088469", "Kota\ Kinabalu",
"6082668", "Kota\ Samarahan",
"605291", "Tanjung\ Rambutan",
"6085284", "Lawas",
"6033185", "Banting",
"609231", "Karak",
"60743", "Batu\ Pahat",
"605358", "Batu\ Gajah",
"6087880", "Membakut",
"6083411", "Kabong",
"6088367", "Kota\ Kinabalu",
"607259", "Johor\ Bahru",
"607934", "Labis",
"607685", "Pontian",
"607652", "Kulai",
"6082846", "Damai\ Beach",
"6035526", "Kinrara",
"605792", "Grik",
"607678", "Pontian",
"609732", "Kota\ Bharu",
"609234", "Karak",
"6089565", "Kinabatangan",
"6087750", "Tenom",
"609959", "Batu\ Gajah",
"6088205", "Kota\ Kinabalu",
"6036081", "Batu\ Arang",
"605294", "Tanjung\ Rambutan",
"6032733", "Kuala\ Lumpur",
"606228", "Melaka",
"6085283", "Lawas",
"6039521", "Kuala\ Lumpur",
"6083430", "Saratok",
"604985", "Kangar",
"604952", "Kuah",
"609208", "Sungai\ Tekam",
"604545", "Sungai\ Bakap",
"6082499", "Kuching",
"607562", "Senai",
"608887", "Ranau",
"604757", "Alor\ Setar",
"605679", "Sitiawan",
"6082532", "Kuching",
"6037933", "Kuala\ Lumpur",
"6093262", "Padang\ Tengku",
"607920", "Segamat",
"606242", "Melaka",
"6086327", "Bintulu",
"609937", "Kuala\ Balah",
"6085737", "Batu\ Niah",
"603893", "Cheras",
"604593", "Parit\ Buntar",
"6084698", "Bintangor",
"6032770", "Kuala\ Lumpur",
"6032847", "Kuala\ Lumpur",
"6065350", "Jasin",
"606987", "Bakri",
"609474", "Kota\ Gelangi",
"6038008", "Putrajaya",
"6039212", "Kuala\ Lumpur",
"6088667", "Kota\ Marudu",
"605253", "Ipoh",
"6058307", "Selama",
"607964", "Bukit\ Gambir",
"606384", "Tangga\ Batu",
"6033396", "Kelang",
"609874", "Kemasik",
"6083473", "Betong",
"6082286", "Kuching",
"604554", "Tasek\ Gelugor",
"6082715", "Semantan",
"6035541", "Kinrara",
"6082821", "Asajaya",
"6082551", "Kuching",
"603780", "Kuala\ Lumpur",
"60565", "Langkap",
"6088797", "Tuaran",
"604899", "Penang",
"6035885", "Kinrara",
"6038991", "Cheras",
"607267", "Johor\ Bahru",
"6089937", "Luasong",
"605432", "Trolak",
"6039546", "Cheras",
"6084645", "Sarikei",
"6085638", "Miri",
"6085266", "Lawas",
"604499", "Baling",
"6084797", "Kapit",
"606782", "Seremban",
"605353", "Ipoh",
"6033135", "Kelang",
"6082473", "Kuching",
"609361", "Raub",
"6039225", "Kuala\ Lumpur",
"606547", "Durian\ Tunggal",
"607477", "Sri\ Gading",
"6032783", "Kuala\ Lumpur",
"607706", "Keluang",
"6034288", "Kuala\ Lumpur",
"604407", "Serdang",
"607532", "Senai",
"6032272", "Kuala\ Lumpur",
"6087231", "Beaufort",
"60779", "Mersing",
"6084398", "Sibu",
"6038684", "Putrajaya",
"6088615", "Kudat",
"6038071", "Kinrara",
"6083480", "Betong",
"6087811", "Sipitang",
"6082474", "Kuching",
"604551", "Tasek\ Gelugor",
"6082220", "Kuching",
"6087725", "Tenom",
"6086290", "Bintulu",
"6034106", "Kuala\ Lumpur",
"609264", "Mentakab",
"6082582", "Kota\ Samarahan",
"609762", "Pasir\ Putih",
"607961", "Segamat",
"6085460", "Miri",
"6033272", "Batang\ Berjuntai",
"609471", "Sungai\ Tekam",
"6037862", "Kuala\ Lumpur",
"604598", "Parit\ Buntar",
"6083220", "Bandar\ Sri\ Aman",
"605725", "Parit\ Buntar",
"605636", "Sabak\ Bernam",
"604769", "Alor\ Setar",
"6083474", "Debak",
"605610", "Telukintan",
"606658", "Sepang",
"607783", "Keluang",
"604686", "Penang",
"604929", "Alor\ Setar",
"6088961", "Kota\ Belud",
"60961", "Kuala\ Brang",
"609560", "Kuantan",
"6038767", "Semenyih",
"607721", "Renggam",
"609286", "Kuala\ Krau",
"6086555", "Bintulu",
"6082895", "Serian",
"6033279", "Batang\ Berjuntai",
"6084237", "Sibu",
"606469", "Kemavan",
"6038912", "Semenyih",
"605846", "Taiping",
"604417", "Mahang",
"6039548", "Cheras",
"6036131", "Kuala\ Lumpur",
"606476", "Ladang\ Geddes",
"6085268", "Sundar",
"6098000", "Kerteh",
"6085636", "Miri",
"604613", "Penang",
"6085664", "Miri",
"606691", "Linggi",
"6088783", "Tuaran",
"6082288", "Kuching",
"6036140", "Kuala\ Lumpur",
"6089631", "Elopura",
"608251", "Kuching",
"6083589", "Lubukantu",
"6086232", "Bintulu",
"6032279", "Kuala\ Lumpur",
"6082684", "Kuching",
"609213", "Jengka\ Lapan\ Belas",
"6088854", "Ranau",
"6082804", "Simunjan",
"605446", "Tapah",
"605349", "Batu\ Gajah",
"6036433", "Genting",
"6088784", "Tuaran",
"604250", "Penang",
"606266", "Sungai\ Rambai",
"609489", "Maran",
"6085663", "Miri",
"607913", "Labis",
"609650", "Batu\ Rakit",
"606379", "Tangga\ Batu",
"606694", "Rantau",
"6034821", "Kuala\ Lumpur",
"606799", "Mantin",
"604455", "Sungai\ Petani",
"6088853", "Ranau",
"6082803", "Simunjan",
"6082683", "Kuching",
"603928", "Kuala\ Lumpur",
"6088396", "Kota\ Kinabalu",
"6087507", "Labuan",
"607222", "Johor\ Bahru",
"605249", "Ipoh",
"605642", "Hutan\ Melintang",
"6084770", "Song",
"6034108", "Kuala\ Lumpur",
"6032035", "Kuala\ Lumpur",
"606533", "Jasin",
"609575", "Kuantan",
"6032731", "Kuala\ Lumpur",
"6087772", "Tambunan",
"606387", "Kuala\ Sungai\ Baru",
"6082261", "Kuching",
"60979", "Kota\ Bharu",
"604539", "Tasek\ Gelugor",
"6089286", "Elopura",
"6088309", "Kota\ Kinabalu",
"6089715", "Tawau",
"6087476", "Labuan",
"6085750", "Marudi",
"6083414", "Kabong",
"6032302", "Kuala\ Lumpur",
"605592", "Lintang",
"60648", "Kuala\ Pilah",
"607364", "Johor\ Bahru",
"6089942", "Tawau",
"6088518", "Kota\ Kinabalu",
"606726", "Seremban",
"609477", "Maran",
"609706", "Kota\ Bharu",
"606984", "Bukit\ Gambir",
"608828", "Kota\ Kinabalu",
"6037931", "Kuala\ Lumpur",
"607696", "Pontian",
"607303", "Johor\ Bahru",
"6087737", "Tenom",
"6039058", "Cheras",
"604373", "Penang",
"606544", "Durian\ Tunggal",
"604401", "Kulim",
"6039770", "Kuala\ Lumpur",
"6033162", "Kelang",
"609961", "Kuala\ Krai",
"6087871", "Weston",
"6033225", "Sabak\ Bernam",
"6038011", "Kinrara",
"6037940", "Kuala\ Lumpur",
"604557", "Tasek\ Gelugor",
"6088675", "Pantai\ Pitas",
"607762", "Renggam",
"608842", "Kota\ Kinabalu",
"6089722", "Tawau",
"604515", "Tasekgelugor",
"607261", "Johor\ Bahru",
"6037910", "Kuala\ Lumpur",
"604404", "Mahang",
"609367", "Dong",
"606541", "Durian\ Tunggal",
"6089925", "Tawau",
"605756", "Kuala\ Kangsar",
"604838", "Penang",
"6032242", "Kuala\ Lumpur",
"607361", "Johor\ Bharu",
"606981", "Bakri",
"6036084", "Batu\ Arang",
"604463", "Jeniang",
"607892", "Kota\ Tinggi",
"604667", "Penang",
"6082860", "Kota\ Samarahan",
"6089745", "Merotai",
"603563", "Kinrara",
"6083413", "Kabong",
"606312", "Melaka",
"609267", "Jerantut",
"6033242", "Sekinchan",
"603300", "Kelang",
"6087478", "Labuan",
"6036184", "Kuala\ Lumpur",
"609546", "Gambang",
"6032027", "Kuala\ Lumpur",
"6085495", "Miri",
"6088516", "Kota\ Kinabalu",
"6035650", "Kinrara",
"607650", "Layang\-Layang",
"6033291", "Kelang",
"607889", "Kota\ Tinggi",
"609248", "Bera",
"609913", "Gua\ Musang",
"609322", "Kuala\ Lipis",
"6089288", "Elopura",
"6038775", "Mantin",
"6085404", "Miri",
"604229", "Penang",
"605888", "Taiping",
"609222", "Bentong",
"605488", "Tanjung\ Malim",
"6089670", "Elopura",
"604414", "Serdang",
"6039056", "Cheras",
"6082381", "Kuching",
"6086253", "Bintulu",
"6038092", "Kinrara",
"6085403", "Miri",
"6086307", "Bintulu",
"606493", "Kuala\ Klawang",
"606240", "Melaka",
"607922", "Bekok",
"6084832", "Matu",
"6033169", "Kelang",
"606697", "Linggi",
"6089729", "Tawau",
"606701", "Linggi",
"609721", "Kota\ Bharu",
"6087401", "Labuan",
"604811", "Penang",
"607560", "Senai",
"609783", "Bachok",
"606979", "Tangkak",
"608257", "Kuching",
"6088920", "Papar",
"6086254", "Bintulu",
"606966", "Bakri",
"6084302", "Sibu",
"604950", "Kuah",
"607386", "Johor\ Bahru",
"604826", "Penang",
"6084877", "Mukah",
"6084731", "Julau",
"603228", "Kuala\ Lumpur",
"60478", "Pokok\ Sena",
"6088302", "Kota\ Kinabalu",
"6088740", "Kinarut",
"605370", "Batu\ Gajah",
"6085661", "Miri",
"604447", "Bedong",
"6083340", "Bandar\ Sri\ Aman",
"6089818", "Lahad\ Datu",
"607746", "Renggam",
"6039205", "Kuala\ Lumpur",
"6089666", "Elopura",
"6082681", "Kuching",
"60695", "Muar",
"6083406", "Maludam",
"6088851", "Ranau",
"6035625", "Kinrara",
"609918", "Gua\ Musang",
"605416", "Tapah",
"6096830", "Kuala\ Brang",
"6089634", "Elopura",
"605430", "Besout",
"609243", "Triang",
"605883", "Taiping",
"609775", "Kota\ Bharu",
"6034028", "Kuala\ Lumpur",
"606733", "Mantin",
"605421", "Besout",
"6035612", "Kinrara",
"6089796", "Merotai",
"605687", "Sitiawan",
"6085791", "Miri",
"6089492", "Beluran",
"6084752", "Kanowit",
"6085719", "Bekenu",
"6082878", "Baki",
"605612", "Sitiawan",
"606498", "Batu\ Kikir",
"6038408", "Cheras",
"607521", "Senai",
"6038659", "Cheras",
"606910", "Muar",
"6032938", "Kuala\ Lumpur",
"609760", "Bachok",
"6088602", "Kudat",
"609788", "Kok\ Lanas",
"6039085", "Cheras",
"6088781", "Tuaran",
"6035032", "Kinrara",
"607943", "Tenang",
"607218", "Johor\ Bahru",
"606851", "Seremban",
"6089633", "Elopura",
"607516", "Tanjung\ Kupang",
"607530", "Senai",
"6089848", "Kunak",
"6083310", "Bandar\ Sri\ Aman",
"6089668", "Elopura",
"6087233", "Beaufort",
"6038994", "Cheras",
"6085240", "Kampung\ Pahlawan",
"6083408", "Maludam",
"6039766", "Cheras",
"6084375", "Sibu",
"6035544", "Kinrara",
"607208", "Johor\ Bahru",
"6082824", "Asajaya",
"6032781", "Kuala\ Lumpur",
"608823", "Kota\ Kinabalu",
"6085231", "Kampung\ Pahlawan",
"6038073", "Kinrara",
"606517", "Jasin",
"6035039", "Kinrara",
"607506", "Senai",
"6088889", "Ranau",
"604569", "Kepala\ Batas",
"6088609", "Kudat",
"6082659", "Kota\ Samarahan",
"605525", "Ipoh",
"6033250", "Kelang",
"604378", "Penang",
"6038026", "Kinrara",
"605209", "Ipoh",
"609856", "Chukai",
"609456", "Chini",
"6034026", "Kuala\ Lumpur",
"6087460", "Labuan",
"6089798", "Tawau",
"6032602", "Kuala\ Lumpur",
"6088938", "Kota\ Belud",
"6089950", "Balung",
"607425", "Parit\ Betak",
"6089532", "Elopura",
"6085742", "Beluru",
"6082709", "Kota\ Samarahan",
"6083471", "Betong",
"6038080", "Kinrara",
"609237", "Bilut\ Valley",
"6038331", "Putrajaya",
"605640", "Hutan\ Melintang",
"607220", "Johor\ Bahru",
"6082547", "Kuching",
"6033851", "Banting",
"609685", "Kuala\ Brang",
"605806", "Taiping",
"6038993", "Cheras",
"6087234", "Beaufort",
"6036066", "Kuala\ Kubu\ Baru",
"604468", "Bedong",
"6034801", "Kuala\ Lumpur",
"60549", "Cameron\ Highland",
"6036034", "Rawang",
"6082553", "Kuching",
"6035543", "Kinrara",
"6038074", "Kinrara",
"6082471", "Kuching",
"6037885", "Kuala\ Lumpur",
"604252", "Penang",
"605406", "Tapah",
"604868", "Penang",
"6083547", "Maludam",
"6036737", "Kuala\ Kubu\ Baru",
"609544", "Kuantan",
"6033269", "Kuala\ Selangor",
"607912", "Aver\ Panas",
"604687", "Penang",
"6037879", "Kuala\ Lumpur",
"604483", "Baling",
"6032119", "Kuala\ Lumpur",
"6087888", "Membakut",
"6087459", "Labuan",
"6085680", "Miri",
"6088533", "Kota\ Kinabalu",
"6038777", "Mantin",
"6088971", "Kota\ Belud",
"607381", "Johor\ Bahru",
"6038211", "Semenyih",
"6083323", "Bandar\ Sri\ Aman",
"6087314", "Keningau",
"6082739", "Lundu",
"604830", "Penang",
"605643", "Hutan\ Melintang",
"607223", "Johor\ Bahru",
"606477", "Palong",
"609635", "Kuala\ Brang",
"608434", "Sibu",
"6038956", "Serdang",
"604416", "Sungai\ Petani",
"605847", "Taiping",
"6082790", "Tebedu",
"6034161", "Kuala\ Lumpur",
"609726", "Kota\ Bharu",
"606532", "Jasin",
"6036095", "Rawang",
"6082323", "Damai\ Beach",
"6032025", "Kuala\ Lumpur",
"6082596", "Kuching",
"6033191", "Banting",
"6086580", "Tatau",
"6088690", "Kota\ Marudu",
"6033149", "Banting",
"607782", "Paloh",
"6087313", "Keningau",
"607755", "Renggam",
"608431", "Sibu",
"609981", "Kuala\ Krai",
"6088908", "Papar",
"6033382", "Kelang",
"608831", "Kota\ Kinabalu",
"6084875", "Mukah",
"609312", "Kuala\ Lipis",
"6039179", "Kuala\ Lumpur",
"6087344", "Keningau",
"6082324", "Asajaya",
"6084690", "Bintangor",
"608225", "Kuching",
"6085201", "Limbang",
"606964", "Tangkak",
"6032191", "Kuala\ Lumpur",
"6085626", "Miri",
"604612", "Penang",
"604824", "Penang",
"604219", "Penang",
"6084760", "Kanowit",
"6036270", "Kuala\ Lumpur",
"6032382", "Kuala\ Lumpur",
"6089969", "Lahad\ Datu",
"6089206", "Elopura",
"6083438", "Saratok",
"609714", "Kota\ Bharu",
"6082292", "Kuching",
"6083324", "Bandar\ Sri\ Aman",
"6034810", "Kuala\ Lumpur",
"6088534", "Kota\ Kinabalu",
"609541", "Sungai\ Lembing",
"609212", "Maran",
"6034299", "Kuala\ Lumpur",
"6035102", "Kinrara",
"6036021", "Batuarang",
"607279", "Johor\ Bahru",
"605798", "Lenggong",
"609738", "Kota\ Bharu",
"6034292", "Kuala\ Lumpur",
"6082810", "Asajaya",
"607533", "Senai",
"6082299", "Kuching",
"6083463", "Debak",
"6087221", "Beaufort",
"609609", "Bandar\ Permaisuri",
"6036103", "Genting",
"6084382", "Sibu",
"604958", "Kuah",
"607940", "Segamat",
"606222", "Melaka",
"6032389", "Kuala\ Lumpur",
"606986", "Bakri",
"6087735", "Tenom",
"6085223", "Limbang",
"6038958", "Cheras",
"6088405", "Kota\ Kinabalu",
"604309", "Sungai\ Petani",
"606546", "Durian\ Tunggal",
"605751", "Kuala\ Kangsar",
"6039172", "Kuala\ Lumpur",
"6087481", "Labuan",
"6033142", "Sepang",
"6038324", "Putrajaya",
"6089271", "Elopura",
"6089717", "Tawau",
"6084632", "Selalang",
"607266", "Johor\ Bahru",
"6084405", "Sibu",
"60449", "Kulim",
"6082301", "Kuching",
"6088351", "Kota\ Kinabalu",
"6089747", "Tawau",
"609340", "Sungai\ Koyan",
"605480", "Tanjung\ Malim",
"609966", "Kuala\ Krai",
"605468", "Kampar",
"605880", "Selama",
"605285", "Ipoh",
"604406", "Padang\ Serai",
"6037771", "Kuala\ Lumpur",
"604397", "Penang",
"607707", "Keluang",
"6038323", "Putrajaya",
"6038790", "Mantin",
"6032262", "Kuala\ Lumpur",
"6084351", "Miri",
"6036195", "Kuala\ Lumpur",
"6088906", "Papar",
"6038660", "Mantin",
"6089208", "Elopura",
"609701", "Kota\ Bharu",
"6083436", "Saratok",
"6082831", "Sebangan",
"6037872", "Kuala\ Lumpur",
"605637", "Sabak\ Bernam",
"607902", "Tangkak",
"6083464", "Debak",
"605433", "Tapah",
"6089927", "Tawau",
"609845", "Dungun",
"609240", "Kemayan",
"6087452", "Labuan",
"607469", "Sri\ Gading",
"6082840", "Damai\ Beach",
"607869", "Senai",
"607658", "Kulai",
"609445", "Bandar\ Tun\ Razak",
"605385", "Bota",
"609979", "Machang",
"6035520", "Kinrara",
"6085628", "Miri",
"6087820", "Sipitang",
"6085224", "Limbang",
"6049371", "Kangar",
"6036104", "Genting",
"6039235", "Kuala\ Lumpur",
"6085470", "Miri",
"6039540", "Kuala\ Lumpur",
"605401", "Tapah",
"6088332", "Kota\ Kinabalu",
"605793", "Grik",
"607415", "Batu\ Pahat",
"6032723", "Kuala\ Lumpur",
"6089244", "Elopura",
"606775", "Seremban",
"6036148", "Kuala\ Lumpur",
"6082280", "Kuching",
"6087216", "Beaufort",
"607210", "Johor\ Bahru",
"604953", "Kuah",
"603261", "Kuala\ Lumpur",
"6088701", "Kinarut",
"6082751", "Bau",
"605801", "Taiping",
"607504", "Tanjung\ Kupang",
"6087431", "Labuan",
"60473", "Alor\ Setar",
"609599", "Gambang",
"609780", "Kok\ Lanas",
"609768", "Bachok",
"609854", "Chukai",
"606295", "Melaka",
"6032776", "Kuala\ Lumpur",
"606490", "Rembau",
"6038529", "Mantin",
"609454", "Bukit\ Ibam",
"6084802", "Sibu",
"6082274", "Kuching",
"6087440", "Labuan",
"6084682", "Sarikei",
"604592", "Parit\ Buntar",
"603892", "Semenyih",
"605667", "Bruas",
"6083545", "Pantu",
"609451", "Bandar\ Tun\ Razak",
"6037887", "Kuala\ Lumpur",
"6089461", "Elopura",
"6038100", "Kinrara",
"6034100", "Kuala\ Lumpur",
"6082273", "Kuching",
"606527", "Jasin",
"609851", "Chukai",
"6082782", "Gedong",
"609936", "Kuala\ Balah",
"605438", "Tapah",
"6082545", "Kuching",
"608486", "Dalat",
"604571", "Tasek\ Gelugor",
"605804", "Taiping",
"6078011", "Mersing",
"6036046", "Kampong\ Suharto",
"608565", "Miri",
"603762", "Kuala\ Lumpur",
"6089243", "Elopura",
"6032724", "Kuala\ Lumpur",
"6082226", "Kuching",
"6087863", "Bongawan",
"60735", "Johor\ Bahru",
"6086296", "Bintulu",
"6089866", "Lahad\ Datu",
"6037713", "Kuala\ Lumpur",
"605404", "Tapah",
"6089618", "Elopura",
"6083567", "Lingga",
"605838", "Selama",
"607511", "Senai",
"606856", "Mantin",
"6087218", "Beaufort",
"605622", "Telukintan",
"604860", "Penang",
"609900", "Gua\ Musang",
"608758", "Labuan",
"604888", "Penang",
"607744", "Ayer\ Hitam",
"6038601", "Kinrara",
"6033050", "Kelang",
"6036460", "Kerling",
"6085630", "Miri",
"604460", "Bedong",
"604488", "Padang\ Serai",
"609665", "Kuala\ Brang",
"607228", "Johor\ Bahru",
"605648", "Hutan\ Melintang",
"6038000", "Putrajaya",
"6039207", "Kuala\ Lumpur",
"6085769", "Marudi",
"6084689", "Bintangor",
"6084809", "Sibu",
"6039105", "Cheras",
"609582", "Gebeng",
"6038522", "Semenyih",
"609555", "Kuantan",
"6088943", "Kota\ Belud",
"6086952", "Bintulu",
"608977", "Tawau",
"607300", "Johor\ Bahru",
"604790", "Pokok\ Sena",
"606337", "Melaka",
"609928", "Gua\ Musang",
"604370", "Penang",
"6035891", "Kinrara",
"6034280", "Kuala\ Lumpur",
"6032332", "Kuala\ Lumpur",
"6089616", "Elopura",
"604949", "Kangar",
"604475", "Kupang",
"6038751", "Semenyih",
"6036048", "Kerling",
"6085611", "Miri",
"605811", "Taiping",
"607514", "Tanjung\ Kupang",
"6089868", "Lahad\ Datu",
"607741", "Felda\ Kahang\ Timur",
"6086298", "Bintulu",
"6082228", "Kuching",
"605899", "Semanggol",
"609839", "Merchang",
"6087392", "Keningau",
"6087484", "Labuan",
"6036178", "Kuala\ Lumpur",
"604432", "Kulim",
"6037946", "Kuala\ Lumpur",
"6089852", "Kunak",
"6088353", "Kota\ Kinabalu",
"6082303", "Kuching",
"607507", "Tanjung\ Kupang",
"6033187", "Banting",
"606530", "Jasin",
"6086506", "Bintulu",
"60465", "Penang",
"6084896", "Stapang",
"607451", "Batu\ Pahat",
"6084353", "Sibu",
"603673", "Kuala\ Lumpur",
"6089274", "Elopura",
"6038321", "Putrajaya",
"6084365", "Sibu",
"6037773", "Kuala\ Lumpur",
"6039776", "Kuala\ Lumpur",
"6089985", "Tawau",
"608989", "Lahad\ Datu",
"607898", "Tenggara",
"609653", "Batu\ Rakit",
"6085756", "Marudi",
"609457", "Chini",
"6087224", "Beaufort",
"605661", "Ipoh",
"6085452", "Miri",
"6089515", "Beluran",
"6049373", "Kangar",
"604253", "Penang",
"6035167", "Kinrara",
"606318", "Melaka",
"6052320", "Ipoh",
"6088347", "Kota\ Kinabalu",
"6089280", "Elopura",
"606521", "Jasin",
"607910", "Tenang",
"6083461", "Debak",
"6085735", "Batu\ Niah",
"6087223", "Beaufort",
"606524", "Jasin",
"6086325", "Bintulu",
"609236", "Bilut\ Valley",
"609815", "Kerteh",
"6035122", "Kinrara",
"605296", "Tanjung\ Rambutan",
"609415", "Kuala\ Rompin",
"6085221", "Limbang",
"605664", "Sitiawan",
"608822", "Kota\ Kinabalu",
"6036101", "Genting",
"605769", "Lenggong",
"604610", "Penang",
"609538", "Kuantan",
"605598", "Chemor",
"6087483", "Labuan",
"609310", "Kuala\ Lipis",
"6033093", "Pulau\ Ketam",
"6082304", "Kota\ Samarahan",
"6089567", "Kinabatangan",
"6085481", "Bekenu",
"6088207", "Kota\ Kinabalu",
"605807", "Taiping",
"608848", "Kota\ Kinabalu",
"607780", "Kahang",
"607768", "Paloh",
"607599", "Senai",
"6035115", "Kinrara",
"6088928", "Papar",
"6089273", "Elopura",
"6084898", "Sibu",
"6034257", "Kuala\ Lumpur",
"6089676", "Elopura",
"6039050", "Cheras",
"6087311", "Keningau",
"605417", "Tapah",
"609300", "Mentakab",
"607928", "Aver\ Panas",
"605613", "Teluk\ Intan",
"6033317", "Kelang",
"6047455", "Alor\ Setar",
"607747", "Ayer\ Hitam",
"6037948", "Kuala\ Lumpur",
"606231", "Melaka",
"6086508", "Bintulu",
"6088412", "Kota\ Kinabalu",
"6035022", "Kinrara",
"6036123", "Kuala\ Lumpur",
"6032193", "Kuala\ Lumpur",
"6085758", "Marudi",
"606425", "Tampin",
"609405", "Pekan",
"607670", "Kulai",
"6089623", "Elopura",
"6087201", "Beaufort",
"606331", "Melaka",
"607665", "Kulai",
"6057180", "Parit\ Buntar",
"606334", "Melaka",
"6036421", "Rawang",
"605350", "Batu\ Gajah",
"6032087", "Kuala\ Lumpur",
"6088746", "Kinarut",
"6035879", "Kinrara",
"6036124", "Kuala\ Lumpur",
"6088973", "Kota\ Belud",
"6083321", "Bandar\ Sri\ Aman",
"6038213", "Putrajaya",
"6082868", "Kota\ Samarahan",
"609328", "Kuala\ Lipis",
"607900", "Tenggara",
"609242", "Bera",
"606234", "Melaka",
"605855", "Taiping",
"6036078", "Batu\ Arang",
"6036281", "Kuala\ Lumpur",
"604628", "Penang",
"6085295", "Lawas",
"6089859", "Kunak",
"6087341", "Keningau",
"6082321", "Kuching",
"6086391", "Bintulu",
"609228", "Bilut\ Valley",
"607923", "Bukit\ Kepong",
"605618", "Changkat\ Keruing",
"606492", "Kuala\ Klawang",
"604789", "Alor\ Setar",
"6033258", "Kelang",
"604684", "Penang",
"6038870", "Putrajaya",
"6037662", "Kuala\ Lumpur",
"609547", "Kuantan",
"6039025", "Kuala\ Lumpur",
"6087468", "Labuan",
"609782", "Bachok",
"609755", "Kota\ Bharu",
"6089790", "Merotai",
"6082502", "Kuching",
"6088552", "Telupid",
"609284", "Mentakab",
"608633", "Bintulu",
"6084235", "Sibu",
"6089660", "Elopura",
"6039012", "Cheras",
"606474", "Palong",
"6085613", "Miri",
"6084815", "Rejang",
"605441", "Trolak",
"6032037", "Kuala\ Lumpur",
"60962", "Kuala\ Brang",
"604919", "Alor\ Setar",
"6039191", "Kuala\ Lumpur",
"609912", "Gua\ Musang",
"6033179", "Kelang",
"606696", "Linggi",
"6085614", "Miri",
"6087505", "Labuan",
"609323", "Kuala\ Lipis",
"6082621", "Kuching",
"605841", "Taiping",
"6038962", "Cheras",
"606471", "Simpang\ Durian",
"607711", "Keluang",
"609281", "Kuala\ Krau",
"604623", "Penang",
"604427", "Kulim",
"6034271", "Kuala\ Lumpur",
"604827", "Penang",
"609223", "Bentong",
"607387", "Johor\ Bahru",
"606967", "Bakri",
"6089463", "Elopura",
"605631", "Kampong\ Gajah",
"6034020", "Kuala\ Lumpur",
"6087466", "Labuan",
"609476", "Maran",
"609707", "Kota\ Bharu",
"6084647", "Sarikei",
"606727", "Seremban",
"6099560", "Batu\ Gajah",
"604358", "Tasek\ Gelugor",
"6035887", "Kinrara",
"607340", "Johor\ Bahru",
"6033256", "Kelang",
"6038020", "Kinrara",
"604291", "Penang",
"6082271", "Kuching",
"6087861", "Bongawan",
"6035561", "Kinrara",
"6088653", "Kotamarudu",
"6094310", "Pekan",
"606560", "Simpang\ Empat",
"6089241", "Elopura",
"6083348", "Bandar\ Sri\ Aman",
"604462", "Jeniang",
"6088665", "Kotamarudu",
"609869", "Kemasik",
"607445", "Batu\ Pahat",
"607893", "Kota\ Tinggi",
"605620", "Telukintan",
"607240", "Johor\ Bahru",
"604258", "Penang",
"6088704", "Kota\ Kinabalu",
"607697", "Pontian",
"604391", "Penang",
"6037711", "Kuala\ Lumpur",
"605757", "Kuala\ Kangsar",
"6032721", "Kuala\ Lumpur",
"605545", "Ipoh",
"6035198", "Kinrara",
"6085785", "Marudi",
"6088703", "Kinarut",
"6039019", "Cheras",
"609279", "Mentakab",
"6082765", "Bau",
"607738", "Lavang\-Lavang",
"604997", "Kangar",
"6086350", "Bintulu",
"6087727", "Tenom",
"609266", "Jerantut",
"607302", "Johor\ Bahru",
"6089464", "Elopura",
"606489", "Kuala\ Klawang",
"605608", "Teluk\ Intan",
"6088617", "Kudat",
"6089436", "Kinabatangan",
"603337", "Kelang",
"609568", "Kuantan",
"609580", "Gebeng",
"607763", "Ayer\ Hitam",
"6037669", "Kuala\ Lumpur",
"606650", "Port\ Dickson",
"608843", "Kota\ Kinabalu",
"6089505", "Beluran",
"609829", "Paka",
"609214", "Bentong",
"6083344", "Bandar\ Sri\ Aman",
"609712", "Kota\ Bharu",
"607911", "Aver\ Panas",
"6036130", "Kuala\ Lumpur",
"6032022", "Kuala\ Lumpur",
"6036092", "Rawang",
"6098001", "Kerteh",
"607382", "Johor\ Bahru",
"604614", "Penang",
"6036141", "Kuala\ Lumpur",
"6089630", "Elopura",
"604719", "Sungai\ Petani",
"606962", "Bakri",
"605688", "Sitiawan",
"6088960", "Tenghilan",
"607450", "Senggarang",
"6087438", "Labuan",
"6033129", "Tk\ Panglima\ Garang",
"607784", "Kahang",
"607850", "Tiram",
"6082313", "Kuching",
"607255", "Johor\ Bahru",
"606531", "Jasin",
"607926", "Labis",
"607689", "Pontian",
"607781", "Paloh",
"606534", "Jasin",
"607217", "Johor\ Bahru",
"608432", "Sibu",
"609955", "Machang",
"608832", "Kota\ Kinabalu",
"6036261", "Kuala\ Lumpur",
"604626", "Penang",
"604989", "Kangar",
"6082314", "Kuching",
"6032385", "Kuala\ Lumpur",
"6087739", "Tenom",
"604549", "Tasek\ Gelugor",
"6083343", "Bandar\ Sri\ Aman",
"6085616", "Miri",
"604611", "Penang",
"6082888", "Serian",
"606497", "Rembau",
"605675", "Changkat\ Keruing",
"6084872", "Mukah",
"6086485", "Belaga",
"6084307", "Sibu",
"606693", "Rantau",
"609787", "Machang",
"6089611", "Elopura",
"607914", "Tenang",
"6088307", "Kota\ Kinabalu",
"606645", "Port\ Dickson",
"609542", "Sungai\ Lembing",
"6033385", "Kelang",
"60741", "Parit\ Sulong",
"6034820", "Kuala\ Lumpur",
"6039075", "Cheras",
"6038990", "Cheras",
"6033145", "Banting",
"6037971", "Kuala\ Lumpur",
"6087211", "Beaufort",
"605354", "Ipoh",
"606316", "Durian\ Tunggal",
"6087777", "Tambunan",
"604797", "Ayer\ Hitam",
"606330", "Melaka",
"6035540", "Kinrara",
"6082550", "Kuching",
"604377", "Penang",
"6033217", "Sabak\ Bernam",
"607938", "Tenang",
"607896", "Tenggara",
"607904", "Tenang",
"6088402", "Kota\ Kinabalu",
"6084879", "Dalat",
"60447", "Baling",
"606221", "Melaka",
"6039175", "Kuala\ Lumpur",
"6087831", "Menumbok",
"6032771", "Kuala\ Lumpur",
"609873", "Cheneh",
"605752", "Kuala\ Kangsar",
"606383", "Tangga\ Batu",
"605254", "Ipoh",
"607207", "Johor\ Bahru",
"6089965", "Lahad\ Datu",
"606230", "Melaka",
"606435", "Tampin",
"6089727", "Tawau",
"609473", "Bukit\ Ibam",
"6087464", "Labuan",
"6087436", "Labuan",
"609301", "Jerantut",
"60668", "Rembau",
"6033167", "Kelang",
"6087301", "Keningau",
"6034295", "Kuala\ Lumpur",
"6085461", "Miri",
"604467", "Jeniang",
"6089954", "Balung",
"607766", "Mersing",
"6033265", "Kuala\ Selangor",
"6039232", "Kuala\ Lumpur",
"6033122", "Tk\ Panglima\ Garang",
"6087463", "Labuan",
"6032247", "Kuala\ Lumpur",
"6037875", "Kuala\ Lumpur",
"6089466", "Elopura",
"6038084", "Kinrara",
"6032115", "Kuala\ Lumpur",
"607299", "Johor\ Bahru",
"609263", "Damak",
"606224", "Melaka",
"6087230", "Beaufort",
"6082735", "Lundu",
"609204", "Jerantut",
"609536", "Kuantan",
"6036192", "Kuala\ Lumpur",
"605596", "Chemor",
"6085395", "Miri",
"6032265", "Kuala\ Lumpur",
"6082886", "Serian",
"6038070", "Kinrara",
"6087810", "Sipitang",
"6085618", "Miri",
"605351", "Batu\ Gajah",
"6088656", "Kotamarudu",
"6082221", "Kuching",
"6086291", "Bintulu",
"6089861", "Lahad\ Datu",
"604709", "Alor\ Setar",
"6036099", "Rawang",
"609363", "Fraser\ Hill",
"607674", "Pontian",
"609238", "Karak",
"6084805", "Kuala\ Igan",
"6033358", "Kelang",
"604925", "Ayer\ Hitam",
"604558", "Tasek\ Gelugor",
"6087881", "Kuala\ Penyu",
"6083410", "Kabong",
"6082863", "Kota\ Samarahan",
"6087226", "Beaufort",
"6038989", "Cheras",
"606465", "Ayer\ Hitam",
"607980", "Bakri",
"604356", "Tasek\ Gelugor",
"6038308", "Putrajaya",
"6084894", "Stapang",
"607968", "Gemas",
"606388", "Kuala\ Sungai\ Baru",
"6036073", "Kuala\ Kubu\ Baru",
"6087782", "Tambunan",
"6089276", "Elopura",
"6038657", "Cheras",
"6087486", "Labuan",
"608827", "Kota\ Kinabalu",
"6085717", "Bekenu",
"609478", "Maran",
"603894", "Cheras",
"604594", "Parit\ Buntar",
"609566", "Kuantan",
"6038707", "Mantin",
"6084893", "Selangau",
"604680", "Penang",
"604668", "Penang",
"6033198", "Banting",
"604859", "Penang",
"6089537", "Elopura",
"609452", "Bukit\ Ibam",
"609485", "Jengka\ Lapan\ Belas",
"609268", "Damak",
"609280", "Lanchang",
"6087852", "Menumbok",
"609852", "Chukai",
"6082542", "Sejingkat",
"6088356", "Kota\ Kinabalu",
"6082306", "Kuching",
"604572", "Tasek\ Gelugor",
"6085604", "Miri",
"6035721", "Kinrara",
"607710", "Keluang",
"605245", "Ipoh",
"605840", "Taiping",
"6036128", "Kuala\ Lumpur",
"6082864", "Kota\ Samarahan",
"605440", "Tapah",
"605293", "Tanjung\ Rambutan",
"609233", "Genting",
"609368", "Raub",
"606275", "Melaka",
"609380", "Jerantut",
"6039520", "Kuala\ Lumpur",
"6085765", "Marudi",
"6087228", "Beaufort",
"605621", "Telukintan",
"6088976", "Kota\ Belud",
"6083549", "Pantu",
"6038216", "Kuala\ Lumpur",
"607241", "Johor\ Bahru",
"607512", "Senai",
"6036028", "Batu\ Arang",
"604390", "Penang",
"606737", "Mantin",
"609944", "Ayer\ Lanas",
"605683", "Sitiawan",
"605487", "Cameron\ Highland",
"6088743", "Kinarut",
"6082549", "Kuching",
"6082707", "Kota\ Samarahan",
"604290", "Penang",
"6038951", "Cheras",
"605616", "Bruas",
"606654", "Port\ Dickson",
"6089674", "Elopura",
"606759", "Mantin",
"609247", "Bera",
"609584", "Gebeng",
"6089278", "Elopura",
"609581", "Gebeng",
"606651", "Port\ Dickson",
"6082308", "Kuching",
"6089673", "Elopura",
"6088607", "Kudat",
"606698", "Linggi",
"605412", "Trolak",
"6083308", "Bandar\ Sri\ Aman",
"6089201", "Elopura",
"6035653", "Kinrara",
"6032685", "Kuala\ Lumpur",
"6038525", "Mantin",
"607587", "Senai",
"6039102", "Cheras",
"607742", "Lavang\-Lavang",
"6085206", "Kampung\ Pahlawan",
"6088744", "Kinarut",
"6085621", "Miri",
"605812", "Taiping",
"6037651", "Kuala\ Lumpur",
"607244", "Johor\ Bahru",
"608258", "Kuching",
"604765", "Alor\ Setar",
"608862", "Kudat",
"6036126", "Kuala\ Lumpur",
"605624", "Hutan\ Melintang",
"6089512", "Beluran",
"6036057", "Kuala\ Kubu\ Baru",
"6085455", "Miri",
"6033109", "Pulau\ Ketam",
"605369", "Pusing",
"607268", "Johor\ Bahru",
"607885", "Kota\ Tinggi",
"6085463", "Miri",
"607485", "Batu\ Pahat",
"6087304", "Keningau",
"6086469", "Belaga",
"6087461", "Labuan",
"6087214", "Beaufort",
"6032780", "Kuala\ Lumpur",
"604820", "Penang",
"6089982", "Tawau",
"6084362", "Sibu",
"604956", "Kuah",
"6085299", "Lawas",
"607380", "Johor\ Bahru",
"6085241", "Kampung\ Pahlawan",
"6032109", "Kuala\ Lumpur",
"606960", "Bukit\ Gambir",
"608824", "Kota\ Kinabalu",
"606988", "Bakri",
"605376", "Bota",
"6089855", "Kunak",
"605796", "Grik",
"609710", "Kota\ Bharu",
"6088362", "Kota\ Kinabalu",
"606522", "Jasin",
"6086293", "Bintulu",
"6089863", "Lahad\ Datu",
"6082223", "Kuching",
"6035566", "Kinrara",
"6038052", "Kinrara",
"6089246", "Elopura",
"607656", "Kulai",
"605479", "Tapah",
"6087213", "Beaufort",
"608421", "Sibu",
"609540", "Kuantan",
"6033282", "Kuala\ Selangor",
"6034800", "Kuala\ Lumpur",
"6087833", "Menumbok",
"6038800", "Putrajaya\/Cyberjaya",
"6082628", "Kuching",
"604597", "Parit\ Buntar",
"608821", "Kota\ Kinabalu",
"6036044", "Kampong\ Suharto",
"6032726", "Kuala\ Lumpur",
"606975", "Muar",
"6082224", "Kuching",
"6089864", "Lahad\ Datu",
"6086294", "Bintulu",
"6082537", "Kuching",
"604408", "Kulim",
"608235", "Kuching",
"6034278", "Kuala\ Lumpur",
"6032773", "Kuala\ Lumpur",
"6089951", "Balung",
"6087303", "Keningau",
"6033850", "Banting",
"6086322", "Bintulu",
"604434", "Padang\ Serai",
"6035125", "Kinrara",
"609980", "Kuala\ Krai",
"6083470", "Betong",
"605466", "Kampar",
"6038081", "Kinrara",
"6085739", "Batu\ Niah",
"604418", "Mahang",
"6089591", "Telupid",
"607523", "Senai",
"603216", "Kuala\ Lumpur",
"6085790", "Miri",
"6082278", "Kuching",
"6088415", "Kota\ Kinabalu",
"6084773", "Song",
"609947", "Ayer\ Lanas",
"604818", "Penang",
"605750", "Kuala\ Kangsar",
"6036263", "Kuala\ Lumpur",
"606232", "Melaka",
"609244", "Triang",
"6084850", "Dalat",
"6047452", "Alor\ Setar",
"6035568", "Kinrara",
"6085660", "Miri",
"6083341", "Bandar\ Sri\ Aman",
"6089248", "Elopura",
"609587", "Gebeng",
"6036144", "Kuala\ Lumpur",
"6037718", "Kuala\ Lumpur",
"606332", "Melaka",
"6033289", "Kuala\ Selangor",
"6089613", "Elopura",
"6088850", "Ranau",
"6082626", "Kuching",
"6088369", "Kota\ Kinabalu",
"6035191", "Kinrara",
"6036411", "Kuala\ Lumpur",
"6088780", "Kota\ Kinabalu",
"606615", "Kuala\ Klawang",
"607944", "Segamat",
"609700", "Kota\ Bharu",
"6036143", "Kuala\ Lumpur",
"606720", "Seremban",
"6084780", "Kapit",
"6089614", "Elopura",
"6036157", "Kuala\ Lumpur",
"605881", "Selama",
"6086462", "Bakun",
"605423", "Tapah",
"6082311", "Kuching",
"6089519", "Beluran",
"605481", "Tanjung\ Malim",
"608991", "Tawau",
"6033102", "Pulau\ Ketam",
"6033362", "Kelang",
"6084812", "Stapang",
"607528", "Kangkar\ Pulai",
"606491", "Simpang\ Durian",
"6034131", "Kuala\ Lumpur",
"604413", "Sungai\ Petani",
"6082380", "Kuching",
"607226", "Johor\ Bahru",
"6087316", "Keningau",
"6038328", "Putrajaya",
"605646", "Bagan\ Datoh",
"6084232", "Sibu",
"609217", "Mentakab",
"6089671", "Elopura",
"609781", "Machang",
"604565", "Kepala\ Batas",
"6035651", "Kinrara",
"6082699", "Kuching",
"607211", "Johor\ Bahru",
"605529", "Ipoh",
"6033290", "Kelang",
"60472", "Alor\ Setar",
"6089203", "Elopura",
"605205", "Ipoh",
"6082505", "Kuching",
"609914", "Gua\ Musang",
"607787", "Keluang",
"606458", "Serting",
"6084555", "Sibu",
"6038861", "Putrajaya",
"604886", "Penang",
"6037665", "Kuala\ Lumpur",
"6089204", "Elopura",
"607429", "Senggarang",
"609355", "Raub",
"6084799", "Kapit",
"6083326", "Bandar\ Sri\ Aman",
"6083468", "Sebuyau",
"6088536", "Kota\ Kinabalu",
"6034260", "Kuala\ Lumpur",
"607500", "Tanjung\ Kupang",
"6088741", "Kinarut",
"606537", "Jasin",
"6088799", "Tuaran",
"604570", "Tasek\ Gelugor",
"6084730", "Julau",
"606472", "Kuala\ Klawang",
"6036108", "Genting",
"609850", "Chukai",
"609255", "Triang",
"6087502", "Labuan",
"6089295", "Elopura",
"609282", "Lanchang",
"606906", "Muar",
"6038953", "Cheras",
"607917", "Tenang",
"609784", "Pasirputih",
"6082593", "Kuching",
"6082326", "Kuching",
"6088669", "Kota\ Marudu",
"6038727", "Semenyih",
"603795", "Kuala\ Lumpur",
"604289", "Penang",
"606494", "Kuala\ Klawang",
"6036286", "Kuala\ Lumpur",
"609450", "Bukit\ Ibam",
"6087318", "Keningau",
"607907", "Labis",
"605632", "Kampong\ Gajah",
"6039771", "Kuala\ Lumpur",
"6084662", "Sarikei",
"6088903", "Papar",
"60545", "Tanjung\ Malim",
"6084891", "Selangau",
"6039145", "Kuala\ Lumpur",
"6087509", "Labuan",
"604699", "Alor\ Setar",
"609766", "Bachok",
"6088662", "Kota\ Marudu",
"604292", "Penang",
"604794", "Ayer\ Hitam",
"6037941", "Kuala\ Lumpur",
"607304", "Johor\ Bahru",
"605357", "Ipoh",
"606983", "Bakri",
"6087765", "Tambunan",
"6082260", "Kuching",
"6088792", "Tuaran",
"609779", "Bachok",
"607363", "Johor\ Bahru",
"6032730", "Kuala\ Lumpur",
"604461", "Bedong",
"607510", "Senai",
"6085280", "Lawas",
"6087208", "Beaufort",
"6087884", "Kuala\ Penyu",
"608875", "Kinarut",
"604392", "Penang",
"607740", "Kahang",
"6089735", "Semporna",
"605836", "Selama",
"6038699", "Semenyih",
"604758", "Alor\ Setar",
"605810", "Taiping",
"6085601", "Miri",
"605410", "Tapah",
"605436", "Tapah",
"604464", "Jeniang",
"6083466", "Debak",
"6087883", "Kuala\ Penyu",
"6088538", "Kota\ Kinabalu",
"6058710", "Semanggol",
"6033277", "Kuala\ Selangor",
"6084239", "Sibu",
"604371", "Penang",
"607301", "Johor\ Bahru",
"604607", "Penang",
"6082762", "Bau",
"60755", "Senai",
"6034031", "Kuala\ Lumpur",
"607677", "Pontian",
"6088904", "Papar",
"604403", "Kulim",
"606227", "Melaka",
"6038769", "Semenyih",
"6082328", "Serian",
"6086285", "Bintulu",
"609960", "Kuala\ Krai",
"605486", "Cameron\ Highland",
"6034252", "Kuala\ Lumpur",
"603214", "Kuala\ Lumpur",
"6089569", "Kinabatangan",
"6088966", "Kota\ Belud",
"6032202", "Kuala\ Lumpur",
"6036243", "Kuala\ Lumpur",
"606736", "Mantin",
"608838", "Kota\ Kinabalu",
"604400", "Padang\ Serai",
"609246", "Bera",
"6038998", "Cheras",
"6082495", "Kuching",
"605413", "Cameron\ Highland",
"6089664", "Elopura",
"607795", "Felda\ Tenggaroh",
"6033051", "Kelang",
"605617", "Telukintan",
"604305", "Penang",
"6035548", "Kinrara",
"6087848", "Sipitang",
"6082828", "Asajaya",
"6038600", "Kinrara",
"609548", "Gambang",
"6033325", "Kelang",
"6036461", "Kerling",
"607743", "Keluang",
"6089705", "Tawau",
"6036136", "Kuala\ Lumpur",
"6085631", "Miri",
"6032082", "Kuala\ Lumpur",
"6088349", "Kota\ Kinabalu",
"6089663", "Elopura",
"607513", "Tanjung\ Kupang",
"609718", "Kota\ Bharu",
"6036038", "Kuala\ Lumpur",
"606980", "Bukit\ Gambir",
"605289", "Pusing",
"606968", "Pagoh",
"6087818", "Sipitang",
"6085610", "Miri",
"605655", "Kampong\ Gajah",
"605682", "Changkat\ Keruing",
"6036303", "Genting",
"607388", "Johor\ Bahru",
"607360", "Johor\ Bahru",
"6089902", "Merotai",
"604828", "Penang",
"6038750", "Semenyih",
"6084391", "Sibu",
"6033082", "Kelang",
"607586", "Senai",
"6082403", "Kuching",
"606540", "Durian\ Tunggal",
"6038873", "Putrajaya",
"609849", "Dungun",
"607288", "Johor\ Bahru",
"607865", "Tiram",
"605389", "Bota",
"609975", "Machang",
"6033342", "Kelang",
"6033182", "Banting",
"6088968", "Kota\ Belud",
"605461", "Tapah",
"6034024", "Kuala\ Lumpur",
"6033349", "Kelang",
"609453", "Bukit\ Ibam",
"609853", "Chukai",
"6035485", "Kinrara",
"6038024", "Kinrara",
"6086449", "Pelagus",
"6087441", "Labuan",
"60445", "Bedong",
"6032182", "Kuala\ Lumpur",
"6089814", "Tungku",
"603873", "Semenyih",
"604573", "Tasek\ Gelugor",
"606728", "Seremban",
"6032391", "Kuala\ Lumpur",
"609708", "Kota\ Bharu",
"6036138", "Kuala\ Lumpur",
"608826", "Kota\ Kinabalu",
"6035162", "Kinrara",
"605699", "Sitiawan",
"6036063", "Kuala\ Kubu\ Baru",
"609232", "Karak",
"6038996", "Cheras",
"605292", "Tanjung\ Rambutan",
"6035740", "Kinrara",
"609639", "Kuala\ Brang",
"605794", "Grik",
"6082750", "Kota\ Samarahan",
"6037733", "Kuala\ Lumpur",
"6088342", "Kota\ Kinabalu",
"6032089", "Kuala\ Lumpur",
"6082281", "Kuching",
"6036055", "Kuala\ Kubu\ Baru",
"607651", "Layang\-Layang",
"6089843", "Kunak",
"6082826", "Asajaya",
"6038076", "Kinrara",
"607654", "Linggiu",
"607759", "Ayer\ Hitam",
"605403", "Tapah",
"6078010", "Mersing",
"605791", "Grik",
"603263", "Kuala\ Lumpur",
"604951", "Kuah",
"609567", "Kuantan",
"6037734", "Kuala\ Lumpur",
"6036064", "Kuala\ Kubu\ Baru",
"6036036", "Batuarang",
"6034023", "Kuala\ Lumpur",
"607561", "Senai",
"605758", "Kuala\ Kangsar",
"604810", "Penang",
"6033319", "Kelang",
"606512", "Jasin",
"6034101", "Kuala\ Lumpur",
"604410", "Kulim",
"6089562", "Kinabatangan",
"6038023", "Kinrara",
"6034259", "Kuala\ Lumpur",
"605225", "Ipoh",
"605820", "Taiping",
"609458", "Bukit\ Ibam",
"604269", "Penang",
"6087480", "Labuan",
"607897", "Tiram",
"6084642", "Sarikei",
"6039222", "Kuala\ Lumpur",
"60777", "Keluang",
"6084869", "Kuala\ Igan",
"6033132", "Tk\ Panglima\ Garang",
"6082712", "Semantan",
"604376", "Penang",
"609764", "Bachok",
"606317", "Melaka",
"609669", "Batu\ Rakit",
"6035882", "Kinrara",
"609858", "Chukai",
"604369", "Serdang",
"6036188", "Kuala\ Lumpur",
"609703", "Kota\ Bharu",
"605431", "Besout",
"6036020", "Batu\ Arang",
"6033177", "Kelang",
"607508", "Tanjung\ Kupang",
"606781", "Sepang",
"605831", "Selama",
"6032039", "Kuala\ Lumpur",
"609362", "Fraser\ Hill",
"609559", "Kuantan",
"6038892", "Putrajaya",
"6037865", "Kuala\ Lumpur",
"6038661", "Mantin",
"6083300", "Bandar\ Sri\ Aman",
"604866", "Penang",
"606850", "Mantin",
"607531", "Senai",
"605834", "Taiping",
"6082830", "Sebangan",
"607767", "Mersing",
"6049370", "Kangar",
"605434", "Tapah",
"608847", "Kota\ Kinabalu",
"605808", "Taiping",
"6085471", "Miri",
"604466", "Bedong",
"604552", "Tasek\ Gelugor",
"6082899", "Serian",
"6035521", "Kinrara",
"6087821", "Sipitang",
"6033275", "Batang\ Berjuntai",
"6088612", "Kudat",
"6089871", "Tungku",
"607409", "Parit\ Sulong",
"605753", "Kuala\ Kangsar",
"609872", "Cheneh",
"604945", "Kangar",
"6088350", "Kota\ Kinabalu",
"6082300", "Kuching",
"6084350", "Sibu",
"6083585", "Lubukantu",
"6038749", "Semenyih",
"6032275", "Kuala\ Lumpur",
"6037770", "Kuala\ Lumpur",
"607520", "Senai",
"605597", "Chemor",
"6084612", "Rejang",
"6039054", "Cheras",
"608433", "Sibu",
"607224", "Johor\ Bahru",
"6082507", "Kuching",
"605644", "Hutan\ Melintang",
"6085331", "Miri",
"607722", "Renggam",
"6085406", "Miri",
"6087729", "Tenom",
"6082791", "Tebedu",
"606901", "Muar",
"6087803", "Sipitang",
"6082661", "Kota\ Samarahan",
"605535", "Tanjung\ Rambutan",
"609595", "Gebeng",
"607927", "Tenang",
"605418", "Tapah",
"6083418", "Bandar\ Sri\ Aman",
"6036186", "Kuala\ Lumpur",
"604884", "Penang",
"6088970", "Kota\ Belud",
"607748", "Keluang",
"6038210", "Semenyih",
"609543", "Sungai\ Lembing",
"604627", "Penang",
"609713", "Kota\ Bharu",
"6038725", "Semenyih",
"6085200", "Limbang",
"607518", "Senai",
"604881", "Penang",
"6036120", "Kuala\ Lumpur",
"6032032", "Kuala\ Lumpur",
"6034811", "Kuala\ Lumpur",
"606963", "Tangkak",
"6088513", "Kota\ Kinabalu",
"607216", "Johor\ Bahru",
"609786", "Pasirputih",
"6035889", "Kinrara",
"605641", "Hutan\ Melintang",
"6033190", "Banting",
"6086581", "Tatau",
"60942", "Pekan",
"607221", "Johor\ Bahru",
"6086256", "Bintulu",
"6084691", "Bintangor",
"606496", "Kuala\ Klawang",
"607283", "Johor\ Bahru",
"609327", "Padang\ Tengku",
"6085310", "Limbang",
"6039544", "Cheras",
"6034297", "Kuala\ Lumpur",
"6039132", "Kuala\ Lumpur",
"6085264", "Sundar",
"6033165", "Kelang",
"605356", "Ipoh",
"6089725", "Tawau",
"6085668", "Miri",
"609767", "Bachok",
"6094311", "Pekan",
"6089240", "Elopura",
"605591", "Lintang",
"6082284", "Kuching",
"607894", "Kota\ Tinggi",
"609531", "Kuantan",
"6089967", "Lahad\ Datu",
"607906", "Segamat",
"6032786", "Kuala\ Lumpur",
"6037710", "Kuala\ Lumpur",
"6083338", "Bandar\ Sri\ Aman",
"6088858", "Ranau",
"6082808", "Simunjan",
"6082688", "Kuching",
"6084229", "Sibu",
"6032222", "Kuala\ Lumpur",
"609520", "Kuantan",
"604969", "Kuah",
"604402", "Kulim",
"605256", "Ipoh",
"6034021", "Kuala\ Lumpur",
"606429", "Bahau",
"6038021", "Kinrara",
"6034103", "Kuala\ Lumpur",
"6082270", "Kuching",
"6087775", "Tambunan",
"6089712", "Tawau",
"603625", "Kuala\ Lumpur",
"607761", "Ayer\ Hitam",
"607262", "Johor\ Bahru",
"6033393", "Kelang",
"605633", "Kampong\ Gajah",
"608844", "Kota\ Kinabalu",
"605437", "Tapah",
"607764", "Felda\ Tenggaroh",
"6033856", "Sabak\ Bernam",
"6082871", "Baki",
"6037832", "Kuala\ Lumpur",
"6087443", "Labuan",
"6034104", "Kuala\ Lumpur",
"6032267", "Kuala\ Lumpur",
"606542", "Durian\ Tunggal",
"605837", "Selama",
"6082737", "Lundu",
"604293", "Penang",
"6038686", "Putrajaya",
"606226", "Melaka",
"605680", "Sitiawan",
"6038779", "Mantin",
"6085263", "Sundar",
"6032856", "Kuala\ Lumpur",
"605668", "Sitiawan",
"605859", "Taiping",
"6089922", "Tawau",
"6032393", "Kuala\ Lumpur",
"607362", "Johor\ Bharu",
"6032117", "Kuala\ Lumpur",
"6039543", "Cheras",
"6088788", "Tuaran",
"609534", "Kuantan",
"607891", "Kota\ Tinggi",
"605594", "Chemor",
"6032720", "Kuala\ Lumpur",
"6037877", "Kuala\ Lumpur",
"6032245", "Kuala\ Lumpur",
"606311", "Melaka",
"609508", "Teruntum",
"6084788", "Kapit",
"6082283", "Kuching",
"6086351", "Bintulu",
"60929", "Mentakab",
"6036739", "Kuala\ Kubu\ Baru",
"6037731", "Kuala\ Lumpur",
"6039514", "Kuala\ Lumpur",
"6036061", "Kuala\ Kubu\ Baru",
"605290", "Tanjung\ Rambutan",
"605443", "Tapah",
"605895", "Taiping",
"609835", "Dungun",
"6032788", "Kuala\ Lumpur",
"607227", "Johor\ Bahru",
"6088393", "Kota\ Kinabalu",
"6038095", "Kinrara",
"6082686", "Kuching",
"609321", "Kuala\ Lipis",
"6084393", "Sibu",
"606473", "Kemavan",
"6085238", "Limbang",
"6085666", "Limbang",
"604616", "Penang",
"60655", "Durian\ Tunggal",
"6036436", "Genting",
"608634", "Bintulu",
"6088940", "Kota\ Belud",
"6038871", "Putrajaya",
"6037890", "Kuala\ Lumpur",
"60438", "Penang",
"60782", "Penggerang",
"6082401", "Kuching",
"6088451", "Kinarut",
"604621", "Penang",
"6036211", "Kuala\ Lumpur",
"6085492", "Bekenu",
"6089749", "Tawau",
"6088931", "Kota\ Belud",
"609221", "Bentong",
"604683", "Penang",
"6037839", "Kuala\ Lumpur",
"607786", "Felda\ Kahang\ Timur",
"604487", "Sungai\ Bakap",
"607924", "Labis",
"607921", "Labis",
"606536", "Jasin",
"6034270", "Kuala\ Lumpur",
"604412", "Penang",
"609819", "Paka",
"609224", "Bentong",
"609419", "Kuala\ Rompin",
"6084305", "Sibu",
"6036241", "Kuala\ Lumpur",
"605765", "Lenggong",
"6084222", "Sibu",
"6032387", "Kuala\ Lumpur",
"608631", "Bintulu",
"609324", "Kuala\ Lipis",
"608978", "Semporna",
"6088394", "Kota\ Kinabalu",
"607930", "Labis",
"6085633", "Miri",
"607916", "Bekok",
"6082620", "Kuching",
"6032858", "Kuala\ Lumpur",
"6084394", "Sibu",
"606907", "Muar",
"6038688", "Putrajaya",
"6039139", "Kuala\ Lumpur",
"607595", "Senai",
"6088786", "Tuaran",
"6083569", "Engkilili",
"6084755", "Kanowit",
"6036273", "Kuala\ Lumpur",
"6082664", "Kota\ Samarahan",
"605448", "Tanjung\ Malim",
"609946", "Ayer\ Lanas",
"6088511", "Kota\ Kinabalu",
"605848", "Taiping",
"6085288", "Lawas",
"603217", "Kuala\ Lumpur",
"6034813", "Kuala\ Lumpur",
"609288", "Bukit\ Tinggi",
"6039051", "Cheras",
"609865", "Kemasik",
"609260", "Jerantut",
"6035622", "Kinrara",
"605614", "Sitiawan",
"606656", "Port\ Dickson",
"6032296", "Kuala\ Lumpur",
"604660", "Penang",
"605719", "Parit\ Buntar",
"604688", "Penang",
"6084693", "Bintangor",
"609586", "Gebeng",
"6088981", "Tenghilan",
"6039202", "Kuala\ Lumpur",
"6038787", "Mantin",
"6086584", "Tatau",
"609470", "Bukit\ Ibam",
"6087406", "Labuan",
"607522", "Senai",
"605549", "Ipoh",
"6036280", "Kuala\ Lumpur",
"6032687", "Kuala\ Lumpur",
"6038527", "Mantin",
"6082793", "Tebedu",
"6087340", "Keningau",
"6082320", "Semantan",
"6035035", "Kinrara",
"607960", "Gemas",
"606233", "Melaka",
"6086390", "Bintulu",
"6084694", "Bintangor",
"6088885", "Ranau",
"6034266", "Kuala\ Lumpur",
"6088605", "Kudat",
"603784", "Kuala\ Lumpur",
"6047210", "Sungai\ Petani",
"6084736", "Julau",
"6082663", "Kota\ Samarahan",
"6036274", "Kuala\ Lumpur",
"6087801", "Sipitang",
"6036420", "Rawang",
"6039082", "Cheras",
"6083320", "Bandar\ Sri\ Aman",
"606333", "Melaka",
"605626", "Telukintan",
"606852", "Melaka",
"604254", "Penang",
"6085286", "Lawas",
"6077690", "Paloh",
"6038655", "Cheras",
"6032605", "Kuala\ Lumpur",
"6035523", "Kinrara",
"6087823", "Sipitang",
"6052321", "Ipoh",
"6089281", "Elopura",
"6082843", "Damai\ Beach",
"609759", "Pasirputih",
"6032298", "Kuala\ Lumpur",
"607720", "Mersing",
"6033885", "Kelang",
"60644", "Tampin",
"6038320", "Putrajaya",
"6082388", "Kuching",
"6084687", "Sarikei",
"6084807", "Sibu",
"609561", "Kuantan",
"6037882", "Kuala\ Lumpur",
"6085767", "Marudi",
"604915", "Changlon",
"60450", "Tasek\ Gelugor",
"607657", "Kulai",
"604298", "Penang",
"6035629", "Kinrara",
"604351", "Kepala\ Batas",
"6087408", "Labuan",
"609651", "Batu\ Rakit",
"605467", "Kampar",
"6083460", "Sebuyau",
"607734", "Ayer\ Hitam",
"607708", "Keluang",
"6083562", "Roban",
"6082844", "Damai\ Beach",
"6089535", "Elopura",
"604398", "Penang",
"6036789", "Genting",
"6035524", "Kinrara",
"604778", "Pokok\ Sena",
"6085220", "Limbang",
"6038705", "Mantin",
"6084738", "Julau",
"606523", "Jasin",
"60536", "Batu\ Gajah",
"6036100", "Genting",
"6085474", "Miri",
"604251", "Penang",
"603207", "Kuala\ Lumpur",
"606682", "Seremban",
"606655", "Port\ Dickson",
"609466", "Maran",
"608243", "Sejingkat",
"6084695", "Bintangor",
"6065110", "Jasin",
"6084870", "Mukah",
"609585", "Gebeng",
"609552", "Kuantan",
"6082829", "Asajaya",
"6035591", "Kinrara",
"604559", "Tasek\ Gelugor",
"6035549", "Kinrara",
"6088747", "Kinarut",
"609866", "Kemasik",
"6088695", "Kudat",
"6038999", "Cheras",
"604906", "Changlon",
"607969", "Bukit\ Gambir",
"6086300", "Bintulu",
"6035613", "Kinrara",
"6033346", "Kelang",
"6034815", "Kuala\ Lumpur",
"604537", "Tasek\ Gelugor",
"6084753", "Kanowit",
"6089568", "Kinabatangan",
"605540", "Ipoh",
"6037611", "Kuala\ Lumpur",
"6036275", "Kuala\ Lumpur",
"609479", "Maran",
"6084765", "Kanowit",
"609945", "Ayer\ Lanas",
"6033086", "Kelang",
"6035614", "Kinrara",
"6036177", "Kuala\ Lumpur",
"605710", "Parit\ Buntar",
"604669", "Penang",
"6088962", "Papar",
"604262", "Penang",
"605625", "Telukintan",
"604764", "Alor\ Setar",
"606486", "Simpang\ Durian",
"6082665", "Kota\ Samarahan",
"609662", "Kuala\ Brang",
"607440", "Batu\ Pahat",
"6034256", "Kuala\ Lumpur",
"609269", "Damak",
"6089677", "Elopura",
"6084754", "Kanowit",
"604891", "Penang",
"6038911", "Semenyih",
"6036090", "Rawang",
"6035033", "Kinrara",
"60769", "Air\ Baloi",
"6032020", "Kuala\ Lumpur",
"609276", "Mentakab",
"6038079", "Kinrara",
"6054620", "Kampar",
"606617", "Kuala\ Klawang",
"604703", "Bedong",
"6036039", "Kuala\ Lumpur",
"609369", "Dong",
"6089632", "Elopura",
"6086231", "Bintulu",
"6084717", "Pakan",
"6088348", "Kota\ Kinabalu",
"6036032", "Rawang",
"609481", "Kota\ Gelangi",
"6032088", "Kuala\ Lumpur",
"604227", "Penang",
"6087232", "Beaufort",
"609823", "Al\ Muktafi\ Billa\ H\ Shah",
"6036139", "Kuala\ Lumpur",
"6082867", "Kota\ Samarahan",
"609423", "Chini",
"6087812", "Sipitang",
"606791", "Seremban",
"6089566", "Kinabatangan",
"6088206", "Kota\ Kinabalu",
"6085475", "Miri",
"6085744", "Beluru",
"605241", "Ipoh",
"6033120", "Tk\ Panglima\ Garang",
"6082581", "Kota\ Samarahan",
"6033271", "Batang\ Berjuntai",
"607887", "Kota\ Tinggi",
"6035525", "Kinrara",
"6082845", "Damai\ Beach",
"606464", "Ladang\ Geddes",
"6089534", "Elopura",
"6037861", "Kuala\ Lumpur",
"607683", "Pontian",
"6032603", "Kuala\ Lumpur",
"604924", "Changlon",
"606758", "Mantin",
"6033348", "Kelang",
"60442", "Sungai\ Petani",
"6088969", "Kota\ Belud",
"6034258", "Kuala\ Lumpur",
"6087730", "Tenom",
"6038703", "Mantin",
"607412", "Batu\ Pahat",
"6084897", "Stapang",
"6085743", "Beluru",
"608237", "Kuching",
"606274", "Melaka",
"6089533", "Elopura",
"6037260", "Kuala\ Lumpur",
"6033318", "Kelang",
"604921", "Kangar",
"6032604", "Kuala\ Lumpur",
"606461", "Ladanggeddes",
"6037947", "Kuala\ Lumpur",
"6083450", "Saratok",
"6086507", "Bintulu",
"605244", "Ipoh",
"6035542", "Kinrara",
"606292", "Melaka",
"606699", "Linggi",
"6082552", "Kuching",
"609750", "Kota\ Bharu",
"6082822", "Asajaya",
"606794", "Mantin",
"6038992", "Cheras",
"6035166", "Kinrara",
"6088346", "Kota\ Kinabalu",
"604595", "Parit\ Buntar",
"6033884", "Kelang",
"605728", "Parit\ Buntar",
"604916", "Alor\ Setar",
"604930", "Alor\ Setar",
"608685", "Bintulu",
"606977", "Tangkak",
"606434", "Jelai",
"609828", "Paka",
"6089570", "Kinabatangan",
"6039274", "Kuala\ Lumpur",
"6033213", "Hutan\ Melintang",
"608532", "Miri",
"6087773", "Tambunan",
"6034105", "Kuala\ Lumpur",
"6032303", "Kuala\ Lumpur",
"605689", "Sitiawan",
"6085771", "Long\ Lama",
"608877", "Kinarut",
"605282", "Ipoh",
"605255", "Ipoh",
"6036189", "Kuala\ Lumpur",
"605850", "Sungai\ Nyior",
"609842", "Dungun",
"604449", "Baling",
"6082531", "Kuching",
"6087726", "Tenom",
"6093261", "Padang\ Tengku",
"6087850", "Kuala\ Penyu",
"6088616", "Kudat",
"607688", "Pontian",
"6033163", "Kelang",
"607660", "Kulai",
"604522", "Tasek\ Gelugor",
"6035886", "Kinrara",
"607675", "Pontian",
"6083425", "Roban",
"6082716", "Semantan",
"6082285", "Kuching",
"606420", "Johol",
"6039226", "Kuala\ Lumpur",
"604988", "Kangar",
"609205", "Jerantut",
"604960", "Kuah",
"6087467", "Labuan",
"6085265", "Sundar",
"609529", "Kuantan",
"6084646", "Sarikei",
"6039545", "Kuala\ Lumpur",
"606509", "Jasin",
"6082898", "Serian",
"6035481", "Kinrara",
"604548", "Tasek\ Gelugor",
"608267", "Kota\ Samarahan",
"6087774", "Tambunan",
"6033214", "Sabak\ Bernam",
"6033243", "Sekinchan",
"605723", "Parit\ Buntar",
"606431", "Gemencheh",
"6093141", "Kuala\ Lipis",
"609951", "Machang",
"607785", "Keluang",
"607752", "Lavang\-Lavang",
"6086880", "Bakun",
"6084304", "Sibu",
"608248", "Kuching",
"607254", "Johor\ Bahru",
"6088304", "Kota\ Kinabalu",
"6032036", "Kuala\ Lumpur",
"609315", "Kuala\ Lipis",
"6098710", "Cheneh",
"6039100", "Cheras",
"6087728", "Tenom",
"605671", "Sitiawan",
"6036151", "Kuala\ Lumpur",
"6088618", "Kudat",
"604615", "Penang",
"609410", "Pekan",
"6084395", "Sibu",
"6084834", "Matu",
"609215", "Genting",
"6038093", "Kinrara",
"6088395", "Kota\ Kinabalu",
"6086252", "Bintulu",
"606519", "Jasin",
"606641", "Port\ Dickson",
"6034285", "Kuala\ Lumpur",
"6033321", "Kelang",
"606644", "Port\ Dickson",
"607915", "Bukit\ Kepong",
"604332", "Penang",
"607596", "Senai",
"6084833", "Matu",
"6085635", "Miri",
"6085402", "Miri",
"6089701", "Tawau",
"6038094", "Kinrara",
"6035888", "Kuala\ Lumpur",
"6082491", "Kuching",
"605674", "Bruas",
"604453", "Kulim",
"607298", "Johor\ Bahru",
"60457", "Kepala\ Batas",
"605766", "Lenggong",
"6033868", "Batang\ Berjuntai",
"6084303", "Sibu",
"609573", "Kuantan",
"6082896", "Serian",
"6088303", "Kota\ Kinabalu",
"607251", "Johor\ Bahru",
"6086281", "Bintulu",
"609632", "Kuala\ Brang",
"605299", "Tanjung\ Rambutan",
"609954", "Machang",
"609239", "Telemong",
"605692", "Sitiawan",
"608261", "Kuching",
"6089531", "Elopura",
"605542", "Ipoh",
"605211", "Ipoh",
"6083570", "Lingga",
"6086320", "Bintulu",
"606633", "Seremban",
"607400", "Rengit",
"6083472", "Betong",
"606437", "Johol",
"6089746", "Tawau",
"60974", "Kota\ Bharu",
"6033852", "Banting",
"6084228", "Sibu",
"6035110", "Kinrara",
"6082809", "Simunjan",
"605311", "Ipoh",
"6034802", "Kuala\ Lumpur",
"6033280", "Kuala\ Selangor",
"6032274", "Kuala\ Lumpur",
"6083339", "Bandar\ Sri\ Aman",
"605528", "Ipoh",
"604375", "Penang",
"6083584", "Lubukantu",
"607305", "Johor\ Bahru",
"606459", "Serting",
"6082472", "Kuching",
"605226", "Ipoh",
"6083437", "Saratok",
"609550", "Kuantan",
"6044110", "Serdang",
"6089926", "Tawau",
"6032273", "Kuala\ Lumpur",
"607428", "Senggarang",
"6036738", "Kuala\ Kubu\ Baru",
"6034050", "Kuala\ Lumpur",
"6084789", "Kapit",
"6035131", "Kinrara",
"6032782", "Kuala\ Lumpur",
"604513", "Padang\ Serai",
"604946", "Kangar",
"6087887", "Membakut",
"607828", "Penawar",
"6088360", "Kota\ Kinabalu",
"6038778", "Mantin",
"609688", "Kuala\ Brang",
"605429", "Trolak",
"60951", "Kuantan",
"607442", "Senggarang",
"609660", "Kuala\ Brang",
"6089716", "Tawau",
"6089285", "Elopura",
"6033273", "Batang\ Berjuntai",
"604465", "Bedong",
"6082583", "Kota\ Samarahan",
"6089510", "Beluran",
"608871", "Kinarut",
"6085555", "Miri",
"604260", "Penang",
"6032601", "Kuala\ Lumpur",
"604288", "Penang",
"605712", "Parit\ Buntar",
"6037863", "Kuala\ Lumpur",
"605829", "Taiping",
"6087475", "Labuan",
"608264", "Kuching",
"6086460", "Belaga",
"608922", "Elopura",
"6089748", "Tawau",
"609351", "Raub",
"604564", "Kepala\ Batas",
"6088881", "Ranau",
"6038724", "Semenyih",
"605536", "Tanjung\ Rambutan",
"6082651", "Kuching",
"607257", "Johor\ Bharu",
"609915", "Gua\ Musang",
"603271", "Kuala\ Lumpur",
"6088782", "Tuaran",
"609778", "Bachok",
"6089207", "Elopura",
"60745", "Sri\ Gading",
"6035031", "Kinrara",
"6038913", "Semenyih",
"6085627", "Miri",
"6085290", "Lawas",
"6085662", "Miri",
"6078710", "Tiram",
"604932", "Ayer\ Hitam",
"605473", "Bagan\ Datoh",
"6038776", "Mantin",
"6038689", "Putrajaya",
"6047450", "Alor\ Setar",
"604759", "Alor\ Setar",
"605677", "Bruas",
"6032859", "Kuala\ Lumpur",
"606495", "Simpang\ Durian",
"6047930", "Pokok\ Sena",
"609254", "Triang",
"609785", "Pasirputih",
"6036736", "Batu\ Arang",
"6088852", "Ranau",
"609752", "Pasir\ Putih",
"6082682", "Kuching",
"606647", "Port\ Dickson",
"6039055", "Cheras",
"6082701", "Lundu",
"605201", "Chemor",
"6038957", "Cheras",
"603772", "Kuala\ Lumpur",
"6088515", "Kota\ Kinabalu",
"604561", "Kepala\ Batas",
"6035611", "Kinrara",
"6085496", "Ladang\ Tiga",
"609957", "Batu\ Gajah",
"607810", "Paloh",
"6082597", "Kuching",
"6089718", "Tawau",
"6038723", "Semenyih",
"606770", "Seremban",
"606390", "Tangga\ Batu",
"6089491", "Beluran",
"6085792", "Mulu",
"6084751", "Kanowit",
"6089703", "Tawau",
"60477", "Alor\ Setar",
"6084831", "Matu",
"605380", "Pusing",
"605368", "Pusing",
"608521", "Limbang",
"607662", "Kulai",
"609440", "Bandar\ Tun\ Razak",
"6033323", "Kelang",
"6084840", "Kuala\ Igan",
"604497", "Bedong",
"6084777", "Song",
"6092590", "Karak",
"609840", "Dungun",
"609245", "Triang",
"6087402", "Labuan",
"604306", "Penang",
"606611", "Kuala\ Klawang",
"6082493", "Kuching",
"6086423", "Sebauh",
"606549", "Durian\ Tunggal",
"607578", "Senai",
"6084301", "Sibu",
"609606", "Tenang",
"606989", "Bakri",
"605852", "Taiping",
"605280", "Ipoh",
"605885", "Taiping",
"609773", "Kota\ Bharu",
"605485", "Cameron\ Highland",
"6039086", "Cheras",
"609345", "Raub",
"607276", "Johor\ Bahru",
"6083568", "Engkilili",
"6089617", "Elopura",
"6034262", "Kuala\ Lumpur",
"60969", "Jerteh",
"6088301", "Kota\ Kinabalu",
"6086283", "Bintulu",
"605478", "Tapah",
"609976", "Machang",
"603831", "Putrajaya",
"6033292", "Kelang",
"6038690", "Semenyih",
"607585", "Senai",
"6086284", "Bintulu",
"6099200", "Ayer\ Lanas",
"6039206", "Kuala\ Lumpur",
"607945", "Tenang",
"606614", "Kuala\ Klawang",
"604409", "Kulim",
"604962", "Kuah",
"6089704", "Tawau",
"6033324", "Kelang",
"6084810", "Julau",
"6038760", "Semenyih",
"607879", "Linggiu",
"609402", "Chini",
"6082382", "Kuching",
"6086424", "Sebauh",
"6038091", "Kinrara",
"606422", "Tampin",
"6089665", "Elopura",
"608425", "Sibu",
"604419", "Sungai\ Petani",
"6082760", "Bau",
"60626", "Melaka",
"6036065", "Kuala\ Kubu\ Baru",
"6082389", "Kuching",
"6037735", "Kuala\ Lumpur",
"606971", "Bukit\ Kepong",
"6032241", "Kuala\ Lumpur",
"6037886", "Kuala\ Lumpur",
"604224", "Penang",
"604819", "Penang",
"606638", "Kuala\ Pilah",
"604722", "Kulim",
"608825", "Kota\ Kinabalu",
"608220", "Kuching",
"609412", "Kuala\ Rompin",
"6032299", "Kuala\ Lumpur",
"607484", "Batu\ Pahat",
"6039271", "Kuala\ Lumpur",
"604927", "Ayer\ Hitam",
"6083566", "Pantu",
"6032935", "Kuala\ Lumpur",
"6082639", "Kuching",
"6035483", "Kinrara",
"6036047", "Kerling",
"607750", "Lavang\-Lavang",
"606467", "Ayer\ Hitam",
"6033241", "Sekinchan",
"6082227", "Kuching",
"607884", "Kota\ Tinggi",
"605581", "Chemor",
"604748", "Alor\ Setar",
"604324", "Penang",
"6086297", "Bintulu",
"6082690", "Kuching",
"606663", "Tekok\ Kemang",
"6037481", "Kuala\ Lumpur",
"6089867", "Lahad\ Datu",
"604518", "Tasekgelugor",
"6087217", "Beaufort",
"6032732", "Kuala\ Lumpur",
"6087771", "Tambunan",
"607881", "Air\ Tawar",
"6038025", "Kinrara",
"6035484", "Kinrara",
"6088790", "Tuaran",
"605690", "Sitiawan",
"607423", "Rengit",
"609630", "Kuala\ Brang",
"606277", "Melaka",
"6033831", "Semenyih",
"607823", "Penawar",
"608234", "Kuching",
"6084790", "Kapit",
"604835", "Penang",
"6032301", "Kuala\ Lumpur",
"6034025", "Kuala\ Lumpur",
"6089941", "Tawau",
"607481", "Kangkar\ Baru",
"6085282", "Lawas",
"6037932", "Kuala\ Lumpur",
"6039765", "Cheras",
"6087409", "Labuan",
"603749", "Kuala\ Lumpur",
"6035628", "Kinrara",
"606974", "Pagoh",
"6084660", "Sarikei",
"604330", "Penang",
"606797", "Mantin",
"6058300", "Taiping",
"6033161", "Kelang",
"604283", "Penang",
"6087872", "Weston",
"606601", "Seremban",
"604333", "Penang",
"6037663", "Kuala\ Lumpur",
"604852", "Penang",
"6087490", "Labuan",
"604885", "Penang",
"6032681", "Kuala\ Lumpur",
"604280", "Penang",
"6038521", "Sepang",
"604268", "Penang",
"6084823", "Daro",
"6086951", "Bintulu",
"6033080", "Kelang",
"60463", "Penang",
"604566", "Tasekgelugor",
"606550", "Tampin",
"6087439", "Labuan",
"6082503", "Kuching",
"604485", "Padang\ Serai",
"6089205", "Elopura",
"609859", "Chukai",
"6035892", "Kinrara",
"609668", "Batu\ Rakit",
"609680", "Kuala\ Brang",
"605645", "Bagan\ Datoh",
"604368", "Kepala\ Batas",
"607225", "Johor\ Bahru",
"605897", "Semanggol",
"6032331", "Kuala\ Lumpur",
"6088709", "Kinarut",
"60577", "Kuala\ Kangsar",
"6032080", "Kuala\ Lumpur",
"607509", "Senai",
"6038964", "Cheras",
"6038752", "Semenyih",
"609572", "Kuantan",
"6085612", "Miri",
"609437", "Perwira\ Jaya",
"605693", "Sitiawan",
"607420", "Senggarang",
"609633", "Bandar\ Permaisuri",
"6038602", "Kinrara",
"603796", "Kuala\ Lumpur",
"609558", "Kuantan",
"607753", "Renggam",
"606660", "Tekok\ Kemang",
"609256", "Triang",
"605809", "Taiping",
"6032026", "Kuala\ Lumpur",
"6038963", "Cheras",
"605520", "Ipoh",
"6088517", "Kota\ Kinabalu",
"603269", "Kuala\ Lumpur",
"6088408", "Kota\ Kinabalu",
"6082889", "Serian",
"6037118", "Kuala\ Lumpur",
"6038955", "Serdang",
"607597", "Senai",
"6087738", "Tenom",
"6034250", "Kuala\ Lumpur",
"6037664", "Kuala\ Lumpur",
"6039057", "Cheras",
"607408", "Kampong\ Parit\ Tengah",
"608223", "Kuching",
"609591", "Kuantan",
"6082504", "Kuching",
"605767", "Lenggong",
"609356", "Raub",
"60793", "Segamat",
"606251", "Melaka",
"608876", "Kinarut",
"6089462", "Elopura",
"606398", "Tangga\ Batu",
"6085761", "Layang\-Layang",
"6083435", "Saratok",
"607990", "Bakri",
"6089560", "Kinabatangan",
"6039236", "Kuala\ Lumpur",
"6033126", "Tk\ Panglima\ Garang",
"6082781", "Gedong",
"6039411", "Cheras",
"606351", "Tangga\ Batu",
"604941", "Kangar",
"609765", "Bachok",
"6088652", "Kotamarudu",
"6082882", "Serian",
"605419", "Tapah",
"6036196", "Kuala\ Lumpur",
"6038609", "Kinrara",
"607749", "Ayer\ Hitam",
"605722", "Parit\ Buntar",
"6087477", "Labuan",
"6084702", "Bintangor",
"604347", "Penang",
"6032028", "Kuala\ Lumpur",
"6088331", "Kota\ Kinabalu",
"6032180", "Kuala\ Lumpur",
"60444", "Sungai\ Petani",
"6086371", "Sebauh",
"604944", "Kangar",
"606354", "Tangga\ Batu",
"6089287", "Elopura",
"6088702", "Kinarut",
"609770", "Bachok",
"6082752", "Kuching",
"6087885", "Kuala\ Penyu",
"6088801", "Tuaran",
"6033180", "Banting",
"605321", "Ipoh",
"6087736", "Tenom",
"6084681", "Sarikei",
"6084801", "Sibu",
"6092870", "Kuala\ Krau",
"605230", "Ipoh",
"609443", "Bandar\ Tun\ Razak",
"607413", "Batu\ Pahat",
"6082225", "Kuching",
"6089865", "Lahad\ Datu",
"605375", "Bota",
"6086295", "Bintulu",
"6082302", "Kuching",
"609735", "Kota\ Bharu",
"6088352", "Kota\ Kinabalu",
"6083485", "Betong",
"605795", "Grik",
"6089853", "Kunak",
"6089523", "Telupid",
"6082546", "Kuching",
"6037772", "Kuala\ Lumpur",
"6082731", "Lundu",
"6084610", "Rejang",
"604982", "Kangar",
"604955", "Kuah",
"6084352", "Sibu",
"6032261", "Kuala\ Lumpur",
"605743", "Manong",
"604226", "Penang",
"607486", "Batu\ Pahat",
"6038988", "Cheras",
"606293", "Melaka",
"604787", "Alor\ Setar",
"6035124", "Kinrara",
"6088979", "Kota\ Belud",
"6087451", "Labuan",
"6038890", "Putrajaya",
"609611", "Bandar\ Permaisuri",
"609549", "Gambang",
"6049372", "Kangar",
"6033359", "Kelang",
"605470", "Kampar",
"6039368", "Kuala\ Lumpur",
"6085453", "Miri",
"607886", "Penawar",
"6036022", "Batu\ Arang",
"6035123", "Kinrara",
"6089817", "Lahatdatu",
"6033860", "Sekinchan",
"609719", "Kota\ Bharu",
"6034291", "Kuala\ Lumpur",
"609822", "Al\ Muktafi\ Billa\ H\ Shah",
"6087222", "Beaufort",
"605465", "Kampar",
"606969", "Bukit\ Kepong",
"605288", "Pusing",
"608236", "Kuching",
"604829", "Penang",
"6084381", "Sibu",
"6039767", "Cheras",
"603205", "Kuala\ Lumpur",
"6085454", "Miri",
"604500", "Kulim",
"6032775", "Kuala\ Lumpur",
"607570", "Senai",
"6034027", "Kuala\ Lumpur",
"606976", "Bukit\ Gambir",
"609848", "Dungun",
"6089524", "Telupid",
"6087482", "Labuan",
"6084640", "Sarikei",
"604917", "Alor\ Setar",
"6089854", "Kunak",
"6039171", "Kuala\ Lumpur",
"607682", "Air\ Baloi",
"607655", "Kulai",
"604314", "Penang",
"6089272", "Elopura",
"607289", "Johor\ Bahru",
"6033141", "Sepang",
"6035880", "Kinrara",
"605388", "Bota",
"6084631", "Selalang",
"6038027", "Kinrara",
"6087215", "Beaufort",
"6033192", "Banting",
"6089279", "Elopura",
"6089615", "Elopura",
"604263", "Penang",
"609867", "Kemasik",
"6033381", "Kelang",
"6033099", "Pulau\ Ketam",
"609663", "Batu\ Rakit",
"607699", "Pontian",
"607794", "Endau",
"609467", "Maran",
"6082548", "Kuching",
"6085202", "Limbang",
"6036122", "Kuala\ Lumpur",
"6032030", "Kuala\ Lumpur",
"6095070", "Kuantan",
"6032381", "Kuala\ Lumpur",
"606729", "Seremban",
"604238", "Penang",
"6088413", "Kota\ Kinabalu",
"6039106", "Cheras",
"609638", "Kuala\ Berang",
"605698", "Sitiawan",
"6089622", "Elopura",
"607274", "Johor\ Bahru",
"604702", "Alor\ Setar",
"6083548", "Maludam",
"6087229", "Beaufort",
"6082291", "Kuching",
"607861", "Tiram",
"6035101", "Kinrara",
"604536", "Tasek\ Gelugor",
"608741", "Labuan",
"604510", "Tasek\ Gelugor",
"6033610", "Kuala\ Selangor",
"6089667", "Elopura",
"608242", "Kuching",
"604740", "Alor\ Setar",
"6082890", "Serian",
"609974", "Machang",
"607758", "Ayer\ Hitam",
"6032011", "Kuala\ Lumpur",
"609553", "Kuantan",
"604201", "Penang",
"6088414", "Kota\ Kinabalu",
"607271", "Johor\ Bahru",
"6083309", "Bandar\ Sri\ Aman",
"6088972", "Kota\ Belud",
"605654", "Kampong\ Gajah",
"606630", "Seremban",
"605759", "Kuala\ Kangsar",
"6038740", "Semenyih",
"607791", "Felda\ Tenggaroh",
"6036145", "Kuala\ Lumpur",
"6082309", "Kuching",
"6034162", "Kuala\ Lumpur",
"60628", "Melaka",
"609277", "Mentakab",
"6032722", "Kuala\ Lumpur",
"609570", "Kuantan",
"604911", "Alor\ Setar",
"6088333", "Kota\ Kinabalu",
"607422", "Kampung\ Parit\ Tengah",
"605449", "Tanjung\ Malim",
"6089920", "Tawau",
"607822", "Penawar",
"605849", "Taiping",
"6082770", "Bau",
"6032108", "Kuala\ Lumpur",
"606479", "Ayer\ Hitam",
"6085298", "Lawas",
"608733", "Keningau",
"6036075", "Kuala\ Kubu\ Baru",
"6086326", "Bintulu",
"6086468", "Belaga",
"606552", "Simpang\ Empat",
"609682", "Kuala\ Brang",
"6085736", "Batu\ Niah",
"6082865", "Kota\ Samarahan",
"606466", "Palong",
"607448", "Batu\ Pahat",
"604784", "Lubuk\ Merbau",
"604926", "Ayer\ Hitam",
"604282", "Penang",
"604850", "Penang",
"604255", "Penang",
"6084803", "Sibu",
"6085605", "Miri",
"6084683", "Sarikei",
"609813", "Paka",
"6033006", "Sabak\ Bernam",
"604217", "Penang",
"606276", "Melaka",
"605548", "Ipoh",
"6085755", "Marudi",
"6087761", "Tenom",
"6034279", "Kuala\ Lumpur",
"6084684", "Sarikei",
"6082272", "Kuching",
"609413", "Kuala\ Rompin",
"6084804", "Sarikei",
"605246", "Ipoh",
"6035562", "Kinrara",
"6087862", "Bongawan",
"6088334", "Kota\ Kinabalu",
"6089242", "Elopura",
"605522", "Ipoh",
"6088366", "Kota\ Kinabalu",
"6082629", "Kuching",
"6039130", "Kuala\ Lumpur",
"6084366", "Sibu",
"6089986", "Tawau",
"6039775", "Kuala\ Lumpur",
"609565", "Kuantan",
"6039141", "Kuala\ Lumpur",
"604914", "Alor\ Setar",
"609486", "Jengka\ Tiga\ Belas",
"6037712", "Kuala\ Lumpur",
"606662", "Tekok\ Kemang",
"6084895", "Kuala\ Igan",
"6032106", "Kuala\ Lumpur",
"604307", "Penang",
"604938", "Kangar",
"605720", "Parit\ Buntar",
"6085296", "Lawas",
"6033288", "Kuala\ Selangor",
"6036277", "Kuala\ Lumpur",
"6037719", "Kuala\ Lumpur",
"60787", "Kota\ Tinggi",
"609271", "Mentakab",
"6035569", "Kinrara",
"6038961", "Cheras",
"609758", "Pasir\ Putih",
"6082622", "Kuching",
"6084480", "Sibu",
"609864", "Kemasik",
"607277", "Johor\ Bahru",
"604963", "Kuah",
"6088745", "Kinarut",
"6082279", "Kuching",
"603778", "Kuala\ Lumpur",
"6086466", "Sebauh",
"6086328", "Bintulu",
"6084220", "Sibu",
"6038783", "Mantin",
"606423", "Simpang\ Durian",
"6085738", "Batu\ Niah",
"6084821", "Daro",
"6089518", "Beluran",
"6038523", "Kinrara",
"609794", "Kok\ Lanas",
"607467", "Sri\ Gading",
"604766", "Alor\ Setar",
"607663", "Kulai",
"6037661", "Kuala\ Lumpur",
"609977", "Machang",
"6033008", "Banting",
"6082797", "Tebedu",
"607867", "Tiram",
"6082501", "Kuching",
"6034770", "Kuala\ Lumpur",
"604901", "Changlon",
"6039011", "Cheras",
"6089675", "Elopura",
"6032333", "Kuala\ Lumpur",
"609772", "Kok\ Lanas",
"6086260", "Bintulu",
"6082667", "Kota\ Samarahan",
"605853", "Sungai\ Nyior",
"604399", "Penang",
"604779", "Pokok\ Sena",
"6047456", "Alor\ Setar",
"6088368", "Kota\ Kinabalu",
"605537", "Tanjung\ Rambutan",
"6034287", "Kuala\ Lumpur",
"6039080", "Cheras",
"6082315", "Kuching",
"604933", "Kuah",
"6056340", "Kampong\ Gajah",
"607925", "Labis",
"6088397", "Kota\ Kinabalu",
"607256", "Johor\ Bahru",
"6082294", "Kuching",
"6083322", "Bandar\ Sri\ Aman",
"608287", "Serian",
"605872", "Semanggol",
"6088532", "Kota\ Kinabalu",
"609753", "Bachok",
"608544", "Miri",
"604540", "Tasek\ Gelugor",
"6082698", "Kuching",
"6039074", "Cheras",
"604968", "Kuah",
"604980", "Kangar",
"6038329", "Putrajaya",
"6086484", "Balingan",
"609834", "Bukit\ Besi",
"6087342", "Keningau",
"606428", "Kuala\ Pilah",
"605894", "Taiping",
"6035195", "Kinrara",
"6082322", "Kuching",
"609408", "Kuala\ Rompin",
"60475", "Lubuk\ Merbau",
"6087506", "Labuan",
"607668", "Kulai",
"606646", "Port\ Dickson",
"6032848", "Kuala\ Lumpur",
"608923", "Elopura",
"607680", "Pontian",
"6035620", "Kinrara",
"6063130", "Melaka",
"605891", "Taiping",
"6087312", "Keningau",
"609831", "Paka",
"6084236", "Sibu",
"6039200", "Kuala\ Lumpur",
"6088668", "Kota\ Marudu",
"608981", "Felda\ Sahabat",
"6086483", "Pelagus",
"60723", "Johor\ Bahru",
"605676", "Changkat\ Keruing",
"6084816", "Rejang",
"6038766", "Semenyih",
"605858", "Taiping",
"604710", "Alor\ Setar",
"608541", "Miri",
"605669", "Sitiawan",
"6088411", "Kota\ Kinabalu",
"604625", "Penang",
"6032383", "Kuala\ Lumpur",
"6035021", "Kinrara",
"6088798", "Tuaran",
"609509", "Kuantan",
"60733", "Johor\ Bahru",
"6035103", "Kinrara",
"6083469", "Sebuyau",
"6082293", "Kuching",
"6084798", "Kapit",
"606529", "Jasin",
"6085637", "Miri",
"609225", "Bentong",
"609820", "Paka",
"606436", "Johol",
"606410", "Tampin",
"6035270", "Kinrara",
"604700", "Alor\ Setar",
"6032114", "Kuala\ Lumpur",
"6034293", "Kuala\ Lumpur",
"6087209", "Beaufort",
"6086201", "Bintulu",
"604241", "Penang",
"604512", "Penang",
"6037874", "Kuala\ Lumpur",
"6035121", "Kinrara",
"6085222", "Limbang",
"6033264", "Kuala\ Selangor",
"6036102", "Genting",
"6084383", "Sibu",
"6039173", "Kuala\ Lumpur",
"607895", "Air\ Tawar",
"607443", "Rengit",
"6087508", "Labuan",
"6037880", "Kuala\ Lumpur",
"6034107", "Kuala\ Lumpur",
"6032264", "Kuala\ Lumpur",
"6084848", "Kuala\ Igan",
"6085482", "Kampung\ Bakam",
"6084633", "Selalang",
"6082766", "Bau",
"6082734", "Lundu",
"606315", "Melaka",
"6087319", "Keningau",
"6033143", "Sepang",
"6087391", "Keningau",
"6082329", "Serian",
"605543", "Ipoh",
"6089851", "Kunak",
"6089521", "Telupid",
"6039174", "Kuala\ Lumpur",
"6038768", "Semenyih",
"6084818", "Daro",
"606357", "Tangga\ Batu",
"604947", "Kangar",
"609818", "Kerteh",
"606632", "Seremban",
"609418", "Nenasi",
"605930", "Sitiawan",
"6084634", "Pakan",
"6032263", "Kuala\ Lumpur",
"60645", "Bahau",
"605595", "Chemor",
"6038322", "Putrajaya",
"6084238", "Sibu",
"6085720", "Batu\ Niah",
"6039547", "Cheras",
"6034294", "Kuala\ Lumpur",
"6087453", "Labuan",
"6032113", "Kuala\ Lumpur",
"6084796", "Kapit",
"6037873", "Kuala\ Lumpur",
"6087465", "Labuan",
"6082287", "Damai\ Beach",
"6084384", "Sibu",
"608845", "Kota\ Kinabalu",
"607765", "Endau",
"6083427", "Roban",
"6088796", "Tuaran",
"6089936", "Luasong",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+60|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;