/*
 * Indeo Video Interactive 5 compatible decoder
 * Copyright (c) 2009 Maxim Poliakovski
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * @file
 * This file contains data needed for the Indeo5 decoder.
 */

#ifndef AVCODEC_INDEO5DATA_H
#define AVCODEC_INDEO5DATA_H

#include <stdint.h>

/**
 *  standard picture dimensions (width, height)
 */
static uint16_t ivi5_common_pic_sizes[30] = {640, 480, 320, 240, 160, 120, 704, 480, 352, 240, 352, 288, 176, 144,
                                             240, 180, 640, 240, 704, 240,  80,  60,  88,  72,   0,   0,   0,   0, 0, 0};


/**
 *  Indeo5 8x8 scan (zigzag) patterns
 */
static const uint8_t ivi5_scans8x8[3][64] = {
    {0,  1,  8, 16,  9,  2,  3, 10, 17, 24, 32, 25, 18, 11,  4,  5,
    12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13,  6,  7, 14, 21, 28,
    35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51,
    58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63
    },
    {0,  8, 16, 24, 32, 40, 48, 56,  1,  9, 17, 25, 33, 41, 49, 57,
     2, 10, 18, 26, 34, 42, 50, 58,  3, 11, 19, 27, 35, 43, 51, 59,
     4, 12, 20, 28, 36, 44, 52, 60,  5, 13, 21, 29, 37, 45, 53, 61,
     6, 14, 22, 30, 38, 46, 54, 62,  7, 15, 23, 31, 39, 47, 55, 63
    },
    {0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
    16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
    48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63
    }
};

/**
 *  Indeo5 4x4 scan (zigzag) pattern
 */
static const uint8_t ivi5_scan4x4[16] = {
    0, 1, 4, 8, 5, 2, 3, 6, 9, 12, 13, 10, 7, 11, 14, 15
};


/**
 *  Indeo5 dequantization matrixes consist of two tables: base table
 *  and scale table. The base table defines the dequantization matrix
 *  itself and the scale table tells how this matrix should be scaled
 *  for a particular quant level (0...24).
 *
 *  ivi5_base_quant_bbb_ttt  - base  tables for block size 'bbb' of type 'ttt'
 *  ivi5_scale_quant_bbb_ttt - scale tables for block size 'bbb' of type 'ttt'
 */
static const uint8_t ivi5_base_quant_8x8_inter[5][64] = {
    {0x13, 0x1d, 0x1f, 0x23, 0x25, 0x27, 0x29, 0x2d, 0x1d, 0x1f, 0x21, 0x23, 0x25, 0x27, 0x2b, 0x2f,
     0x1f, 0x21, 0x23, 0x24, 0x26, 0x29, 0x2d, 0x31, 0x23, 0x23, 0x24, 0x25, 0x27, 0x2b, 0x2f, 0x33,
     0x25, 0x25, 0x26, 0x27, 0x29, 0x2d, 0x31, 0x35, 0x27, 0x27, 0x29, 0x2b, 0x2d, 0x2f, 0x33, 0x37,
     0x29, 0x2b, 0x2d, 0x2f, 0x31, 0x33, 0x35, 0x39, 0x2d, 0x2f, 0x31, 0x33, 0x35, 0x37, 0x39, 0x3b
    },
    {0x13, 0x1d, 0x1f, 0x23, 0x25, 0x27, 0x29, 0x2d, 0x1d, 0x1f, 0x21, 0x23, 0x25, 0x27, 0x2b, 0x2f,
     0x1f, 0x21, 0x23, 0x24, 0x26, 0x29, 0x2d, 0x31, 0x23, 0x23, 0x24, 0x25, 0x27, 0x2b, 0x2f, 0x33,
     0x25, 0x25, 0x26, 0x27, 0x29, 0x2d, 0x31, 0x35, 0x27, 0x27, 0x29, 0x2b, 0x2d, 0x2f, 0x33, 0x37,
     0x29, 0x2b, 0x2d, 0x2f, 0x31, 0x33, 0x35, 0x39, 0x2d, 0x2f, 0x31, 0x33, 0x35, 0x37, 0x39, 0x3b
    },
    {0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61, 0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61,
     0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61, 0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61,
     0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61, 0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61,
     0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61, 0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61
    },
    {0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
     0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a,
     0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
     0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61
    },
    {0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f,
     0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f,
     0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f,
     0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f
    }
};

static const uint8_t ivi5_base_quant_8x8_intra[5][64] = {
    {0x0d, 0x17, 0x1b, 0x21, 0x23, 0x25, 0x27, 0x2d, 0x17, 0x19, 0x1f, 0x21, 0x23, 0x27, 0x2b, 0x35,
     0x1b, 0x1f, 0x1f, 0x22, 0x25, 0x2a, 0x33, 0x39, 0x21, 0x21, 0x22, 0x25, 0x29, 0x31, 0x36, 0x3d,
     0x23, 0x23, 0x25, 0x29, 0x2f, 0x33, 0x39, 0x47, 0x25, 0x27, 0x2a, 0x31, 0x33, 0x37, 0x43, 0x53,
     0x27, 0x2b, 0x33, 0x36, 0x39, 0x43, 0x4d, 0x65, 0x2d, 0x35, 0x39, 0x3d, 0x47, 0x53, 0x65, 0x7f
    },
    {0x13, 0x1d, 0x1f, 0x23, 0x25, 0x27, 0x29, 0x2d, 0x1d, 0x1f, 0x21, 0x23, 0x25, 0x27, 0x2b, 0x2f,
     0x1f, 0x21, 0x23, 0x24, 0x26, 0x29, 0x2d, 0x31, 0x23, 0x23, 0x24, 0x25, 0x27, 0x2b, 0x2f, 0x33,
     0x25, 0x25, 0x26, 0x27, 0x29, 0x2d, 0x31, 0x35, 0x27, 0x27, 0x29, 0x2b, 0x2d, 0x2f, 0x33, 0x37,
     0x29, 0x2b, 0x2d, 0x2f, 0x31, 0x33, 0x35, 0x39, 0x2d, 0x2f, 0x31, 0x33, 0x35, 0x37, 0x39, 0x3b
    },
    {0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61, 0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61,
     0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61, 0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61,
     0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61, 0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61,
     0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61, 0x27, 0x55, 0x79, 0x6a, 0x6f, 0x61, 0x6b, 0x61
    },
    {0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
     0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a,
     0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x6f, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61,
     0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61
    },
    {0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f,
     0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f,
     0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f,
     0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f
    }
};

static const uint8_t ivi5_base_quant_4x4_inter[16] = {
    0x0f, 0x1f, 0x25, 0x29, 0x1f, 0x25, 0x29, 0x2b, 0x25, 0x29, 0x2b, 0x2f, 0x29, 0x2b, 0x2f, 0x33
};

static const uint8_t ivi5_base_quant_4x4_intra[16] = {
    0x0f, 0x1f, 0x25, 0x29, 0x1f, 0x25, 0x29, 0x2f, 0x25, 0x29, 0x2f, 0x3d, 0x29, 0x2f, 0x3d, 0x49
};


static const uint8_t ivi5_scale_quant_8x8_inter[5][24] = {
    {0x0b, 0x11, 0x13, 0x14, 0x15, 0x16, 0x18, 0x1a, 0x1b, 0x1d, 0x20, 0x22,
     0x23, 0x25, 0x28, 0x2a, 0x2e, 0x32, 0x35, 0x39, 0x3d, 0x41, 0x44, 0x4a,
    },
    {0x07, 0x14, 0x16, 0x18, 0x1b, 0x1e, 0x22, 0x25, 0x29, 0x2d, 0x31, 0x35,
     0x3a, 0x3f, 0x44, 0x4a, 0x50, 0x56, 0x5c, 0x63, 0x6a, 0x71, 0x78, 0x7e,
    },
    {0x15, 0x25, 0x28, 0x2d, 0x30, 0x34, 0x3a, 0x3d, 0x42, 0x48, 0x4c, 0x51,
     0x56, 0x5b, 0x60, 0x65, 0x6b, 0x70, 0x76, 0x7c, 0x82, 0x88, 0x8f, 0x97,
    },
    {0x13, 0x1f, 0x20, 0x22, 0x25, 0x28, 0x2b, 0x2d, 0x30, 0x33, 0x36, 0x39,
     0x3c, 0x3f, 0x42, 0x45, 0x48, 0x4b, 0x4e, 0x52, 0x56, 0x5a, 0x5e, 0x62,
    },
    {0x3c, 0x52, 0x58, 0x5d, 0x63, 0x68, 0x68, 0x6d, 0x73, 0x78, 0x7c, 0x80,
     0x84, 0x89, 0x8e, 0x93, 0x98, 0x9d, 0xa3, 0xa9, 0xad, 0xb1, 0xb5, 0xba,
    },
};

static const uint8_t ivi5_scale_quant_8x8_intra[5][24] = {
    {0x0b, 0x0e, 0x10, 0x12, 0x14, 0x16, 0x17, 0x18, 0x1a, 0x1c, 0x1e, 0x20,
     0x22, 0x24, 0x27, 0x28, 0x2a, 0x2d, 0x2f, 0x31, 0x34, 0x37, 0x39, 0x3c,
    },
    {0x01, 0x10, 0x12, 0x14, 0x16, 0x18, 0x1b, 0x1e, 0x22, 0x25, 0x28, 0x2c,
     0x30, 0x34, 0x38, 0x3d, 0x42, 0x47, 0x4c, 0x52, 0x58, 0x5e, 0x65, 0x6c,
    },
    {0x13, 0x22, 0x27, 0x2a, 0x2d, 0x33, 0x36, 0x3c, 0x41, 0x45, 0x49, 0x4e,
     0x53, 0x58, 0x5d, 0x63, 0x69, 0x6f, 0x75, 0x7c, 0x82, 0x88, 0x8e, 0x95,
    },
    {0x13, 0x1f, 0x21, 0x24, 0x27, 0x29, 0x2d, 0x2f, 0x34, 0x37, 0x3a, 0x3d,
     0x40, 0x44, 0x48, 0x4c, 0x4f, 0x52, 0x56, 0x5a, 0x5e, 0x62, 0x66, 0x6b,
    },
    {0x31, 0x42, 0x47, 0x47, 0x4d, 0x52, 0x58, 0x58, 0x5d, 0x63, 0x67, 0x6b,
     0x6f, 0x73, 0x78, 0x7c, 0x80, 0x84, 0x89, 0x8e, 0x93, 0x98, 0x9d, 0xa4,
    }
};

static const uint8_t ivi5_scale_quant_4x4_inter[24] = {
    0x0b, 0x0d, 0x0d, 0x0e, 0x11, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23,
};

static const uint8_t ivi5_scale_quant_4x4_intra[24] = {
    0x01, 0x0b, 0x0b, 0x0d, 0x0d, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x13, 0x14,
    0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20
};


#endif /* AVCODEC_INDEO5DATA_H */
