#!/usr/bin/env perl

use 5.008;

use strict;
use warnings;

use Test::More;
use Test::Exception;

use Test::Approximate;

for my $v ( undef, '', 'abc', '1.0', -1 ) {
    my $str = ! defined $v ? 'undef' : "'$v'";
    throws_ok { set_dop($v) } qr/Positive integer expected/, "catch set_dop($str)";
}

set_dop(0);
is set_dop(), 1, "attempt to set DOP to 0 forced to 1";

set_dop(14);
is set_dop(), 14, "can set DOP to 14";

set_dop(15);
is set_dop(), 14, "attempt to set DOP to 14 forced to 15";

done_testing;
