#!/usr/bin/env perl

use 5.008;

use strict;
use warnings;

use Test::More;
use Test2::API qw/intercept/;

use Test::Approximate;

my ($ok, $ev);

set_dop(2);

$ev = intercept { $ok = is_approx 10, 10 };
ok   $ok, "is_approx returns true";

$ev = intercept { $ok = is_approx 10, 20 };
ok ! $ok, "is_approx returns false";

$ev = intercept { $ok = isnt_approx 10, 10 };
ok ! $ok, "is_approx returns false";

$ev = intercept { $ok = isnt_approx 10, 20 };
ok   $ok, "is_approx returns true";

done_testing;
